/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpOverridingMethodVisibilityQuickFix;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpOverridingMethodVisibilityInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpOverridingMethodVisibilityInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                if (clazz.isTrait() || clazz.isInterface()) {
                    return;
                }
                List publicMethods = ContainerUtil.filter((Object[])clazz.getOwnMethods(), method -> method.getAccess().isPublic());
                if (publicMethods.isEmpty()) {
                    return;
                }
                Collection<String> superClassProtectedMethodNames = this.getSuperClassProtectedMethodNames(clazz);
                publicMethods.stream().filter(method -> !(method instanceof PhpDocMethod)).filter(method -> superClassProtectedMethodNames.contains(method.getName())).map(method -> method.getNameIdentifier()).filter(Objects::nonNull).forEach(identifier -> holder.registerProblem(identifier, 1.getDescription(), new LocalQuickFix[]{PhpOverridingMethodVisibilityQuickFix.INSTANCE}));
            }

            private Collection<String> getSuperClassProtectedMethodNames(PhpClass clazz) {
                Set<String> methodNames = PhpStringUtil.createCaseInsensitiveSet();
                PhpClassHierarchyUtils.processSupers((PhpClass)clazz, (boolean)false, (boolean)true, c -> 1.addProtectedMethodNames(methodNames, c));
                return methodNames;
            }

            private static boolean addProtectedMethodNames(Set<String> methodNames, PhpClass c) {
                if (c.isTrait() || c.isInterface()) {
                    return true;
                }
                Arrays.stream(c.getOwnMethods()).filter(method -> method.getAccess().isProtected()).map(method -> method.getName()).forEach(methodNames::add);
                return true;
            }

            @NotNull
            @InspectionMessage
            private static String getDescription() {
                String string = PhpBundle.message("inspection.codeSmell.overriding.method.visibility.description", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/codeSmell/PhpOverridingMethodVisibilityInspection$1", "getDescription"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpOverridingMethodVisibilityInspection", "buildVisitor"));
    }
}

