/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                Object parentCall = PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                if (parentCall != null && PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection.isDirCall(parentCall)) {
                    return;
                }
                DirnameInfo info = PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection.getDirNameInfo((PsiElement)reference);
                if (info == null || info.myDepth <= 0 || info.myDepth == PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection.getLevels(reference)) {
                    return;
                }
                String dirnameText = String.format("dirname(%s, %d)", info.myArgument.getText(), info.myDepth);
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                holder.registerProblem(nameNode.getPsi(), PhpBundle.message("inspection.message.can.be.replaced.with", dirnameText), new LocalQuickFix[]{new PhpReplaceWithDirNameCallQuickFix(dirnameText)});
            }
        };
    }

    private static DirnameInfo getDirNameInfo(PsiElement reference) {
        if (!(reference instanceof FunctionReference) || !PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection.isDirCall(reference)) {
            return null;
        }
        PsiElement parameter = ((FunctionReference)reference).getParameter(0);
        if (parameter == null) {
            return null;
        }
        int levels = PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection.getLevels((FunctionReference)reference);
        if (levels < 0) {
            return null;
        }
        DirnameInfo info = PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection.getDirNameInfo(parameter);
        return info != null ? new DirnameInfo(levels + info.myDepth, info.myArgument) : new DirnameInfo(levels, parameter);
    }

    private static int getLevels(FunctionReference reference) {
        PsiElement levelsArgument = reference.getParameter(1);
        return levelsArgument != null ? StringUtil.parseInt((String)levelsArgument.getText(), (int)-1) : 1;
    }

    private static boolean isDirCall(PsiElement reference) {
        return reference instanceof FunctionReference && !(reference instanceof MethodReference) && PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)reference, "dirname");
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP700;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection", "buildVisitor"));
    }

    private static class DirnameInfo {
        private final int myDepth;
        private final PsiElement myArgument;

        private DirnameInfo(int depth, PsiElement argument) {
            this.myDepth = depth;
            this.myArgument = argument;
        }
    }

    private static class PhpReplaceWithDirNameCallQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myDirnameText;

        private PhpReplaceWithDirNameCallQuickFix(String dirnameText) {
            this.myDirnameText = dirnameText;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.dirname.call", new Object[0]);
            if (string == null) {
                PhpReplaceWithDirNameCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("php.replace.with", this.myDirnameText);
            if (string == null) {
                PhpReplaceWithDirNameCallQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithDirNameCallQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpReplaceWithDirNameCallQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithDirNameCallQuickFix.$$$reportNull$$$0(4);
            }
            element.getParent().replace((PsiElement)PhpPsiElementFactory.createFunctionReference(project, this.myDirnameText));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection$PhpReplaceWithDirNameCallQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpNestedDirNameCallsCanBeReplacedWithLevelParameterInspection$PhpReplaceWithDirNameCallQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

