/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpInvalidInstanceofInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInvalidInstanceofInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                PsiElement rightOperand;
                if (expression.getOperationType() != PhpTokenTypes.kwINSTANCEOF) {
                    return;
                }
                PsiElement leftOperand = expression.getLeftOperand();
                if (leftOperand instanceof PhpTypedElement && PhpInvalidInstanceofInspection.isPrimitiveTypedElement((PhpTypedElement)leftOperand)) {
                    holder.registerProblem(leftOperand, PhpBundle.message("inspection.message.primitive.types.can.t.be.used.as.instanceof.argument", ((PhpTypedElement)leftOperand).getGlobalType()), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
                if ((rightOperand = expression.getRightOperand()) instanceof PhpTypedElement && !(rightOperand instanceof ClassReference) && PhpInvalidInstanceofInspection.isPrimitiveTypedElement((PhpTypedElement)rightOperand)) {
                    holder.registerProblem(rightOperand, PhpBundle.message("inspection.message.primitive.types.can.t.be.used.as.instanceof.argument", ((PhpTypedElement)rightOperand).getGlobalType()), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static boolean isPrimitiveTypedElement(@NotNull PhpTypedElement rightOperand) {
        PhpType classReferenceType;
        if (rightOperand == null) {
            PhpInvalidInstanceofInspection.$$$reportNull$$$0(1);
        }
        return !(classReferenceType = rightOperand.getGlobalType().filterNull()).isAmbiguous() && classReferenceType.filterOut(s -> !PhpType.isString((String)s) && (PhpType.isNotExtendablePrimitiveType((String)s) || PhpType.isArray((String)s) || PhpType.isPluralType((String)s))).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInvalidInstanceofInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrimitiveTypedElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

