/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class PhpClassConstantAccessedViaChildClassInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpClassConstantAccessedViaChildClassInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                PhpExpression classReference = constantReference.getClassReference();
                if (classReference instanceof ClassReference) {
                    PhpClass containingClass;
                    if (PhpLangUtil.isClassNameSpecial(classReference.getName())) {
                        return;
                    }
                    PhpClass referencedClass = (PhpClass)ObjectUtils.tryCast((Object)((ClassReference)classReference).resolve(), PhpClass.class);
                    if (referencedClass == null) {
                        return;
                    }
                    ClassConstImpl classConst = (ClassConstImpl)((Object)ObjectUtils.tryCast((Object)constantReference.resolve(), ClassConstImpl.class));
                    PhpClass phpClass = containingClass = classConst != null ? classConst.getContainingClass() : null;
                    if (containingClass == null || containingClass.isTrait() || PhpClassHierarchyUtils.classesEqual((PhpClass)containingClass, (PhpClass)referencedClass)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)classReference, PhpBundle.message("inspection.message.constant.from.base.class.referenced.via.child.class", containingClass.getFQN()), new LocalQuickFix[]{new PhpReplaceWithClassReferenceQuickFix(containingClass.getFQN())});
                }
            }
        };
    }

    public static void replaceWithClassReference(PhpPsiElement classReference, String classFQN) {
        String qualifiedName = PhpMoveMemberProcessor.importClassAndGetName(classReference, Collections.emptyList(), classFQN);
        classReference.replace((PsiElement)PhpPsiElementFactory.createClassReference(classReference.getProject(), qualifiedName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpClassConstantAccessedViaChildClassInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithClassReferenceQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myClassFQN;

        private PhpReplaceWithClassReferenceQuickFix(@NotNull @NlsSafe String classFQN) {
            if (classFQN == null) {
                PhpReplaceWithClassReferenceQuickFix.$$$reportNull$$$0(0);
            }
            this.myClassFQN = classFQN;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.class.reference.with.base.class", new Object[0]);
            if (string == null) {
                PhpReplaceWithClassReferenceQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("php.replace.with", PhpLangUtil.toShortName(this.myClassFQN));
            if (string == null) {
                PhpReplaceWithClassReferenceQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithClassReferenceQuickFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                PhpReplaceWithClassReferenceQuickFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                PhpReplaceWithClassReferenceQuickFix.$$$reportNull$$$0(5);
            }
            PhpClassConstantAccessedViaChildClassInspection.replaceWithClassReference((PhpPsiElement)element, this.myClassFQN);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFQN";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpClassConstantAccessedViaChildClassInspection$PhpReplaceWithClassReferenceQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpClassConstantAccessedViaChildClassInspection$PhpReplaceWithClassReferenceQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

