/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.codeSmell.PhpCaseInsensitiveProcessor;
import com.jetbrains.php.lang.inspections.quickfix.PhpCaseSensitiveQuickFix;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpCaseInsensitiveFunctionProcessor
implements PhpCaseInsensitiveProcessor {
    ProblemsHolder myHolder;

    public PhpCaseInsensitiveFunctionProcessor(ProblemsHolder holder) {
        this.myHolder = holder;
    }

    @Override
    public void process(PhpReference reference, String resolvedElementName) {
        ASTNode nameNode = reference.getNameNode();
        Object elementToRegister = nameNode != null ? nameNode.getPsi() : reference;
        this.myHolder.registerProblem((PsiElement)elementToRegister, PhpBundle.message("inspection.codeSmell.function.call.is.not.casesensitive", new Object[0]), new LocalQuickFix[]{new PhpFunctionCaseInsensitiveQuickFix(resolvedElementName)});
    }

    static class PhpFunctionCaseInsensitiveQuickFix
    extends PhpCaseSensitiveQuickFix {
        PhpFunctionCaseInsensitiveQuickFix(String resolvedName) {
            super(resolvedName);
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            FunctionReference reference;
            if (project == null) {
                PhpFunctionCaseInsensitiveQuickFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                PhpFunctionCaseInsensitiveQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpFunctionCaseInsensitiveQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement instanceof FunctionReference) {
                FunctionReference fn;
                reference = fn = (FunctionReference)startElement;
            } else {
                PsiElement psiElement = startElement.getParent();
                if (psiElement instanceof FunctionReference) {
                    FunctionReference fn;
                    reference = fn = (FunctionReference)psiElement;
                } else {
                    return;
                }
            }
            reference.handleElementRename(this.myResolvedName);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.case.sensitive.name", "function/method reference");
            if (string == null) {
                PhpFunctionCaseInsensitiveQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpCaseInsensitiveFunctionProcessor$PhpFunctionCaseInsensitiveQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpCaseInsensitiveFunctionProcessor$PhpFunctionCaseInsensitiveQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

