/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpArgumentWithoutNamedIdentifierInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNamedArgumentUsageInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpNamedArgumentUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpParameterList(ParameterList list) {
                List<PsiElement> arguments = Arrays.asList(list.getParameters());
                int indexOfLastPositionalArgument = PhpArgumentWithoutNamedIdentifierInspection.getIndexOfLastPositionalArgument(arguments);
                if (indexOfLastPositionalArgument == arguments.size() - 1) {
                    return;
                }
                List<List<Parameter>> parameters = PhpArgumentWithoutNamedIdentifierInspection.resolveParameters(list);
                if (parameters.isEmpty()) {
                    return;
                }
                for (int i = indexOfLastPositionalArgument + 1; i < arguments.size(); ++i) {
                    List<Parameter> mappedParameters = PhpArgumentWithoutNamedIdentifierInspection.getMappedParameters(parameters, arguments, i);
                    Parameter param = PhpArgumentWithoutNamedIdentifierInspection.getApplicableParameter(mappedParameters);
                    if (param == null) {
                        return;
                    }
                    if (param.isVariadic()) {
                        this.checkRemainVariadics(arguments, indexOfLastPositionalArgument, PhpNamedArgumentUsageInspection.getParameters(param), i, param);
                        return;
                    }
                    if (!1.allParametersWithIndex(mappedParameters, i)) {
                        return;
                    }
                    this.registerProblem(arguments, indexOfLastPositionalArgument, i);
                }
            }

            private static boolean allParametersWithIndex(List<Parameter> mappedParameters, int i) {
                if (mappedParameters.contains(null)) {
                    return false;
                }
                int[] indices = mappedParameters.stream().mapToInt(parameter -> PhpNamedArgumentUsageInspection.getParameters(parameter).indexOf(parameter)).distinct().toArray();
                return indices.length == 1 && indices[0] == i;
            }

            private void checkRemainVariadics(List<PsiElement> arguments, int indexOfLastPositionalArgument, List<Parameter> parameters, int firstVariadicIndex, Parameter param) {
                if (IntStream.range(firstVariadicIndex + 1, arguments.size()).allMatch(i -> PhpParamsInspection.getMappedParam(arguments, parameters, i) == param)) {
                    for (int i2 = firstVariadicIndex; i2 < arguments.size(); ++i2) {
                        this.registerProblem(arguments, indexOfLastPositionalArgument, i2);
                    }
                }
            }

            private void registerProblem(List<PsiElement> arguments, int indexOfLastPositionalArgument, int argumentIndex) {
                if (!isOnTheFly && argumentIndex != arguments.size() - 1) {
                    return;
                }
                boolean firstNamedArgument = indexOfLastPositionalArgument + 1 == argumentIndex;
                PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(arguments.get(argumentIndex));
                if (nameIdentifier == null) {
                    return;
                }
                PsiElement parent = nameIdentifier.getParent();
                holder.registerProblem(parent, PhpAnnotatorVisitor.getRangeWithColon(nameIdentifier).shiftLeft(parent.getTextRange().getStartOffset()), PhpBundle.message("inspection.message.named.argument.usage", new Object[0]), new LocalQuickFix[]{new PhpRemoveArgumentNamesQuickFix(firstNamedArgument)});
            }
        };
    }

    private static List<Parameter> getParameters(@NotNull Parameter parameter) {
        Function function;
        if (parameter == null) {
            PhpNamedArgumentUsageInspection.$$$reportNull$$$0(1);
        }
        return (function = PhpPsiUtil.getParentOfClass((PsiElement)parameter, Function.class)) != null ? Arrays.asList(function.getParameters()) : Collections.emptyList();
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentUsageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpRemoveArgumentNamesQuickFix
    extends ModCommandQuickFix {
        private final boolean myFirstArgument;

        private PhpRemoveArgumentNamesQuickFix(boolean firstArgument) {
            this.myFirstArgument = firstArgument;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.argument.name", new Object[0]);
            if (string == null) {
                PhpRemoveArgumentNamesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = this.myFirstArgument ? this.getFamilyName() : PhpBundle.message("intention.name.remove.argument.names.from.all.arguments.up.to.current", new Object[0]);
            if (string == null) {
                PhpRemoveArgumentNamesQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            ParameterList parent;
            PsiElement identifier;
            if (project == null) {
                PhpRemoveArgumentNamesQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpRemoveArgumentNamesQuickFix.$$$reportNull$$$0(3);
            }
            if (!PhpPsiUtil.isOfType(identifier = (parent = (ParameterList)descriptor.getStartElement()).findElementAt(descriptor.getTextRangeInElement().getStartOffset()), PhpTokenTypes.IDENTIFIER)) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    PhpRemoveArgumentNamesQuickFix.$$$reportNull$$$0(4);
                }
                return modCommand;
            }
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)parent, (writableParent, updater) -> {
                PsiElement writableIdentifier = updater.getWritable(identifier);
                for (PsiElement argument : writableParent.getParameters()) {
                    PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(argument);
                    if (nameIdentifier == null) continue;
                    boolean stop = false;
                    PsiElement colon = PhpPsiUtil.getNextSiblingIgnoreWhitespace(nameIdentifier, true);
                    if (nameIdentifier == writableIdentifier) {
                        stop = true;
                    }
                    writableParent.deleteChildRange(nameIdentifier, colon);
                    if (!stop) continue;
                    return;
                }
            });
            if (modCommand == null) {
                PhpRemoveArgumentNamesQuickFix.$$$reportNull$$$0(5);
            }
            return modCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentUsageInspection$PhpRemoveArgumentNamesQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentUsageInspection$PhpRemoveArgumentNamesQuickFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

