/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.move.constant.PhpMoveFileConstantProcessor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PhpAttributeCanBeAddedToOverriddenMemberInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpAttributeCanBeAddedToOverriddenMemberInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method originalMethod) {
                HashSet processed = new HashSet();
                PhpAttributeCanBeAddedToOverriddenMemberInspection.processOverridingAttributes(originalMethod, (owner, attribute) -> {
                    LocalQuickFix fix;
                    if (!processed.add(attribute)) {
                        return;
                    }
                    boolean isMethod = attribute.getParent().getParent() instanceof Method;
                    String message = isMethod ? PhpBundle.message("attribute.can.be.added.to.overridden.method", new Object[0]) : PhpBundle.message("attribute.can.be.added.to.overridden.parameter", new Object[0]);
                    LocalQuickFix localQuickFix = fix = isMethod ? 1.getFix(originalMethod) : PhpAddAttributeToOverriddenEntityQuickFix.PARAMETER_INSTANCE;
                    if (originalMethod.isAbstract() || !isOnTheFly) {
                        holder.registerProblem((PsiElement)attribute, message, new LocalQuickFix[]{fix});
                    } else {
                        holder.registerProblem((PsiElement)attribute, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{fix});
                    }
                });
            }

            @NotNull
            private static LocalQuickFix getFix(Method originalMethod) {
                if (originalMethod.isAbstract()) {
                    LocalQuickFix localQuickFix = PhpAddAttributeToOverriddenEntityQuickFix.ABSTRACT_METHOD_INSTANCE;
                    if (localQuickFix == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return localQuickFix;
                }
                LocalQuickFix localQuickFix = PhpAddAttributeToOverriddenEntityQuickFix.METHOD_INSTANCE;
                if (localQuickFix == null) {
                    1.$$$reportNull$$$0(1);
                }
                return localQuickFix;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/attributes/PhpAttributeCanBeAddedToOverriddenMemberInspection$1", "getFix"));
            }
        };
    }

    private static void processOverridingAttributes(Method method, BiConsumer<PhpAttributesOwner, PhpAttribute> consumer) {
        Collection attributes = method.getAttributes();
        Int2ObjectMap<Collection<PhpAttribute>> parametersAttributes = PhpAttributeCanBeAddedToOverriddenMemberInspection.getParametersWithIndicesAttributes(method);
        if (attributes.isEmpty() && parametersAttributes.isEmpty()) {
            return;
        }
        PhpClassHierarchyUtils.processOverridingMethods((Method)method, (member, subClass, baseClass) -> {
            PhpAttributeCanBeAddedToOverriddenMemberInspection.processOverridingAttributes(attributes, (PhpAttributesOwner)member, consumer);
            PhpAttributeCanBeAddedToOverriddenMemberInspection.processOverridingParameterAttributes(parametersAttributes, member, consumer);
            return true;
        });
    }

    @NotNull
    private static Int2ObjectMap<Collection<PhpAttribute>> getParametersWithIndicesAttributes(Method method) {
        Int2ObjectOpenHashMap parametersAttributes = new Int2ObjectOpenHashMap();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Collection paramAttributes = parameters[i].getAttributes();
            if (paramAttributes.isEmpty()) continue;
            parametersAttributes.put(i, (Object)paramAttributes);
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = parametersAttributes;
        if (int2ObjectOpenHashMap == null) {
            PhpAttributeCanBeAddedToOverriddenMemberInspection.$$$reportNull$$$0(1);
        }
        return int2ObjectOpenHashMap;
    }

    public static void shortenClassReferences(PhpPsiElement addedAttribute) {
        for (PhpReference reference : PhpAttributeCanBeAddedToOverriddenMemberInspection.getChildrenToReplaceFQNs((PsiElement)addedAttribute)) {
            PhpMoveFileConstantProcessor.replaceReferenceWithResolvedImport(reference.getProject(), addedAttribute, reference);
        }
    }

    private static @Unmodifiable @NotNull Collection<PhpReference> getChildrenToReplaceFQNs(PsiElement element) {
        Set set = ContainerUtil.union(PhpPsiUtil.findChildrenNonStrict(element, ClassReference.class), PhpPsiUtil.findChildrenNonStrict(element, ConstantReference.class));
        if (set == null) {
            PhpAttributeCanBeAddedToOverriddenMemberInspection.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static void processOverridingParameterAttributes(Int2ObjectMap<Collection<PhpAttribute>> parametersAttributes, Method method, BiConsumer<PhpAttributesOwner, PhpAttribute> consumer) {
        Parameter[] overridingParameters = method.getParameters();
        for (int i = 0; i < overridingParameters.length; ++i) {
            if (!parametersAttributes.containsKey(i)) continue;
            PhpAttributeCanBeAddedToOverriddenMemberInspection.processOverridingAttributes((Collection)parametersAttributes.get(i), (PhpAttributesOwner)overridingParameters[i], consumer);
        }
    }

    private static void processOverridingAttributes(Collection<PhpAttribute> attributesToOverride, PhpAttributesOwner overridingAttributesOwner, BiConsumer<PhpAttributesOwner, PhpAttribute> consumer) {
        Collection overridingAttributes = overridingAttributesOwner.getAttributes();
        for (PhpAttribute attributeToOverride : attributesToOverride) {
            if (ContainerUtil.exists((Iterable)overridingAttributes, overridingAttribute -> PhpLangUtil.equalsClassNames(attributeToOverride.getFQN(), overridingAttribute.getFQN()))) continue;
            consumer.accept(overridingAttributesOwner, attributeToOverride);
        }
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpAttributeCanBeAddedToOverriddenMemberInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpAttributeCanBeAddedToOverriddenMemberInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersWithIndicesAttributes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenToReplaceFQNs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static abstract class PhpAddAttributeToOverriddenEntityQuickFix
    extends ModCommandQuickFix {
        private static final LocalQuickFix METHOD_INSTANCE = new PhpAddAttributeToOverriddenEntityQuickFix(){

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = PhpBundle.message("intention.family.name.add.attribute.to.overridden.method", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/attributes/PhpAttributeCanBeAddedToOverriddenMemberInspection$PhpAddAttributeToOverriddenEntityQuickFix$1", "getFamilyName"));
            }
        };
        private static final LocalQuickFix ABSTRACT_METHOD_INSTANCE = new PhpAddAttributeToOverriddenEntityQuickFix(){

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = PhpBundle.message("intention.family.name.add.attribute.to.overridden.method.of.abstract.method", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/attributes/PhpAttributeCanBeAddedToOverriddenMemberInspection$PhpAddAttributeToOverriddenEntityQuickFix$2", "getFamilyName"));
            }
        };
        private static final LocalQuickFix PARAMETER_INSTANCE = new PhpAddAttributeToOverriddenEntityQuickFix(){

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = PhpBundle.message("intention.family.name.add.attribute.to.overridden.parameter", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/attributes/PhpAttributeCanBeAddedToOverriddenMemberInspection$PhpAddAttributeToOverriddenEntityQuickFix$3", "getFamilyName"));
            }
        };

        private PhpAddAttributeToOverriddenEntityQuickFix() {
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpAttribute attribute;
            if (project == null) {
                PhpAddAttributeToOverriddenEntityQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                PhpAddAttributeToOverriddenEntityQuickFix.$$$reportNull$$$0(1);
            }
            if ((attribute = PhpPsiUtil.getParentOfClass(descriptor.getStartElement(), false, PhpAttribute.class)) == null) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    PhpAddAttributeToOverriddenEntityQuickFix.$$$reportNull$$$0(2);
                }
                return modCommand;
            }
            PhpAttributesOwner attributeOwner = (PhpAttributesOwner)attribute.getParent().getParent();
            Method method = PhpPsiUtil.getParentOfClass((PsiElement)attribute, Method.class);
            if (method == null) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    PhpAddAttributeToOverriddenEntityQuickFix.$$$reportNull$$$0(3);
                }
                return modCommand;
            }
            HashSet ownerList = new HashSet();
            PhpAttributeCanBeAddedToOverriddenMemberInspection.processOverridingAttributes(method, (owner, missingAttribute) -> {
                if (missingAttribute == attribute && PhpAddAttributeToOverriddenEntityQuickFix.sameElements(attributeOwner, owner)) {
                    ownerList.add(owner);
                }
            });
            ModCommand modCommand = ModCommand.psiUpdate((ActionContext)ActionContext.from((ProblemDescriptor)descriptor), updater -> {
                for (PhpAttributesOwner owner : ContainerUtil.map((Collection)ownerList, arg_0 -> ((ModPsiUpdater)updater).getWritable(arg_0))) {
                    PhpAttributesList attributesListToAdd = PhpAddAttributeToOverriddenEntityQuickFix.createAttributesListWithExpandedFQNs(project, attribute);
                    PhpAttributeCanBeAddedToOverriddenMemberInspection.shortenClassReferences((PhpPsiElement)owner.addBefore((PsiElement)attributesListToAdd, owner.getFirstChild()));
                }
            });
            if (modCommand == null) {
                PhpAddAttributeToOverriddenEntityQuickFix.$$$reportNull$$$0(4);
            }
            return modCommand;
        }

        @NotNull
        private static PhpAttributesList createAttributesListWithExpandedFQNs(@NotNull Project project, PhpAttribute attribute) {
            if (project == null) {
                PhpAddAttributeToOverriddenEntityQuickFix.$$$reportNull$$$0(5);
            }
            PsiElement copy = attribute.copy();
            PhpAddAttributeToOverriddenEntityQuickFix.expandFQNsInCopyReferences(project, attribute, copy);
            PhpAttributesList phpAttributesList = PhpPsiElementFactory.createAttributesList(project, copy.getText());
            if (phpAttributesList == null) {
                PhpAddAttributeToOverriddenEntityQuickFix.$$$reportNull$$$0(6);
            }
            return phpAttributesList;
        }

        private static void expandFQNsInCopyReferences(@NotNull Project project, PhpAttribute attribute, PsiElement copy) {
            if (project == null) {
                PhpAddAttributeToOverriddenEntityQuickFix.$$$reportNull$$$0(7);
            }
            HashMap<PhpReference, String> replacements = new HashMap<PhpReference, String>();
            for (PhpReference phpReference : PhpAttributeCanBeAddedToOverriddenMemberInspection.getChildrenToReplaceFQNs(copy)) {
                PsiElement at = attribute.getContainingFile().findElementAt(phpReference.getTextRange().shiftRight(attribute.getTextRange().getStartOffset()).getStartOffset());
                PhpReference ref = PhpPsiUtil.getParentOfClass(at, false, PhpReference.class);
                assert (ref != null);
                String fqn = ref.getFQN();
                if (fqn == null) continue;
                replacements.put(phpReference, fqn);
            }
            for (Map.Entry entry : replacements.entrySet()) {
                ((PhpReference)entry.getKey()).replace((PsiElement)PhpPsiElementFactory.createClassReference(project, (String)entry.getValue()));
            }
        }

        private static boolean sameElements(PhpAttributesOwner one, PhpAttributesOwner another) {
            if (one instanceof Method) {
                return another instanceof Method;
            }
            if (one instanceof Parameter) {
                return another instanceof Parameter && PhpLangUtil.equalsParameterNames(another.getName(), one.getName());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpAttributeCanBeAddedToOverriddenMemberInspection$PhpAddAttributeToOverriddenEntityQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpAttributeCanBeAddedToOverriddenMemberInspection$PhpAddAttributeToOverriddenEntityQuickFix";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAttributesListWithExpandedFQNs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createAttributesListWithExpandedFQNs";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "expandFQNsInCopyReferences";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 6 -> new IllegalStateException(string);
            };
        }
    }
}

