/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.assignment;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.assignment.PhpReplaceableAssignmentCondition;
import com.jetbrains.php.lang.inspections.quickfix.assignment.PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.assignment.PhpReplaceAssignmentWithOperatorAssignmentQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpAssignmentReplaceableWithOperatorAssignmentInspection
extends PhpInspection {
    private static final TokenSet alwaysReplaceableOperatorTypes = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsMATH_OPS, PhpTokenTypes.tsBIT_BINARY_OPS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opCONCAT})});
    private static final TokenSet replaceableOperatorTypes74 = TokenSet.orSet((TokenSet[])new TokenSet[]{alwaysReplaceableOperatorTypes, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opCOALESCE})});
    private static final TokenSet commutativeOperatorTypes = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opMUL, PhpTokenTypes.opBIT_AND, PhpTokenTypes.opBIT_OR, PhpTokenTypes.opBIT_XOR});
    private static final Condition<AssignmentExpression> alwaysReplaceableAssignmentCondition = new PhpReplaceableAssignmentCondition(alwaysReplaceableOperatorTypes, commutativeOperatorTypes);
    private static final Condition<AssignmentExpression> replaceableAssignmentCondition74 = new PhpReplaceableAssignmentCondition(replaceableOperatorTypes74, commutativeOperatorTypes);

    private static boolean isReplaceableAssignment(AssignmentExpression expression) {
        Project project = expression.getProject();
        if (PhpLanguageFeature.COALESCE_ASSIGN.isSupported(project)) {
            return replaceableAssignmentCondition74.value((Object)expression);
        }
        return alwaysReplaceableAssignmentCondition.value((Object)expression);
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpAssignmentReplaceableWithOperatorAssignmentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpAssignmentExpression(AssignmentExpression assignment) {
                BinaryExpression expression = (BinaryExpression)ObjectUtils.tryCast((Object)assignment.getValue(), BinaryExpression.class);
                if (expression == null) {
                    return;
                }
                if (PhpAssignmentReplaceableWithOperatorAssignmentInspection.isReplaceableAssignment(assignment)) {
                    String operator = PhpReplaceAssignmentWithOperatorAssignmentQuickFix.getOperatorText(expression);
                    String name = PhpBundle.message("quickfix.replace.assignment.with.operator.assignment.name", operator);
                    this.registerProblem(new PhpReplaceAssignmentWithOperatorAssignmentQuickFix(name), assignment);
                } else {
                    TokenSet replaceableOperatorTypes = PhpLanguageFeature.COALESCE_ASSIGN.isSupported(assignment.getProject()) ? replaceableOperatorTypes74 : alwaysReplaceableOperatorTypes;
                    PsiElement operator = PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.getReplaceableOperatorWithMinorPrecedence(assignment, replaceableOperatorTypes);
                    if (operator != null) {
                        String name = PhpBundle.message("quickfix.replace.assignment.with.operator.assignment.name", PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.getOperatorText(operator));
                        this.registerProblem(new PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix(name, operator), assignment);
                    }
                }
            }

            private void registerProblem(PhpReplaceAssignmentWithOperatorAssignmentQuickFix fix, AssignmentExpression assignment) {
                String message = PhpBundle.message("inspection.assignment.replaceable.with", fix.getReplacementExpressionString(assignment));
                holder.registerProblem((PsiElement)assignment, message, PhpReplaceableAssignmentCondition.getHighlightType(assignment), new LocalQuickFix[]{fix});
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/assignment/PhpAssignmentReplaceableWithOperatorAssignmentInspection", "buildVisitor"));
    }
}

