/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.PhpSwitchCaseAwareInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpCustomExitPointRegistry;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpIncludeInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpVariableDocDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessDynamicVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.dataFlow.PhpDFAMap;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpBooleanConstantValueDfaAnalyzer;
import com.jetbrains.php.lang.intentions.addConstructorParameters.PhpAddConstructorParametersIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.GlobalImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUndefinedVariableInspection
extends PhpInspection {
    private static final InitializeVarQuickFix INITIALIZE_FIX = new InitializeVarQuickFix();
    public static final String INITIALIZE_FIX_NAME = INITIALIZE_FIX.getName();
    private static final CreateParameterQuickFix CREATE_PARAMETER_FIX = new CreateParameterQuickFix();
    public static final String CREATE_PARAMETER_FIX_NAME = CREATE_PARAMETER_FIX.getName();
    public static final LocalQuickFix[] FIXES = new LocalQuickFix[]{INITIALIZE_FIX};
    public static final LocalQuickFix[] FIXES_AND_CREATE_PARAMETER_FIX = (LocalQuickFix[])ArrayUtil.append((Object[])FIXES, (Object)((Object)CREATE_PARAMETER_FIX));
    public boolean ENABLE_IN_FILE_SCOPE = true;
    public boolean REPORT_CAN_BE_UNDEFINED = true;
    public boolean IGNORE_INCLUDE = false;
    public boolean FILE_SCOPE_HIGHLIGHT_TYPE = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                Set<CharSequence> predefined = PhpUndefinedVariableInspection.getPredefinedVariableNames(function);
                if (predefined == null) {
                    return;
                }
                PhpUndefinedVariableInspection.this.analyzeScope((PhpScopeHolder)function, predefined, holder, isOnTheFly);
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }

            public void visitPhpFile(PhpFile file) {
                if (PhpUndefinedVariableInspection.this.ENABLE_IN_FILE_SCOPE) {
                    PhpUndefinedVariableInspection.this.analyzeScope((PhpScopeHolder)file, file.getPredefinedVariables(), holder, isOnTheFly);
                } else {
                    super.visitPhpFile(file);
                }
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                PhpUndefinedVariableInspection.this.analyzeScope((PhpScopeHolder)namespace, namespace.getPredefinedVariables(), holder, isOnTheFly);
            }
        };
    }

    @Nullable
    public static Set<CharSequence> getPredefinedVariableNames(Function function) {
        Parameter[] parameters;
        HashSet<CharSequence> predefined = null;
        if (function.isClosure()) {
            if (FunctionImpl.isShortArrowFunction(function)) {
                return null;
            }
            PhpUseList useList = (PhpUseList)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (useList != null) {
                List<Variable> variables = PhpPsiUtil.getChildren((PsiElement)useList, (Condition<? super PsiElement>)Variable.INSTANCEOF);
                for (Variable variable : variables) {
                    CharSequence variableName = variable.getNameCS();
                    if (StringUtil.isEmpty((CharSequence)variableName)) continue;
                    if (predefined == null) {
                        predefined = new HashSet();
                    }
                    predefined.add(variableName);
                }
            }
        }
        if ((parameters = function.getParameters()).length == 0) {
            if (predefined == null) {
                predefined = function.getPredefinedVariables();
            }
        } else {
            if (predefined == null) {
                predefined = new HashSet<CharSequence>();
            }
            for (Parameter parameter : parameters) {
                predefined.add(parameter.getNameCS());
            }
        }
        return predefined;
    }

    private void analyzeScope(final @NotNull PhpScopeHolder scopeHolder, final @NotNull Set<CharSequence> predefinedVariables, final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (scopeHolder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(1);
        }
        if (predefinedVariables == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(3);
        }
        final PhpControlFlow controlFlow = PhpCustomExitPointRegistry.getControlFlow(scopeHolder);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)controlFlow.getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement variableToHighlight;
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (!access.isRead() && access != PhpAccessInstruction.Access.COMPACT_READ_ACCESS) {
                    return true;
                }
                CharSequence variableName = instruction.getVariableName();
                if (PhpLangUtil.equalsVariableNames("this", variableName)) {
                    return true;
                }
                PhpPsiElement anchor = instruction.getAnchor();
                if (PhpWorkaroundUtil.getArrayAccess(instruction).isWrite()) {
                    return true;
                }
                if (PhpUndefinedVariableInspection.isStaticFieldReference((PsiElement)anchor)) {
                    return true;
                }
                if (PhpUndefinedVariableInspection.this.IGNORE_INCLUDE && scopeHolder instanceof PhpFile && anchor instanceof PhpTypedElement && !((PhpTypedElement)anchor).getGlobalType().filterUnknown().isEmpty()) {
                    return true;
                }
                PhpDFAMap<PhpReachingDefinitionsDFAnalyzer.Result> dfaMap = PhpDFAMap.create(new MyDFAnalyzer());
                Ref canBeDefined = new Ref((Object)false);
                Ref canBeUndefined = new Ref((Object)false);
                HashMap<CharSequence, Collection<Object>> dfaStateOfVariables = new HashMap<CharSequence, Collection<Object>>();
                HashSet<PsiElement> processedViaDFAConditions = new HashSet<PsiElement>();
                int initialNumber = instruction.num();
                PhpInstructionProcessor processor2 = this.createProcessor(variableName, dfaMap, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, dfaStateOfVariables, processedViaDFAConditions, initialNumber);
                HashSet unreachableViaDFAInstructions = new HashSet();
                BitSet visited = new BitSet(instruction.num());
                PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, PhpUndefinedVariableInspection.createStrategyWithoutAlwaysFalseConditions(dfaStateOfVariables, processedViaDFAConditions, unreachableViaDFAInstructions), processor2, visited);
                if (!((Boolean)canBeDefined.get()).booleanValue() && !unreachableViaDFAInstructions.isEmpty()) {
                    for (PhpInstruction unreachableInstruction : unreachableViaDFAInstructions) {
                        PhpControlFlowUtil.processPredecessors(unreachableInstruction, false, processor2, visited);
                    }
                }
                Object object = variableToHighlight = PhpUndefinedVariableInspection.isEncapsVarInString(anchor) ? anchor.getFirstChild().getNextSibling() : anchor;
                if (variableToHighlight == null) {
                    return true;
                }
                if (!((Boolean)canBeDefined.get()).booleanValue()) {
                    if (!PhpUndefinedVariableInspection.isReachableCode(instruction, controlFlow)) {
                        return true;
                    }
                    LocalQuickFix[] fixes = PhpUndefinedVariableInspection.getUndefinedFixes((PsiElement)anchor, scopeHolder, isOnTheFly);
                    holder.registerProblem((PsiElement)variableToHighlight, PhpBundle.message("inspection.undefined.variable.problem1", new Object[0]), fixes);
                } else if (((Boolean)canBeUndefined.get()).booleanValue() && PhpUndefinedVariableInspection.this.REPORT_CAN_BE_UNDEFINED) {
                    if (!PhpUndefinedVariableInspection.isReachableCode(instruction, controlFlow)) {
                        return true;
                    }
                    holder.registerProblem((PsiElement)variableToHighlight, PhpBundle.message("inspection.undefined.variable.problem2", new Object[0]), ProblemHighlightType.WEAK_WARNING, LocalQuickFix.EMPTY_ARRAY);
                }
                return true;
            }

            @NotNull
            private PhpInstructionProcessor createProcessor(final CharSequence variableName, final PhpDFAMap<PhpReachingDefinitionsDFAnalyzer.Result> dfaMap, final Ref<Boolean> canBeDefined, final Ref<Boolean> canBeUndefined, final Map<CharSequence, Collection<Object>> dfaStateOfVariables, final Set<PsiElement> processedViaDFAConditions, final int initialNumber) {
                return new PhpSwitchCaseAwareInstructionProcessor<Map<String, PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState>>(){

                    public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                        return instruction.getResult();
                    }

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction curInstruction) {
                        PhpAccessInstruction.Access curAccess = curInstruction.getAccess();
                        if (initialNumber > curInstruction.num() && curAccess.isWrite()) {
                            PhpUndefinedVariableInspection.addState(curInstruction.getVariableName(), dfaStateOfVariables, (Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS);
                        }
                        if (PhpLangUtil.equalsVariableNames(variableName, curInstruction.getVariableName())) {
                            if (curAccess.isUnset()) {
                                canBeUndefined.set((Object)true);
                            } else {
                                if (curAccess.isLightRead()) {
                                    return true;
                                }
                                if (initialNumber > curInstruction.num() || !curAccess.isRead()) {
                                    canBeDefined.set((Object)true);
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public boolean processVariableDocDeclarationInstruction(PhpVariableDocDeclarationInstruction instruction) {
                        if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                            canBeDefined.set((Object)true);
                            return false;
                        }
                        return true;
                    }

                    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                        if (!PhpUndefinedVariableInspection.isPredefinedVariable(variableName, predefinedVariables)) {
                            canBeUndefined.set((Object)true);
                        } else {
                            canBeDefined.set((Object)true);
                        }
                        return true;
                    }

                    public boolean processIncludeInstruction(PhpIncludeInstruction instruction) {
                        if (!PhpUndefinedVariableInspection.this.IGNORE_INCLUDE) {
                            return super.processIncludeInstruction(instruction);
                        }
                        canBeDefined.set((Object)true);
                        return false;
                    }

                    public boolean processInstruction(PhpInstruction instruction) {
                        PhpAccessInstruction.Access curAccess;
                        if (instruction instanceof PhpAccessDynamicVariableInstructionImpl && !(curAccess = ((PhpAccessDynamicVariableInstructionImpl)instruction).getAccess()).isUnset() && !curAccess.isRead()) {
                            canBeDefined.set((Object)true);
                            return false;
                        }
                        return super.processInstruction(instruction);
                    }

                    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                        if (PhpCodeInsightUtil.isGlobalFunctionCallWithName(instruction.getFunctionReference(), "extract")) {
                            canBeDefined.set((Object)true);
                            return false;
                        }
                        return super.processPhpCallInstruction(instruction);
                    }

                    @Override
                    protected PhpConditionDFAnalyzer<Map<String, PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState>> getAnalyzer() {
                        return new PhpBooleanConstantValueDfaAnalyzer(){

                            @Override
                            @Nullable
                            protected Map<String, PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState> performDFAFromBooleanComparison(PsiElement left, PsiElement right, IElementType operationType, boolean result) {
                                Object map = super.performDFAFromBooleanComparison(left, right, operationType, result);
                                return result || map == null ? map : StreamEx.of(map.entrySet()).mapToEntry(Map.Entry::getKey, v -> PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS).toMap();
                            }
                        };
                    }

                    @Override
                    protected boolean processBaseConditionInstruction(PhpConditionInstruction instruction) {
                        PsiElement condition = instruction.getCondition();
                        if (condition == null) {
                            return true;
                        }
                        if (initialNumber > instruction.num()) {
                            this.addComputedConditions(instruction, dfaStateOfVariables, processedViaDFAConditions);
                            return ((PhpReachingDefinitionsDFAnalyzer.Result)dfaMap.get(instruction)).apply(variableName, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
                        }
                        return true;
                    }

                    private void addComputedConditions(PhpConditionInstruction instruction, Map<CharSequence, Collection<Object>> dfaStateOfVariables2, Collection<PsiElement> processedViaDFAConditionsRanges) {
                        PsiElement condition = instruction.getCondition();
                        if (condition == null) {
                            return;
                        }
                        if (PhpUndefinedVariableInspection.processedElementsContainsOneOfParent(processedViaDFAConditionsRanges, condition.getParent())) {
                            return;
                        }
                        processedViaDFAConditionsRanges.add(condition);
                        Set entries = ((Map)this.performDFA(instruction)).entrySet();
                        if (!entries.isEmpty()) {
                            for (Map.Entry entry : entries) {
                                PhpUndefinedVariableInspection.addState((CharSequence)entry.getKey(), dfaStateOfVariables2, entry.getValue());
                            }
                        } else {
                            PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState state = (PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState)((Object)new PhpDfaBaseStateConditionDFAnalyzer(true, true).performDFA(instruction));
                            if (!StringUtil.isEmpty((CharSequence)state.getVariableName())) {
                                PhpUndefinedVariableInspection.addState(state.getVariableName(), dfaStateOfVariables2, state.getState());
                            }
                        }
                    }
                };
            }
        });
    }

    private static boolean processedElementsContainsOneOfParent(Collection<PsiElement> processedElements, PsiElement traverseFrom) {
        while (traverseFrom != null) {
            if (processedElements.contains(traverseFrom)) {
                return true;
            }
            traverseFrom = traverseFrom.getParent();
        }
        return false;
    }

    private static boolean isEncapsVarInString(PhpPsiElement anchor) {
        return anchor.getParent() instanceof StringLiteralExpression && PhpPsiUtil.isOfType(anchor.getFirstChild(), PhpTokenTypes.chLBRACE, PhpTokenTypes.DOLLAR_LBRACE);
    }

    public static void addState(CharSequence variableName, Map<CharSequence, Collection<Object>> dfaStateOfVariables, Object state) {
        Collection computedStates = dfaStateOfVariables.computeIfAbsent(variableName, t -> new HashSet());
        if (computedStates.stream().anyMatch(s -> s != state && s.getClass() == state.getClass())) {
            computedStates.add(PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS);
        } else {
            computedStates.add(state);
        }
    }

    private static @NotNull PhpControlFlowUtil.AppendPredecessorsStrategy createStrategyWithoutAlwaysFalseConditions(final Map<CharSequence, Collection<Object>> dfaStateOfVariableNames, final Set<PsiElement> processedViaDFAConditions, final Collection<? super PhpInstruction> unreachableViaDFAInstructions) {
        return new PhpControlFlowUtil.AppendPredecessorsStrategy(){

            @Override
            public void appendPredecessors(@NotNull PhpInstruction instruction, @NotNull Collection<PhpInstruction> pool, int initialNumber, List<PhpInstruction> predecessors) {
                if (instruction == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pool == null) {
                    3.$$$reportNull$$$0(1);
                }
                PhpControlFlowBuilder.PhpSkippedLoopInstruction skipLoopPredecessor = ((PhpInstructionImpl)instruction).getSkipLoopPredecessor();
                int size = predecessors.size();
                for (int i = 0; i < size; ++i) {
                    PhpInstruction predecessor = predecessors.get(i);
                    if (initialNumber == predecessor.num()) continue;
                    if (predecessor instanceof PhpConditionInstruction && this.predecessorIsAlwaysFalse((PhpConditionInstruction)predecessor) || PhpControlFlowUtil.alwaysNonEmpty(skipLoopPredecessor, predecessor)) {
                        unreachableViaDFAInstructions.add(predecessor);
                        continue;
                    }
                    pool.add(predecessor);
                }
            }

            private boolean predecessorIsAlwaysFalse(PhpConditionInstruction predecessor) {
                PhpDfaBaseStateConditionDFAnalyzer invertedAnalyzer;
                PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState stateOfInvertedInstruction;
                Collection states;
                PsiElement condition = predecessor.getCondition();
                if (condition == null || PhpUndefinedVariableInspection.processedElementsContainsOneOfParent(processedViaDFAConditions, condition)) {
                    return false;
                }
                PhpBooleanConstantValueDfaAnalyzer analyzer = new PhpBooleanConstantValueDfaAnalyzer();
                Map constStateOfPredecessor = (Map)analyzer.performDFA(predecessor);
                for (Map.Entry predecessorsState : constStateOfPredecessor.entrySet()) {
                    String predecessorVariableName = (String)predecessorsState.getKey();
                    PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState predecessorStateValue = (PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState)((Object)predecessorsState.getValue());
                    PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState aTrue = PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.TRUE;
                    if (this.isAmbiguous(predecessorVariableName) || (predecessorStateValue != PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.FALSE || !PhpUndefinedVariableInspection.hasState(predecessorVariableName, (Object)aTrue, dfaStateOfVariableNames)) && (predecessorStateValue != PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.TRUE || !PhpUndefinedVariableInspection.hasState(predecessorVariableName, (Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.FALSE, dfaStateOfVariableNames))) continue;
                    return true;
                }
                return !predecessor.getResult() && !(states = (Collection)dfaStateOfVariableNames.getOrDefault((stateOfInvertedInstruction = (PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState)((Object)(invertedAnalyzer = new PhpDfaBaseStateConditionDFAnalyzer(true, true){

                    @Override
                    @NotNull
                    public PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState and(@NotNull PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState leftOperand, @NotNull PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState rightOperand, boolean conditionResult) {
                        if (leftOperand == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (rightOperand == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState phpVariableDfaState = super.and(leftOperand, rightOperand, !conditionResult);
                        if (phpVariableDfaState == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return phpVariableDfaState;
                    }

                    @Override
                    @NotNull
                    public PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState or(@NotNull PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState leftOperand, @NotNull PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState rightOperand, boolean conditionResult) {
                        if (leftOperand == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (rightOperand == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState phpVariableDfaState = super.or(leftOperand, rightOperand, !conditionResult);
                        if (phpVariableDfaState == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        return phpVariableDfaState;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 2, 5 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "leftOperand";
                                break;
                            }
                            case 1: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "rightOperand";
                                break;
                            }
                            case 2: 
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$3$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$3$1";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "and";
                                break;
                            }
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[1] = "or";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "and";
                                break;
                            }
                            case 2: 
                            case 5: {
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray;
                                objectArray[2] = "or";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 2, 5 -> new IllegalStateException(string);
                        };
                    }
                }).performDFA(new PhpConditionInstructionImpl(predecessor.getCondition(), true)))).getVariableName(), Collections.emptySet())).isEmpty() && ContainerUtil.all((Collection)states, prevState -> prevState instanceof PhpDfaBasedTypeState && ((PhpDfaBasedTypeState)prevState).coveredBy(condition.getProject(), (PhpDfaBasedTypeState)stateOfInvertedInstruction.getState(), true));
            }

            private boolean isAmbiguous(CharSequence variableName) {
                return PhpUndefinedVariableInspection.hasState(variableName, (Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.AMBIGUOUS, dfaStateOfVariableNames) || PhpUndefinedVariableInspection.hasState(variableName, PhpDfaBasedTypeState.AMBIGUOUS, dfaStateOfVariableNames) || PhpUndefinedVariableInspection.hasState(variableName, (Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.TRUE, dfaStateOfVariableNames) && PhpUndefinedVariableInspection.hasState(variableName, (Object)PhpBooleanConstantValueDfaAnalyzer.BooleanConstantState.FALSE, dfaStateOfVariableNames);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "instruction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pool";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$3";
                objectArray[2] = "appendPredecessors";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean hasState(CharSequence variableName, Object state, Map<CharSequence, Collection<Object>> dfaStateOfVariableNames) {
        return ((Collection)dfaStateOfVariableNames.getOrDefault(variableName, Collections.emptySet())).contains(state);
    }

    private static boolean isStaticFieldReference(@Nullable PsiElement element) {
        PsiElement parent;
        if (element instanceof Variable && (parent = element.getParent()) instanceof FieldReference) {
            List children = PhpPsiUtil.getChildren(parent, (Condition<? super PsiElement>)Variable.INSTANCEOF);
            if (children.size() == 2 && children.get(1) == element) {
                return !PhpPsiUtil.isOfType(((PsiElement)children.get(1)).getPrevSibling(), PhpTokenTypes.ARROW);
            }
            return false;
        }
        return false;
    }

    private static boolean isReachableCode(@NotNull PhpAccessVariableInstruction instruction, @NotNull PhpControlFlow controlFlow) {
        if (instruction == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(4);
        }
        if (controlFlow == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(5);
        }
        return PhpControlFlowUtil.isPredecessor((PhpInstruction)instruction, (PhpInstruction)controlFlow.getEntryPoint());
    }

    public static LocalQuickFix @NotNull [] getUndefinedFixes(@NotNull PsiElement variable, @Nullable PhpScopeHolder scopeHolder, boolean isOnTheFly) {
        Collection vars;
        PhpAccessVariableInstruction access;
        if (variable == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(6);
        }
        if (!isOnTheFly) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                PhpUndefinedVariableInspection.$$$reportNull$$$0(7);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        Object[] fixes = FIXES;
        String variableName = null;
        if (variable instanceof PhpPsiElement && (access = PhpControlFlowUtil.getAccessInstructionInScopeHolder(scopeHolder, (PhpPsiElement)variable, PhpAccessVariableInstruction.class)) != null) {
            variableName = (String)access.getVariableName();
        }
        if (variableName != null && !(vars = PhpIndex.getInstance((Project)variable.getProject()).getVariablesByName(variableName)).isEmpty()) {
            fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)LocalQuickFix.from((ModCommandAction)new AddGlobalVariableQuickFix(variable, (PsiElement)scopeHolder)));
        }
        if (scopeHolder instanceof Function) {
            Function function = (Function)scopeHolder;
            fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)((Object)CREATE_PARAMETER_FIX));
            if (function.isClosure() && !FunctionImpl.isShortArrowFunction(function)) {
                fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)LocalQuickFix.from((ModCommandAction)new AddToUseQuickFix(variable, function)));
            }
            if (fixes == null) {
                PhpUndefinedVariableInspection.$$$reportNull$$$0(8);
            }
            return fixes;
        }
        if (fixes == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(9);
        }
        return fixes;
    }

    private static boolean isPredefinedVariable(@NotNull CharSequence variableName, @NotNull Set<CharSequence> predefinedVariables) {
        if (variableName == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(10);
        }
        if (predefinedVariables == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(11);
        }
        return PhpUndefinedVariableInspection.isPredefinedVariable(variableName) || predefinedVariables.contains(variableName);
    }

    private static boolean isPredefinedVariable(@NotNull CharSequence variableName) {
        if (variableName == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(12);
        }
        return PhpLangUtil.isSuperGlobal(variableName) || PhpLangUtil.isMagicPredefinedVariable(variableName);
    }

    private static boolean isCoalesceVariable(@Nullable PsiElement element) {
        if (element instanceof ArrayAccessExpression || element instanceof FieldReference || element instanceof Variable) {
            PsiElement parent = element.getParent();
            return PhpPsiUtil.isOfType(parent, PhpElementTypes.COALESCE_EXPRESSION) && parent instanceof BinaryExpression && ((BinaryExpression)parent).getLeftOperand() == element;
        }
        return false;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"REPORT_CAN_BE_UNDEFINED", (String)PhpBundle.message("inspection.undefined.variable.option.description.report.can.be.undefined", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ENABLE_IN_FILE_SCOPE", (String)PhpBundle.message("inspection.undefined.variable.option.description.enable.in.file.scope", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_INCLUDE", (String)PhpBundle.message("inspection.undefined.variable.option.description.ignore.include", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(13);
        }
        return optPane;
    }

    @NotNull
    private static PhpUseList createUseList(@NotNull Project project, Variable ... variables) {
        if (project == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(14);
        }
        String variablesList = Arrays.stream(variables).map(v -> "$" + v.getName()).collect(Collectors.joining(","));
        String useListString = "function() use(" + variablesList + ") {}";
        PhpUseList useList = PhpPsiElementFactory.createFromText(project, PhpUseList.class, useListString);
        assert (useList != null);
        PhpUseList phpUseList = useList;
        if (phpUseList == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(15);
        }
        return phpUseList;
    }

    public static void addUseListWithVariables(@NotNull Project project, Function function, Variable ... variables) {
        PsiElement anchor;
        if (project == null) {
            PhpUndefinedVariableInspection.$$$reportNull$$$0(16);
        }
        if ((anchor = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.chRPAREN)) == null) {
            anchor = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.chLPAREN);
        }
        if (anchor == null) {
            anchor = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.kwFUNCTION);
        }
        assert (anchor != null);
        PhpUseList phpUseList = PhpUndefinedVariableInspection.createUseList(project, variables);
        function.addAfter((PsiElement)phpUseList, anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedVariables";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndefinedFixes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReachableCode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUndefinedFixes";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedVariable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createUseList";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addUseListWithVariables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 13, 15 -> new IllegalStateException(string);
        };
    }

    private static class AddGlobalVariableQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        @NotNull
        private final SmartPsiElementPointer<PsiElement> myScopeHolderPointer;

        private AddGlobalVariableQuickFix(PsiElement anchor, PsiElement scopeHolder) {
            super(anchor);
            this.myScopeHolderPointer = SmartPointerManager.createPointer((PsiElement)scopeHolder);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("add.global.variable.quick.fix.family.name", new Object[0]);
            if (string == null) {
                AddGlobalVariableQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement variable) {
            if (context == null) {
                AddGlobalVariableQuickFix.$$$reportNull$$$0(1);
            }
            if (variable == null) {
                AddGlobalVariableQuickFix.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.isOfType(variable, PhpTokenTypes.VARIABLE)) {
                variable = variable.getParent();
            }
            if (variable == null) {
                return null;
            }
            String varName = AddGlobalVariableQuickFix.getVariableName(variable);
            if (varName == null) {
                return null;
            }
            return Presentation.of((String)PhpBundle.message("add.global.variable.quick.fix.text", varName));
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement variable, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                AddGlobalVariableQuickFix.$$$reportNull$$$0(3);
            }
            if (variable == null) {
                AddGlobalVariableQuickFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                AddGlobalVariableQuickFix.$$$reportNull$$$0(5);
            }
            if (PhpPsiUtil.isOfType(variable, PhpTokenTypes.VARIABLE)) {
                variable = variable.getParent();
            }
            if (variable == null) {
                return;
            }
            String varName = AddGlobalVariableQuickFix.getVariableName(variable);
            if (varName == null) {
                return;
            }
            PsiElement scopeHolder = this.myScopeHolderPointer.getElement();
            if (scopeHolder == null) {
                return;
            }
            PsiElement placeForGlobal = updater.getWritable(AddGlobalVariableQuickFix.findPlaceForGlobal(scopeHolder));
            if (placeForGlobal == null) {
                return;
            }
            if (placeForGlobal instanceof Global) {
                Variable variablePsi = PhpPsiElementFactory.createVariable(variable.getProject(), varName, true);
                GlobalImpl.addVariable((Global)placeForGlobal, variablePsi);
                return;
            }
            PhpCodeEditUtil.addGlobalStatementBefore(placeForGlobal, varName);
        }

        @Nullable
        private static String getVariableName(@NotNull PsiElement variable) {
            if (variable == null) {
                AddGlobalVariableQuickFix.$$$reportNull$$$0(6);
            }
            return variable instanceof Variable ? ((Variable)variable).getName() : PhpCodeInsightUtil.toString(variable);
        }

        @Nullable
        private static PsiElement findPlaceForGlobal(@NotNull PsiElement endElement) {
            if (endElement == null) {
                AddGlobalVariableQuickFix.$$$reportNull$$$0(7);
            }
            if (endElement instanceof PhpFile) {
                GroupStatement group = (GroupStatement)endElement.getFirstChild();
                return (PsiElement)group.statements().first();
            }
            if (endElement instanceof Function) {
                GroupStatement body = (GroupStatement)endElement.getLastChild();
                return (PsiElement)body.statements().first();
            }
            if (endElement instanceof PhpNamespace) {
                GroupStatement body = ((PhpNamespace)endElement).getStatements();
                if (body == null) {
                    return null;
                }
                return (PsiElement)body.statements().first();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$AddGlobalVariableQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$AddGlobalVariableQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariableName";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findPlaceForGlobal";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class CreateParameterQuickFix
    extends IntentionAndQuickFixAction {
        public static final Runnable DO_NOTHING = () -> {};

        @NotNull
        public String getName() {
            String string = CreateParameterQuickFix.getNameText();
            if (string == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CreateParameterQuickFix.getNameText();
            if (string == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
            Variable variable;
            if (project == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(2);
            }
            if ((variable = CreateParameterQuickFix.findVariable(psiFile, editor)) == null) {
                return;
            }
            PhpUseList useList = PhpPsiUtil.getParentOfClass((PsiElement)variable, PhpUseList.class);
            Function function = CreateParameterQuickFix.getTargetFunction(variable, useList);
            PhpParameterInfo newParameter = new PhpParameterInfo(-1, variable.getName());
            if (!CreateParameterQuickFix.isAvailable(variable)) {
                PhpMethodDescriptor functionDescriptor = new PhpMethodDescriptor(function);
                List<PhpParameterInfo> functionDescriptorParameters = functionDescriptor.getParameters();
                functionDescriptorParameters.add(newParameter);
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    this.emulateDialogInteractionInTests(functionDescriptor, functionDescriptorParameters);
                }
                PhpAddConstructorParametersIntention.addParameterUsingChangeSignature(project, functionDescriptor, functionDescriptorParameters, DO_NOTHING, variable);
                return;
            }
            assert (function != null);
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)function)) {
                return;
            }
            WriteAction.run(() -> PhpChangeSignatureProcessor.addParameterToFunctionSignature(project, function, Collections.singletonList(newParameter)));
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            if (project == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(3);
            }
            if (editor == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(4);
            }
            if (psiFile == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(5);
            }
            Variable variable = (Variable)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)editor.getCaretModel().getOffset(), Variable.class, (boolean)false);
            PhpUseList useList = PhpPsiUtil.getParentOfClass((PsiElement)variable, PhpUseList.class);
            Function function = CreateParameterQuickFix.getTargetFunction(variable, useList);
            if (variable == null || function == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    CreateParameterQuickFix.$$$reportNull$$$0(6);
                }
                return intentionPreviewInfo;
            }
            PhpParameterInfo newParameter = new PhpParameterInfo(-1, variable.getName());
            PhpChangeSignatureProcessor.addParameterToFunctionSignature(project, function, Collections.singletonList(newParameter));
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }

        protected void emulateDialogInteractionInTests(PhpMethodDescriptor functionDescriptor, List<PhpParameterInfo> functionDescriptorParameters) {
        }

        @Nullable
        private static Function getTargetFunction(Variable variable, PhpUseList useList) {
            Function function = PhpPsiUtil.getParentOfClass((PsiElement)variable, Function.class);
            if (useList != null) {
                function = PhpPsiUtil.getParentOfClass((PsiElement)function, Function.class);
            }
            return function;
        }

        private static boolean isAvailable(@NotNull Variable variable) {
            if (variable == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(8);
            }
            Function function = PhpPsiUtil.getParentOfClass((PsiElement)variable, true, Function.class);
            PhpUseList useList = PhpPsiUtil.getParentOfClass((PsiElement)variable, PhpUseList.class);
            if (useList != null) {
                function = PhpPsiUtil.getParentOfClass((PsiElement)function, Function.class);
            }
            if (function == null) {
                return false;
            }
            Query query = ReferencesSearch.search((PsiElement)function, (SearchScope)GlobalSearchScope.allScope((Project)function.getProject()));
            PsiReference functionReference = (PsiReference)query.findFirst();
            return functionReference == null;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile psiFile) {
            if (project == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(9);
            }
            return CreateParameterQuickFix.findVariable(psiFile, editor) != null;
        }

        @IntentionFamilyName
        @IntentionName
        private static String getNameText() {
            return PhpBundle.message("quickfix.create.parameter", new Object[0]);
        }

        @Nullable
        private static Variable findVariable(@NotNull PsiFile file, @Nullable Editor editor) {
            if (file == null) {
                CreateParameterQuickFix.$$$reportNull$$$0(10);
            }
            if (editor == null) {
                return null;
            }
            if (!IntentionPreviewUtils.isPreviewElement((PsiElement)file) && !file.getManager().isInProject((PsiElement)file)) {
                return null;
            }
            CaretModel caretModel = editor.getCaretModel();
            int position = caretModel.getOffset();
            return (Variable)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)position, Variable.class, (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 8, 9, 10 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$CreateParameterQuickFix";
                    break;
                }
                case 2: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$CreateParameterQuickFix";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findVariable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 8, 9, 10 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class AddToUseQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        @NotNull
        private final SmartPsiElementPointer<Function> myHolderPointer;

        private AddToUseQuickFix(PsiElement anchor, Function holder) {
            super(anchor);
            this.myHolderPointer = SmartPointerManager.createPointer((PsiElement)holder);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.add.to.use", new Object[0]);
            if (string == null) {
                AddToUseQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                AddToUseQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                AddToUseQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AddToUseQuickFix.$$$reportNull$$$0(3);
            }
            Variable variable = (Variable)startElement;
            Function function = (Function)updater.getWritable((PsiElement)((Function)this.myHolderPointer.getElement()));
            if (function == null) {
                return;
            }
            Project project = context.project();
            assert (function.isClosure());
            PhpUseList useList = (PhpUseList)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (useList != null) {
                PsiElement firstChild = useList.getChildren()[0];
                PsiElement openParen = PhpPsiUtil.getChildOfType((PsiElement)useList, PhpTokenTypes.chLPAREN);
                if (openParen != null && firstChild instanceof Variable) {
                    PsiElement comma = PhpPsiElementFactory.createComma(project);
                    comma = openParen.getParent().addAfter(comma, openParen);
                    Variable newUseParameter = PhpPsiElementFactory.createVariable(project, variable.getName(), true);
                    comma.getParent().addBefore((PsiElement)newUseParameter, comma);
                } else {
                    useList.replace((PsiElement)PhpUndefinedVariableInspection.createUseList(project, variable));
                }
            } else {
                PhpUndefinedVariableInspection.addUseListWithVariables(project, function, variable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$AddToUseQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$AddToUseQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class InitializeVarQuickFix
    extends PsiUpdateModCommandQuickFix {
        private InitializeVarQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("initialize.var.quick.fix.family.name", new Object[0]);
            if (string == null) {
                InitializeVarQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement variable, @NotNull ModPsiUpdater updater) {
            String string;
            if (project == null) {
                InitializeVarQuickFix.$$$reportNull$$$0(1);
            }
            if (variable == null) {
                InitializeVarQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                InitializeVarQuickFix.$$$reportNull$$$0(3);
            }
            if (PhpPsiUtil.isOfType(variable, PhpTokenTypes.VARIABLE)) {
                variable = variable.getParent();
            }
            StringBuilder builder2 = new StringBuilder();
            builder2.append("$");
            if (variable instanceof Variable) {
                Variable var = (Variable)variable;
                string = var.getName();
            } else {
                string = PhpCodeInsightUtil.toString(variable);
            }
            builder2.append(string);
            boolean needSpace = CodeStyle.getSettings((Project)project).getCommonSettings((Language)PhpLanguage.INSTANCE).SPACE_AROUND_ASSIGNMENT_OPERATORS;
            if (needSpace) {
                builder2.append(" = ;");
            } else {
                builder2.append("=;");
            }
            Statement statement = PhpCodeEditUtil.putStatementBefore(variable, PhpPsiElementFactory.createFromText(variable.getProject(), Statement.class, builder2.toString()));
            PsiElement semicolon = PhpPsiUtil.getChildOfType((PsiElement)statement, PhpTokenTypes.opSEMICOLON);
            if (semicolon != null) {
                updater.moveCaretTo(semicolon);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$InitializeVarQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$InitializeVarQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyDFAnalyzer
    extends PhpReachingDefinitionsDFAnalyzer {
        private MyDFAnalyzer() {
        }

        @Override
        @NotNull
        public PhpReachingDefinitionsDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
            if (condition instanceof PhpIsset) {
                PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                if (result) {
                    MyDFAnalyzer.fillDefinedVariables(dfaResult, ((PhpIsset)condition).getVariables());
                }
                PhpReachingDefinitionsDFAnalyzer.Result result2 = dfaResult;
                if (result2 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(0);
                }
                return result2;
            }
            if (condition instanceof PhpEmpty) {
                PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                if (!result) {
                    MyDFAnalyzer.fillDefinedVariables(dfaResult, ((PhpEmpty)condition).getVariables());
                }
                PhpReachingDefinitionsDFAnalyzer.Result result3 = dfaResult;
                if (result3 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(1);
                }
                return result3;
            }
            if (result && condition instanceof Variable) {
                Variable variable = (Variable)condition;
                PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                CharSequence variableName = variable.getNameCS();
                if (!StringUtil.isEmpty((CharSequence)variableName)) {
                    dfaResult.addDefined(variableName);
                }
                PhpReachingDefinitionsDFAnalyzer.Result result4 = dfaResult;
                if (result4 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(2);
                }
                return result4;
            }
            if (result && PhpUndefinedVariableInspection.isCoalesceVariable(condition)) {
                final PhpReachingDefinitionsDFAnalyzer.Result dfaResult = new PhpReachingDefinitionsDFAnalyzer.Result();
                condition.accept((PsiElementVisitor)new PhpElementVisitor(){

                    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                        PhpPsiElement value = expression.getValue();
                        if (value != null) {
                            value.accept((PsiElementVisitor)this);
                        }
                    }

                    public void visitPhpFieldReference(FieldReference fieldReference) {
                        PhpExpression reference = fieldReference.getClassReference();
                        if (reference != null) {
                            reference.accept((PsiElementVisitor)this);
                        }
                    }

                    public void visitPhpVariable(Variable variable) {
                        String variableName = variable.getName();
                        if (StringUtil.isNotEmpty((String)variableName)) {
                            dfaResult.addDefined(variableName);
                        }
                    }
                });
                PhpReachingDefinitionsDFAnalyzer.Result result5 = dfaResult;
                if (result5 == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(3);
                }
                return result5;
            }
            PhpReachingDefinitionsDFAnalyzer.Result result6 = (PhpReachingDefinitionsDFAnalyzer.Result)super.performDFA(condition, result);
            if (result6 == null) {
                MyDFAnalyzer.$$$reportNull$$$0(4);
            }
            return result6;
        }

        private static void fillDefinedVariables(PhpReachingDefinitionsDFAnalyzer.Result dfaResult, PhpExpression[] variables) {
            for (PhpExpression expression : variables) {
                for (String variableName : MyDFAnalyzer.extractVariableName((PsiElement)expression)) {
                    if (!StringUtil.isNotEmpty((String)variableName)) continue;
                    dfaResult.addDefined(variableName);
                }
            }
        }

        @NotNull
        private static Collection<String> extractVariableName(PsiElement expression) {
            if (expression instanceof Variable) {
                Set<String> set = Collections.singleton(((Variable)expression).getName());
                if (set == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(5);
                }
                return set;
            }
            if (expression instanceof ArrayAccessExpression) {
                return MyDFAnalyzer.extractVariableName((PsiElement)((ArrayAccessExpression)expression).getValue());
            }
            if (expression instanceof FieldReference) {
                Collection collection = Arrays.stream(expression.getChildren()).flatMap(c -> MyDFAnalyzer.extractVariableName(c).stream()).collect(Collectors.toSet());
                if (collection == null) {
                    MyDFAnalyzer.$$$reportNull$$$0(6);
                }
                return collection;
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                MyDFAnalyzer.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedVariableInspection$MyDFAnalyzer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performDFA";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extractVariableName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

