/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpUndefinedNamespaceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedNamespaceInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpNamespaceReference(PhpNamespaceReference reference) {
                PsiReference[] references;
                PsiReference psiReference;
                PsiElement parent = reference.getParent();
                if (parent instanceof PhpNamespace) {
                    return;
                }
                if (parent.getParent() instanceof PhpUse || PhpPsiUtil.isOfType(parent, PhpElementTypes.USE_BRACES)) {
                    Object name = reference.getFullName();
                    if (!((String)name).startsWith("\\")) {
                        name = "\\" + (String)name;
                    }
                    if (!PhpIndex.getInstance((Project)reference.getProject()).getChildNamespacesByParentName((String)name).isEmpty()) {
                        return;
                    }
                }
                if (parent instanceof PhpReference) {
                    PhpReference phpReference = (PhpReference)parent;
                    if (phpReference.multiResolve(false).length > 0) {
                        return;
                    }
                    if (phpReference instanceof ClassReference && PhpUndefinedClassInspection.classReferenceIsDfaDefined((ClassReference)phpReference)) {
                        return;
                    }
                }
                PsiReference psiReference2 = psiReference = (references = reference.getReferences()).length > 0 ? references[references.length - 1] : null;
                if (psiReference != null && psiReference instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)psiReference).multiResolve(false).length == 0 && psiReference.resolve() == null) {
                    holder.registerProblem(psiReference, PhpBundle.message("inspection.php.undefined.namespace.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpUndefinedNamespaceInspection", "buildVisitor"));
    }
}

