/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.EditorHelper;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.composer.LanguageLevelComposerParser;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSwitchComposerLanguageLevelQuickFix
implements LocalQuickFix {
    protected final PhpLanguageLevel myTargetLevel;
    @Nls
    protected final String myMessage;
    private static final String GIST_ID = "PhpComposerLanguageLevelVersionCanBeReplaced";
    private static final int VERSION = 1;
    private static final PsiFileGist<Boolean> COMPOSER_LANGUAGE_LEVEL_VERSION_CAN_BE_REPLACED = GistManager.getInstance().newPsiFileGist("PhpComposerLanguageLevelVersionCanBeReplaced", 1, (DataExternalizer)BooleanDataDescriptor.INSTANCE, file -> {
        JsonProperty property = PhpSwitchComposerLanguageLevelQuickFix.findPhpProperty(file);
        if (property == null) {
            return false;
        }
        JsonStringLiteral propertyValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
        if (propertyValue == null) {
            return false;
        }
        String data = propertyValue.getValue();
        LanguageLevelComposerParser.ParsedComposerLanguageLevel singleLanguageLevel = LanguageLevelComposerParser.parseSingleLanguageLevel(data);
        return singleLanguageLevel != null && singleLanguageLevel.isConcreteVersionSpecified() && singleLanguageLevel.isInclusiveHigher();
    });

    protected PhpSwitchComposerLanguageLevelQuickFix(PhpLanguageLevel level, @Nls String message) {
        this.myTargetLevel = level;
        this.myMessage = message;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.myMessage;
        if (string == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void doFix(@NotNull JsonProperty phpRequireProperty, @NotNull JsonStringLiteral phpRequirePropertyValue) {
        JsonStringLiteral updatedVersionLiteral;
        if (phpRequireProperty == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(1);
        }
        if (phpRequirePropertyValue == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(2);
        }
        if ((updatedVersionLiteral = this.createUpdatedVersionLiteral(phpRequireProperty, phpRequirePropertyValue)) == null) {
            return;
        }
        phpRequirePropertyValue.replace((PsiElement)updatedVersionLiteral);
    }

    @Nullable
    private JsonStringLiteral createUpdatedVersionLiteral(@NotNull JsonProperty phpRequireProperty, @NotNull JsonStringLiteral phpRequirePropertyValue) {
        LanguageLevelComposerParser.ParsedComposerLanguageLevel level;
        if (phpRequireProperty == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(3);
        }
        if (phpRequirePropertyValue == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(4);
        }
        if ((level = LanguageLevelComposerParser.parseSingleLanguageLevel(phpRequirePropertyValue.getValue())) == null) {
            return null;
        }
        return new JsonElementGenerator(phpRequireProperty.getProject()).createStringLiteral(level.getPrefix() + this.myTargetLevel.getPresentableName());
    }

    @Nullable
    public static JsonProperty findPhpProperty(PsiFile file) {
        JsonObject requirePropertyBody;
        if (!(file instanceof JsonFile)) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)ObjectUtils.tryCast((Object)file.getFirstChild(), JsonObject.class);
        if (jsonObject == null) {
            return null;
        }
        JsonProperty requireProperty = PhpSwitchComposerLanguageLevelQuickFix.findPropertyByAnyName(jsonObject, "require");
        JsonObject jsonObject2 = requirePropertyBody = requireProperty != null ? (JsonObject)ObjectUtils.tryCast((Object)requireProperty.getValue(), JsonObject.class) : null;
        if (requirePropertyBody == null) {
            return null;
        }
        return PhpSwitchComposerLanguageLevelQuickFix.findPropertyByAnyName(requirePropertyBody, ComposerConfigUtils.PHP_PROPERTIES_NAMES);
    }

    @Nullable
    private static JsonProperty findPropertyByAnyName(JsonObject jsonObject, String ... names) {
        return StreamEx.of((Object[])names).map(arg_0 -> ((JsonObject)jsonObject).findProperty(arg_0)).findFirst(Objects::nonNull).orElse(null);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        JsonProperty property;
        if (project == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(6);
        }
        if ((property = PhpSwitchComposerLanguageLevelQuickFix.getComposerPhpLevelProperty(project)) == null) {
            return;
        }
        JsonStringLiteral propertyValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
        if (propertyValue == null) {
            return;
        }
        this.doFix(property, propertyValue);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        JsonProperty property;
        if (project == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(7);
        }
        if (previewDescriptor == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(8);
        }
        if ((property = PhpSwitchComposerLanguageLevelQuickFix.getComposerPhpLevelProperty(project)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(9);
            }
            return intentionPreviewInfo;
        }
        JsonStringLiteral propertyValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
        if (propertyValue == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(10);
            }
            return intentionPreviewInfo;
        }
        JsonStringLiteral updatedVersionLiteral = this.createUpdatedVersionLiteral(property, propertyValue);
        if (updatedVersionLiteral == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }
        String oldText = propertyValue.getParent().getText();
        PsiFile parentCopy = (PsiFile)propertyValue.getContainingFile().copy();
        String newText = ((JsonStringLiteral)PsiTreeUtil.findSameElementInCopy((PsiElement)propertyValue, (PsiFile)parentCopy)).replace((PsiElement)updatedVersionLiteral).getParent().getText();
        return new IntentionPreviewInfo.CustomDiff((FileType)JsonFileType.INSTANCE, propertyValue.getContainingFile().getName(), oldText, newText);
    }

    @Nullable
    public static JsonProperty getComposerPhpLevelProperty(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(12);
        }
        if ((file = ComposerDataService.getInstance(project).getConfigFile()) == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return PhpSwitchComposerLanguageLevelQuickFix.findPhpProperty(psiFile);
    }

    @NotNull
    private static LocalQuickFix getManualInstance(@NotNull PhpLanguageLevel level) {
        if (level == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(13);
        }
        return new PhpSwitchComposerLanguageLevelManuallyQuickFix(level, PhpBundle.message("inspection.language.level.quick.fix.switch.language.level.in.composer.manually.0", level.getPresentableName()));
    }

    @NotNull
    private static LocalQuickFix getInstance(@NotNull PhpLanguageLevel level) {
        if (level == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(14);
        }
        return new PhpSwitchComposerLanguageLevelQuickFix(level, PhpBundle.message("inspection.language.level.quick.fix.switch.language.level.in.composer.0", level.getPresentableName()));
    }

    private static boolean composerLanguageLevelCanBeSafelyReplaced(@NotNull Project project) {
        VirtualFile virtualFileConfig;
        if (project == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(15);
        }
        PsiFile file = (virtualFileConfig = ComposerDataService.getInstance(project).getConfigFile()) != null ? PsiManager.getInstance((Project)project).findFile(virtualFileConfig) : null;
        return file != null && COMPOSER_LANGUAGE_LEVEL_VERSION_CAN_BE_REPLACED.getFileData(file) == Boolean.TRUE;
    }

    public static LocalQuickFix getInstance(@NotNull Project project, @NotNull PhpLanguageLevel preferableLanguageLevel, boolean onTheFly) {
        if (project == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(16);
        }
        if (preferableLanguageLevel == null) {
            PhpSwitchComposerLanguageLevelQuickFix.$$$reportNull$$$0(17);
        }
        if (PhpSwitchComposerLanguageLevelQuickFix.composerLanguageLevelCanBeSafelyReplaced(project)) {
            return PhpSwitchComposerLanguageLevelQuickFix.getInstance(preferableLanguageLevel);
        }
        return onTheFly ? PhpSwitchComposerLanguageLevelQuickFix.getManualInstance(preferableLanguageLevel) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpSwitchComposerLanguageLevelQuickFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpRequireProperty";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpRequirePropertyValue";
                break;
            }
            case 5: 
            case 7: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferableLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpSwitchComposerLanguageLevelQuickFix";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUpdatedVersionLiteral";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getComposerPhpLevelProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getManualInstance";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "composerLanguageLevelCanBeSafelyReplaced";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    private static class PhpSwitchComposerLanguageLevelManuallyQuickFix
    extends PhpSwitchComposerLanguageLevelQuickFix {
        protected PhpSwitchComposerLanguageLevelManuallyQuickFix(PhpLanguageLevel targetLevel, @Nls String message) {
            super(targetLevel, message);
        }

        @Override
        protected void doFix(@NotNull JsonProperty phpRequireProperty, @NotNull JsonStringLiteral phpRequirePropertyValue) {
            Editor editor;
            if (phpRequireProperty == null) {
                PhpSwitchComposerLanguageLevelManuallyQuickFix.$$$reportNull$$$0(0);
            }
            if (phpRequirePropertyValue == null) {
                PhpSwitchComposerLanguageLevelManuallyQuickFix.$$$reportNull$$$0(1);
            }
            if ((editor = EditorHelper.openInEditor((PsiElement)phpRequireProperty)) == null) {
                return;
            }
            WriteAction.run(() -> this.runLiveTemplateOnPhpProperty(phpRequireProperty, phpRequirePropertyValue, editor));
        }

        @Override
        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                PhpSwitchComposerLanguageLevelManuallyQuickFix.$$$reportNull$$$0(2);
            }
            if (previewDescriptor == null) {
                PhpSwitchComposerLanguageLevelManuallyQuickFix.$$$reportNull$$$0(3);
            }
            return new IntentionPreviewInfo.Html(PhpBundle.message("opens.composer.json.to.change.php.property", new Object[0]));
        }

        private void runLiveTemplateOnPhpProperty(JsonProperty property, JsonStringLiteral propertyValue, Editor editor) {
            String text = propertyValue.getText();
            if (text.length() <= 2) {
                return;
            }
            TemplateBuilderImpl builder2 = new TemplateBuilderImpl((PsiElement)property);
            builder2.replaceElement((PsiElement)propertyValue, TextRange.create((int)1, (int)(text.length() - 1)), (Expression)this.getExpression(text));
            TemplateManager.getInstance((Project)property.getProject()).startTemplate(editor, builder2.buildInlineTemplate());
        }

        @NotNull
        private ConstantNode getExpression(String text) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return new ConstantNode(this.myTargetLevel.getPresentableName());
            }
            ConstantNode constantNode = new ConstantNode(JsonPsiUtil.stripQuotes((String)text)).withLookupStrings(new String[]{this.myTargetLevel.getPresentableName()});
            if (constantNode == null) {
                PhpSwitchComposerLanguageLevelManuallyQuickFix.$$$reportNull$$$0(4);
            }
            return constantNode;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpRequireProperty";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpRequirePropertyValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpSwitchComposerLanguageLevelQuickFix$PhpSwitchComposerLanguageLevelManuallyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpSwitchComposerLanguageLevelQuickFix$PhpSwitchComposerLanguageLevelManuallyQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

