/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpSetVisibilityCanBeRemovedInspectionKt;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpModifierListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpSetVisibilityCanBeRemovedInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "childFieldContainsSetModifier", "field", "Lcom/jetbrains/php/lang/psi/elements/Field;", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "intellij.php.impl"})
public final class PhpSetVisibilityCanBeRemovedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(this, holder){
            final /* synthetic */ PhpSetVisibilityCanBeRemovedInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPhpField(Field field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                if (!(field instanceof FieldImpl)) {
                    return;
                }
                PhpClassFieldsList phpClassFieldsList = ((FieldImpl)field).getParentList();
                if (phpClassFieldsList == null || (phpClassFieldsList = phpClassFieldsList.getModifierList()) == null) {
                    return;
                }
                this.checkField(field, (PsiElement)phpClassFieldsList);
            }

            public void visitPhpParameter(Parameter parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                if (!parameter.isPromotedField()) {
                    return;
                }
                this.checkField((Field)parameter, (PsiElement)parameter);
            }

            private final void checkField(Field field, PsiElement elementToRegisterProblem) {
                PsiElement elementToRemove;
                TextRange textRange;
                boolean removeSetKw;
                if (field.isReadonly()) {
                    return;
                }
                PhpModifier phpModifier = field.getModifier();
                Intrinsics.checkNotNullExpressionValue((Object)phpModifier, (String)"getModifier(...)");
                PhpModifier modifier = phpModifier;
                if (modifier.getSetAccess() == null || modifier.getAccess() != modifier.getSetAccess()) {
                    return;
                }
                PsiElement setModifierPsi = PhpModifierListImpl.getSetOperationModifierPsiElement((PsiElement)field);
                PhpModifier.Access access = modifier.getSetAccess();
                Intrinsics.checkNotNull((Object)access);
                if (!access.isPublic() && !PhpSetVisibilityCanBeRemovedInspectionKt.access$getModifierIsDefined(field) || setModifierPsi == null || PhpSetVisibilityCanBeRemovedInspection.access$childFieldContainsSetModifier(this.this$0, field)) {
                    return;
                }
                PhpModifier.Access access2 = modifier.getSetAccess();
                Intrinsics.checkNotNull((Object)access2);
                boolean it = removeSetKw = access2.isPublic() && !PhpSetVisibilityCanBeRemovedInspectionKt.access$getModifierIsDefined(field);
                boolean bl = false;
                TextRange textRange2 = setModifierPsi.getTextRangeInParent();
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRangeInParent(...)");
                TextRange textRangeInParent = textRange2;
                if (it) {
                    textRange = new TextRange(textRangeInParent.getStartOffset() + 6, textRangeInParent.getEndOffset() + 5);
                } else {
                    TextRange textRange3 = textRangeInParent.grown(5);
                    Intrinsics.checkNotNull((Object)textRange3);
                    textRange = textRange3;
                }
                TextRange range = textRange;
                if (elementToRegisterProblem.getTextRangeInParent().getEndOffset() < range.getEndOffset()) {
                    return;
                }
                PsiElement psiElement = elementToRemove = removeSetKw ? PhpPsiUtil.getChildOfType(elementToRegisterProblem, PhpTokenTypes.kwSET) : setModifierPsi;
                if (elementToRemove == null) {
                    return;
                }
                this.$holder.problem(elementToRegisterProblem, PhpBundle.message("inspection.set.visibility.can.be.removed", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).range(range).fix((ModCommandAction)new PhpDeleteElementQuickFix(elementToRemove)).register();
            }
        };
    }

    private final boolean childFieldContainsSetModifier(Field field) {
        Ref childFieldContainsSetModifier2 = new Ref((Object)false);
        PhpClassHierarchyUtils.processOverridingFields((Field)field, (PhpClassHierarchyUtils.TypedHierarchyMemberProcessor)new PhpClassHierarchyUtils.TypedHierarchyMemberProcessor((Ref<Boolean>)childFieldContainsSetModifier2){
            final /* synthetic */ Ref<Boolean> $childFieldContainsSetModifier;
            {
                this.$childFieldContainsSetModifier = $childFieldContainsSetModifier;
            }

            public final boolean process(Field superField, PhpClass superClass, PhpClass baseClass) {
                if (superField.getModifier().getSetAccess() != null) {
                    this.$childFieldContainsSetModifier.set((Object)true);
                    return false;
                }
                return true;
            }
        });
        Object object = childFieldContainsSetModifier2.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    public static final /* synthetic */ boolean access$childFieldContainsSetModifier(PhpSetVisibilityCanBeRemovedInspection $this, Field field) {
        return $this.childFieldContainsSetModifier(field);
    }
}

