/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.findUsages.PhpSerializationMethodsReferenceSearcher;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpPrivateFieldCanBeLocalVariableInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSecondWriteToReadonlyPropertyInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpSecondWriteToReadonlyPropertyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFieldReference(FieldReference fieldReference) {
                Method method = (Method)ObjectUtils.tryCast((Object)PhpPsiUtil.getScopeHolder((PsiElement)fieldReference), Method.class);
                if (method == null || method.isStatic()) {
                    return;
                }
                if (!((FieldReferenceImpl)fieldReference).isWriteAccess(false) || PhpCodeInsightUtil.isPassByRefParameter((PsiElement)fieldReference, false)) {
                    return;
                }
                PhpAccessFieldByVariableInstruction access = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)fieldReference, PhpAccessFieldByVariableInstruction.class);
                if (access == null) {
                    return;
                }
                Collection fields = fieldReference.multiResolveStrict(Field.class);
                if (fields.isEmpty() || ContainerUtil.exists((Iterable)fields, f -> !f.isReadonly())) {
                    return;
                }
                Ref<PhpAccessFieldByVariableInstruction> prevAccess = PhpPrivateFieldCanBeLocalVariableInspection.findPreviousAlwaysAccessibleWriteInstruction((PhpInstruction)access, arg_0 -> ((PhpAccessFieldByVariableInstruction)access).isSameFieldReference(arg_0));
                if (!prevAccess.isNull()) {
                    holder.registerProblem(PhpSecondWriteToReadonlyPropertyInspection.getNodeToHighlight(access), PhpBundle.message("inspection.message.second.write.to.readonly.property", new Object[0]), new LocalQuickFix[0]);
                    return;
                }
                if (PhpSecondWriteToReadonlyPropertyInspection.isUnserializationMethod(method)) {
                    return;
                }
                if (PhpLanguageLevel.current((Project)method.getProject()).isAtLeast(PhpLanguageLevel.PHP830) && "__clone".equalsIgnoreCase(method.getName())) {
                    return;
                }
                PhpClass clazz = method.getContainingClass();
                if (clazz == null) {
                    return;
                }
                Method constructor = clazz.getOwnConstructor();
                if (method == constructor || constructor == null) {
                    return;
                }
                Ref<PhpAccessFieldByVariableInstruction> prevAccessInConstructor = PhpPrivateFieldCanBeLocalVariableInspection.findPreviousAlwaysAccessibleWriteInstruction((PhpInstruction)constructor.getControlFlow().getExitPoint(), accessInConstructor -> PhpSecondWriteToReadonlyPropertyInspection.isSameFieldReference(accessInConstructor, access, fields));
                if (!prevAccessInConstructor.isNull()) {
                    holder.registerProblem(PhpSecondWriteToReadonlyPropertyInspection.getNodeToHighlight(access), PhpBundle.message("inspection.message.second.write.to.readonly.property", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static boolean isUnserializationMethod(@NotNull Method method) {
        String name;
        if (method == null) {
            PhpSecondWriteToReadonlyPropertyInspection.$$$reportNull$$$0(1);
        }
        return (name = method.getName()).equalsIgnoreCase("__unserialize") || name.equalsIgnoreCase("unserialize") && PhpSerializationMethodsReferenceSearcher.methodFromSerializableInterface(method);
    }

    private static boolean isSameFieldReference(@NotNull PhpAccessFieldByVariableInstruction prevAccess, @NotNull PhpAccessFieldByVariableInstruction currentAccess, Collection<Field> fields) {
        if (prevAccess == null) {
            PhpSecondWriteToReadonlyPropertyInspection.$$$reportNull$$$0(2);
        }
        if (currentAccess == null) {
            PhpSecondWriteToReadonlyPropertyInspection.$$$reportNull$$$0(3);
        }
        if (currentAccess.isSameFieldReference(prevAccess)) {
            return true;
        }
        Collection elements = prevAccess.resolveFields();
        return fields.size() == elements.size() && fields.containsAll(elements);
    }

    @NotNull
    private static PsiElement getNodeToHighlight(PhpAccessFieldByVariableInstruction access) {
        PsiElement parent = access.getAnchor().getParent();
        Object object = parent instanceof AssignmentExpression ? parent : access.getAnchor();
        if (object == null) {
            PhpSecondWriteToReadonlyPropertyInspection.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevAccess";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentAccess";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpSecondWriteToReadonlyPropertyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpSecondWriteToReadonlyPropertyInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnserializationMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSameFieldReference";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

