/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpImplicitPromotedFieldAssignmentInstructionImpl;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpInferredArrayEmptinessProcessor;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldNamesAssignedByTheConstructorIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPropertyCanBeReadonlyInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPropertyCanBeReadonlyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                if (method.getMethodType(false) != Method.MethodType.CONSTRUCTOR) {
                    return;
                }
                PhpClass clazz = method.getContainingClass();
                if (clazz == null) {
                    return;
                }
                Map privatePromotedProperties = ((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Object[])method.getParameters()).filter(Parameter::isPromotedField)).filter(p -> p.getTypeDeclaration() != null)).map(p -> (Field)p).filter(f -> (f.getModifier().isPrivate() || f.getModifier().isSetPrivate()) && !f.isReadonly())).filter(f -> !f.hasPropertyHooksContainer())).toMap(PhpNamedElement::getName, Function.identity(), (f1, f2) -> f1);
                if (privatePromotedProperties.isEmpty()) {
                    return;
                }
                for (Method ownMethod : clazz.getOwnMethods()) {
                    if (privatePromotedProperties.isEmpty()) {
                        return;
                    }
                    if (ownMethod instanceof PhpDocMethod) continue;
                    PhpPropertyCanBeReadonlyInspection.removePropertiesWrittenInMethod(ownMethod, privatePromotedProperties);
                }
                for (Field field : privatePromotedProperties.values()) {
                    PsiElement nameIdentifier = field.getNameIdentifier();
                    if (nameIdentifier == null) continue;
                    holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.message.property.can.be.readonly", new Object[0]), new LocalQuickFix[]{PhpHierarchyChecksInspection.PhpAddReadonlyModifierQuickFix.INSTANCE});
                }
            }
        };
    }

    private static void removePropertiesWrittenInMethod(Method method, final Map<String, Field> privatePromotedProperties) {
        PhpEntryPointInstruction entryPoint = method.getControlFlow().getEntryPoint();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)entryPoint, false, new PhpControlFlowUtil.PhpClosureVisitingInstructionProcessor(){

            @Override
            public boolean processInstruction(PhpInstruction instruction) {
                if (privatePromotedProperties.isEmpty()) {
                    return false;
                }
                return super.processInstruction(instruction);
            }

            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                if (!super.processAccessFieldByVariableInstruction(instruction)) {
                    return false;
                }
                if (instruction instanceof PhpImplicitPromotedFieldAssignmentInstructionImpl) {
                    return true;
                }
                2.processFieldAccess((PhpAccessInstruction)instruction, instruction.getFieldName(), instruction.getFieldReference(), privatePromotedProperties);
                return true;
            }

            public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
                if (!super.processAccessFieldInObjectContextInstruction(instruction)) {
                    return false;
                }
                2.processFieldAccess((PhpAccessInstruction)instruction, instruction.getFieldName(), instruction.getFieldReference(), privatePromotedProperties);
                return true;
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                if (!super.processArrayAccessInstruction(instruction)) {
                    return false;
                }
                PhpAccessFieldByVariableInstruction access = PhpFieldNamesAssignedByTheConstructorIndex.findFieldReadNestedInArrayAccess(instruction);
                if (access != null) {
                    2.processFieldAccess((PhpAccessInstruction)instruction, access.getFieldName(), access.getFieldReference(), privatePromotedProperties);
                }
                return true;
            }

            private static void processFieldAccess(PhpAccessInstruction instruction, CharSequence name, FieldReference reference, Map<String, Field> privatePromotedProperties2) {
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (privatePromotedProperties2.containsKey(name) && (access.isUnset() || PhpInferredArrayEmptinessProcessor.isModifyingAccess(instruction.getAnchor(), access))) {
                    Field targetPromotedProperty = privatePromotedProperties2.get(name);
                    if (ContainerUtil.exists((Iterable)reference.multiResolveStrict(Field.class), f -> f == targetPromotedProperty)) {
                        privatePromotedProperties2.remove(name);
                    }
                }
            }
        });
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpPropertyCanBeReadonlyInspection", "buildVisitor"));
    }
}

