/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.function.PhpPreviousFunctionDfaAnalyzerProcessor;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldsDefaultValueMatcherIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFileConstantsDefaultValueMatcherIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpParametersDefaultValueMatchersIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDuplicateArrayKeysInspection
extends PhpInspection {
    private static final int MAX_RESOLVE_JUMPS = 5;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                for (Map.Entry<KeyDescriptor, List<ArrayHashElement>> entry : PhpPreviousFunctionDfaAnalyzerProcessor.doUnwrapMergedArrays((PsiElement)element, true, true).entrySet()) {
                    KeyDescriptor valueWithSignature;
                    List<ArrayHashElement> duplicates = entry.getValue();
                    if (duplicates.size() < 2 || (valueWithSignature = entry.getKey()).getActualValue() == null && valueWithSignature.getSignature() == null) continue;
                    this.highlightDuplicates(valueWithSignature.getActualValue(), duplicates, element);
                }
            }

            private void highlightDuplicates(@Nullable String keyValue, @NotNull List<ArrayHashElement> duplicateKeys, PhpPsiElement element) {
                if (duplicateKeys == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (int i = 0; i < duplicateKeys.size(); ++i) {
                    ArrayHashElement hashElement = duplicateKeys.get(i);
                    PhpPsiElement key = hashElement.getKey();
                    if (key == null || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)key, (boolean)false) || i < duplicateKeys.size() - 1 && !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)((PsiElement)duplicateKeys.get(i + 1)), (boolean)false)) continue;
                    if (isOnTheFly) {
                        ArrayHashElement nextElement = duplicateKeys.get((i + 1) % duplicateKeys.size());
                        PhpPsiElement nextKey = nextElement.getKey();
                        if (nextKey == null) continue;
                        holder.problem((PsiElement)key, PhpDuplicateArrayKeysInspection.getProblem((PsiElement)key, keyValue)).fix((ModCommandAction)new PhpNavigateToElementQuickFix((PsiElement)nextKey, PhpBundle.message("quickfix.navigate.to.duplicate.array.key", new Object[0]))).register();
                        continue;
                    }
                    holder.registerProblem((PsiElement)key, PhpDuplicateArrayKeysInspection.getProblem((PsiElement)key, keyValue), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicateKeys", "com/jetbrains/php/lang/inspections/PhpDuplicateArrayKeysInspection$1", "highlightDuplicates"));
            }
        };
    }

    @NotNull
    public static Map<KeyDescriptor, List<ArrayHashElement>> getKeyValueToKeyElementMap(ArrayCreationExpression expression) {
        HashMap<KeyDescriptor, List<ArrayHashElement>> keyValueToKeyElement = new HashMap<KeyDescriptor, List<ArrayHashElement>>();
        HashMap<CharSequence, Integer> writtenOrders = new HashMap<CharSequence, Integer>();
        for (ArrayHashElement hashElement : expression.getHashElements()) {
            KeyDescriptor keyValueWithSignature;
            PhpPsiElement keyElement = hashElement.getKey();
            KeyDescriptor keyDescriptor = keyValueWithSignature = keyElement != null ? PhpDuplicateArrayKeysInspection.getKeyValueWithSignature(keyElement, writtenOrders) : null;
            if (keyValueWithSignature != null) {
                keyValueToKeyElement.computeIfAbsent(keyValueWithSignature, s -> new SmartList()).add(hashElement);
            }
            PhpDuplicateArrayKeysInspection.incrementVariablesWrittenOrder(writtenOrders, hashElement);
        }
        HashMap<KeyDescriptor, List<ArrayHashElement>> hashMap = keyValueToKeyElement;
        if (hashMap == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static void incrementVariablesWrittenOrder(Map<CharSequence, Integer> writtenOrders, ArrayHashElement hashElement) {
        for (Variable variable : PsiTreeUtil.findChildrenOfType((PsiElement)hashElement, Variable.class)) {
            String name = variable.getName();
            if (!writtenOrders.containsKey(name) || !variable.isWriteAccess(true)) continue;
            writtenOrders.computeIfPresent(name, (k, v) -> v + 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static KeyDescriptor getKeyValueWithSignature(@NotNull PhpPsiElement firstChild, Map<CharSequence, Integer> writtenOrders) {
        ParenthesizedExpression parenthesizedExpression;
        PhpPsiElement extractedArgument;
        if (firstChild == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(2);
        }
        if (firstChild instanceof ConstantReference || firstChild instanceof ClassConstantReference) {
            Collection resolveResults = ((PhpReference)firstChild).multiResolveStrict(PhpNamedElement.class);
            if (resolveResults.isEmpty() && firstChild instanceof ClassConstantReference) {
                PhpExpression classReference = ((ClassConstantReference)firstChild).getClassReference();
                if (!(classReference instanceof ClassReference)) return new MyKeyDescriptor(PhpCodeInsightUtil.toString((PsiElement)firstChild), null);
                return new MyKeyDescriptor(((ClassReference)classReference).getFQN() + "::" + firstChild.getName(), null);
            }
            SmartHashSet alreadyPresentKeyValues = new SmartHashSet();
            List values = (List)resolveResults.stream().filter(resolve -> resolve instanceof Constant || PhpDuplicateArrayKeysInspection.isClassConstant((PsiElement)resolve)).flatMap(resolve -> PhpDuplicateArrayKeysInspection.multiResolveToFinalValue(resolve, 5).stream()).filter(arg_0 -> PhpDuplicateArrayKeysInspection.lambda$getKeyValueWithSignature$4((Set)alreadyPresentKeyValues, arg_0)).collect(Collectors.toCollection(SmartList::new));
            return (KeyDescriptor)ContainerUtil.getOnlyItem((Collection)values);
        }
        if (firstChild instanceof Variable) {
            Integer order = writtenOrders.computeIfAbsent(firstChild.getName(), n -> 1);
            return new VariableKeyDescriptor(firstChild.getText(), order);
        }
        if (firstChild instanceof ConcatenationExpression) {
            ConcatenationExpression concatenationExpression = (ConcatenationExpression)firstChild;
            PhpPsiElement leftOperand = (PhpPsiElement)ObjectUtils.tryCast((Object)concatenationExpression.getLeftOperand(), PhpPsiElement.class);
            PhpPsiElement rightOperand = (PhpPsiElement)ObjectUtils.tryCast((Object)concatenationExpression.getRightOperand(), PhpPsiElement.class);
            if (leftOperand == null || rightOperand == null) return null;
            KeyDescriptor leftKeyDescriptor = PhpDuplicateArrayKeysInspection.getKeyValueWithSignature(leftOperand, writtenOrders);
            KeyDescriptor rightKeyDescriptor = PhpDuplicateArrayKeysInspection.getKeyValueWithSignature(rightOperand, writtenOrders);
            if (leftKeyDescriptor == null || leftKeyDescriptor.getSignature() == null && leftKeyDescriptor.getActualValue() == null || rightKeyDescriptor == null || rightKeyDescriptor.getSignature() == null && rightKeyDescriptor.getActualValue() == null) return null;
            return new MergedKeyDescriptor(leftKeyDescriptor, rightKeyDescriptor);
        }
        if (!(firstChild instanceof ParenthesizedExpression) || (extractedArgument = (parenthesizedExpression = (ParenthesizedExpression)firstChild).extract()) == null) return new MyKeyDescriptor(PhpCodeInsightUtil.toString((PsiElement)firstChild), null);
        return PhpDuplicateArrayKeysInspection.getKeyValueWithSignature(extractedArgument, writtenOrders);
    }

    @NotNull
    private static List<KeyDescriptor> multiResolveToFinalValue(@NotNull PhpNamedElement element, int resolveJumpsLeft) {
        Collection<PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher> matchers;
        if (element == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(3);
        }
        if ((matchers = PhpDuplicateArrayKeysInspection.getValueMatchers(element)).isEmpty()) {
            List<KeyDescriptor> list = Collections.emptyList();
            if (list == null) {
                PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(4);
            }
            return list;
        }
        SmartList finalValues = new SmartList();
        for (PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher matcher : matchers) {
            String value = matcher.getValue();
            if (matcher instanceof PhpParametersDefaultValueMatchersIndex.PhpParameterConstantDefaultValueMatcher) {
                if (resolveJumpsLeft > 0) {
                    PhpDuplicateArrayKeysInspection.multiResolveToConstantFinalValue(element.getProject(), value, (List<KeyDescriptor>)finalValues, resolveJumpsLeft);
                    continue;
                }
                finalValues.add(new MyKeyDescriptor(null, value));
                continue;
            }
            finalValues.add(new MyKeyDescriptor(value, null));
        }
        SmartList smartList = finalValues;
        if (smartList == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private static void multiResolveToConstantFinalValue(@NotNull Project project, String value, List<KeyDescriptor> finalValues, int resolveJumpsLeft) {
        if (project == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(6);
        }
        List constants = ContainerUtil.filter((Collection)PhpIndex.getInstance((Project)project).getBySignature(value), e -> e instanceof Constant || PhpDuplicateArrayKeysInspection.isClassConstant((PsiElement)e));
        for (PhpNamedElement constant : constants) {
            List<KeyDescriptor> resolvedValues = PhpDuplicateArrayKeysInspection.multiResolveToFinalValue(constant, resolveJumpsLeft - 1);
            finalValues.addAll(resolvedValues);
            if (!resolvedValues.isEmpty()) continue;
            finalValues.add(new MyKeyDescriptor(null, value));
        }
        if (constants.isEmpty()) {
            finalValues.add(new MyKeyDescriptor(null, value));
        }
    }

    @NotNull
    private static Collection<PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher> getValueMatchers(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(7);
        }
        if (element instanceof Constant) {
            Collection<PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher> collection = PhpFileConstantsDefaultValueMatcherIndex.getDefaultValueMatchers((Constant)element);
            if (collection == null) {
                PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(8);
            }
            return collection;
        }
        if (PhpDuplicateArrayKeysInspection.isClassConstant((PsiElement)element)) {
            Collection<PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher> collection = PhpFieldsDefaultValueMatcherIndex.getDefaultValueMatcher((Field)element);
            if (collection == null) {
                PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(9);
            }
            return collection;
        }
        List<PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher> list = Collections.emptyList();
        if (list == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static boolean isClassConstant(PsiElement element) {
        return element instanceof Field && ((Field)element).isConstant();
    }

    @Nls
    private static String getProblem(@NotNull PsiElement key, @Nullable String keyValue) {
        if (key == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(11);
        }
        if (keyValue != null && key instanceof PhpReference && !PhpLangUtil.isBuiltInConstant(((PhpReference)key).getName(), key.getProject())) {
            return PhpBundle.message("inspection.duplicate.array.keys.problem.0", keyValue);
        }
        return PhpBundle.message("inspection.duplicate.array.keys.problem", new Object[0]);
    }

    private static /* synthetic */ boolean lambda$getKeyValueWithSignature$4(Set alreadyPresentKeyValues, KeyDescriptor keyValueToSignature) {
        return keyValueToSignature.getActualValue() == null || alreadyPresentKeyValues.add(keyValueToSignature.getActualValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDuplicateArrayKeysInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDuplicateArrayKeysInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyValueToKeyElementMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveToFinalValue";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueMatchers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKeyValueWithSignature";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveToFinalValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveToConstantFinalValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValueMatchers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProblem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    public static interface KeyDescriptor {
        public static final KeyDescriptor[] EMPTY_ARRAY = new KeyDescriptor[0];

        public String getActualValue();

        public String getSignature();
    }

    private static class MyKeyDescriptor
    implements KeyDescriptor {
        @Nullable
        private final String myActualValue;
        @Nullable
        private final String mySignature;

        private MyKeyDescriptor(@Nullable String actualValue, @Nullable String signature) {
            this.myActualValue = actualValue;
            this.mySignature = signature;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyDescriptor value = (KeyDescriptor)o;
            return Objects.equals(this.myActualValue, value.getActualValue()) && Objects.equals(this.mySignature, value.getSignature());
        }

        public int hashCode() {
            return Objects.hash(this.myActualValue, this.mySignature);
        }

        @Override
        @Nullable
        public String getActualValue() {
            return this.myActualValue;
        }

        @Override
        @Nullable
        public String getSignature() {
            return this.mySignature;
        }
    }

    private static class VariableKeyDescriptor
    extends MyKeyDescriptor {
        @NotNull
        private final Integer myWrittenOrder;

        private VariableKeyDescriptor(@NotNull String variableText, @NotNull Integer order) {
            if (variableText == null) {
                VariableKeyDescriptor.$$$reportNull$$$0(0);
            }
            if (order == null) {
                VariableKeyDescriptor.$$$reportNull$$$0(1);
            }
            super(variableText, null);
            this.myWrittenOrder = order;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VariableKeyDescriptor that = (VariableKeyDescriptor)o;
            return this.myWrittenOrder.equals(that.myWrittenOrder);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myWrittenOrder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variableText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "order";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/PhpDuplicateArrayKeysInspection$VariableKeyDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MergedKeyDescriptor
    implements KeyDescriptor {
        private final KeyDescriptor[] myDescriptors;

        private MergedKeyDescriptor(KeyDescriptor ... descriptors) {
            this.myDescriptors = descriptors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MergedKeyDescriptor that = (MergedKeyDescriptor)o;
            return Arrays.equals(this.myDescriptors, that.myDescriptors);
        }

        public int hashCode() {
            return Arrays.hashCode(this.myDescriptors);
        }

        @Override
        public String getActualValue() {
            return Arrays.stream(this.myDescriptors).map(KeyDescriptor::getActualValue).collect(Collectors.joining(" . "));
        }

        @Override
        public String getSignature() {
            return Arrays.stream(this.myDescriptors).map(KeyDescriptor::getSignature).collect(Collectors.joining(" . "));
        }
    }
}

