/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.php.debug.common.PhpLineBreakpointType;
import com.jetbrains.php.lang.inspections.PhpDebugActionFixKt;
import com.jetbrains.php.lang.inspections.PhpRunActionFix;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpDebugActionFix;", "Lcom/jetbrains/php/lang/inspections/PhpRunActionFix;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Companion", "intellij.php.impl"})
public final class PhpDebugActionFix
extends PhpRunActionFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public PhpDebugActionFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getDebugExecutorInstance(...)");
        super(executor, element);
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement element = descriptor.getPsiElement();
        Intrinsics.checkNotNull((Object)element);
        int lineNumber = PhpDebugActionFixKt.access$getLineNumber(element, descriptor.getTextRangeInElement().getStartOffset());
        if (lineNumber < 0) {
            return;
        }
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager manager = xBreakpointManager;
        PhpLineBreakpointType phpLineBreakpointType = PhpLineBreakpointType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)phpLineBreakpointType), (String)"getInstance(...)");
        PhpLineBreakpointType breakpointType = phpLineBreakpointType;
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        if (!manager.findBreakpointsAtLine((XLineBreakpointType)breakpointType, vFile, lineNumber).isEmpty()) {
            manager.addLineBreakpoint((XLineBreakpointType)breakpointType, vFile.getUrl(), lineNumber, null, false);
        }
        super.applyFix(project, descriptor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpDebugActionFix$Companion;", "", "<init>", "()V", "isAvailable", "", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "isAvailable$intellij_php_impl", "intellij.php.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAvailable$intellij_php_impl(@NotNull PsiElement element, int offset) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            int lineNumber = PhpDebugActionFixKt.access$getLineNumber(element, offset);
            if (lineNumber < 0) {
                return false;
            }
            return PhpLineBreakpointType.getInstance().canPutAt(element.getContainingFile().getVirtualFile(), lineNumber, element.getProject());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

