/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpConcatenationWithArithmeticInspection
extends PhpInspection {
    @NotNull
    private static final TokenSet RIGHT_DEPRECATED = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opMINUS, PhpTokenTypes.opSHIFT_LEFT, PhpTokenTypes.opSHIFT_RIGHT});
    @NotNull
    private static final TokenSet LEFT_DEPRECATED = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opSHIFT_LEFT, PhpTokenTypes.opSHIFT_RIGHT});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpConcatenationWithArithmeticInspection.$$$reportNull$$$0(0);
        }
        if (PhpLanguageLevel.current((Project)holder.getProject()).isAtLeast(PhpLanguageLevel.PHP800)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpConcatenationWithArithmeticInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (expression.getOperationType() == PhpTokenTypes.opCONCAT) {
                    BinaryExpression rightOp;
                    BinaryExpression leftOp;
                    PsiElement left = expression.getLeftOperand();
                    PsiElement right = expression.getRightOperand();
                    if (left instanceof BinaryExpression && LEFT_DEPRECATED.contains((leftOp = (BinaryExpression)left).getOperationType())) {
                        this.registerProblem(expression, leftOp);
                    } else if (right instanceof BinaryExpression && RIGHT_DEPRECATED.contains((rightOp = (BinaryExpression)right).getOperationType())) {
                        this.registerProblem(expression, rightOp);
                    }
                }
            }

            private void registerProblem(BinaryExpression expression, BinaryExpression operand) {
                PsiElement operandOperation = operand.getOperation();
                if (operandOperation != null) {
                    holder.problem((PsiElement)expression, PhpBundle.message("inspection.message.behavior.unparenthesized.expressions.containing.both.will.change.in.php", operandOperation.getText())).fix((ModCommandAction)new PhpWrapWithParenthesesQuickFix(expression, true)).fix((ModCommandAction)new PhpWrapWithParenthesesQuickFix(expression, false)).register();
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpConcatenationWithArithmeticInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpConcatenationWithArithmeticInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class PhpWrapWithParenthesesQuickFix
    extends PsiUpdateModCommandAction<BinaryExpression> {
        private final boolean myWrapCorrectlyParsedOperand;

        protected PhpWrapWithParenthesesQuickFix(@NotNull BinaryExpression element, boolean wrapCorrectlyParsedOperand) {
            if (element == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
            this.myWrapCorrectlyParsedOperand = wrapCorrectlyParsedOperand;
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull BinaryExpression element) {
            String textToReplace;
            if (context == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(2);
            }
            return Presentation.of((String)((textToReplace = this.getTextToReplace(element)) != null ? PhpBundle.message("intention.family.name.replace.with", textToReplace) : this.getFamilyName()));
        }

        private String getTextToReplace(@NotNull BinaryExpression element) {
            if (element == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement left = element.getLeftOperand();
            PsiElement right = element.getRightOperand();
            PsiElement operation = element.getOperation();
            if (left == null || right == null || operation == null) {
                return null;
            }
            if (this.myWrapCorrectlyParsedOperand) {
                if (left instanceof BinaryExpression) {
                    return String.format("(%s) %s %s", left.getText(), operation.getText(), right.getText());
                }
                return String.format("%s %s (%s)", left.getText(), operation.getText(), right.getText());
            }
            if (left instanceof BinaryExpression) {
                BinaryExpression leftOp = (BinaryExpression)left;
                PsiElement leftLeft = leftOp.getLeftOperand();
                PsiElement leftRight = leftOp.getRightOperand();
                PsiElement leftOperation = leftOp.getOperation();
                if (leftOperation != null && leftLeft != null && leftRight != null) {
                    return String.format("%s %s (%s %s %s)", leftLeft.getText(), leftOperation.getText(), leftRight.getText(), operation.getText(), right.getText());
                }
            } else if (right instanceof BinaryExpression) {
                BinaryExpression rightOp = (BinaryExpression)right;
                PsiElement rightLeft = rightOp.getLeftOperand();
                PsiElement rightRight = rightOp.getRightOperand();
                PsiElement rightOperation = rightOp.getOperation();
                if (rightOperation != null && rightLeft != null && rightRight != null) {
                    return String.format("(%s %s %s) %s %s", left.getText(), operation.getText(), rightLeft.getText(), rightOperation.getText(), rightRight.getText());
                }
            }
            return null;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull BinaryExpression element, @NotNull ModPsiUpdater updater) {
            String textToReplace;
            if (context == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(4);
            }
            if (element == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(6);
            }
            if ((textToReplace = this.getTextToReplace(element)) == null) {
                return;
            }
            element.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(context.project(), BinaryExpression.class, textToReplace));
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.myWrapCorrectlyParsedOperand ? PhpBundle.message("intention.name.wrap.left.operand.in.parentheses", new Object[0]) : PhpBundle.message("intention.name.wrap.right.operand.in.parentheses", new Object[0]);
            if (string == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpConcatenationWithArithmeticInspection$PhpWrapWithParenthesesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpConcatenationWithArithmeticInspection$PhpWrapWithParenthesesQuickFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTextToReplace";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }
}

