/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.inspections.PhpElementImmediatelyRewrittenInspectionBase;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayIndexImmediatelyRewrittenInspection
extends PhpElementImmediatelyRewrittenInspectionBase<ArrayAccessExpression, PhpArrayAccessInstruction> {
    public static final PhpArrayIndexImmediatelyRewrittenInspection INSTANCE = new PhpArrayIndexImmediatelyRewrittenInspection();

    @Override
    protected Class<ArrayAccessExpression> getElementClass() {
        return ArrayAccessExpression.class;
    }

    @Override
    protected Class<PhpArrayAccessInstruction> getInstructionClass() {
        return PhpArrayAccessInstruction.class;
    }

    @Override
    protected PsiElement getValue(ArrayAccessExpression element) {
        return element.getValue();
    }

    @Override
    @Nls
    @NotNull
    protected String getMessage() {
        String string = PhpBundle.message("inspection.message.array.index.immediately.rewritten.before.accessing", new Object[0]);
        if (string == null) {
            PhpArrayIndexImmediatelyRewrittenInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static void processAssignedArrayKeyInfos(AssignmentExpression assignmentExpression, PhpArrayKeyInfoConsumer consumer) {
        PhpPsiElement variable = assignmentExpression.getVariable();
        if (variable == null) {
            return;
        }
        PhpStateArgumentInfo variableInfo = PhpStateArgumentInfo.tryCreateInfo((PsiElement)variable, true);
        ArrayCreationExpression value = (ArrayCreationExpression)ObjectUtils.tryCast((Object)assignmentExpression.getValue(), ArrayCreationExpression.class);
        if (variableInfo == null || value == null) {
            return;
        }
        PhpAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessInstruction.class);
        if (instruction == null) {
            return;
        }
        for (ArrayHashElement element : value.getHashElements()) {
            PhpStateArgumentInfo.PhpArrayStateArgumentInfo info;
            PhpPsiElement key = element.getKey();
            if (key == null || (info = PhpStateArgumentInfo.PhpArrayStateArgumentInfo.create(variableInfo, key)) == null) continue;
            consumer.accept(info, instruction, key);
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayIndexImmediatelyRewrittenInspection.$$$reportNull$$$0(1);
        }
        final PsiElementVisitor visitor = super.buildVisitor(holder, isOnTheFly);
        return new PhpElementVisitor(){

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PhpArrayIndexImmediatelyRewrittenInspection.processAssignedArrayKeyInfos(assignmentExpression, (info, instruction, key) -> {
                    PsiElement rewrittenValue = PhpArrayIndexImmediatelyRewrittenInspection.this.getImmediatelyRewrittenValue((PhpInstruction)instruction, info);
                    if (rewrittenValue != null) {
                        PhpArrayIndexImmediatelyRewrittenInspection.this.registerProblem(holder, isOnTheFly, (PsiElement)key, rewrittenValue);
                    }
                });
            }

            public void visitPhpElement(PhpPsiElement element) {
                element.accept(visitor);
            }
        };
    }

    @Override
    @Nullable
    protected PsiElement getImmediatelyRewrittenValue(PhpInstruction instruction, PhpStateArgumentInfo info) {
        PhpStateArgumentInfo currentInfo = info;
        while (currentInfo instanceof PhpStateArgumentInfo.PhpArrayStateArgumentInfo) {
            if (((PhpStateArgumentInfo.PhpArrayStateArgumentInfo)currentInfo).getIndex() == null) {
                return null;
            }
            currentInfo = currentInfo.getBaseInfo();
        }
        return super.getImmediatelyRewrittenValue(instruction, info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpArrayIndexImmediatelyRewrittenInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpArrayIndexImmediatelyRewrittenInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    @FunctionalInterface
    public static interface PhpArrayKeyInfoConsumer {
        public void accept(@NotNull PhpStateArgumentInfo.PhpArrayStateArgumentInfo var1, @NotNull PhpAccessInstruction var2, @NotNull PhpPsiElement var3);
    }
}

