/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpAccessingStaticMembersOnTraitInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpAccessingStaticMembersOnTraitInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                this.doCheck((MemberReference)reference, PhpClass::findMethodByName);
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
                this.doCheck((MemberReference)fieldReference, (containingClass, name) -> containingClass.findFieldByName((CharSequence)name, false));
            }

            private void doCheck(MemberReference reference, BiFunction<PhpClass, String, PhpClassMember> memberFinder) {
                ProblemDescriptor descriptor = PhpAccessingStaticMembersOnTraitInspection.createProblemDescriptor(reference, memberFinder, isOnTheFly);
                if (descriptor != null) {
                    holder.registerProblem((PsiElement)reference, descriptor.getDescriptionTemplate(), descriptor.getHighlightType(), (LocalQuickFix[])descriptor.getFixes());
                }
            }
        };
    }

    public static ProblemDescriptor createProblemDescriptor(MemberReference reference, BiFunction<? super PhpClass, ? super String, PhpClassMember> memberFinder, boolean isOnTheFly) {
        if (!reference.isStatic() || reference instanceof MethodReference && reference.getParent() instanceof PhpTraitUseRule || reference instanceof ClassConstantReference && PhpLangUtil.equalsIgnoreCase("class", reference.getName())) {
            return null;
        }
        ClassReference classReference = (ClassReference)ObjectUtils.tryCast((Object)reference.getClassReference(), ClassReference.class);
        if (classReference == null || PhpLangUtil.isClassNameSpecial(classReference.getName())) {
            return null;
        }
        Collection classes = classReference.multiResolveStrict(PhpClass.class);
        if (!classes.isEmpty() && ContainerUtil.all((Collection)classes, PhpClass::isTrait)) {
            LocalQuickFix[] localQuickFixArray;
            PhpClassMember classMember;
            PhpClass currentClass = PhpPsiUtil.getParentOfClass((PsiElement)reference, true, PhpClass.class);
            PhpClassMember phpClassMember = classMember = currentClass != null ? memberFinder.apply((PhpClass)currentClass, reference.getName()) : null;
            if (classMember != null && reference.multiResolveStrict(PhpClassMember.class).contains(classMember)) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = LocalQuickFix.from((ModCommandAction)new PhpReplaceWithSelfClassReferenceQuickFix(classReference));
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            return InspectionManager.getInstance((Project)reference.getProject()).createProblemDescriptor((PsiElement)reference, PhpBundle.message("inspection.message.calling.static.trait.member", new Object[0]), isOnTheFly, fixes, ProblemHighlightType.LIKE_DEPRECATED);
        }
        return null;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpAccessingStaticMembersOnTraitInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithSelfClassReferenceQuickFix
    extends PsiUpdateModCommandAction<ClassReference> {
        private PhpReplaceWithSelfClassReferenceQuickFix(ClassReference classReference) {
            super((PsiElement)classReference);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull ClassReference classReference, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithSelfClassReferenceQuickFix.$$$reportNull$$$0(0);
            }
            if (classReference == null) {
                PhpReplaceWithSelfClassReferenceQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpReplaceWithSelfClassReferenceQuickFix.$$$reportNull$$$0(2);
            }
            classReference.replace((PsiElement)PhpPsiElementFactory.createClassReference(context.project(), "self"));
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.self.access", new Object[0]);
            if (string == null) {
                PhpReplaceWithSelfClassReferenceQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpAccessingStaticMembersOnTraitInspection$PhpReplaceWithSelfClassReferenceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpAccessingStaticMembersOnTraitInspection$PhpReplaceWithSelfClassReferenceQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

