/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.util.TriConsumer;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpCommaAfterLastElementPostFormatProcessor;
import com.jetbrains.php.lang.inspections.PhpUselessTrailingCommaInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/php/lang/formatter/PhpRemoveTrailingCommaPostFormatProcessor;", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessor;", "<init>", "()V", "processElement", "Lcom/intellij/psi/PsiElement;", "source", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "processText", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "findRedundantCommas", "", "range", "phpSettings", "Lcom/jetbrains/php/lang/formatter/PhpCodeStyleSettings;", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpRemoveTrailingCommaPostFormatProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpRemoveTrailingCommaPostFormatProcessor.kt\ncom/jetbrains/php/lang/formatter/PhpRemoveTrailingCommaPostFormatProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1869#2,2:49\n774#2:51\n865#2,2:52\n*S KotlinDebug\n*F\n+ 1 PhpRemoveTrailingCommaPostFormatProcessor.kt\ncom/jetbrains/php/lang/formatter/PhpRemoveTrailingCommaPostFormatProcessor\n*L\n24#1:49,2\n46#1:51\n46#1:52,2\n*E\n"})
public final class PhpRemoveTrailingCommaPostFormatProcessor
implements PostFormatProcessor {
    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        PsiFile psiFile = source.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        TextRange textRange = source.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        this.processText(psiFile, textRange, settings);
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile file, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (!(file instanceof PhpFile)) {
            return rangeToReformat;
        }
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(PhpCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        List<PsiElement> commas = this.findRedundantCommas(file, rangeToReformat, (PhpCodeStyleSettings)customCodeStyleSettings);
        Iterable $this$forEach$iv = commas;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.delete();
        }
        TextRange textRange = rangeToReformat.grown(-commas.size());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"grown(...)");
        return textRange;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> findRedundantCommas(PsiFile file, TextRange range, PhpCodeStyleSettings phpSettings) {
        void $this$filterTo$iv$iv;
        List commas = new ArrayList();
        Function3 consumer = (arg_0, arg_1, arg_2) -> PhpRemoveTrailingCommaPostFormatProcessor.findRedundantCommas$lambda$1(commas, arg_0, arg_1, arg_2);
        PhpUselessTrailingCommaInspection.Visitor visitor = new PhpUselessTrailingCommaInspection.Visitor((TriConsumer<? super PsiElement, ? super PsiElement, ? super Boolean>)((TriConsumer)(arg_0, arg_1, arg_2) -> PhpRemoveTrailingCommaPostFormatProcessor.findRedundantCommas$lambda$2(consumer, arg_0, arg_1, arg_2)), PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInOneLineParameterList((PsiElement)file, phpSettings), PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInOneLineFunctionCall((PsiElement)file, phpSettings), PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInOneLineUseList((PsiElement)file, phpSettings));
        PhpRecursiveElementVisitor recursiveVisitor2 = new PhpRecursiveElementVisitor(visitor){
            final /* synthetic */ PhpUselessTrailingCommaInspection.Visitor $visitor;
            {
                this.$visitor = $visitor;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.accept((PsiElementVisitor)this.$visitor);
                super.visitElement(element);
            }
        };
        file.accept((PsiElementVisitor)recursiveVisitor2);
        Iterable $this$filter$iv = commas;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement element = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!range.contains(element.getTextRange())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit findRedundantCommas$lambda$1(List $commas, PsiElement comma, PsiElement nextSibling, boolean isMultiline) {
        Intrinsics.checkNotNullParameter((Object)comma, (String)"comma");
        Intrinsics.checkNotNullParameter((Object)nextSibling, (String)"nextSibling");
        if (!(nextSibling instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)nextSibling.getText()) || isMultiline)) {
            $commas.add(comma);
        }
        return Unit.INSTANCE;
    }

    private static final void findRedundantCommas$lambda$2(Function3 $tmp0, Object p0, Object p1, Object p2) {
        $tmp0.invoke(p0, p1, p2);
    }
}

