/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.PhpUselessTrailingCommaInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpDefaultMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Arrays;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhpCommaAfterLastElementPostFormatProcessor
implements PostFormatProcessor {
    private static final TokenSet RPAREN = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chRPAREN});
    private static final TokenSet RBRACE = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chRBRACE});
    private static final TokenSet RPAREN_RBRACKET = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chRPAREN, PhpTokenTypes.chRBRACKET});

    PhpCommaAfterLastElementPostFormatProcessor() {
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PhpCommaAfterLastElementPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PhpCommaAfterLastElementPostFormatProcessor.$$$reportNull$$$0(1);
        }
        PhpCommaAfterLastElementPostFormatProcessor.processRange(source, source.getContainingFile(), () -> ((PsiElement)source).getTextRange(), settings);
        PsiElement psiElement = source;
        if (psiElement == null) {
            PhpCommaAfterLastElementPostFormatProcessor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        TextRange processedRange;
        if (source == null) {
            PhpCommaAfterLastElementPostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (rangeToReformat == null) {
            PhpCommaAfterLastElementPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            PhpCommaAfterLastElementPostFormatProcessor.$$$reportNull$$$0(5);
        }
        TextRange textRange = (processedRange = PhpCommaAfterLastElementPostFormatProcessor.processRange((PsiElement)source, source, () -> rangeToReformat, settings)) != null ? processedRange : rangeToReformat;
        if (textRange == null) {
            PhpCommaAfterLastElementPostFormatProcessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @Nullable
    private static TextRange processRange(@NotNull PsiElement source, @NotNull PsiFile sourceFile, Supplier<TextRange> rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PhpCommaAfterLastElementPostFormatProcessor.$$$reportNull$$$0(7);
        }
        if (sourceFile == null) {
            PhpCommaAfterLastElementPostFormatProcessor.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            PhpCommaAfterLastElementPostFormatProcessor.$$$reportNull$$$0(9);
        }
        if (source.isValid() && sourceFile.getFileType() == PhpFileType.INSTANCE) {
            PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
            if (phpSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT || PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInParameterList(source, phpSettings) || PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInUseList(source, phpSettings) || PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInFunctionCall(source, phpSettings) || PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInMatchArm(source, phpSettings)) {
                return new ListingVisitor(source, rangeToReformat.get(), settings).processTree();
            }
        }
        return null;
    }

    private static boolean isTrailingCommaAllowedInParameterList(PsiElement source, PhpCodeStyleSettings phpSettings) {
        return PhpLanguageLevel.current((Project)source.getProject()).isAtLeast(PhpLanguageLevel.PHP800) && phpSettings.COMMA_AFTER_LAST_PARAMETER;
    }

    private static boolean isTrailingCommaAllowedInUseList(PsiElement source, PhpCodeStyleSettings phpSettings) {
        return PhpLanguageLevel.current((Project)source.getProject()).isAtLeast(PhpLanguageLevel.PHP800) && phpSettings.COMMA_AFTER_LAST_CLOSURE_USE_VAR;
    }

    private static boolean isTrailingCommaAllowedInFunctionCall(PsiElement source, PhpCodeStyleSettings phpSettings) {
        return PhpLanguageLevel.current((Project)source.getProject()).isAtLeast(PhpLanguageLevel.PHP730) && phpSettings.COMMA_AFTER_LAST_ARGUMENT;
    }

    private static boolean isTrailingCommaAllowedInMatchArm(PsiElement source, PhpCodeStyleSettings phpSettings) {
        return PhpLanguageLevel.current((Project)source.getProject()).isAtLeast(PhpLanguageLevel.PHP800) && phpSettings.COMMA_AFTER_LAST_MATCH_ARM;
    }

    public static boolean isTrailingCommaAllowedInOneLineParameterList(PsiElement source, PhpCodeStyleSettings phpSettings) {
        return PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInParameterList(source, phpSettings) && phpSettings.COMMA_AFTER_LAST_PARAMETER_STYLE == PhpCodeStyleSettings.PhpAddTrailingCommaStyle.ALWAYS;
    }

    public static boolean isTrailingCommaAllowedInOneLineUseList(PsiElement source, PhpCodeStyleSettings phpSettings) {
        return PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInUseList(source, phpSettings) && phpSettings.COMMA_AFTER_LAST_CLOSURE_USE_VAR_STYLE == PhpCodeStyleSettings.PhpAddTrailingCommaStyle.ALWAYS;
    }

    public static boolean isTrailingCommaAllowedInOneLineFunctionCall(PsiElement source, PhpCodeStyleSettings phpSettings) {
        return PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInFunctionCall(source, phpSettings) && phpSettings.COMMA_AFTER_LAST_ARGUMENT_STYLE == PhpCodeStyleSettings.PhpAddTrailingCommaStyle.ALWAYS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpCommaAfterLastElementPostFormatProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpCommaAfterLastElementPostFormatProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }

    private static class ListingVisitor
    extends PsiRecursiveElementVisitor {
        @NotNull
        private final TextRange myRange;
        @NotNull
        private final PsiElement myElement;
        @Nullable
        private Document myDocument;
        private int myDelta;
        private Project myProject;
        private final CodeStyleSettings mySettings;

        ListingVisitor(@NotNull PsiElement element, @NotNull TextRange range, @NotNull CodeStyleSettings settings) {
            if (element == null) {
                ListingVisitor.$$$reportNull$$$0(0);
            }
            if (range == null) {
                ListingVisitor.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                ListingVisitor.$$$reportNull$$$0(2);
            }
            this.myRange = range;
            this.myElement = element;
            if (this.myElement.isValid()) {
                this.myProject = this.myElement.getProject();
                PsiFile file = this.myElement.getContainingFile();
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                this.myDocument = file.isPhysical() ? documentManager.getDocument(file) : file.getViewProvider().getDocument();
            }
            this.mySettings = settings;
        }

        public TextRange processTree() {
            if (this.myDocument != null) {
                this.myElement.accept((PsiElementVisitor)this);
                if (this.myDelta > 0) {
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                    documentManager.commitDocument(this.myDocument);
                }
            }
            return this.myRange.grown(this.myDelta);
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ListingVisitor.$$$reportNull$$$0(3);
            }
            super.visitElement(element);
            if (this.myRange.contains(element.getTextRange())) {
                PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)this.mySettings.getCustomSettings(PhpCodeStyleSettings.class);
                PsiElement parent = element.getParent();
                if (phpSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT && PhpPsiUtil.isOfType(element, PhpElementTypes.HASH_ARRAY_ELEMENT, PhpElementTypes.ARRAY_VALUE) && parent instanceof ArrayCreationExpression) {
                    this.insertCommaBetweenElementAndLineBreak(element, PhpUselessTrailingCommaInspection.getWhiteSpace(element), RPAREN_RBRACKET, PhpCodeStyleSettings.PhpAddTrailingCommaStyle.WHEN_MULTILINE);
                } else if (PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInParameterList(element, phpSettings) && element instanceof Parameter && !((Parameter)element).isVariadic() && parent instanceof ParameterList && parent.getLastChild().equals(element)) {
                    this.insertCommaBetweenElementAndLineBreak(element, PhpUselessTrailingCommaInspection.getWhiteSpace(parent), RPAREN, phpSettings.COMMA_AFTER_LAST_PARAMETER_STYLE);
                } else if (PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInUseList(element, phpSettings) && element instanceof Variable && parent instanceof PhpUseList) {
                    this.insertCommaBetweenElementAndLineBreak(element, PhpUselessTrailingCommaInspection.getWhiteSpace(element), RPAREN, phpSettings.COMMA_AFTER_LAST_CLOSURE_USE_VAR_STYLE);
                } else if (PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInFunctionCall(element, phpSettings) && element instanceof PhpExpression) {
                    PsiElement lastArgument;
                    if (parent instanceof ParameterList && (parent.getParent() instanceof FunctionReference || parent.getParent() instanceof NewExpression) && parent.getLastChild().equals(element)) {
                        this.insertCommaBetweenElementAndLineBreak(element, PhpUselessTrailingCommaInspection.getWhiteSpace(parent), RPAREN, phpSettings.COMMA_AFTER_LAST_ARGUMENT_STYLE);
                    }
                    PsiElement psiElement = parent instanceof PhpUnset ? (PsiElement)ContainerUtil.getLastItem(Arrays.asList(((PhpUnset)parent).getArguments())) : (lastArgument = parent instanceof PhpIsset ? (PsiElement)ContainerUtil.getLastItem(Arrays.asList(((PhpIsset)parent).getVariables())) : null);
                    if (lastArgument != null && !PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace(lastArgument, true), PhpTokenTypes.opCOMMA) && element.equals(lastArgument)) {
                        this.insertCommaBetweenElementAndLineBreak(element, PhpUselessTrailingCommaInspection.getWhiteSpace(element), RPAREN, phpSettings.COMMA_AFTER_LAST_ARGUMENT_STYLE);
                    }
                } else if (PhpCommaAfterLastElementPostFormatProcessor.isTrailingCommaAllowedInMatchArm(element, phpSettings) && element instanceof PhpMatchArm && !(element instanceof PhpDefaultMatchArm)) {
                    this.insertCommaBetweenElementAndLineBreak(element, PhpUselessTrailingCommaInspection.getWhiteSpace(element), RBRACE, PhpCodeStyleSettings.PhpAddTrailingCommaStyle.WHEN_MULTILINE);
                }
            }
        }

        private void insertCommaBetweenElementAndLineBreak(PsiElement element, PsiElement whiteSpace, TokenSet parentheses, PhpCodeStyleSettings.PhpAddTrailingCommaStyle style) {
            if (style == PhpCodeStyleSettings.PhpAddTrailingCommaStyle.ALWAYS) {
                this.insertCommaAfterElement(element, parentheses, whiteSpace.getNextSibling());
            } else if (whiteSpace instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)whiteSpace.getText())) {
                PsiElement next = whiteSpace.getNextSibling();
                if (this.myDocument != null && next != null && parentheses.contains(next.getNode().getElementType())) {
                    this.insertCommaAfterElement(element, parentheses, next);
                }
            }
        }

        private void insertCommaAfterElement(PsiElement element, TokenSet parentheses, PsiElement next) {
            if (this.myDocument != null && next != null && parentheses.contains(next.getNode().getElementType())) {
                String toInsert = ListingVisitor.endsWithHeredoc(element) ? "\n" + this.getIndentString() + "," : ",";
                this.myDocument.insertString(element.getTextRange().getEndOffset() + this.myDelta, (CharSequence)toInsert);
                this.myDelta += toInsert.length();
            }
        }

        private static boolean endsWithHeredoc(@NotNull PsiElement element) {
            if (element == null) {
                ListingVisitor.$$$reportNull$$$0(4);
            }
            if (element.getNode().getElementType() == PhpElementTypes.HASH_ARRAY_ELEMENT) {
                PhpPsiElement value = ((ArrayHashElement)element).getValue();
                return value != null && value.getNode().getElementType() == PhpElementTypes.HEREDOC;
            }
            PsiElement lastChild = element.getLastChild();
            return lastChild != null && lastChild.getNode().getElementType() == PhpElementTypes.HEREDOC;
        }

        private String getIndentString() {
            CommonCodeStyleSettings.IndentOptions options = this.mySettings.getCommonSettings((Language)PhpLanguage.INSTANCE).getIndentOptions();
            if (options == null) {
                return "";
            }
            return new IndentInfo(0, options.INDENT_SIZE, 0).generateNewWhiteSpace(options);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpCommaAfterLastElementPostFormatProcessor$ListingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "endsWithHeredoc";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

