/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocLinkResolver {
    private final String myLink;
    private final PsiElement myContext;

    public PhpDocLinkResolver(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(1);
        }
        this.myLink = link;
        this.myContext = context;
    }

    @NotNull
    public static Collection<Result> resolve(@NotNull String myLink, @NotNull PsiElement myContext) {
        int bracketIndex;
        int arrowIndex;
        if (myLink == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(2);
        }
        if (myContext == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(3);
        }
        SmartList result = new SmartList();
        String className = null;
        String functionName = null;
        String fieldName = null;
        String unqualifiedName = null;
        int doubleColIndex = myLink.indexOf("::");
        if (doubleColIndex > 0) {
            className = myLink.substring(0, doubleColIndex);
        }
        if ((arrowIndex = myLink.indexOf("->")) > 0) {
            className = myLink.substring(0, arrowIndex);
        }
        if ((bracketIndex = myLink.indexOf("[]")) > 0) {
            className = myLink.substring(0, bracketIndex);
        }
        if (myLink.endsWith("()")) {
            functionName = myLink.substring(doubleColIndex > 0 ? doubleColIndex + 2 : 0, myLink.indexOf("()", doubleColIndex));
            arrowIndex = myLink.indexOf("->");
            if (arrowIndex > 0) {
                functionName = functionName.substring(arrowIndex + 2);
            }
        }
        if (myLink.startsWith("function ")) {
            functionName = myLink.substring("function".length()).trim();
        } else if (myLink.contains("$")) {
            int nameStart = myLink.indexOf("$") + 1;
            if (nameStart <= myLink.length()) {
                fieldName = myLink.substring(nameStart);
            }
        } else {
            unqualifiedName = myLink.substring(doubleColIndex > 0 ? doubleColIndex + 2 : 0);
            arrowIndex = unqualifiedName.indexOf("->");
            if (arrowIndex > 0) {
                unqualifiedName = unqualifiedName.substring(arrowIndex + 2);
            }
        }
        if (className == null) {
            PhpClass clazz = (PhpClass)PhpPsiUtil.getParentByCondition(myContext, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
            if (functionName != null) {
                PhpDocLinkResolver.addAll((Collection<Result>)result, PhpDocLinkResolver.findFunctions(functionName, myContext));
                if (result.isEmpty() && clazz != null) {
                    PhpDocLinkResolver.addIfNotNull((Collection<Result>)result, clazz, (PhpClassMember)clazz.findMethodByName((CharSequence)functionName));
                }
            } else if (fieldName != null) {
                PhpDocLinkResolver.addAll((Collection<Result>)result, PhpDocLinkResolver.findVariable(fieldName, myContext));
                if (result.isEmpty() && clazz != null) {
                    PhpDocLinkResolver.addIfNotNull((Collection<Result>)result, clazz, (PhpClassMember)clazz.findFieldByName((CharSequence)fieldName, false));
                }
            } else if (unqualifiedName != null) {
                if (clazz != null) {
                    PhpDocLinkResolver.addIfNotNull((Collection<Result>)result, clazz, (PhpClassMember)clazz.findMethodByName((CharSequence)unqualifiedName));
                    if (result.isEmpty()) {
                        PhpDocLinkResolver.addIfNotNull((Collection<Result>)result, clazz, (PhpClassMember)clazz.findFieldByName((CharSequence)unqualifiedName, false));
                    }
                }
                if (result.isEmpty()) {
                    PhpDocLinkResolver.addAll((Collection<Result>)result, PhpDocLinkResolver.findClasses(unqualifiedName, myContext));
                }
                if (result.isEmpty()) {
                    PhpDocLinkResolver.addAll((Collection<Result>)result, PhpDocLinkResolver.findFunctions(StringUtil.trimEnd((String)unqualifiedName, (String)"()"), myContext));
                }
                if (result.isEmpty()) {
                    if (clazz != null) {
                        PhpDocLinkResolver.addIfNotNull((Collection<Result>)result, clazz, (PhpClassMember)clazz.findFieldByName((CharSequence)unqualifiedName, true));
                    }
                    PhpDocLinkResolver.addAll((Collection<Result>)result, PhpDocLinkResolver.findConstants(unqualifiedName, myContext));
                }
            }
            if (result.isEmpty()) {
                PhpDocLinkResolver.addAll((Collection<Result>)result, PhpDocLinkResolver.findNamespace(myLink, myContext));
            }
        } else {
            PhpIndex index = PhpIndex.getInstance((Project)myContext.getProject());
            Collection classes = (Collection)StreamEx.of((Collection)ClassReferenceImpl.resolveClassTypeFromSpecialName(myContext, className).getTypes()).map(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.CLASS).signIfUnsigned(arg_0)).flatMap(fqn -> index.getBySignature(fqn).stream()).select(PhpClass.class).append(PhpDocLinkResolver.findClasses(className, myContext)).collect(Collectors.toSet());
            for (PhpClass clazz : classes) {
                String name = fieldName == null ? unqualifiedName : fieldName;
                Method resolved = clazz.findMethodByName((CharSequence)(functionName == null ? unqualifiedName : functionName));
                if (resolved == null) {
                    resolved = clazz.findFieldByName((CharSequence)name, false);
                }
                if (clazz.isEnum() && resolved == null) {
                    resolved = (PhpClassMember)ContainerUtil.find((Iterable)clazz.getEnumCases(), c -> name.equals(c.getName()));
                }
                if (resolved == null) {
                    resolved = clazz.findFieldByName((CharSequence)name, true);
                }
                PhpDocLinkResolver.addIfNotNull((Collection<Result>)result, clazz, (PhpClassMember)resolved);
            }
            if (result.isEmpty() && arrowIndex < 0) {
                PhpDocLinkResolver.addAll((Collection<Result>)result, classes);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private static void addAll(@NotNull Collection<Result> result, @NotNull Collection<? extends PsiElement> elements) {
        if (result == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(6);
        }
        for (PsiElement psiElement : elements) {
            result.add(new Result(psiElement));
        }
    }

    private static void addIfNotNull(@NotNull Collection<Result> result, @NotNull PhpClass phpClass, @Nullable PhpClassMember member) {
        if (result == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(7);
        }
        if (phpClass == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(8);
        }
        if (member != null) {
            result.add(new Result(phpClass, member));
        }
    }

    private static Collection<PhpClass> findClasses(@NotNull String name, @NotNull PsiElement myContext) {
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(9);
        }
        if (myContext == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(10);
        }
        PhpIndex myIndex = PhpIndex.getInstance((Project)myContext.getProject());
        boolean qualified = PhpLangUtil.isFqn(name);
        if (!qualified) {
            Collection<PhpClass> classesByResolvedFqn = PhpDocLinkResolver.getElementsByResolvedFqn(name, myContext.getParent(), arg_0 -> ((PhpIndex)myIndex).getAnyByFQN(arg_0));
            if (!classesByResolvedFqn.isEmpty()) {
                return classesByResolvedFqn;
            }
            List phpClasses = PhpDocLinkResolver.findInImports(name, myContext, false, false).select(PhpClass.class).toList();
            if (!phpClasses.isEmpty()) {
                return phpClasses;
            }
        } else {
            return myIndex.getAnyByFQN(name);
        }
        SmartList result = new SmartList();
        result.addAll(myIndex.getClassesByName(name));
        result.addAll(myIndex.getInterfacesByName(name));
        result.addAll(myIndex.getTraitsByName(name));
        return result;
    }

    @NotNull
    private static <T> Collection<T> getElementsByResolvedFqn(String name, PsiElement docRef, java.util.function.Function<String, Collection<T>> elementsSupplier) {
        PhpNamespaceReference namespace = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition(docRef, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF);
        if (namespace != null) {
            String fqn = PhpLangUtil.concat(PhpReferenceImpl.findNamespaceName(namespace.getFullName(), docRef), PhpLangUtil.toShortName(name));
            Collection<T> collection = elementsSupplier.apply(fqn);
            if (collection == null) {
                PhpDocLinkResolver.$$$reportNull$$$0(11);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static Collection<Function> findFunctions(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(14);
        }
        boolean qualified = PhpLangUtil.isFqn(name);
        PhpIndex index = PhpIndex.getInstance((Project)context.getProject());
        if (!qualified) {
            Collection<Function> classesByResolvedFqn = PhpDocLinkResolver.getElementsByResolvedFqn(name, context.getParent(), arg_0 -> ((PhpIndex)index).getFunctionsByFQN(arg_0));
            if (!classesByResolvedFqn.isEmpty()) {
                return classesByResolvedFqn;
            }
            List functions = PhpDocLinkResolver.findInImports(name, context, true, false).select(Function.class).toList();
            return !functions.isEmpty() ? functions : index.getFunctionsByName(name);
        }
        return index.getFunctionsByFQN(name);
    }

    private static Collection<Variable> findVariable(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(16);
        }
        return PhpIndex.getInstance((Project)context.getProject()).getVariablesByName(name);
    }

    private static Collection<PhpNamespace> findNamespace(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(18);
        }
        return PhpIndex.getInstance((Project)context.getProject()).getNamespacesByName(StringUtil.trimEnd((String)name, (String)"\\"));
    }

    private static Collection<Constant> findConstants(@NotNull String name, @NotNull PsiElement context) {
        Collection constants;
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(20);
        }
        boolean qualified = PhpLangUtil.isFqn(name);
        PhpIndex index = PhpIndex.getInstance((Project)context.getProject());
        if (!qualified) {
            Collection<Constant> classesByResolvedFqn = PhpDocLinkResolver.getElementsByResolvedFqn(name, context.getParent(), arg_0 -> ((PhpIndex)index).getConstantsByFQN(arg_0));
            if (!classesByResolvedFqn.isEmpty()) {
                return classesByResolvedFqn;
            }
            constants = PhpDocLinkResolver.findInImports(name, context, false, true).select(Constant.class).toList();
            if (!constants.isEmpty()) {
                return constants;
            }
            constants = index.getConstantsByName(name);
        } else {
            constants = index.getConstantsByFQN(name);
        }
        SmartList result = new SmartList();
        for (Constant constant : constants) {
            if (constant.isCaseSensitive() && !PhpLangUtil.toShortName(name).equals(constant.getName())) continue;
            result.add(constant);
        }
        return result;
    }

    private static StreamEx<PsiElement> findInImports(@NotNull String name, @NotNull PsiElement myContext, boolean function, boolean constant) {
        PhpPsiElement scope;
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(21);
        }
        if (myContext == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(22);
        }
        if ((scope = PhpCodeInsightUtil.findScopeForUseOperator(myContext)) != null) {
            return ((StreamEx)((StreamEx)StreamEx.of(PhpCodeInsightUtil.collectImports(scope)).map(PhpUseList::getDeclarations).flatMap(Arrays::stream).filter(use -> !(function && !PhpUseImpl.isOfFunction(use) || constant && !PhpUseImpl.isOfConst(use)))).filter(use -> constant ? name.equals(use.getName()) : name.equalsIgnoreCase(use.getName()))).map(PhpUse::getTargetReference).nonNull().map(reference -> reference.multiResolve(false)).flatMap(Arrays::stream).map(ResolveResult::getElement);
        }
        return StreamEx.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myLink";
                break;
            }
            case 3: 
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myContext";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/PhpDocLinkResolver";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpDocLinkResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByResolvedFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findFunctions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findVariable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findConstants";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findInImports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static final class Result {
        private final PsiElement myElement;
        private final PhpClassMember myMember;

        private Result(@NotNull PsiElement element) {
            if (element == null) {
                Result.$$$reportNull$$$0(0);
            }
            this.myElement = element;
            this.myMember = null;
        }

        private Result(@NotNull PhpClass phpClass, @NotNull PhpClassMember member) {
            if (phpClass == null) {
                Result.$$$reportNull$$$0(1);
            }
            if (member == null) {
                Result.$$$reportNull$$$0(2);
            }
            this.myElement = phpClass;
            this.myMember = member;
        }

        @NotNull
        public PsiElement getElement() {
            Object object = this.myMember != null ? this.myMember : this.myElement;
            if (object == null) {
                Result.$$$reportNull$$$0(3);
            }
            return object;
        }

        @Nullable
        public PhpClass getPhpClass() {
            return this.myElement instanceof PhpClass ? (PhpClass)this.myElement : null;
        }

        @Nullable
        public PhpClassMember getMember() {
            return this.myMember;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/documentation/PhpDocLinkResolver$Result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpDocLinkResolver$Result";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

