/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.impl.PhpModifierListImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDeleteElementQuickFix
extends PsiUpdateModCommandAction<PsiElement> {
    @Nls
    private final String myText;
    private IElementType myDelivery;

    public PhpDeleteElementQuickFix(@NotNull PsiElement element) {
        if (element == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(0);
        }
        this(element, PhpBundle.message("quick.fix.delete", element.getText()));
    }

    public PhpDeleteElementQuickFix(@NotNull PsiElement element, @NotNull IElementType delivery) {
        if (element == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(1);
        }
        if (delivery == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(2);
        }
        this(element);
        this.myDelivery = delivery;
    }

    public PhpDeleteElementQuickFix(@NotNull PsiElement element, @Nls String text) {
        if (element == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(3);
        }
        super(element);
        this.myText = text;
    }

    public PhpDeleteElementQuickFix(@NotNull PsiElement element, @Nls String text, @Nullable IElementType delivery) {
        if (element == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(4);
        }
        this(element, text);
        this.myDelivery = delivery;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.myText;
        if (string == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(7);
        }
        if (updater == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(8);
        }
        this.deleteElement(element);
    }

    private void deleteElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(9);
        }
        if (this.myDelivery != null) {
            PhpCodeEditUtil.removeStatementWithDelivery(element, this.myDelivery);
            return;
        }
        if (PhpModifierListImpl.isSetOperationModifier(element)) {
            PhpDeleteElementQuickFix.deleteSetOperation(element);
        }
        if (PhpPsiUtil.isOfType(element, PhpTokenTypes.kwSET)) {
            Object lparen = PhpPsiUtil.getPrevSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)it -> PhpPsiUtil.isOfType(it, PhpTokenTypes.chLPAREN)));
            Object rparen = PhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)it -> PhpPsiUtil.isOfType(it, PhpTokenTypes.chRPAREN)));
            if (lparen != null && rparen != null) {
                lparen.delete();
                rparen.delete();
            }
        }
        element.delete();
    }

    public static void deleteSetOperation(PsiElement element) {
        Object lparen = PhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)it -> PhpPsiUtil.isOfType(it, PhpTokenTypes.chLPAREN)));
        Object set = PhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)it -> PhpPsiUtil.isOfType(it, PhpTokenTypes.kwSET)));
        Object rparen = PhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)it -> PhpPsiUtil.isOfType(it, PhpTokenTypes.chRPAREN)));
        if (lparen != null && set != null && rparen != null) {
            lparen.delete();
            set.delete();
            rparen.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delivery";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDeleteElementQuickFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDeleteElementQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

