/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.actions;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.actions.PhpStatementUpDownBaseMover;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Try;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpStatementUpDownMover
extends PhpStatementUpDownBaseMover {
    private static final Logger LOG = Logger.getInstance(PhpStatementUpDownMover.class);
    private static final Condition<PsiElement> STATEMENT = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            if (element instanceof GroupStatement) {
                PsiElement child = element.getFirstChild();
                return PhpPsiUtil.isOfType(child, PhpTokenTypes.chLBRACE) && !SIMPLE_STATEMENT.value((Object)element.getParent());
            }
            return SIMPLE_STATEMENT.value((Object)element);
        }
    };
    private static final Condition<PsiElement> SIMPLE_STATEMENT = element -> !(element instanceof GroupStatement) && element instanceof Statement || !(element instanceof Method) && element instanceof Function || element instanceof PhpUseList && !((PhpUseList)element).isTraitImport() || element instanceof PsiComment;
    private static final Condition<PsiElement> SKIP = element -> element instanceof PhpClass || element instanceof Statement && !(element instanceof ControlStatement) && !(element instanceof GroupStatement) && !(element instanceof Try) && !(element instanceof Else) && !(element instanceof PhpSwitch);
    private static final Condition<PsiElement> MAX_SKIP_EXPRESSION = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            return SKIP_EXPRESSION.value((Object)element) && !SKIP_EXPRESSION.value((Object)element.getParent());
        }
    };
    private static final Condition<PsiElement> SKIP_EXPRESSION = element -> element instanceof PhpExpression || element instanceof ParameterList;

    private static PsiElement expandStatement(@NotNull PsiElement element) {
        PhpDocComment comment;
        if (element == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(0);
        }
        if (PhpPsiUtil.isOfType(element, PhpTokenTypes.chLBRACE) || PhpPsiUtil.isOfType(element, PhpTokenTypes.chRBRACE)) {
            GroupStatement group = PhpPsiUtil.getParentOfClass(element, GroupStatement.class);
            if (group != null) {
                element = SIMPLE_STATEMENT.value((Object)group.getParent()) ? group.getParent() : group;
            }
        } else if ((PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_COMMENT_START) || PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_COMMENT_END)) && (comment = PhpPsiUtil.getParentOfClass(element, PhpDocComment.class)) != null) {
            element = comment;
        }
        return element instanceof Else || element instanceof ElseIf || element instanceof Catch || element instanceof Finally ? element.getParent() : element;
    }

    @Override
    protected boolean configureMoveRange(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, @NotNull PsiElement firstElement, @NotNull PsiElement lastElement, boolean down) {
        int endOffset;
        int lastStatementStart;
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(2);
        }
        if (info == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(3);
        }
        if (firstElement == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(4);
        }
        if (lastElement == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(5);
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        Pair elementRange = PhpStatementUpDownMover.getElementRange((PsiElement)parent, (PsiElement)firstElement, (PsiElement)lastElement);
        if (parent == null || elementRange == null) {
            return false;
        }
        firstElement = (PsiElement)elementRange.getFirst();
        lastElement = (PsiElement)elementRange.getSecond();
        Object firstStatement = PhpPsiUtil.getParentByCondition((PsiElement)elementRange.getFirst(), false, STATEMENT);
        Object lastStatement = PhpPsiUtil.getParentByCondition((PsiElement)elementRange.getSecond(), false, STATEMENT);
        if (firstStatement == null || lastStatement == null) {
            return false;
        }
        int firstStatementStart = editor.offsetToLogicalPosition((int)firstStatement.getTextRange().getStartOffset()).line;
        if (info.toMove.startLine == firstStatementStart) {
            firstElement = firstStatement;
            if (firstStatement == lastStatement) {
                lastElement = firstElement;
            }
        }
        if (info.toMove.endLine == (lastStatementStart = editor.offsetToLogicalPosition((int)lastStatement.getTextRange().getStartOffset()).line)) {
            lastElement = lastStatement;
            if (firstStatement == lastStatement) {
                firstElement = lastElement;
            }
        }
        LineRange range = PhpStatementUpDownMover.expandLineRangeToPsi(info.toMove, editor, file, PhpStatementUpDownMover.expandStatement(firstElement), PhpStatementUpDownMover.expandStatement(lastElement));
        int startOffset = editor.logicalPositionToOffset(new LogicalPosition(range.startLine, 0));
        PsiElement[] statements = PhpStatementUpDownMover.findElementsInRange(file, startOffset, endOffset = editor.logicalPositionToOffset(new LogicalPosition(range.endLine, 0)));
        if (statements == null || statements.length == 0) {
            return false;
        }
        PsiElement first = this.getStatement(statements[0]);
        PsiElement last = this.getStatement(statements[statements.length - 1]);
        if (first != null && last != null) {
            info.toMove = PhpStatementUpDownMover.expandLineRangeToPsi(info.toMove, editor, file, first, last);
            boolean isAvailable = PhpStatementUpDownMover.moveStatementIsAvailable(info.toMove, editor, file, down);
            if (!isAvailable) {
                info.prohibitMove();
            }
            return true;
        }
        return true;
    }

    @Override
    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiFile file;
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(6);
        }
        if (info == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(7);
        }
        super.beforeMove(editor, info, down);
        Project project = editor.getProject();
        if (project != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            info.toMove2 = this.configureTargetRange(info.toMove, editor, file, down);
        }
    }

    private PsiElement getStatement(@NotNull PsiElement element) {
        if (element == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(8);
        }
        if (element instanceof PhpDocComment) {
            PsiElement owner = ((PhpDocComment)element).getOwner();
            return owner instanceof Function ? owner : element;
        }
        return element;
    }

    private static PsiElement @Nullable [] findElementsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        PsiElement lastElement;
        if (file == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(9);
        }
        PhpLanguage language = PhpLanguage.INSTANCE;
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement firstElement = viewProvider.findElementAt(startOffset, (Language)language);
        if (firstElement instanceof PsiWhiteSpace) {
            firstElement = file.findElementAt(firstElement.getTextRange().getEndOffset());
        }
        if ((lastElement = viewProvider.findElementAt(endOffset - 1, (Language)language)) instanceof PsiWhiteSpace) {
            lastElement = file.findElementAt(lastElement.getTextRange().getStartOffset() - 1);
        }
        if (firstElement == null || lastElement == null) {
            return null;
        }
        Object firstStatement = PhpPsiUtil.getParentByCondition(firstElement, false, STATEMENT);
        Object lastStatement = PhpPsiUtil.getParentByCondition(lastElement, false, STATEMENT);
        if (firstStatement == null && lastStatement == null) {
            return null;
        }
        if (firstStatement != null && PhpStatementUpDownMover.isInRange(file, firstStatement, startOffset, endOffset)) {
            if (lastStatement == null || !PhpStatementUpDownMover.isInRange(file, lastStatement, startOffset, endOffset)) {
                lastStatement = firstStatement;
            }
        } else if (lastStatement != null && PhpStatementUpDownMover.isInRange(file, lastStatement, startOffset, endOffset)) {
            if (firstStatement == null || !PhpStatementUpDownMover.isInRange(file, firstStatement, startOffset, endOffset)) {
                firstStatement = lastStatement;
            }
        } else {
            return null;
        }
        if (firstStatement == lastStatement || firstStatement.getTextRange().contains(lastStatement.getTextRange())) {
            return new PsiElement[]{firstStatement};
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        Pair elementRange = PhpStatementUpDownMover.getElementRange((PsiElement)parent, (PsiElement)firstElement, (PsiElement)lastElement);
        if (elementRange == null) {
            return null;
        }
        PhpPsiElement[] elements = PhpPsiUtil.getPhpPsiElementsInRange((PsiElement)elementRange.first, (PsiElement)elementRange.second);
        ArrayList<Object> array = new ArrayList<Object>();
        array.add((PsiElement)elementRange.first);
        for (PhpPsiElement element : elements) {
            if (!SIMPLE_STATEMENT.value((Object)element)) continue;
            array.add(element);
        }
        array.add((PsiElement)elementRange.second);
        return PsiUtilCore.toPsiElementArray(array);
    }

    private static boolean isInRange(@NotNull PsiFile file, @NotNull PsiElement element, int startOffset, int endOffset) {
        boolean isRightContain;
        TextRange range;
        if (file == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(10);
        }
        if (element == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(11);
        }
        boolean isLeftContain = startOffset <= (range = element.getTextRange()).getStartOffset();
        boolean bl = isRightContain = endOffset >= range.getEndOffset();
        if (!isRightContain) {
            PsiElement nextElement = file.findElementAt(endOffset);
            while (nextElement instanceof PsiWhiteSpace) {
                nextElement = file.findElementAt(nextElement.getTextRange().getEndOffset());
            }
            boolean bl2 = isRightContain = nextElement != null && nextElement.getTextRange().getEndOffset() >= range.getEndOffset();
        }
        if (!isLeftContain) {
            PsiElement prevElement = file.findElementAt(startOffset - 1);
            while (prevElement instanceof PsiWhiteSpace) {
                prevElement = file.findElementAt(prevElement.getTextRange().getStartOffset() - 1);
            }
            isLeftContain = prevElement != null && prevElement.getTextRange().getStartOffset() <= range.getStartOffset();
        }
        return isLeftContain && isRightContain;
    }

    private static boolean moveStatementIsAvailable(@NotNull LineRange toMove, @NotNull Editor editor, @NotNull PsiFile file, boolean down) {
        int startLine;
        if (toMove == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(13);
        }
        if (file == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(14);
        }
        int n = startLine = down ? toMove.endLine : toMove.startLine - 1;
        if (startLine < 0) {
            return false;
        }
        int targetElementOffset = editor.logicalPositionToOffset(new LogicalPosition(startLine, 0));
        PsiElement targetElement = PhpStatementUpDownMover.firstNonWhiteLeafElement(targetElementOffset, file);
        if (PhpStatementUpDownMover.lineIsEmpty(editor, down, startLine, targetElement)) {
            return true;
        }
        return PhpStatementUpDownMover.canMoveOutside(toMove.firstElement, toMove.lastElement, targetElement);
    }

    private static boolean lineIsEmpty(Editor editor, boolean down, int startLine, @Nullable PsiElement targetElement) {
        return targetElement == null || PhpStatementUpDownMover.canMoveToLine(editor, targetElement, startLine, down);
    }

    @Nullable
    private static Pair<PsiElement, PsiElement> getTargetElementRange(@NotNull Editor editor, @NotNull PsiFile file, int targetLine) {
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(15);
        }
        if (file == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(16);
        }
        PsiElement first = PhpStatementUpDownMover.firstNonEmptyElement(editor.logicalPositionToOffset(new LogicalPosition(targetLine, 0)), file, true);
        PsiElement last = PhpStatementUpDownMover.firstNonEmptyElement(editor.logicalPositionToOffset(new LogicalPosition(targetLine + 1, 0)) - 1, file, false);
        if (first == null || last == null) {
            return null;
        }
        PsiElement firstChild = first.getFirstChild();
        PsiElement lastChild = last.getLastChild();
        return Pair.create((Object)(firstChild == null ? first : firstChild), (Object)(lastChild == null ? last : lastChild));
    }

    @Nullable
    private LineRange configureTargetRange(@NotNull LineRange toMove, @NotNull Editor editor, @NotNull PsiFile file, boolean down) {
        PhpSwitch switchStatement;
        PsiElement owner;
        Pair<PsiElement, PsiElement> targetElementRange;
        PsiElement targetElement;
        int startLine;
        if (toMove == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(17);
        }
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(18);
        }
        if (file == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(19);
        }
        if (PhpStatementUpDownMover.lineIsEmpty(editor, down, startLine = down ? toMove.endLine : toMove.startLine - 1, targetElement = (PsiElement)Pair.getFirst(targetElementRange = PhpStatementUpDownMover.getTargetElementRange(editor, file, startLine)))) {
            return new LineRange(startLine, startLine + 1);
        }
        ASTNode node = targetElement.getNode();
        IElementType type = node.getElementType();
        Object sourceStatement = PhpPsiUtil.getParentByCondition(down ? toMove.lastElement : toMove.firstElement, SKIP);
        Object targetStatement = toMove.firstElement instanceof PhpCase || toMove.lastElement instanceof PhpCase ? PhpPsiUtil.getParentOfClass(targetElement, PhpCase.class) : PhpPsiUtil.getParentByCondition(targetElement, SKIP);
        if (targetStatement != null && targetStatement != sourceStatement) {
            return PhpStatementUpDownMover.skipStatement(toMove, editor, file, (PsiElement)targetStatement, down);
        }
        PhpDocComment phpDoc = PhpPsiUtil.getParentOfClass(targetElement, PhpDocComment.class);
        PsiElement psiElement = owner = phpDoc != null ? phpDoc.getOwner() : null;
        if (owner instanceof Function) {
            return PhpStatementUpDownMover.moveInsideFunction(editor, (Function)owner, startLine + 1);
        }
        if (PhpTokenTypes.COMMENTS.contains(type) || phpDoc != null) {
            PsiElement comment = phpDoc == null ? targetElement : phpDoc;
            TextRange range = comment.getTextRange();
            int commentStartLine = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
            int commentEndLine = editor.offsetToLogicalPosition((int)range.getEndOffset()).line + 1;
            return new LineRange(commentStartLine, commentEndLine);
        }
        if (type == PhpTokenTypes.kwFUNCTION) {
            PsiElement parent = targetElement.getParent();
            if (parent instanceof Function) {
                return down ? PhpStatementUpDownMover.moveInsideFunction(editor, (Function)parent, startLine + 1) : PhpStatementUpDownMover.moveOutsideOfFunction(editor, (Function)parent, startLine);
            }
        } else if (type == PhpTokenTypes.chLBRACE && !down) {
            PsiElement parent;
            GroupStatement group = PhpPsiUtil.getParentOfClass(targetElement, GroupStatement.class);
            PsiElement psiElement2 = parent = group == null ? null : group.getParent();
            if (parent instanceof Function) {
                return PhpStatementUpDownMover.moveOutsideOfFunction(editor, (Function)parent, startLine);
            }
        } else if (type == PhpTokenTypes.kwSWITCH && down) {
            switchStatement = PhpPsiUtil.getParentOfClass(targetElement, PhpSwitch.class);
            Object firstCase = PhpPsiUtil.getChildByCondition((PsiElement)switchStatement, (Condition<? super PsiElement>)PhpCase.INSTANCEOF);
            if (switchStatement != null && firstCase != null) {
                int endLine = editor.offsetToLogicalPosition((int)firstCase.getTextRange().getStartOffset()).line + 1;
                return new LineRange(startLine, endLine);
            }
        } else if (!(type != PhpTokenTypes.kwCASE && type != PhpTokenTypes.kwDEFAULT || down || (switchStatement = PhpPsiUtil.getParentOfClass(targetElement, PhpSwitch.class)) == null)) {
            Object firstCase = PhpPsiUtil.getChildByCondition((PsiElement)switchStatement, (Condition<? super PsiElement>)PhpCase.INSTANCEOF);
            PhpCase caseStatement = PhpPsiUtil.getParentOfClass(targetElement, PhpCase.class);
            if (caseStatement != null && firstCase == caseStatement) {
                int endLine = startLine + 1;
                startLine = editor.offsetToLogicalPosition((int)switchStatement.getTextRange().getStartOffset()).line;
                return new LineRange(startLine, endLine);
            }
        }
        LineRange parameterListRange = PhpStatementUpDownMover.getParameterListRange(editor, targetElementRange, startLine, down ? toMove.endLine - 1 : toMove.startLine);
        return parameterListRange == null ? new LineRange(startLine, startLine + 1) : parameterListRange;
    }

    private static LineRange skipStatement(@NotNull LineRange toMove, @NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement targetStatement, boolean down) {
        if (toMove == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(21);
        }
        if (file == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(22);
        }
        if (targetStatement == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(23);
        }
        TextRange range = targetStatement.getTextRange();
        int skipStartLine = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
        int skipEndLine = editor.offsetToLogicalPosition((int)range.getEndOffset()).line + 1;
        if (!down) {
            int startLineOffset;
            PsiElement startingElement;
            if (skipEndLine - 1 == toMove.startLine && ((startingElement = PhpStatementUpDownMover.firstNonWhiteElement((int)(startLineOffset = editor.logicalPositionToOffset(new LogicalPosition(toMove.startLine, 0))), (PsiFile)file, (boolean)true)) == null || StringUtil.isEmpty((String)startingElement.getText()) || toMove.firstElement.getTextRange().contains(startingElement.getTextRange()))) {
                --skipEndLine;
            }
            if (skipEndLine > toMove.startLine) {
                startLineOffset = editor.logicalPositionToOffset(new LogicalPosition(toMove.startLine, 0));
                int endLineOffset = editor.logicalPositionToOffset(new LogicalPosition(toMove.endLine, 0));
                String fragmentToMove = editor.getDocument().getText(new TextRange(startLineOffset, endLineOffset));
                String previousFragment = editor.getDocument().getText(range);
                LOG.error("Line range of target statement is intersected with upper statement.\n[" + skipStartLine + "," + skipEndLine + "]\n'" + previousFragment + "'\n[" + toMove.startLine + ", " + toMove.endLine + "]\n'" + fragmentToMove + "'");
                return null;
            }
        } else {
            int skipEndLineOffset = editor.logicalPositionToOffset(new LogicalPosition(skipEndLine - 1, 0));
            PsiElement skipEndElement = PhpStatementUpDownMover.firstNonWhiteElement((int)skipEndLineOffset, (PsiFile)file, (boolean)true);
            if (skipEndElement == null || StringUtil.isEmpty((String)skipEndElement.getText()) || !(skipEndElement instanceof GroupStatement) && !targetStatement.getTextRange().contains(skipEndElement.getTextRange())) {
                --skipEndLine;
            }
        }
        return new LineRange(skipStartLine, skipEndLine);
    }

    @Nullable
    private static LineRange getParameterListRange(@NotNull Editor editor, @NotNull Pair<PsiElement, PsiElement> elementRange, int targetLine, int sourceLine) {
        PsiElement first;
        LineRange expressionRange;
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(24);
        }
        if (elementRange == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(25);
        }
        if ((expressionRange = PhpStatementUpDownMover.getParameterListRangeByElement(editor, first = PhpStatementUpDownMover.getMaxParentExpression((PsiElement)elementRange.first), targetLine, sourceLine)) != null) {
            return expressionRange;
        }
        PsiElement last = PhpStatementUpDownMover.getMaxParentExpression((PsiElement)elementRange.second);
        return last == first ? null : PhpStatementUpDownMover.getParameterListRangeByElement(editor, last, targetLine, sourceLine);
    }

    @NotNull
    private static PsiElement getMaxParentExpression(@NotNull PsiElement element) {
        Object expression;
        if (element == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(26);
        }
        Object object = (expression = PhpPsiUtil.getParentByCondition(element, MAX_SKIP_EXPRESSION)) == null ? element : expression;
        if (object == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(27);
        }
        return object;
    }

    @Nullable
    private static LineRange getParameterListRangeByElement(@NotNull Editor editor, @NotNull PsiElement element, int targetLine, int sourceLine) {
        PsiElement end;
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(28);
        }
        if (element == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(29);
        }
        PsiElement start = PhpStatementUpDownMover.findParameterListStart(element);
        PsiElement psiElement = end = PhpPsiUtil.isOfType(element, PhpTokenTypes.chRPAREN) ? element : PhpPsiUtil.findNextSiblingOfAnyType(element, PhpTokenTypes.chRPAREN);
        if (start != null && end != null) {
            int startLine = editor.offsetToLogicalPosition((int)start.getTextRange().getStartOffset()).line;
            int endLine = editor.offsetToLogicalPosition((int)end.getTextRange().getStartOffset()).line;
            if ((sourceLine > endLine || sourceLine < startLine) && targetLine <= endLine && targetLine >= startLine) {
                return new LineRange(startLine, endLine + 1);
            }
        }
        return null;
    }

    private static PsiElement findParameterListStart(@NotNull PsiElement element) {
        PsiElement prev;
        PsiElement open;
        PsiElement next;
        if (element == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(30);
        }
        if (PhpStatementUpDownMover.isKeywordWithCondition(element) && PhpPsiUtil.isOfType(next = PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, true), PhpTokenTypes.chLPAREN)) {
            return element;
        }
        PsiElement psiElement = open = PhpPsiUtil.isOfType(element, PhpTokenTypes.chLPAREN) ? element : PhpPsiUtil.findPrevSiblingOfAnyType(element, PhpTokenTypes.chLPAREN);
        if (open != null && PhpStatementUpDownMover.isKeywordWithCondition(prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(open, true))) {
            return prev;
        }
        return open;
    }

    private static boolean isKeywordWithCondition(@NotNull PsiElement element) {
        if (element == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(31);
        }
        return PhpPsiUtil.isOfType(element, PhpTokenTypes.kwWHILE, PhpTokenTypes.kwIF, PhpTokenTypes.kwFOR, PhpTokenTypes.kwFOREACH);
    }

    private static LineRange moveOutsideOfFunction(@NotNull Editor editor, @NotNull Function element, int endLine) {
        PhpDocComment comment;
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(32);
        }
        if (element == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(33);
        }
        Function target = (comment = element.getDocComment()) == null ? element : comment;
        int startLine = editor.offsetToLogicalPosition((int)target.getTextRange().getStartOffset()).line;
        return new LineRange(startLine, endLine + 1);
    }

    private static LineRange moveInsideFunction(@NotNull Editor editor, @NotNull Function element, int defaultEnd) {
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(34);
        }
        if (element == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(35);
        }
        int startOffset = element.getTextRange().getStartOffset();
        PhpDocComment comment = element.getDocComment();
        if (comment != null) {
            startOffset = Math.min(startOffset, comment.getTextRange().getStartOffset());
        }
        int startLine = editor.offsetToLogicalPosition((int)startOffset).line;
        Object group = PhpPsiUtil.getChildByCondition((PsiElement)element, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        int endOffset = group == null ? -1 : group.getTextRange().getStartOffset();
        int endLine = endOffset == -1 ? defaultEnd : editor.offsetToLogicalPosition((int)endOffset).line + 1;
        return new LineRange(startLine, endLine);
    }

    private static boolean canMoveOutside(@NotNull PsiElement firstSourceElement, @NotNull PsiElement lastSourceElement, @NotNull PsiElement targetElement) {
        ASTNode node;
        IElementType type;
        if (firstSourceElement == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(36);
        }
        if (lastSourceElement == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(37);
        }
        if (targetElement == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(38);
        }
        if ((type = (node = targetElement.getNode()).getElementType()) == PhpTokenTypes.PHP_CLOSING_TAG || type == PhpTokenTypes.PHP_OPENING_TAG || type == PhpTokenTypes.PHP_ECHO_OPENING_TAG || type == PhpTokenTypes.kwNAMESPACE) {
            return false;
        }
        if (firstSourceElement instanceof PhpCase || lastSourceElement instanceof PhpCase) {
            PhpSwitch parentSwitch = PhpPsiUtil.getParentOfClass(targetElement, PhpSwitch.class);
            if (parentSwitch == null) {
                return false;
            }
            return (type != PhpTokenTypes.chRBRACE && type != PhpTokenTypes.chLBRACE || targetElement.getParent() != parentSwitch) && type != PhpTokenTypes.kwSWITCH && type != PhpTokenTypes.kwENDSWITCH;
        }
        if (type == PhpTokenTypes.kwFUNCTION || type == PhpTokenTypes.chRBRACE || type == PhpTokenTypes.chLBRACE || PhpTokenTypes.tsVISIBILITY_MODIFIERS.contains(type) || PhpTokenTypes.tsMODIFIERS.contains(type)) {
            targetElement = targetElement.getParent().getParent();
        }
        return !(targetElement instanceof PhpNamespace) && !(targetElement instanceof Method);
    }

    private static boolean canMoveToLine(@NotNull Editor editor, @NotNull PsiElement element, int startLine, boolean down) {
        if (editor == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(39);
        }
        if (element == null) {
            PhpStatementUpDownMover.$$$reportNull$$$0(40);
        }
        TextRange range = element.getTextRange();
        int elementStartLine = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
        int elementEndLine = editor.offsetToLogicalPosition((int)range.getEndOffset()).line;
        return down ? elementStartLine > startLine : startLine > elementEndLine || elementStartLine > startLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastElement";
                break;
            }
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMove";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetStatement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/actions/PhpStatementUpDownMover";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstSourceElement";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastSourceElement";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/actions/PhpStatementUpDownMover";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxParentExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expandStatement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureMoveRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeMove";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInRange";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveStatementIsAvailable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElementRange";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "configureTargetRange";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "skipStatement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getParameterListRange";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMaxParentExpression";
                break;
            }
            case 27: {
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParameterListRangeByElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findParameterListStart";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordWithCondition";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "moveOutsideOfFunction";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "moveInsideFunction";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "canMoveOutside";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "canMoveToLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 27 -> new IllegalStateException(string);
        };
    }
}

