/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.debugger;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpMethodBreakpointProperties;
import com.jetbrains.php.debug.common.PhpStackFrame;
import com.jetbrains.php.debug.common.PhpSuspendContext;
import com.jetbrains.php.debug.common.smartStepInto.PhpSmartStepIntoState;
import com.jetbrains.php.debug.connection.ConnectionStatus;
import com.jetbrains.php.debug.connection.InputHandler;
import com.jetbrains.php.debug.connection.PhpDebugPathExtractor;
import com.jetbrains.php.debug.stepFilters.PhpStepFiltersConfiguration;
import com.jetbrains.php.debug.zend.ZendDebugUtil;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnection;
import com.jetbrains.php.debug.zend.debugger.ZendDebuggerStackFrame;
import com.jetbrains.php.debug.zend.debugger.ZendDebuggerValue;
import com.jetbrains.php.debug.zend.handlers.GetFileContentFastNotificationHandler;
import com.jetbrains.php.debug.zend.handlers.GetFileContentNotificationHandler;
import com.jetbrains.php.debug.zend.handlers.ReadyNotificationHandler;
import com.jetbrains.php.debug.zend.handlers.ScriptEndNotificationHandler;
import com.jetbrains.php.debug.zend.handlers.ZendDebuggerResponseHandler;
import com.jetbrains.php.debug.zend.messages.AddBreakpointResponse;
import com.jetbrains.php.debug.zend.messages.AddLineBreakpointRequest;
import com.jetbrains.php.debug.zend.messages.ContinueProcessFileNotification;
import com.jetbrains.php.debug.zend.messages.DeleteBreakpointRequest;
import com.jetbrains.php.debug.zend.messages.DeleteBreakpointResponse;
import com.jetbrains.php.debug.zend.messages.GetCallStackRequest;
import com.jetbrains.php.debug.zend.messages.GetCallStackResponse;
import com.jetbrains.php.debug.zend.messages.GetFileContentFastNotification;
import com.jetbrains.php.debug.zend.messages.GetFileContentNotification;
import com.jetbrains.php.debug.zend.messages.GoRequest;
import com.jetbrains.php.debug.zend.messages.OutputNotification;
import com.jetbrains.php.debug.zend.messages.PhpErrorNotification;
import com.jetbrains.php.debug.zend.messages.ReadyNotification;
import com.jetbrains.php.debug.zend.messages.ScriptEndNotification;
import com.jetbrains.php.debug.zend.messages.SessionCloseNotification;
import com.jetbrains.php.debug.zend.messages.StartProcessFileNotification;
import com.jetbrains.php.debug.zend.messages.StartRequest;
import com.jetbrains.php.debug.zend.messages.StepIntoRequest;
import com.jetbrains.php.debug.zend.messages.StepOutRequest;
import com.jetbrains.php.debug.zend.messages.StepOverRequest;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ZendDebuggerDriver
extends PhpDebugDriver<ZendDebuggerConnection> {
    public static final ZendDebuggerDriver INSTANCE = new ZendDebuggerDriver();

    private ZendDebuggerDriver() {
    }

    @Override
    @NotNull
    public String getSessionIdName() {
        return "session id";
    }

    @Override
    public boolean isConditionalBreakpointSupported(XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        return false;
    }

    @Override
    public boolean isExceptionalBreakpointSupported() {
        return false;
    }

    @Override
    public boolean isMethodBreakpointSupported() {
        return false;
    }

    @Override
    public void registerBreakpoint(@NotNull ZendDebuggerConnection connection, @NotNull String remoteFilePath, int line, @Nullable String condition, @NotNull String encoding, final @NotNull PhpDebugProcess.RegisterBreakpointCallback callback) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(0);
        }
        if (remoteFilePath == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(1);
        }
        if (encoding == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(3);
        }
        connection.send(new AddLineBreakpointRequest(remoteFilePath, line + 1), new ZendDebuggerResponseHandler<AddBreakpointResponse>(){

            @Override
            public void onSuccessResponse(@NotNull AddBreakpointResponse message) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                callback.registered(String.valueOf(message.getBreakpointId()));
            }

            @Override
            public void onErrorResponse(@NotNull AddBreakpointResponse message) {
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                callback.errorOccurred("Cannot add breakpoint");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void registerMethodBreakpoint(@NotNull ZendDebuggerConnection connection, @NotNull PhpMethodBreakpointProperties properties, @NotNull PhpDebugProcess.RegisterBreakpointCallback callback) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(4);
        }
        if (properties == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(6);
        }
        callback.errorOccurred(PhpBundle.message("debug.php.method.breakpoint.zend.not.supported", new Object[0]));
    }

    @Override
    public void registerExceptionBreakpoint(@NotNull ZendDebuggerConnection connection, @NotNull String exception, @NotNull PhpDebugProcess.RegisterBreakpointCallback callback) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(7);
        }
        if (exception == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(9);
        }
        callback.errorOccurred(PhpBundle.message("debug.php.exception.breakpoint.zend.not.supported", new Object[0]));
    }

    @Override
    public void unregisterBreakpoint(@NotNull ZendDebuggerConnection connection, @NotNull String breakpointId, final @NotNull PhpDebugProcess.UnregisterBreakpointCallback callback) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(10);
        }
        if (breakpointId == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(11);
        }
        if (callback == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(12);
        }
        int id = Integer.parseInt(breakpointId);
        connection.send(new DeleteBreakpointRequest(id), new ZendDebuggerResponseHandler<DeleteBreakpointResponse>(){

            @Override
            public void onSuccessResponse(@NotNull DeleteBreakpointResponse message) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                callback.unregistered();
            }

            @Override
            public void onErrorResponse(@NotNull DeleteBreakpointResponse message) {
                if (message == null) {
                    2.$$$reportNull$$$0(1);
                }
                callback.errorOccurred("Cannot remote breakpoint");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings, @NotNull PhpDebugProcess process) {
        if (leftToolbar == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(13);
        }
        if (topToolbar == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(14);
        }
        if (settings == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(15);
        }
        if (process == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(16);
        }
        topToolbar.add(ActionManager.getInstance().getAction("PhpDebugHideEmptySuperGlobals"));
    }

    @Override
    public XValueMarkerProvider<ZendDebuggerValue, String> createValueMarkerProvider() {
        return null;
    }

    @Override
    public void registerHandlers(@NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess) {
        ZendDebuggerConnection connection;
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(17);
        }
        if ((connection = debugProcess.getConnection()) == null) {
            return;
        }
        connection.registerClassHandler(ReadyNotification.class, new ReadyNotificationHandler(debugProcess));
        connection.registerClassHandler(GetFileContentNotification.class, new GetFileContentNotificationHandler(debugProcess));
        connection.registerClassHandler(GetFileContentFastNotification.class, new GetFileContentFastNotificationHandler(debugProcess));
        connection.registerClassHandler(ScriptEndNotification.class, new ScriptEndNotificationHandler(connection));
        connection.registerClassHandler(StartProcessFileNotification.class, new InputHandler<StartProcessFileNotification>(){

            @Override
            public void onResponse(@NotNull StartProcessFileNotification message) {
                if (message == null) {
                    3.$$$reportNull$$$0(0);
                }
                connection.send(new ContinueProcessFileNotification());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$3", "onResponse"));
            }
        });
    }

    @Override
    public void registerErrorOutputHandler(@NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, final @NotNull PhpDebugProcess.ErrorOutputHandler handler) {
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(18);
        }
        if (handler == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(19);
        }
        ZendDebuggerConnection connection = debugProcess.getConnection();
        assert (connection != null);
        connection.registerClassHandler(PhpErrorNotification.class, new InputHandler<PhpErrorNotification>(){

            @Override
            public void onResponse(@NotNull PhpErrorNotification message) {
                if (message == null) {
                    4.$$$reportNull$$$0(0);
                }
                String errorText = message.getText();
                String filename = message.getFilename();
                int lineNumber = message.getLineNumber();
                String errorName = ZendDebugUtil.getErrorName(message.getErrorType());
                handler.onErrorOutput(PhpBundle.message("debug.process.console.error.format", errorName, errorText, filename, String.valueOf(lineNumber)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$4", "onResponse"));
            }
        });
    }

    @Override
    public void startStepOver(@NotNull ZendDebuggerConnection connection) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(20);
        }
        connection.send(new StepOverRequest(), null);
    }

    @Override
    public void startStepInto(@NotNull ZendDebuggerConnection connection) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(21);
        }
        connection.send(new StepIntoRequest(), null);
    }

    @Override
    public void startFilteredStepInto(@NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, @NotNull ZendDebuggerConnection connection, @NotNull PhpStepFiltersConfiguration.State state) {
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(22);
        }
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(23);
        }
        if (state == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(24);
        }
        this.startStepInto(connection);
    }

    @Override
    public void startSmartStepInto(final @NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess) {
        ZendDebuggerConnection connection;
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(25);
        }
        if ((connection = debugProcess.getConnection()) != null) {
            connection.send(new GetCallStackRequest(), new ZendDebuggerResponseHandler<GetCallStackResponse>(){

                @Override
                public void onSuccessResponse(@NotNull GetCallStackResponse message) {
                    if (message == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    List<GetCallStackResponse.StackFrame> frames = message.getStackFrames();
                    int depth = frames.size();
                    PhpSmartStepIntoState state = debugProcess.getSmartStepIntoState();
                    assert (state != null);
                    state.setInitialDepth(depth);
                    ZendDebuggerDriver.this.startStepInto(connection);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$5", "onSuccessResponse"));
                }
            });
        }
    }

    public static void onSmartStepInto(final @NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, final @NotNull String fileName, final int currentLine) {
        ZendDebuggerConnection connection;
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(26);
        }
        if (fileName == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(27);
        }
        if ((connection = debugProcess.getConnection()) != null) {
            debugProcess.evalString("get_class($this)", new PhpDebugProcess.StringEvaluateCallback(){

                @Override
                public void evaluated(@NotNull String result) {
                    if (result == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    ZendDebuggerDriver.handleSmartStepInto(debugProcess, result, fileName, currentLine, connection);
                }

                @Override
                public void errorOccurred() {
                    ZendDebuggerDriver.handleSmartStepInto(debugProcess, null, fileName, currentLine, connection);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$6", "evaluated"));
                }
            });
        }
    }

    private static void handleSmartStepInto(final @NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, final @Nullable String className, final @NotNull String fileName, final int currentLine, final @NotNull ZendDebuggerConnection connection) {
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(28);
        }
        if (fileName == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(29);
        }
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(30);
        }
        final PhpSmartStepIntoState state = debugProcess.getSmartStepIntoState();
        assert (state != null);
        connection.send(new GetCallStackRequest(), new ZendDebuggerResponseHandler<GetCallStackResponse>(){

            @Override
            public void onSuccessResponse(@NotNull GetCallStackResponse message) {
                if (message == null) {
                    7.$$$reportNull$$$0(0);
                }
                List<GetCallStackResponse.StackFrame> frames = message.getStackFrames();
                assert (!frames.isEmpty());
                int depth = frames.size();
                if (depth > state.getInitialDepth()) {
                    GetCallStackResponse.StackFrame firstFrame = frames.get(frames.size() - 1);
                    String name = firstFrame.getCalledFunctionName();
                    if (state.isTargetFunctionReached(className, name)) {
                        this.stopSmartStepInto(true);
                    } else {
                        connection.send(new StepOutRequest(), null);
                    }
                } else if (state.isOnStartPosition(depth, currentLine)) {
                    connection.send(new StepIntoRequest(), null);
                } else {
                    this.stopSmartStepInto(false);
                }
            }

            private void stopSmartStepInto(boolean functionAchieved) {
                debugProcess.stopSmartStepInto(functionAchieved);
                ZendDebuggerDriver.onReady(debugProcess, fileName, currentLine);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$7", "onSuccessResponse"));
            }
        });
    }

    @Override
    public void startStepOut(@NotNull ZendDebuggerConnection connection) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(31);
        }
        connection.send(new StepOutRequest(), null);
    }

    @Override
    public void resume(@NotNull ZendDebuggerConnection connection) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(32);
        }
        connection.send(new GoRequest(), null);
    }

    @Override
    public void stop(@NotNull ZendDebuggerConnection connection) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(33);
        }
        if (connection.getStatus() == ConnectionStatus.CONNECTED) {
            connection.send(new SessionCloseNotification());
            connection.stop();
        }
    }

    @Override
    public void start(@NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess) {
        ZendDebuggerConnection connection;
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(34);
        }
        if ((connection = debugProcess.getConnection()) == null) {
            return;
        }
        connection.send(new StartRequest(), null);
    }

    public static void onReady(final @NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, final @NotNull String remoteFileName, final int lineNumber) {
        ZendDebuggerConnection connection;
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(35);
        }
        if (remoteFileName == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(36);
        }
        debugProcess.log(PhpBundle.message("debug.log.stop", remoteFileName, lineNumber));
        PhpPathMapper pathMapper = debugProcess.getPathMapper();
        if (pathMapper != null) {
            String localPath = pathMapper.getLocalPath(remoteFileName);
            debugProcess.log(PhpBundle.message("debug.log.path.mapping.remote.local", remoteFileName, localPath));
        }
        if ((connection = debugProcess.getConnection()) == null) {
            return;
        }
        connection.send(new GetCallStackRequest(), new ZendDebuggerResponseHandler<GetCallStackResponse>(){

            @Override
            public void onSuccessResponse(@NotNull GetCallStackResponse message) {
                if (message == null) {
                    8.$$$reportNull$$$0(0);
                }
                List<GetCallStackResponse.StackFrame> stackFrames = message.getStackFrames();
                int stackFramesSize = stackFrames.size();
                assert (stackFramesSize > 0);
                ArrayList<PhpStackFrame> zendStackFrames = new ArrayList<PhpStackFrame>();
                GetCallStackResponse.StackFrame topStackFrame = stackFrames.get(stackFramesSize - 1);
                Runnable reloader = () -> ZendDebuggerDriver.onReady(debugProcess, remoteFileName, lineNumber);
                zendStackFrames.add(new ZendDebuggerStackFrame(debugProcess, 0, stackFramesSize, remoteFileName, lineNumber, topStackFrame.getCalledFunctionName(), topStackFrame.getParameters(), reloader));
                debugProcess.log(PhpBundle.message("debug.log.stack.frame", remoteFileName, lineNumber, topStackFrame.getCalledFunctionName()));
                for (int i = stackFramesSize - 2; i > -1; --i) {
                    GetCallStackResponse.StackFrame stackFrame = stackFrames.get(i + 1);
                    String callerFileName = stackFrame.getCallerFileName();
                    int callerLineNumber = stackFrame.getCallerLineNumber();
                    String callerFunctionName = stackFrame.getCallerFunctionName();
                    int depth = stackFramesSize - i - 1;
                    debugProcess.log(PhpBundle.message("debug.log.stack.frame", callerFileName, callerLineNumber, callerFunctionName));
                    zendStackFrames.add(new ZendDebuggerStackFrame(debugProcess, depth, stackFramesSize, callerFileName, callerLineNumber, callerFunctionName, stackFrames.get(i).getParameters(), reloader));
                }
                debugProcess.onReady(new PhpSuspendContext(zendStackFrames), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$8", "onSuccessResponse"));
            }
        });
    }

    public static void registerErrorOutputHandler(final @NotNull PhpDebugProcess<? extends ZendDebuggerConnection> debugProcess) {
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(37);
        }
        ZendDebuggerConnection connection = debugProcess.getConnection();
        assert (connection != null);
        connection.registerClassHandler(PhpErrorNotification.class, new InputHandler<PhpErrorNotification>(){

            @Override
            public void onResponse(@NotNull PhpErrorNotification message) {
                if (message == null) {
                    9.$$$reportNull$$$0(0);
                }
                String errorText = message.getText();
                String filename = message.getFilename();
                int lineNumber = message.getLineNumber();
                String errorName = ZendDebugUtil.getErrorName(message.getErrorType());
                debugProcess.printErrorOutput(PhpBundle.message("debug.process.console.error.format", errorName, errorText, filename, String.valueOf(lineNumber)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$9", "onResponse"));
            }
        });
    }

    public static void registerOutputHandler(final @NotNull PhpDebugProcess<? extends ZendDebuggerConnection> debugProcess) {
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(38);
        }
        ZendDebuggerConnection connection = debugProcess.getConnection();
        assert (connection != null);
        connection.registerClassHandler(OutputNotification.class, new InputHandler<OutputNotification>(){

            @Override
            public void onResponse(@NotNull OutputNotification message) {
                if (message == null) {
                    10.$$$reportNull$$$0(0);
                }
                debugProcess.printScriptOutput(message.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$10", "onResponse"));
            }
        });
    }

    @Override
    @NotNull
    public PhpDebugPathExtractor createPathFromUrlExtractor() {
        return new ZendDebuggerPathExtractor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFileName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerMethodBreakpoint";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "registerExceptionBreakpoint";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAdditionalActions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHandlers";
                break;
            }
            case 18: 
            case 19: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "registerErrorOutputHandler";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "startStepOver";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "startStepInto";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "startFilteredStepInto";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "startSmartStepInto";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "onSmartStepInto";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "handleSmartStepInto";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "startStepOut";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "resume";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "stop";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "onReady";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "registerOutputHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ZendDebuggerPathExtractor
    implements PhpDebugPathExtractor {
        private ZendDebuggerPathExtractor() {
        }

        @Override
        @NotNull
        public String extractPath(@NotNull String remoteFilePath) {
            if (remoteFilePath == null) {
                ZendDebuggerPathExtractor.$$$reportNull$$$0(0);
            }
            String string = PhpPathMapper.urlToPath(remoteFilePath);
            if (string == null) {
                ZendDebuggerPathExtractor.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteFilePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$ZendDebuggerPathExtractor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$ZendDebuggerPathExtractor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extractPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "extractPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

