/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.install;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.debug.xdebug.install.XdebugDownloader;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a7\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00010\tH\u0002\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0001H\u0002\u00a8\u0006\u0011"}, d2={"getUnzipAndBuildScript", "", "Lcom/jetbrains/php/debug/xdebug/install/XdebugDownloader;", "archivePath", "Ljava/nio/file/Path;", "getXdebugMovementAndConfigUpdateScript", "getInstallationScript", "prepareScript", "scriptGenerator", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "dir", "getScriptPrerequisites", "getInstallationCommands", "getUnzipAndBuildCommands", "getXdebugMovementAndConfigUpdateCommands", "intellij.php.impl"})
public final class XdebugUtilsKt {
    @NotNull
    public static final String getUnzipAndBuildScript(@NotNull XdebugDownloader $this$getUnzipAndBuildScript, @NotNull Path archivePath) {
        Intrinsics.checkNotNullParameter((Object)$this$getUnzipAndBuildScript, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)archivePath, (String)"archivePath");
        return XdebugUtilsKt.prepareScript($this$getUnzipAndBuildScript, archivePath, (Function1<? super String, String>)((Function1)arg_0 -> XdebugUtilsKt.getUnzipAndBuildScript$lambda$0($this$getUnzipAndBuildScript, archivePath, arg_0)));
    }

    @NotNull
    public static final String getXdebugMovementAndConfigUpdateScript(@NotNull XdebugDownloader $this$getXdebugMovementAndConfigUpdateScript, @NotNull Path archivePath) {
        Intrinsics.checkNotNullParameter((Object)$this$getXdebugMovementAndConfigUpdateScript, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)archivePath, (String)"archivePath");
        return XdebugUtilsKt.prepareScript($this$getXdebugMovementAndConfigUpdateScript, archivePath, (Function1<? super String, String>)((Function1)arg_0 -> XdebugUtilsKt.getXdebugMovementAndConfigUpdateScript$lambda$1($this$getXdebugMovementAndConfigUpdateScript, arg_0)));
    }

    @NotNull
    public static final String getInstallationScript(@NotNull XdebugDownloader $this$getInstallationScript, @NotNull Path archivePath) {
        Intrinsics.checkNotNullParameter((Object)$this$getInstallationScript, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)archivePath, (String)"archivePath");
        return XdebugUtilsKt.prepareScript($this$getInstallationScript, archivePath, (Function1<? super String, String>)((Function1)arg_0 -> XdebugUtilsKt.getInstallationScript$lambda$2($this$getInstallationScript, archivePath, arg_0)));
    }

    private static final String prepareScript(XdebugDownloader $this$prepareScript, Path archivePath, Function1<? super String, String> scriptGenerator) {
        String dir = StringsKt.removeSuffix((String)((Object)archivePath.toAbsolutePath()).toString(), (CharSequence)".tgz");
        String script = (String)scriptGenerator.invoke((Object)dir);
        return StringsKt.trimIndent((String)("\n" + XdebugUtilsKt.getScriptPrerequisites(archivePath, dir) + "\n  \n" + script + "\n"));
    }

    private static final String getScriptPrerequisites(Path archivePath, String dir) {
        return StringsKt.trimIndent((String)("\n  #!/bin/bash\n  set -e\n  \n  cleanup() {\n      if [[ -f \"" + archivePath + "\" ]]; then\n          rm -f \"" + archivePath + "\"\n      fi\n      if [[ -d \"" + dir + "\" ]]; then\n          rm -R \"" + dir + "\"\n      fi\n  }\n  \n  trap cleanup SIGINT\n  trap cleanup ERR\n"));
    }

    private static final String getInstallationCommands(XdebugDownloader $this$getInstallationCommands, Path archivePath, String dir) {
        return StringsKt.trimIndent((String)("\n" + XdebugUtilsKt.getUnzipAndBuildCommands($this$getInstallationCommands, archivePath, dir) + "\n  \n" + XdebugUtilsKt.getXdebugMovementAndConfigUpdateCommands($this$getInstallationCommands, dir) + "\n"));
    }

    private static final String getUnzipAndBuildCommands(XdebugDownloader $this$getUnzipAndBuildCommands, Path archivePath, String dir) {
        VirtualFile virtualFile = $this$getUnzipAndBuildCommands.myDownloadedFile;
        Path path = virtualFile != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.toNioPath() : null;
        String string = SystemInfo.isLinux ? "--enable-xdebug " : "";
        String string2 = $this$getUnzipAndBuildCommands.myPhpHomePath;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myPhpHomePath");
        CharSequence charSequence = string2;
        Regex regex = new Regex("php$");
        String string3 = "php-config";
        return StringsKt.trimIndent((String)("\n  ROOT=\"" + path + "\"\n\n  tar -xvzf \"" + archivePath + "\" --directory \"$ROOT\"\n  cd \"" + dir + "\"\n  \n  phpize\n  ./configure " + string + "--with-php-config=" + regex.replaceFirst(charSequence, string3) + "\n  make\n"));
    }

    private static final String getXdebugMovementAndConfigUpdateCommands(XdebugDownloader $this$getXdebugMovementAndConfigUpdateCommands, String dir) {
        return StringsKt.trimIndent((String)("\n  trap cleanup EXIT\n  \n  PATH_TO_XDEBUG_SO=\"" + $this$getXdebugMovementAndConfigUpdateCommands.directory + "\"\n  ZEND_EXTENSION='" + $this$getXdebugMovementAndConfigUpdateCommands.phpIniLine + "'\n  FILE=\"" + $this$getXdebugMovementAndConfigUpdateCommands.phpiniPath + "\"\n\n  sudo mkdir -p \"$PATH_TO_XDEBUG_SO\"\n  \n  if [[ -f \"$PATH_TO_XDEBUG_SO/xdebug.so\" ]]; then\n      sudo rm \"$PATH_TO_XDEBUG_SO/xdebug.so\"\n  fi\n  \n  sudo cp " + dir + "/modules/xdebug.so \"$PATH_TO_XDEBUG_SO\"\n  if [[ ! -f \"${FILE}\" ]]; then\n    sudo touch \"${FILE}\"\n  fi\n  LAST_LINE=$(tail -n 1 \"${FILE}\")\n  if [[ \"$LAST_LINE\" != \"${ZEND_EXTENSION}\" ]]; then\n    echo \"${ZEND_EXTENSION}\" | sudo tee -a \"${FILE}\"\n  fi\n"));
    }

    private static final String getUnzipAndBuildScript$lambda$0(XdebugDownloader $this_getUnzipAndBuildScript, Path $archivePath, String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return XdebugUtilsKt.getUnzipAndBuildCommands($this_getUnzipAndBuildScript, $archivePath, dir);
    }

    private static final String getXdebugMovementAndConfigUpdateScript$lambda$1(XdebugDownloader $this_getXdebugMovementAndConfigUpdateScript, String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return XdebugUtilsKt.getXdebugMovementAndConfigUpdateCommands($this_getXdebugMovementAndConfigUpdateScript, dir);
    }

    private static final String getInstallationScript$lambda$2(XdebugDownloader $this_getInstallationScript, Path $archivePath, String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return XdebugUtilsKt.getInstallationCommands($this_getInstallationScript, $archivePath, dir);
    }
}

