/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.debugger;

import com.intellij.openapi.util.Version;
import com.jetbrains.php.debug.connection.PhpDebugConnectionDetacher;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpStatus;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DetachRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ErrorResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.RunRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StatusResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StopRequest;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugConnectionDetacher
extends PhpDebugConnectionDetacher<XdebugConnection> {
    private final String myReason;

    public XdebugConnectionDetacher(XdebugConnection connection, @Nullable String reason) {
        super(connection);
        this.myReason = reason;
    }

    @Override
    protected void registerHandlers() {
    }

    @Override
    protected void start() {
        Version xdebugVersion = ((XdebugConnection)this.getConnection()).getEngineVersion();
        if (xdebugVersion != null && xdebugVersion.isOrGreaterThan(Integer.valueOf(3))) {
            ((XdebugConnection)this.getConnection()).send(new DetachRequest(this.myReason), new MyStatusResponseHandler());
        } else {
            ((XdebugConnection)this.getConnection()).send(new RunRequest(), new MyStatusResponseHandler());
        }
    }

    private class MyStatusResponseHandler
    extends DbgpResponseHandler<StatusResponse> {
        private MyStatusResponseHandler() {
        }

        @Override
        public void onSuccessResponse(@NotNull StatusResponse message) {
            if (message == null) {
                MyStatusResponseHandler.$$$reportNull$$$0(0);
            }
            DbgpStatus status = message.getStatus();
            ((XdebugConnection)XdebugConnectionDetacher.this.getConnection()).onDebugSessionStatusChanged(status);
            DbgpRequest request = status == DbgpStatus.STOPPING ? new StopRequest() : new RunRequest();
            ((XdebugConnection)XdebugConnectionDetacher.this.getConnection()).send(request, new MyStatusResponseHandler());
        }

        @Override
        public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
            if (errorResponse == null) {
                MyStatusResponseHandler.$$$reportNull$$$0(1);
            }
            ((XdebugConnection)XdebugConnectionDetacher.this.getConnection()).send(new RunRequest(), new MyStatusResponseHandler());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorResponse";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugConnectionDetacher$MyStatusResponseHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSuccessResponse";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onErrorResponse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

