/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.connection;

import com.intellij.openapi.util.Version;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpApplicationDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.connection.InputReader;
import com.jetbrains.php.debug.connection.OutputWriter;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.xdebug.XdebugExtension;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnectionConfigurator;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextNamesRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextNamesResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpOutputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpStatus;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DetachRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ErrorResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.EvalRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.InitNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StatusRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StatusResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StepIntoRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StopRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ValidationResponse;
import com.jetbrains.php.debug.xdebug.debugger.XdebugConnectionDetacher;
import com.jetbrains.php.debug.xdebug.handlers.DbgpBooleanEvalResponseHandler;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import com.jetbrains.php.debug.xdebug.handlers.DbgpStringEvalResponseHadler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugConnection
extends PhpDebugConnection<DbgpInputMessage, DbgpOutputMessage> {
    private static final String CHARSET_ENCODE = "UTF-8";
    protected String mySessionId;
    private String myFileName;
    private Version myEngineVersion;
    @Nullable
    private String myLanguageVersion;
    private DbgpStatus myDebugSessionStatus;
    private final AtomicReference<Map<Integer, String>> myContexts;
    private boolean myToDetach;

    public XdebugConnection(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
        if (inputStream == null) {
            XdebugConnection.$$$reportNull$$$0(0);
        }
        if (outputStream == null) {
            XdebugConnection.$$$reportNull$$$0(1);
        }
        super(inputStream, outputStream);
        this.myDebugSessionStatus = DbgpStatus.STARTING;
        this.myContexts = new AtomicReference<Object>(null);
        this.mySessionId = "";
        this.myFileName = "";
        this.myEngineVersion = null;
    }

    @Override
    public void init() throws IOException {
        DbgpInputMessage message = (DbgpInputMessage)this.myInputReader.read();
        this.logMessage(message, "<-");
        if (message instanceof InitNotification) {
            this.onInitNotification((InitNotification)message);
        }
        if (message instanceof ValidationResponse) {
            this.myOutputWriter.write(new DbgpOutputMessage("Ready"){});
        }
    }

    protected void onInitNotification(@NotNull InitNotification initNotification) {
        if (initNotification == null) {
            XdebugConnection.$$$reportNull$$$0(2);
        }
        this.mySessionId = initNotification.getSessionId();
        this.myFileName = initNotification.getFileUri();
        this.myEngineVersion = Version.parseVersion((String)initNotification.getEngineVersion());
        this.myLanguageVersion = initNotification.getLanguageVersion();
    }

    @Override
    protected boolean isDebugSessionActive() {
        return this.myDebugSessionStatus != DbgpStatus.STOPPING && this.myDebugSessionStatus != DbgpStatus.STOPPED;
    }

    public void onDebugSessionStatusChanged(@NotNull DbgpStatus newStatus) {
        if (newStatus == null) {
            XdebugConnection.$$$reportNull$$$0(3);
        }
        this.myDebugSessionStatus = newStatus;
    }

    @Override
    @Nullable
    public Version getEngineVersion() {
        return this.myEngineVersion;
    }

    @Override
    @Nullable
    public String getPhpVersion() {
        return this.myLanguageVersion;
    }

    @Override
    @NotNull
    public String getSessionId() {
        String string = this.mySessionId;
        if (string == null) {
            XdebugConnection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFilePath() {
        String string = this.myFileName;
        if (string == null) {
            XdebugConnection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getEngineName() {
        String string = XdebugExtension.INSTANCE.getName();
        if (string == null) {
            XdebugConnection.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void loadContextNames(final Consumer<Map<Integer, String>> onContextNamesLoaded) {
        if (this.myContexts.get() == null) {
            this.send(new ContextNamesRequest(), new DbgpResponseHandler<ContextNamesResponse>(){

                @Override
                public void onSuccessResponse(@NotNull ContextNamesResponse message) {
                    if (message == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Map<Integer, String> contexts = message.getContexts();
                    if (XdebugConnection.this.myContexts.get() == null) {
                        XdebugConnection.this.myContexts.compareAndSet(null, contexts);
                    }
                    onContextNamesLoaded.accept(contexts);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$2", "onSuccessResponse"));
                }
            });
        } else {
            onContextNamesLoaded.accept(this.myContexts.get());
        }
    }

    @Override
    public void startDetach(@Nullable String reason) {
        XdebugConnectionDetacher detacher = new XdebugConnectionDetacher(this, reason);
        detacher.init();
    }

    @Override
    public boolean isIncludeReturnValueBreakpointSupported() {
        Version version = this.getEngineVersion();
        return version == null || version.isOrGreaterThan(Integer.valueOf(3), Integer.valueOf(2));
    }

    @Override
    @NotNull
    protected InputReader<DbgpInputMessage> createInputReader(InputStream in) {
        return new MyInputReader(in);
    }

    @Override
    @NotNull
    protected OutputWriter<DbgpOutputMessage> createOutputWriter(OutputStream out) {
        return new MyOutputWriter(out);
    }

    public DbgpRequest<?> createStopRequest() {
        return this.myToDetach ? new DetachRequest() : new StopRequest();
    }

    public void setToDetach(boolean toDetach) {
        this.myToDetach = toDetach;
    }

    public boolean isToDetach() {
        return this.myToDetach;
    }

    @Override
    public void evalBoolean(@NotNull String booleanExpression, @NotNull String encoding, final @NotNull PhpDebugProcess.BooleanEvaluateCallback callback) {
        if (booleanExpression == null) {
            XdebugConnection.$$$reportNull$$$0(7);
        }
        if (encoding == null) {
            XdebugConnection.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(9);
        }
        this.send(new EvalRequest(booleanExpression, encoding), new DbgpBooleanEvalResponseHandler(CHARSET_ENCODE){

            @Override
            public void onEval(boolean value) {
                callback.evaluated(value);
            }

            @Override
            public void onEvalError(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    3.$$$reportNull$$$0(0);
                }
                callback.errorOccurred();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$3", "onEvalError"));
            }
        });
    }

    @Override
    public void evalString(@NotNull String expression, @NotNull String encoding, @NotNull PhpDebugProcess.StringEvaluateCallback callback) {
        if (expression == null) {
            XdebugConnection.$$$reportNull$$$0(10);
        }
        if (encoding == null) {
            XdebugConnection.$$$reportNull$$$0(11);
        }
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(12);
        }
        this.doEvaluate(XdebugConnection.getToStringExpression(expression), encoding, callback);
    }

    public void doEvaluate(String expression, @NotNull String encoding, final @NotNull PhpDebugProcess.StringEvaluateCallback callback) {
        if (encoding == null) {
            XdebugConnection.$$$reportNull$$$0(13);
        }
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(14);
        }
        this.send(new EvalRequest(expression, encoding), new DbgpStringEvalResponseHadler(CHARSET_ENCODE){

            @Override
            public void onEval(@NotNull String value) {
                if (value == null) {
                    4.$$$reportNull$$$0(0);
                }
                callback.evaluated(value);
            }

            @Override
            public void onEvalError(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    4.$$$reportNull$$$0(1);
                }
                callback.errorOccurred();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEval";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEvalError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static String getToStringExpression(@NotNull String expression) {
        if (expression == null) {
            XdebugConnection.$$$reportNull$$$0(15);
        }
        return String.format("(string)(%1$s)", expression);
    }

    @Override
    protected void initialize(@NotNull PhpDebugProcess.InitializeCallback callback, boolean isExternalConnection) {
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(16);
        }
        boolean withResolve = PhpApplicationDebugConfiguration.getInstance().getState().isXdebugResolveBreakpoints();
        XdebugConnectionConfigurator.create(isExternalConnection, withResolve).configure(this, () -> XdebugConnection.checkStatus(this, callback));
    }

    private static void checkStatus(final @NotNull XdebugConnection connection, final @NotNull PhpDebugProcess.InitializeCallback callback) {
        if (connection == null) {
            XdebugConnection.$$$reportNull$$$0(17);
        }
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(18);
        }
        connection.send(new StatusRequest(), new DbgpResponseHandler<StatusResponse>(){

            @Override
            public void onSuccessResponse(@NotNull StatusResponse message) {
                if (message == null) {
                    5.$$$reportNull$$$0(0);
                }
                connection.onDebugSessionStatusChanged(message.getStatus());
                switch (message.getStatus()) {
                    case STARTING: {
                        XdebugConnection.stepInto(connection, callback, false);
                        break;
                    }
                    case BREAK: {
                        XdebugConnection.stepInto(connection, callback, true);
                        break;
                    }
                    default: {
                        callback.errorOccurred(PhpBundle.message("debug.zend.error.title.cannot.accept.external.xdebug.connection", new Object[0]), PhpBundle.message("debug.xdebug.error.unsupported.protocol.version", new Object[0]));
                    }
                }
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    5.$$$reportNull$$$0(1);
                }
                callback.errorOccurred(PhpBundle.message("debug.zend.error.title.cannot.accept.external.xdebug.connection", new Object[0]), PhpBundle.message("debug.xdebug.error.unsupported.protocol.version", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void stepInto(final @NotNull XdebugConnection connection, final @NotNull PhpDebugProcess.InitializeCallback callback, final boolean isJitMode) {
        if (connection == null) {
            XdebugConnection.$$$reportNull$$$0(19);
        }
        if (callback == null) {
            XdebugConnection.$$$reportNull$$$0(20);
        }
        connection.send(new StepIntoRequest(), new DbgpResponseHandler<StatusResponse>(){

            @Override
            public void onSuccessResponse(@NotNull StatusResponse message) {
                if (message == null) {
                    6.$$$reportNull$$$0(0);
                }
                callback.initialized(isJitMode);
                connection.onDebugSessionStatusChanged(message.getStatus());
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    6.$$$reportNull$$$0(1);
                }
                callback.errorOccurred(PhpBundle.message("debug.zend.error.title.cannot.accept.external.xdebug.connection", new Object[0]), PhpBundle.message("debug.xdebug.error.unsupported.protocol.version", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    protected void handleClassCastException(@NotNull ClassCastException e) {
        if (e == null) {
            XdebugConnection.$$$reportNull$$$0(21);
        }
        LOG.error("Can not handle debugger response due to wrong response type.\nPlease, report the issue with attached xdebug log. You can generate it by enabling 'xdebug.remote_log=<path_to_log>' option in php.ini.", (Throwable)e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initNotification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatus";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "booleanExpression";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEngineName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onInitNotification";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onDebugSessionStatusChanged";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "evalBoolean";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "evalString";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getToStringExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkStatus";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "stepInto";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "handleClassCastException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static class MyInputReader
    implements InputReader<DbgpInputMessage> {
        private final InputStream myInputStream;

        public MyInputReader(@NotNull InputStream inputStream) {
            if (inputStream == null) {
                MyInputReader.$$$reportNull$$$0(0);
            }
            this.myInputStream = inputStream;
        }

        @Override
        @NotNull
        public DbgpInputMessage read() throws IOException {
            DbgpInputMessage dbgpInputMessage = DbgpUtil.readMessage(this.myInputStream);
            if (dbgpInputMessage == null) {
                MyInputReader.$$$reportNull$$$0(1);
            }
            return dbgpInputMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputStream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$MyInputReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$MyInputReader";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class MyOutputWriter
    implements OutputWriter<DbgpOutputMessage> {
        private final Writer myWriter;

        public MyOutputWriter(@NotNull OutputStream outputStream) {
            if (outputStream == null) {
                MyOutputWriter.$$$reportNull$$$0(0);
            }
            this.myWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        }

        @Override
        public void write(DbgpOutputMessage output) throws IOException {
            output.serialize(this.myWriter);
            this.myWriter.write(0);
            this.myWriter.flush();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputStream", "com/jetbrains/php/debug/xdebug/connection/XdebugConnection$MyOutputWriter", "<init>"));
        }
    }
}

