/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.jetbrains.php.debug.PhpInlineDebuggerHelper;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebuggerEditorsProvider
extends XDebuggerEditorsProviderBase {
    public static final Key<Boolean> PHP_INTERACTIVE_CONSOLE = Key.create((String)"php-interactive-console");
    public static final Key<Boolean> DEBUG = Key.create((String)"debug");

    @NotNull
    public FileType getFileType() {
        PhpFileType phpFileType = PhpFileType.INSTANCE;
        if (phpFileType == null) {
            PhpDebuggerEditorsProvider.$$$reportNull$$$0(0);
        }
        return phpFileType;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull String text, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            PhpDebuggerEditorsProvider.$$$reportNull$$$0(1);
        }
        if (text == null) {
            PhpDebuggerEditorsProvider.$$$reportNull$$$0(2);
        }
        PhpExpressionCodeFragment fragment = PhpPsiElementFactory.createExpressionCodeFragment(project, text, context, true);
        fragment.getContainingFile().getVirtualFile().putUserData(DEBUG, (Object)true);
        return fragment;
    }

    @Nullable
    public static PsiElement getContextElement(@NotNull Project project, @Nullable XSourcePosition position) {
        VirtualFile contextVirtualFile;
        if (project == null) {
            PhpDebuggerEditorsProvider.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile = contextVirtualFile = position != null ? position.getFile() : null;
        if (contextVirtualFile != null) {
            contextVirtualFile.putUserData(DEBUG, (Object)true);
        }
        int contextOffset = position != null ? position.getOffset() : -1;
        return contextVirtualFile == null || !contextVirtualFile.isValid() ? null : XDebuggerUtil.getInstance().findContextElement(contextVirtualFile, contextOffset, project, false);
    }

    public static boolean isInteractiveConsole(@NotNull VirtualFile file) {
        if (file == null) {
            PhpDebuggerEditorsProvider.$$$reportNull$$$0(4);
        }
        if ("/PHP Console".equals(file.getPath())) {
            return true;
        }
        Boolean data = (Boolean)file.getUserData(PHP_INTERACTIVE_CONSOLE);
        return data != null && data != false;
    }

    @NotNull
    public InlineDebuggerHelper getInlineDebuggerHelper() {
        PhpInlineDebuggerHelper phpInlineDebuggerHelper = PhpInlineDebuggerHelper.INSTANCE;
        if (phpInlineDebuggerHelper == null) {
            PhpDebuggerEditorsProvider.$$$reportNull$$$0(5);
        }
        return phpInlineDebuggerHelper;
    }

    public static boolean isDebugger(VirtualFile file) {
        Boolean data = (Boolean)file.getUserData(DEBUG);
        return data != null && data != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpDebuggerEditorsProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpDebuggerEditorsProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineDebuggerHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionCodeFragment";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContextElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInteractiveConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

