/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.phpInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.config.phpInfo.PhpInfoParser;
import com.jetbrains.php.config.phpInfo.UserPhpInfo;
import com.jetbrains.php.debug.validation.configuration.PhpDebugConfiguration;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class PhpInfoHtmlParser
extends PhpInfoParser {
    @Override
    public UserPhpInfo parse(String text, Project project) {
        Document document = Jsoup.parse((String)text);
        if (document.title().isEmpty()) {
            return null;
        }
        Element body = document.body();
        Elements elements = body.getElementsByClass("e");
        for (Object element : elements) {
            Element sibling;
            Element value;
            if (element.childNodeSize() <= 0) continue;
            String s = element.childNode(0).toString();
            if (this.ZEND_EXTENSION.equals(s)) {
                this.isLoadedByZendExtension = true;
            }
            if (this.LOADED_CONFIGURATION_FILE.equals(s) && (value = element.nextElementSibling()) != null) {
                this.config = value.text();
            }
            if (!this.ADDITIONAL_INI_FILES_PARSED.equals(s) || (sibling = element.nextElementSibling()) == null) continue;
            this.additionalPhpIni = StringUtil.split((String)sibling.text(), (String)",");
        }
        Elements title = body.getElementsByAttributeValue("name", "module_xdebug");
        for (Object element : title) {
            Element sibling;
            Element parent;
            if (!element.text().equals("xdebug") || (parent = ((Element)title.get(0)).parent()) == null || (sibling = parent.nextElementSibling()) == null) continue;
            this.xDebugVersion = ((Element)sibling.getElementsByClass("v").get(0)).text();
        }
        Elements xdebug = body.getElementsContainingOwnText("xdebug");
        for (Element element : xdebug) {
            String s = element.text();
            Element elementSibling = element.nextElementSibling();
            if (elementSibling == null) continue;
            String valueText = elementSibling.text();
            if (XdebugUtil.isAtLeastXdebug3(this.xDebugVersion)) {
                if (this.CLIENT_PORT.equals(s)) {
                    this.port = valueText;
                }
                if (this.CLIENT_HOST.equals(s)) {
                    this.host = valueText;
                }
                if (this.MODE.equals(s)) {
                    this.mode = valueText;
                }
                if (this.LOG.equals(s)) {
                    this.log = valueText;
                }
                if (this.START_WITH_REQUEST.equals(s)) {
                    this.startWithRequest = valueText;
                }
                if (this.START_UPON_ERROR.equals(s)) {
                    this.startUponError = valueText;
                }
                if (this.DISCOVER_CLIENT_HOST.equals(s)) {
                    boolean bl = this.discoverClientHost = !valueText.equals(this.OFF);
                }
                if (this.CLIENT_DISCOVERY_HEADER.equals(s)) {
                    this.clientDiscoveryHeader = valueText;
                }
                if (!this.CLOUD_ID.equals(s) || this.NO_VALUE.equals(valueText)) continue;
                this.cloudUserId = valueText;
                continue;
            }
            if (this.REMOTE_HANDLER.equals(s)) {
                this.protocol = valueText;
            }
            if (this.REMOTE_ENABLE.equals(s)) {
                boolean bl = this.isRemoteEnabled = !this.OFF.equals(valueText);
            }
            if (this.REMOTE_AUTOSTART.equals(s)) {
                boolean bl = this.autostartEnabled = !this.OFF.equals(valueText);
            }
            if (this.REMOTE_HOST.equals(s)) {
                this.host = valueText;
            }
            if (this.REMOTE_PORT.equals(s)) {
                this.port = valueText;
            }
            if (this.REMOTE_MODE.equals(s)) {
                this.mode = valueText;
            }
            if (this.REMOTE_LOG.equals(s)) {
                this.log = valueText;
            }
            if (!this.REMOTE_CONNECT_BACK.equals(s)) continue;
            this.isConnectBack = true;
        }
        PhpDebugConfiguration configuration = this.getConfiguration(this.xDebugVersion, this.isLoadedByZendExtension, this.protocol, this.log, this.host, this.port, this.mode, this.startWithRequest, this.startUponError, this.isConnectBack, this.discoverClientHost, this.isRemoteEnabled, this.autostartEnabled, this.clientDiscoveryHeader, this.cloudUserId, project);
        return new UserPhpInfo(this.config, this.additionalPhpIni, this.xDebugVersion, configuration);
    }
}

