/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorageKt;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.library.PhpLibraryRoot;
import com.jetbrains.php.config.library.PhpLibraryRootEntity;
import com.jetbrains.php.config.library.PhpLibraryRootSource;
import com.jetbrains.php.config.library.PhpRuntimeExtensionsEntity;
import java.util.List;
import kotlin.Unit;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhpLibraryRootUtil {
    private static final EntitySource ENTITY_SOURCE = new PhpLibraryRootSource();

    private PhpLibraryRootUtil() {
    }

    static void registerPhpNonRuntimeRoots(@NotNull Project project) {
        if (project == null) {
            PhpLibraryRootUtil.$$$reportNull$$$0(0);
        }
        ImmutableEntityStorage originalStorage = WorkspaceModel.getInstance((Project)project).getCurrentSnapshot();
        MutableEntityStorage builder2 = EntityStorageKt.toBuilder((ImmutableEntityStorage)originalStorage);
        List oldEntities = SequencesKt.toMutableList((Sequence)builder2.entities(PhpLibraryRootEntity.class));
        boolean changed = false;
        VirtualFileUrlManager manager = WorkspaceModel.getInstance((Project)project).getVirtualFileUrlManager();
        for (PhpLibraryRoot root : PhpLibraryRoot.EP_NAME.getExtensionList()) {
            if (root.runtime || root.implementationClass != null) continue;
            List<VirtualFileUrl> urls = root.getPathBasedLibraryRoots().map(file -> manager.getOrCreateFromUrl(file.getUrl())).toList();
            PhpLibraryRootEntity oldEntity = (PhpLibraryRootEntity)ContainerUtil.find((Iterable)oldEntities, entity -> entity.getRoots().equals(urls));
            if (oldEntity == null) {
                PhpLibraryRootEntity.Builder entity2 = PhpLibraryRootEntity.create(urls, ENTITY_SOURCE);
                builder2.addEntity((WorkspaceEntity.Builder)entity2);
                changed = true;
                continue;
            }
            oldEntities.remove(oldEntity);
        }
        for (PhpLibraryRootEntity entity3 : oldEntities) {
            builder2.removeEntity((WorkspaceEntity)entity3);
            changed = true;
        }
        if (!changed) {
            return;
        }
        PhpLibraryRootUtil.commitBuilder(project, builder2, null);
    }

    private static void commitBuilder(@NotNull Project project, MutableEntityStorage builder2, @Nullable Runnable onCommittingChange) {
        if (project == null) {
            PhpLibraryRootUtil.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> {
            WorkspaceModel.getInstance((Project)project).updateProjectModel("PhpLibraryRootUtil", tempBuilder -> {
                tempBuilder.applyChangesFrom(builder2);
                return Unit.INSTANCE;
            });
            if (onCommittingChange != null) {
                onCommittingChange.run();
            }
        }));
    }

    static void registerRuntimeRoots(@NotNull Project project, @NotNull List<VirtualFile> roots, @Nullable Runnable onCommittingChange) {
        if (project == null) {
            PhpLibraryRootUtil.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            PhpLibraryRootUtil.$$$reportNull$$$0(3);
        }
        ImmutableEntityStorage originalStorage = WorkspaceModel.getInstance((Project)project).getCurrentSnapshot();
        List oldEntities = SequencesKt.toList((Sequence)originalStorage.entities(PhpRuntimeExtensionsEntity.class));
        if (roots.isEmpty() && oldEntities.isEmpty()) {
            return;
        }
        MutableEntityStorage builder2 = EntityStorageKt.toBuilder((ImmutableEntityStorage)originalStorage);
        if (roots.isEmpty()) {
            for (PhpRuntimeExtensionsEntity entity : oldEntities) {
                builder2.removeEntity((WorkspaceEntity)entity);
            }
            PhpLibraryRootUtil.commitBuilder(project, builder2, onCommittingChange);
            return;
        }
        VirtualFileUrlManager manager = WorkspaceModel.getInstance((Project)project).getVirtualFileUrlManager();
        List urls = ContainerUtil.map(roots, file -> manager.getOrCreateFromUrl(file.getUrl()));
        if (oldEntities.size() == 1 && ((PhpRuntimeExtensionsEntity)oldEntities.get(0)).getRoots().equals(urls)) {
            return;
        }
        for (PhpRuntimeExtensionsEntity entity : oldEntities) {
            builder2.removeEntity((WorkspaceEntity)entity);
        }
        PhpRuntimeExtensionsEntity.Builder entity = PhpRuntimeExtensionsEntity.create(urls, ENTITY_SOURCE);
        builder2.addEntity((WorkspaceEntity.Builder)entity);
        PhpLibraryRootUtil.commitBuilder(project, builder2, onCommittingChange);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/config/library/PhpLibraryRootUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerPhpNonRuntimeRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "commitBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerRuntimeRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

