/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters.herd;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.herd.PhpMacosHerdInterpretersManager;
import com.jetbrains.php.config.interpreters.herd.PhpWindowsHerdInterpretersManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u0082\u0001\u0002\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/php/config/interpreters/herd/PhpHerdInterpretersManager;", "", "<init>", "()V", "herdDirectory", "", "getHerdDirectory", "()Ljava/lang/String;", "herdXdebugDirectory", "getHerdXdebugDirectory", "mainInterpreterName", "getMainInterpreterName", "isValidPhpBinary", "", "path", "Ljava/nio/file/Path;", "isLaravelHerdInterpreter", "interpreter", "Lcom/jetbrains/php/config/interpreters/PhpInterpreter;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isMainLaravelHerdInterpreter", "Companion", "Lcom/jetbrains/php/config/interpreters/herd/PhpMacosHerdInterpretersManager;", "Lcom/jetbrains/php/config/interpreters/herd/PhpWindowsHerdInterpretersManager;", "intellij.php.impl"})
public abstract class PhpHerdInterpretersManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private PhpHerdInterpretersManager() {
    }

    @NotNull
    public abstract String getHerdDirectory();

    @NotNull
    public abstract String getHerdXdebugDirectory();

    @NotNull
    public abstract String getMainInterpreterName();

    public abstract boolean isValidPhpBinary(@NotNull Path var1);

    public abstract boolean isLaravelHerdInterpreter(@NotNull PhpInterpreter var1);

    public final boolean isLaravelHerdInterpreter(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.startsWith$default((String)string, (String)this.getHerdDirectory(), (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMainLaravelHerdInterpreter(@NotNull PhpInterpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        if (!this.isLaravelHerdInterpreter(interpreter)) return false;
        String string = interpreter.getHomePath();
        if (string == null) return false;
        if (!StringsKt.endsWith$default((String)string, (String)this.getMainInterpreterName(), (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMainLaravelHerdInterpreter(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.isLaravelHerdInterpreter(file)) return false;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!StringsKt.endsWith$default((String)string, (String)this.getMainInterpreterName(), (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    @NotNull
    public static final PhpHerdInterpretersManager getInstance() {
        return Companion.getInstance();
    }

    public /* synthetic */ PhpHerdInterpretersManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/php/config/interpreters/herd/PhpHerdInterpretersManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/php/config/interpreters/herd/PhpHerdInterpretersManager;", "intellij.php.impl"})
    @SourceDebugExtension(value={"SMAP\nPhpHerdInterpretersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpHerdInterpretersManager.kt\ncom/jetbrains/php/config/interpreters/herd/PhpHerdInterpretersManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,77:1\n40#2,3:78\n40#2,3:81\n*S KotlinDebug\n*F\n+ 1 PhpHerdInterpretersManager.kt\ncom/jetbrains/php/config/interpreters/herd/PhpHerdInterpretersManager$Companion\n*L\n21#1:78,3\n24#1:81,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PhpHerdInterpretersManager getInstance() {
            PhpHerdInterpretersManager phpHerdInterpretersManager;
            if (SystemInfo.isWindows) {
                boolean $i$f$service = false;
                Class<PhpWindowsHerdInterpretersManager> serviceClass$iv = PhpWindowsHerdInterpretersManager.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                phpHerdInterpretersManager = (PhpHerdInterpretersManager)object;
            } else {
                boolean $i$f$service = false;
                Class<PhpMacosHerdInterpretersManager> serviceClass$iv = PhpMacosHerdInterpretersManager.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                phpHerdInterpretersManager = (PhpHerdInterpretersManager)object;
            }
            return phpHerdInterpretersManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

