/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigurable;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.json.PhpComposerJsonUtils;
import com.jetbrains.php.composer.json.cache.ComposerPackagesCacheStatusProvider;
import com.jetbrains.php.ui.PhpUiUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerCustomReposLineMarkerProvider
implements LineMarkerProvider {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            ComposerCustomReposLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof LeafPsiElement)) {
            return null;
        }
        if (!PhpComposerJsonUtils.insideComposerJson((PsiElement)element.getContainingFile()) || !PhpComposerJsonUtils.insideSection(element, "repositories")) {
            return null;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)StringUtilRt.unquoteString((String)element.getText()), (CharSequence)"repositories")) {
            ComposerDataService instance = ComposerDataService.getInstance(element.getProject());
            if (!instance.isConfigWellConfigured()) {
                return ComposerCustomReposLineMarkerProvider.getInfo(element, AllIcons.General.BalloonWarning12, PhpBundle.message("composer.json.path.not.configured", new Object[0]), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)(e, elt) -> ComposerLogMessageBuilder.Settings.COMPOSER.show(elt.getProject())));
            }
            if (!instance.isExecutionWellConfigured(true)) {
                return ComposerCustomReposLineMarkerProvider.getInfo(element, AllIcons.General.BalloonWarning12, PhpBundle.message("composer.json.exec.not.configured", new Object[0]), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)(e, elt) -> PhpUiUtil.editConfigurable(elt.getProject(), (Configurable)new ComposerConfigurable(elt.getProject(), true, false))));
            }
            ComposerPackagesCacheStatusProvider.Status status = ComposerPackagesCacheStatusProvider.getInstance().getStatus();
            return switch (status) {
                default -> throw new IncompatibleClassChangeError();
                case ComposerPackagesCacheStatusProvider.Status.EMPTY -> ComposerCustomReposLineMarkerProvider.getInfo(element, AllIcons.General.BalloonWarning12, PhpBundle.message("composer.json.custom.packages.empty", new Object[0]));
                case ComposerPackagesCacheStatusProvider.Status.INVALID_JSON -> ComposerCustomReposLineMarkerProvider.getInfo(element, AllIcons.Actions.Pause, PhpBundle.message("composer.json.custom.invalid.json", new Object[0]));
                case ComposerPackagesCacheStatusProvider.Status.COMPOSER -> ComposerCustomReposLineMarkerProvider.getInfo(element, AllIcons.Actions.Checked, PhpBundle.message("composer.json.custom.packages.done", new Object[0]));
                case ComposerPackagesCacheStatusProvider.Status.PACKAGIST -> ComposerCustomReposLineMarkerProvider.getInfo(element, AllIcons.General.BalloonWarning12, PhpBundle.message("composer.json.packagist.packages.done", new Object[0]));
                case ComposerPackagesCacheStatusProvider.Status.REUSED -> ComposerCustomReposLineMarkerProvider.getInfo(element, AllIcons.General.BalloonWarning12, PhpBundle.message("composer.json.packagist.packages.reused", new Object[0]));
                case ComposerPackagesCacheStatusProvider.Status.NOT_DEFINED -> ComposerCustomReposLineMarkerProvider.getInfo(element, AllIcons.General.BalloonWarning12, PhpBundle.message("composer.json.packages.loading.error", new Object[0]));
                case ComposerPackagesCacheStatusProvider.Status.REFRESHING -> ComposerCustomReposLineMarkerProvider.getInfo(element, AllIcons.General.Ellipsis, PhpBundle.message("composer.json.packages.refresh", new Object[0]));
            };
        }
        return null;
    }

    @NotNull
    private static @NotNull LineMarkerInfo<@NotNull PsiElement> getInfo(@NotNull PsiElement element, @NotNull Icon icon, @NotNull String message) {
        if (element == null) {
            ComposerCustomReposLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            ComposerCustomReposLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (message == null) {
            ComposerCustomReposLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return ComposerCustomReposLineMarkerProvider.getInfo(element, icon, message, null);
    }

    @NotNull
    private static @NotNull LineMarkerInfo<@NotNull PsiElement> getInfo(@NotNull PsiElement element, @NotNull Icon icon, @NotNull String message, @Nullable GutterIconNavigationHandler<PsiElement> navHandler) {
        if (element == null) {
            ComposerCustomReposLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (icon == null) {
            ComposerCustomReposLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (message == null) {
            ComposerCustomReposLineMarkerProvider.$$$reportNull$$$0(6);
        }
        return new LineMarkerInfo(element, element.getTextRange(), icon, s -> message, navHandler, GutterIconRenderer.Alignment.CENTER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/json/ComposerCustomReposLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

