/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.addDependency;

import com.intellij.ide.DataManager;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.addDependency.AddDependencyDialog;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ComposerAddDependencyAction
extends ComposerAbstractAction {
    @NonNls
    public static final String ID = "ComposerAddDependencyAction";

    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerAddDependencyAction.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            ComposerAddDependencyAction.$$$reportNull$$$0(1);
        }
        if (placeForStatistics == null) {
            ComposerAddDependencyAction.$$$reportNull$$$0(2);
        }
        ComposerActionStatistics.reportAction(ComposerActionStatistics.Action.ADD_DEPENDENCY_DIALOG_SHOWN, placeForStatistics, project);
        ComposerAddDependencyAction.refreshConfigAndLockFiles(configFile, () -> ApplicationManager.getApplication().invokeLater(() -> {
            boolean showDependencyDialog = Registry.is((String)"php.show.composer.dependency.dialog", (boolean)true);
            if (showDependencyDialog) {
                new AddDependencyDialog(project, configFile, ComposerConfigUtils.getInstalledPackagesFromConfig(configFile)).show();
            } else {
                Document document = FileDocumentManager.getInstance().getDocument(configFile);
                FileEditorManager fileManager = FileEditorManager.getInstance((Project)project);
                if (fileManager != null && document != null) {
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, configFile);
                    Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
                    if (editor != null) {
                        CommandProcessor.getInstance().runUndoTransparentAction(() -> ComposerAddDependencyAction.findPackageAndComplete(project, configFile, document, fileManager, editor));
                    }
                }
            }
            ComposerAddDependencyAction.refreshConfigAndLockFiles(configFile, () -> ComposerUtils.refreshVendorDir(configFile));
        }));
    }

    @Override
    public String getCommand() {
        return null;
    }

    private static void findPackageAndComplete(@NotNull Project project, @NotNull VirtualFile configFile, Document document, FileEditorManager fileManager, Editor editor) {
        JsonProperty require;
        JsonObject value;
        JsonObject topLevelObject;
        PsiFile file;
        if (project == null) {
            ComposerAddDependencyAction.$$$reportNull$$$0(3);
        }
        if (configFile == null) {
            ComposerAddDependencyAction.$$$reportNull$$$0(4);
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) instanceof JsonFile && (topLevelObject = JsonUtil.getTopLevelObject((JsonFile)((JsonFile)file))) != null && (value = (JsonObject)(require = ComposerAddDependencyAction.findOrCreateProperty(project, topLevelObject, "require", "{}")).getValue()) != null) {
            AnAction completionAction;
            JsonProperty property = ComposerAddDependencyAction.findOrCreateProperty(project, value, "", "\"\"");
            fileManager.openFile(configFile, true);
            editor.getCaretModel().moveToOffset(property.getNameElement().getTextRange().getStartOffset() + 1);
            SelectionModel model = editor.getSelectionModel();
            if (model.hasSelection()) {
                model.removeSelection();
            }
            if ((completionAction = ActionManager.getInstance().getAction("CodeCompletion")) != null) {
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> ApplicationManager.getApplication().invokeLater(() -> completionAction.actionPerformed(new AnActionEvent(null, context, "composer.json", new Presentation(), ActionManager.getInstance(), 0)), ModalityState.nonModal()));
            }
        }
    }

    private static JsonProperty findOrCreateProperty(@NotNull Project project, JsonObject jsonObject, String propertyName, String propertyValue) {
        if (project == null) {
            ComposerAddDependencyAction.$$$reportNull$$$0(5);
        }
        return (JsonProperty)WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            JsonProperty property = jsonObject.findProperty(propertyName);
            if (property != null) {
                return property;
            }
            JsonElementGenerator generator = new JsonElementGenerator(project);
            property = generator.createProperty(propertyName, propertyValue);
            List list = jsonObject.getPropertyList();
            if (list.isEmpty()) {
                JsonObject newTopLevelObject = (JsonObject)jsonObject.replace((PsiElement)generator.createObject(property.getText()));
                return newTopLevelObject.findProperty(propertyName);
            }
            PsiElement comma = jsonObject.addAfter(generator.createComma(), (PsiElement)ContainerUtil.getLastItem((List)list));
            return (JsonProperty)jsonObject.addAfter((PsiElement)property, comma);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/addDependency/ComposerAddDependencyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doPerformAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findPackageAndComplete";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrCreateProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

