/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.log;

import com.intellij.execution.ExecutionException;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.log.ComposerLogConsoleView;
import com.jetbrains.php.composer.actions.log.ComposerLogConsoleViewInterface;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerLogService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ComposerLogService.class);
    @NotNull
    private final Project myProject;
    private ComposerLogConsoleView myConsoleView;
    private final Map<String, ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException>> myRerunMap;
    public static final char AI_ASSISTANT_SUFFIX = '\u2007';

    public ComposerLogService(@NotNull Project project) {
        if (project == null) {
            ComposerLogService.$$$reportNull$$$0(0);
        }
        this.myRerunMap = new HashMap<String, ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException>>();
        this.myProject = project;
    }

    @NotNull
    public static ComposerLogService getInstance(@NotNull Project project) {
        if (project == null) {
            ComposerLogService.$$$reportNull$$$0(1);
        }
        ComposerLogService composerLogService = (ComposerLogService)project.getService(ComposerLogService.class);
        if (composerLogService == null) {
            ComposerLogService.$$$reportNull$$$0(2);
        }
        return composerLogService;
    }

    @NotNull
    public synchronized ComposerLogConsoleView getConsoleView() {
        if (this.myConsoleView == null) {
            this.myConsoleView = (ComposerLogConsoleView)ReadAction.compute(() -> new ComposerLogConsoleView(this.myProject));
        }
        ComposerLogConsoleView composerLogConsoleView = this.myConsoleView;
        if (composerLogConsoleView == null) {
            ComposerLogService.$$$reportNull$$$0(3);
        }
        return composerLogConsoleView;
    }

    public void report(String message, @Nullable ComposerLogMessageBuilder.Settings settings) {
        this.report(message, settings, true, null, false);
    }

    public void report(String message, @Nullable ComposerLogMessageBuilder.Settings settings, boolean success, NotificationType notificationType, boolean showInEventLog) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.getConsoleView().attachMessageBuilder(null, settings, ModalityState.defaultModalityState()).printSummary(message, success, showInEventLog, notificationType, this.myProject));
    }

    public void putRerunData(@NotNull MessageId id, @NotNull ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> generator) {
        if (id == null) {
            ComposerLogService.$$$reportNull$$$0(4);
        }
        if (generator == null) {
            ComposerLogService.$$$reportNull$$$0(5);
        }
        this.myRerunMap.put(id.getTextPartWithPrefix(), generator);
    }

    @Nullable
    public ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutor(String idText) {
        return this.myRerunMap.get(idText);
    }

    void cleanRerunMap(String id) {
        ApplicationManager.getApplication().invokeLater(() -> this.myRerunMap.keySet().removeIf(cachedId -> MessageId.isLess(cachedId, id)));
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/log/ComposerLogService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/log/ComposerLogService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putRerunData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static final class MessageId {
        private static final char[] ID_SYMBOLS = new char[]{'\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006'};
        private final char @NotNull [] id;
        public static final Regex ID_SYMBOLS_REGEX = new Regex("[" + new String(ID_SYMBOLS) + "\u2007]");

        public static MessageId getFirst() {
            return new MessageId(new char[]{ID_SYMBOLS[ID_SYMBOLS.length - 1]});
        }

        private MessageId(char @NotNull [] id) {
            if (id == null) {
                MessageId.$$$reportNull$$$0(0);
            }
            this.id = id;
        }

        public String getTextPart() {
            return new String(this.id);
        }

        public String getTextPartWithPrefix() {
            return ComposerLogConsoleViewInterface.MessagePart.ID.getPrefix() + this.getTextPart();
        }

        public MessageId getNextId() {
            if (this.id[0] != ID_SYMBOLS[0]) {
                for (int i = 1; i < ID_SYMBOLS.length; ++i) {
                    char symbol = ID_SYMBOLS[i];
                    if (symbol != this.id[0]) continue;
                    char[] result = new char[this.id.length];
                    System.arraycopy(this.id, 1, result, 1, this.id.length - 1);
                    result[0] = ID_SYMBOLS[i - 1];
                    return new MessageId(result);
                }
                LOG.error("Unexpected char " + Character.getName(this.id[0]) + " not found");
                return null;
            }
            char[] result = new char[this.id.length + 1];
            System.arraycopy(this.id, 0, result, 1, this.id.length);
            result[0] = ID_SYMBOLS[ID_SYMBOLS.length - 1];
            return new MessageId(result);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageId id1 = (MessageId)o;
            return Arrays.equals(this.id, id1.id);
        }

        public static boolean isLess(String lesser, String bigger) {
            if (lesser.length() != bigger.length()) {
                return lesser.length() < bigger.length();
            }
            for (int i = 0; i < lesser.length(); ++i) {
                int biggerIndex;
                char biggerChar;
                char lesserChar = lesser.charAt(i);
                if (lesserChar == (biggerChar = bigger.charAt(i))) continue;
                int lesserIndex = Arrays.binarySearch(ID_SYMBOLS, lesserChar);
                return lesserIndex > (biggerIndex = Arrays.binarySearch(ID_SYMBOLS, biggerChar));
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.id);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/php/composer/actions/log/ComposerLogService$MessageId", "<init>"));
        }
    }
}

