/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigurable;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerSettingSyncConfigClient;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ComposerDetectionManager {
    private ComposerDetectionManager() {
    }

    @Nullable
    public static ComposerConfigs detectComposer(Project project) {
        if (project == null || project.isDefault()) {
            return null;
        }
        if (ComposerConfigManager.getInstance(project).isConfigured()) {
            return null;
        }
        VirtualFile mainComposerJson = ComposerDetectionManager.findMainConfig(project);
        if (mainComposerJson == null) {
            return null;
        }
        Collection<VirtualFile> subProjectConfigs = ComposerDetectionManager.findSubProjectConfigs(project, mainComposerJson);
        return new ComposerConfigs(mainComposerJson, subProjectConfigs);
    }

    public static void updateProjectSettings(@NotNull Project project, @Nullable ComposerConfigs composerConfigs) {
        if (project == null) {
            ComposerDetectionManager.$$$reportNull$$$0(0);
        }
        ComposerConfigManager configManager = ComposerConfigManager.getInstance(project);
        ComposerDataService dataService = ComposerDataService.getInstance(project);
        if (composerConfigs == null) {
            if (configManager.getMainConfig() != null) {
                dataService.setDoNotAskAgain(true);
            }
            return;
        }
        if (composerConfigs.subProjects.isEmpty() && (configManager.getMainConfig() != null || dataService.doNotAskAgain())) {
            return;
        }
        ComposerDataService.SynchronizationState syncState = dataService.getSynchronizationState();
        boolean updateLibrary = dataService.isUpdateLibrary();
        boolean isMainConfigUpdated = !composerConfigs.main.equals(configManager.getMainConfig());
        boolean isDefaultAllSettings = ComposerSettingSyncConfigClient.isDefaultAllSettings(project);
        dataService.setConfigPathAndLibraryUpdateStatus(composerConfigs.main().getPath(), true);
        for (VirtualFile config : composerConfigs.subProjects) {
            configManager.addConfig(config);
            ComposerLibraryService libraryManager = ComposerLibraryServiceFactory.getInstance(project, config);
            libraryManager.reloadLibraries(true, Collections.emptySet(), false, true);
        }
        if (isDefaultAllSettings) {
            dataService.setSynchronizationState(ComposerDataService.SynchronizationState.SYNCHRONIZE);
        }
        ComposerDetectionManager.showNotification(project, composerConfigs, syncState, updateLibrary, isMainConfigUpdated);
    }

    private static void showNotification(final @NotNull Project project, final @NotNull ComposerConfigs composerConfigs, final @NotNull ComposerDataService.SynchronizationState oldSyncState, final boolean oldUpdateLibrary, final boolean isMainConfigUpdated) {
        if (project == null) {
            ComposerDetectionManager.$$$reportNull$$$0(1);
        }
        if (composerConfigs == null) {
            ComposerDetectionManager.$$$reportNull$$$0(2);
        }
        if (oldSyncState == null) {
            ComposerDetectionManager.$$$reportNull$$$0(3);
        }
        final Notification notification = new Notification(ComposerUtils.getComposerGroupDisplayId(), PhpBundle.message("framework.composer", new Object[0]), ComposerDetectionManager.getMessage(project, composerConfigs), NotificationType.INFORMATION);
        DumbAwareAction showSettingsAction = new DumbAwareAction(PhpBundle.message("show.composer.settings.action.name", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                notification.expire();
                ComposerConfigurable configurable = new ComposerConfigurable(project, false, true);
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerDetectionManager$1", "actionPerformed"));
            }
        };
        DumbAwareAction revertAction = new DumbAwareAction(PhpBundle.message("composer.revert.action.name", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ComposerDataService dataService = ComposerDataService.getInstance(project);
                if (isMainConfigUpdated) {
                    dataService.setDoNotAskAgain(true);
                }
                ComposerConfigManager configManager = ComposerConfigManager.getInstance(project);
                configManager.setNotifyAboutSettingsSync(false);
                notification.expire();
                if (isMainConfigUpdated) {
                    dataService.setConfigPathAndLibraryUpdateStatus(null, oldUpdateLibrary);
                    dataService.setSynchronizationState(oldSyncState);
                }
                for (VirtualFile subProject : composerConfigs.subProjects) {
                    configManager.removeConfig(subProject.getPath());
                    ComposerLibraryServiceFactory.remove(project, subProject.getPath());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerDetectionManager$2", "actionPerformed"));
            }
        };
        notification.addAction((AnAction)showSettingsAction);
        notification.addAction((AnAction)revertAction);
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    @NlsSafe
    @NotNull
    private static String getMessage(Project project, ComposerConfigs composerConfigs) {
        if (!composerConfigs.subProjects.isEmpty()) {
            String string = PhpBundle.message("framework.composer.initialize.popup.multi.composer", composerConfigs.subProjects.size() + 1);
            if (string == null) {
                ComposerDetectionManager.$$$reportNull$$$0(4);
            }
            return string;
        }
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        String mainPath = projectDir != null ? VfsUtilCore.getRelativePath((VirtualFile)composerConfigs.main, (VirtualFile)projectDir) : composerConfigs.main.getPath();
        String string = PhpBundle.message("framework.composer.initialize.popup", mainPath);
        if (string == null) {
            ComposerDetectionManager.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static @Unmodifiable Collection<VirtualFile> findSubProjectConfigs(@NotNull Project project, @NotNull VirtualFile mainConfig) {
        VirtualFile baseDir;
        if (project == null) {
            ComposerDetectionManager.$$$reportNull$$$0(6);
        }
        if (mainConfig == null) {
            ComposerDetectionManager.$$$reportNull$$$0(7);
        }
        if ((baseDir = ProjectUtil.guessProjectDir((Project)project)) == null) {
            return Collections.emptyList();
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        Collection configs = FilenameIndex.getVirtualFilesByName((String)"composer.json", (GlobalSearchScope)scope);
        return ContainerUtil.filter((Collection)configs, c -> !c.equals(mainConfig) && !c.isDirectory() && !c.getPath().contains("/vendor/"));
    }

    @Nullable
    private static VirtualFile findMainConfig(@NotNull Project project) {
        VirtualFile baseDir;
        if (project == null) {
            ComposerDetectionManager.$$$reportNull$$$0(8);
        }
        if ((baseDir = ProjectUtil.guessProjectDir((Project)project)) == null) {
            return null;
        }
        VirtualFile composerJson = ComposerDetectionManager.findConfig(baseDir);
        if (composerJson != null) {
            return composerJson;
        }
        for (VirtualFile file : baseDir.getChildren()) {
            if (!file.isDirectory() || (composerJson = ComposerDetectionManager.findConfig(file)) == null) continue;
            return composerJson;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findConfig(@NotNull VirtualFile dir) {
        if (dir == null) {
            ComposerDetectionManager.$$$reportNull$$$0(9);
        }
        return dir.findChild("composer.json");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerConfigs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldSyncState";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerDetectionManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainConfig";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerDetectionManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSubProjectConfigs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findMainConfig";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    public record ComposerConfigs(@NotNull VirtualFile main, @NotNull Collection<VirtualFile> subProjects) {
        @NotNull
        private final VirtualFile main;
        @NotNull
        private final Collection<VirtualFile> subProjects;

        public ComposerConfigs(@NotNull VirtualFile main, @NotNull Collection<VirtualFile> subProjects) {
            if (main == null) {
                ComposerConfigs.$$$reportNull$$$0(0);
            }
            if (subProjects == null) {
                ComposerConfigs.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public VirtualFile main() {
            VirtualFile virtualFile = this.main;
            if (virtualFile == null) {
                ComposerConfigs.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @NotNull
        public Collection<VirtualFile> subProjects() {
            Collection<VirtualFile> collection = this.subProjects;
            if (collection == null) {
                ComposerConfigs.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "main";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subProjects";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/ComposerDetectionManager$ComposerConfigs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/ComposerDetectionManager$ComposerConfigs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "main";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subProjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

