/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerProjectSettings;
import com.jetbrains.php.composer.addDependency.AddDependencySettingsPanel;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.json.PhpComposerJsonCompletionContributor;
import com.jetbrains.php.composer.json.cache.ComposerPackagesCache;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerCreateProjectForm {
    private JPanel myMainPanel;
    private AddDependencySettingsPanel myAddDependencySettingsPanel;
    private TextFieldWithCompletion myPackageTextField;
    private ComboBox<String> myVersionComboBox;
    private JPanel myPackagePanel;
    private final List<WebProjectGenerator.SettingsStateListener> myStateListeners;

    public ComposerCreateProjectForm() {
        this.$$$setupUI$$$();
        this.myStateListeners = new ArrayList<WebProjectGenerator.SettingsStateListener>();
        this.fireStateChanged();
        this.myMainPanel.setLayout((LayoutManager)new VerticalFlowLayout());
        this.myPackagePanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("composer.label.package", new Object[0])));
        this.myVersionComboBox.setEnabled(false);
        this.myAddDependencySettingsPanel.resetOrGuessDefaults();
    }

    private void createUIComponents() {
        Runnable consumer = () -> this.fireStateChanged();
        DialogWrapper dialogWrapper = DialogWrapper.findInstanceFromFocus();
        Application disposable = dialogWrapper == null ? ApplicationManager.getApplication() : dialogWrapper.getDisposable();
        this.myAddDependencySettingsPanel = new AddDependencySettingsPanel(consumer, ProjectManager.getInstance().getDefaultProject(), (Disposable)disposable);
        this.myPackageTextField = new TextFieldWithCompletion(ProjectManager.getInstance().getDefaultProject(), ComposerCreateProjectForm.createPackageCompletionProvider(), "", true, true, true);
        this.myPackageTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                String text = event.getDocument().getText();
                if (!ComposerPackagesCache.getPackageNames().contains(text)) {
                    ComposerCreateProjectForm.this.myVersionComboBox.setEnabled(false);
                } else {
                    ComposerCreateProjectForm.this.myVersionComboBox.removeAllItems();
                    ComposerCreateProjectForm.getPackageVersions(text).forEach(element -> ComposerCreateProjectForm.this.myVersionComboBox.addItem(element));
                    ComposerCreateProjectForm.this.myVersionComboBox.setEnabled(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/composer/ComposerCreateProjectForm$1", "documentChanged"));
            }
        });
    }

    @NotNull
    public static List<String> getPackageVersions(String packageName) {
        List versions = ContainerUtil.sorted(PhpComposerJsonCompletionContributor.PhpComposerPackageVersionsProvider.fetchPackageVersions(packageName), ComposerPackage.VERSIONS_COMPARATOR);
        List list = ContainerUtil.prepend((List)versions, (Object[])new String[]{ComposerPackage.getDefaultVersion()});
        if (list == null) {
            ComposerCreateProjectForm.$$$reportNull$$$0(0);
        }
        return list;
    }

    public static TextCompletionProvider createPackageCompletionProvider() {
        return new TextFieldCompletionProvider(){

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                ArrayList<String> packages = new ArrayList<String>(ComposerPackagesCache.getPackageNames());
                packages.forEach(packageName -> result.addElement(LookupElementBuilder.create((Object)new ComposerPackage((String)packageName), (String)packageName).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/composer/ComposerCreateProjectForm$2";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public JComponent getContentPane() {
        return this.myMainPanel;
    }

    @Nullable
    public ValidationInfo validate() {
        ValidationInfo info = this.myAddDependencySettingsPanel.validate();
        if (info != null) {
            return info;
        }
        String value = this.myPackageTextField.getText();
        if (StringUtil.isEmpty((String)value)) {
            return new ValidationInfo(PhpBundle.message("framework.composer.add.dependency.no.package.selected", new Object[0]), (JComponent)this.myPackageTextField);
        }
        if (!ComposerPackagesCache.getPackageNames().contains(value)) {
            return new ValidationInfo(PhpBundle.message("framework.composer.add.dependency.no.such.package", new Object[0]), (JComponent)this.myPackageTextField);
        }
        Object version = this.myVersionComboBox.getSelectedItem();
        if (version == null) {
            return new ValidationInfo(PhpBundle.message("framework.composer.add.dependency.no.version.selected", new Object[0]), this.myVersionComboBox);
        }
        return null;
    }

    public void addSettingsStateListener(WebProjectGenerator.SettingsStateListener listener) {
        this.myStateListeners.add(listener);
    }

    private void fireStateChanged() {
        boolean validSettings = this.validate() == null;
        for (WebProjectGenerator.SettingsStateListener listener : this.myStateListeners) {
            listener.stateChanged(validSettings);
        }
    }

    @NotNull
    public ComposerProjectSettings getSettings() {
        boolean download = this.myAddDependencySettingsPanel.isDownloadPhar();
        ComposerPackage aPackage = new ComposerPackage(this.myPackageTextField.getText());
        String version = (String)this.myVersionComboBox.getSelectedItem();
        String options = this.myAddDependencySettingsPanel.getCommandLineParameters();
        ComposerExecution execution = this.myAddDependencySettingsPanel.getExecution();
        return new ComposerProjectSettings(download, aPackage, ComposerPackage.getDefaultVersion().equals(version) ? null : version, options, execution);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        AddDependencySettingsPanel addDependencySettingsPanel = this.myAddDependencySettingsPanel;
        JComponent jComponent = addDependencySettingsPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myPackagePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 2, 1, 0, 3, 3, 7, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerCreateProjectForm.class).getString("composer.border.title.package"), (int)0, (int)0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 3, null, null, null, 0, true));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerCreateProjectForm.class).getString("composer.label.package"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        TextFieldWithCompletion textFieldWithCompletion = this.myPackageTextField;
        jPanel3.add((Component)textFieldWithCompletion, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, new Dimension(50, -1), new Dimension(50, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerCreateProjectForm.class).getString("composer.label.version.to.install"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myVersionComboBox = comboBox = new ComboBox();
        jPanel4.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, new Dimension(50, -1), new Dimension(50, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/composer/ComposerCreateProjectForm", "getPackageVersions"));
    }
}

