/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.insert;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.php.completion.insert.PhpInsertHandlerUtil;
import org.jetbrains.annotations.NotNull;

public class PhpSymbolInsertHandler
implements InsertHandler<LookupElement> {
    public static final PhpSymbolInsertHandler SPACE = new PhpSymbolInsertHandler(' ');
    public static final PhpSymbolInsertHandler COLON = new PhpSymbolInsertHandler(':');
    public static final PhpSymbolInsertHandler SEMICOLON = new PhpSymbolInsertHandler(';');
    public static final PhpSymbolInsertHandler ASSIGN = new PhpSymbolInsertHandler('=');
    public static final PhpSymbolInsertHandler ASYMMETRIC_VISIBILITY = new PhpAsymmetricVisibilityModifierInsertHandler();
    public static final PhpSymbolInsertHandler VISIBILITY = new PhpVisibilityModifierInsertHandler();
    private final char symbol;
    private final boolean insertUnconditionally;

    public PhpSymbolInsertHandler(char symbol) {
        this(symbol, false);
    }

    public PhpSymbolInsertHandler(char symbol, boolean insertUnconditionally) {
        this.symbol = symbol;
        this.insertUnconditionally = insertUnconditionally;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Editor editor;
        Project project;
        if (context == null) {
            PhpSymbolInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            PhpSymbolInsertHandler.$$$reportNull$$$0(1);
        }
        if (context.getCompletionChar() != this.symbol && (project = (editor = context.getEditor()).getProject()) != null) {
            if (this.insertUnconditionally || !this.isSymbolAtPlace(editor)) {
                PhpInsertHandlerUtil.insertStringAtCaret(editor, String.valueOf(this.symbol));
            } else {
                CaretModel caretModel = editor.getCaretModel();
                caretModel.moveToOffset(caretModel.getOffset() + 1);
            }
        }
    }

    private boolean isSymbolAtPlace(@NotNull Editor editor) {
        if (editor == null) {
            PhpSymbolInsertHandler.$$$reportNull$$$0(2);
        }
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == this.symbol;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(this.getClass().getSimpleName()).append(": ");
        if (this.symbol == ' ') {
            builder2.append("SPACE");
        } else if (this.symbol == ':') {
            builder2.append("COLON");
        } else if (this.symbol == ';') {
            builder2.append("SEMICOLON");
        } else if (this.symbol == '=') {
            builder2.append("ASSIGN");
        } else {
            builder2.append(this.symbol);
        }
        return builder2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/insert/PhpSymbolInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSymbolAtPlace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpAsymmetricVisibilityModifierInsertHandler
    extends PhpSymbolInsertHandler {
        private PhpAsymmetricVisibilityModifierInsertHandler() {
            super(' ');
        }

        @Override
        public void handleInsert(InsertionContext context, @NotNull LookupElement item) {
            if (item == null) {
                PhpAsymmetricVisibilityModifierInsertHandler.$$$reportNull$$$0(0);
            }
            Document document = context.getEditor().getDocument();
            int offset = context.getEditor().getCaretModel().getOffset();
            int endOffset = "(set)".length() + offset;
            if (document.getTextLength() > endOffset && document.getText(TextRange.create((int)offset, (int)endOffset)).equals("(set)")) {
                document.deleteString(offset, endOffset);
            }
            super.handleInsert(context, item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/php/completion/insert/PhpSymbolInsertHandler$PhpAsymmetricVisibilityModifierInsertHandler", "handleInsert"));
        }
    }

    private static class PhpVisibilityModifierInsertHandler
    extends PhpSymbolInsertHandler {
        private PhpVisibilityModifierInsertHandler() {
            super(' ');
        }

        @Override
        public void handleInsert(InsertionContext context, @NotNull LookupElement item) {
            if (item == null) {
                PhpVisibilityModifierInsertHandler.$$$reportNull$$$0(0);
            }
            Document document = context.getEditor().getDocument();
            int offset = context.getEditor().getCaretModel().getOffset();
            int endOffset = "(set)".length() + offset;
            if (document.getTextLength() > endOffset && document.getText(TextRange.create((int)offset, (int)endOffset)).equals("(set)")) {
                context.getEditor().getCaretModel().moveToOffset(endOffset);
            }
            super.handleInsert(context, item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/php/completion/insert/PhpSymbolInsertHandler$PhpVisibilityModifierInsertHandler", "handleInsert"));
        }
    }
}

