/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.ID;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.PhpLookupElementType;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.completion.insert.PhpVariableInsertHandler;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.inspections.PhpElementIsNotAvailableInCurrentPhpVersionInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ConstantImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpNamespaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUseReferenceNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableIndex;
import java.awt.Color;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLookupElement
extends LookupElement {
    private static final Logger LOG = Logger.getInstance(PhpLookupElement.class);
    static ClassConditionKey<PhpLookupElement> KEY = ClassConditionKey.create(PhpLookupElement.class);
    @Nullable
    public InsertHandler handler;
    @NotNull
    public String lookupString;
    private ID myId;
    protected String myFQN;
    @NotNull
    private final Project myProject;
    @NotNull
    public String tailText;
    public boolean bold;
    protected Icon icon;
    @Nullable
    private final SmartPsiElementPointer<PhpNamedElement> myNamedElementPointer;
    private PhpType myPhpType;
    private static final ID PARAM_FAKE_KEY = ID.create((String)"PARAM_FAKE_KEY");
    private static final ID CLASS_CONSTANT_FAKE_KEY = ID.create((String)"CLASS_CONSTANT_FAKE_KEY");
    private boolean myShouldUseClassAlias;
    private boolean myIsApplicable;
    protected boolean myIsClassElement;

    @Deprecated
    public PhpLookupElement(@NotNull String name, @NotNull StubIndexKey indexKey, @NotNull Icon ico, PhpType phpType, @NotNull Project project, InsertHandler handler) {
        if (name == null) {
            PhpLookupElement.$$$reportNull$$$0(0);
        }
        if (indexKey == null) {
            PhpLookupElement.$$$reportNull$$$0(1);
        }
        if (ico == null) {
            PhpLookupElement.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpLookupElement.$$$reportNull$$$0(3);
        }
        this.lookupString = "";
        this.tailText = "";
        this.bold = false;
        this.myIsApplicable = true;
        this.lookupString = name;
        this.myFQN = name;
        this.icon = ico;
        this.myId = indexKey;
        this.myPhpType = phpType;
        this.myProject = project;
        this.handler = handler;
        this.myNamedElementPointer = null;
    }

    private PhpLookupElement(@NotNull String name, @NotNull StubIndexKey indexKey, @NotNull Project project, InsertHandler handler, @Nullable PhpNamedElement element) {
        if (name == null) {
            PhpLookupElement.$$$reportNull$$$0(4);
        }
        if (indexKey == null) {
            PhpLookupElement.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PhpLookupElement.$$$reportNull$$$0(6);
        }
        this.lookupString = "";
        this.tailText = "";
        this.bold = false;
        this.myIsApplicable = true;
        this.lookupString = name;
        this.myFQN = name;
        this.myId = indexKey;
        this.myProject = project;
        this.handler = handler;
        this.myNamedElementPointer = element != null ? SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)element) : null;
    }

    public PhpLookupElement(@NotNull PhpNamedElement namedElement) {
        if (namedElement == null) {
            PhpLookupElement.$$$reportNull$$$0(7);
        }
        this.lookupString = "";
        this.tailText = "";
        this.bold = false;
        this.myIsApplicable = true;
        this.myProject = namedElement.getProject();
        this.myNamedElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)namedElement);
        this.updatePresentation();
        this.myFQN = namedElement instanceof PhpClass || namedElement instanceof PhpNamespace || namedElement instanceof Function || namedElement instanceof Field && ((Field)namedElement).isConstant() || namedElement instanceof Constant || namedElement instanceof PhpEnumCase ? namedElement.getFQN() : this.lookupString;
        this.myIsApplicable = PhpElementIsNotAvailableInCurrentPhpVersionInspection.isAvailableInCurrentPhpVersion(namedElement);
    }

    private void updatePresentation() {
        PhpNamedElement myNamedElement = this.getNamedElement();
        assert (myNamedElement != null);
        try {
            this.updatePresentation(myNamedElement);
        }
        catch (PsiInvalidElementAccessException e) {
            throw new RuntimeException("myNamedElement = " + String.valueOf(myNamedElement) + " '" + myNamedElement.getName(), e);
        }
    }

    protected void updatePresentation(PhpNamedElement myNamedElement) {
        this.icon = myNamedElement.getIcon();
        this.lookupString = myNamedElement.getName();
    }

    @NotNull
    public Object getObject() {
        PhpNamedElement myNamedElement = this.getNamedElement();
        String string = myNamedElement == null ? "" : myNamedElement;
        if (string == null) {
            PhpLookupElement.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getLookupString() {
        String string = this.lookupString;
        if (string == null) {
            PhpLookupElement.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            PhpLookupElement.$$$reportNull$$$0(10);
        }
        if (this.handler != null) {
            boolean smartParametersTemplateActive;
            boolean shouldInsertArrow = context.getCompletionChar() == '.' && this.canInsertArrow(context);
            Template template = TemplateManager.getInstance((Project)this.myProject).getActiveTemplate(context.getEditor());
            boolean bl = smartParametersTemplateActive = template != null && "params".equals(template.getKey());
            if (smartParametersTemplateActive || shouldInsertArrow) {
                context.setAddCompletionChar(false);
            }
            this.handler.handleInsert(context, (LookupElement)this);
            if (!smartParametersTemplateActive && shouldInsertArrow) {
                PhpLookupElement.insertArrowAtTailOffset(context);
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }
        }
    }

    public void setShouldUseClassAlias(boolean value) {
        this.myShouldUseClassAlias = value;
    }

    public boolean shouldUseClassAlias() {
        return this.myShouldUseClassAlias;
    }

    public boolean isApplicable() {
        return this.myIsApplicable;
    }

    public void setNotApplicable() {
        this.myIsApplicable = false;
    }

    private boolean canInsertArrow(@NotNull InsertionContext context) {
        PsiElement element;
        if (context == null) {
            PhpLookupElement.$$$reportNull$$$0(11);
        }
        if ((element = context.getFile().findElementAt(context.getStartOffset())) == null || context.getEditor().getCaretModel().getCaretCount() != 1 || PhpUseImpl.getUseList(element) != null || PhpPsiUtil.getParentOfClass(element, false, StringLiteralExpression.class) != null || "self".equals(this.lookupString) || "parent".equals(this.lookupString) || "static".equals(this.lookupString) || this.hasPrimitiveOrArrayType(element)) {
            return false;
        }
        PsiElement targetElement = this.getPsiElement();
        if (targetElement instanceof Function) {
            return !PhpLookupElement.shouldHandleParameters((Function)targetElement);
        }
        if (targetElement instanceof PhpClass) {
            ClassReference classReference = PhpPsiUtil.getParentOfClass(element, false, ClassReference.class);
            return classReference != null && PhpCompletionUtil.getUsageContext(classReference).isInNew() && !PhpLookupElement.shouldHandleParameters((Function)((PhpClass)targetElement).getConstructor());
        }
        return true;
    }

    private boolean hasPrimitiveOrArrayType(@NotNull PsiElement elementAt) {
        PhpNamedElement namedElement;
        if (elementAt == null) {
            PhpLookupElement.$$$reportNull$$$0(12);
        }
        PhpNamedElement typedElement = (namedElement = this.getNamedElement()) != null ? namedElement : elementAt.getParent();
        PhpType type = typedElement instanceof PhpTypedElement ? ((PhpTypedElement)typedElement).getGlobalType().filterUnknown() : null;
        return PhpLookupElement.isNotExtendablePrimitiveOrArrayType(type);
    }

    @NotNull
    public PhpLookupElement createClassElement() {
        PhpNamedElement element = this.getNamedElement();
        if (element == null) {
            PhpLookupElement phpLookupElement = this;
            if (phpLookupElement == null) {
                PhpLookupElement.$$$reportNull$$$0(13);
            }
            return phpLookupElement;
        }
        PhpLookupElement result = new PhpLookupElement(element){

            @Override
            @NotNull
            public String getLookupString() {
                String string = super.getLookupString() + "class";
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void handleInsert(@NotNull InsertionContext context) {
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                context.getDocument().insertString(context.getTailOffset() - "class".length(), (CharSequence)"::");
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                super.handleInsert(context);
            }

            @Override
            protected void doRender(LookupElementPresentation presentation, @Nullable PhpType myPhpType, boolean deprecated) {
                super.doRender(presentation, myPhpType, deprecated);
                presentation.setItemText(presentation.getItemText() + "::class");
            }

            @Override
            protected void updatePresentation(PhpNamedElement myNamedElement) {
                super.updatePresentation(myNamedElement);
                this.icon = PhpIcons.CONSTANT;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/completion/PhpLookupElement$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/completion/PhpLookupElement$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "handleInsert";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
        result.myIsClassElement = true;
        result.handler = PhpReferenceInsertHandler.getInstance();
        PhpLookupElement phpLookupElement = result;
        if (phpLookupElement == null) {
            PhpLookupElement.$$$reportNull$$$0(14);
        }
        return phpLookupElement;
    }

    private static boolean isNotExtendablePrimitiveOrArrayType(@Nullable PhpType type) {
        return type != null && !type.isEmpty() && ContainerUtil.and((Iterable)type.getTypes(), t -> PhpType.isNotExtendablePrimitiveType((String)t) || PhpType.isArray((String)t) || PhpType.isPluralType((String)t));
    }

    private static boolean shouldHandleParameters(@Nullable Function function) {
        return function != null && function.getParameters().length > 0 && PhpSmartKeysConfiguration.getInstance().isSmartFunctionParametersCompletion();
    }

    private static void insertArrowAtTailOffset(@NotNull InsertionContext context) {
        if (context == null) {
            PhpLookupElement.$$$reportNull$$$0(15);
        }
        Editor editor = context.getEditor();
        ClassReference classReference = PhpPsiUtil.getParentOfClass(context.getFile().findElementAt(context.getStartOffset()), ClassReference.class);
        if (classReference != null && !PhpLanguageFeature.NEW_WITHOUT_PARENTHESES.isSupported(context.getProject())) {
            PhpLookupElement.wrapConstructorInParens(editor, classReference);
        } else {
            editor.getCaretModel().moveToOffset(context.getTailOffset());
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"->", (boolean)true, (int)2);
    }

    private static void wrapConstructorInParens(@NotNull Editor editor, @NotNull ClassReference classReference) {
        if (editor == null) {
            PhpLookupElement.$$$reportNull$$$0(16);
        }
        if (classReference == null) {
            PhpLookupElement.$$$reportNull$$$0(17);
        }
        PsiElement constructor = classReference.getParent();
        editor.getSelectionModel().setSelection(constructor.getTextRange().getStartOffset(), constructor.getTextRange().getEndOffset());
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("(" + constructor.getText() + ")"), (boolean)true);
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            PhpLookupElement.$$$reportNull$$$0(18);
        }
        this.doRender(presentation, this.myPhpType, false);
    }

    @Nullable
    public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
        final PhpNamedElement named = this.getNamedElement();
        if (named != null) {
            return new LookupElementRenderer<LookupElement>(){

                public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                    PhpLookupElement.this.doRender(presentation, named);
                    PhpNamedElement phpNamedElement = PhpLookupElement.this.getNamedElement();
                    if (phpNamedElement instanceof Function) {
                        Function function = (Function)phpNamedElement;
                        StringBuilder builder2 = new StringBuilder();
                        PhpPresentationUtil.formatParameters(builder2, function.getParameters());
                        if (!(function instanceof Method)) {
                            builder2.append(PhpLookupElement.getNamespaceName(PhpLookupElement.this.myFQN, (PhpNamedElement)function));
                        }
                        PhpLookupElement.this.tailText = builder2.toString();
                        if (!PhpLookupElement.this.tailText.isEmpty()) {
                            presentation.setTailText(PhpLookupElement.this.tailText, true);
                        }
                    }
                }
            };
        }
        return null;
    }

    protected void doRender(LookupElementPresentation presentation, PhpNamedElement named) {
        this.doRender(presentation, this.getPhpType(), named.isDeprecated() && PhpElementIsNotAvailableInCurrentPhpVersionInspection.isAvailableInCurrentPhpVersion(named));
    }

    protected void doRender(LookupElementPresentation presentation, @Nullable PhpType myPhpType, boolean deprecated) {
        if (myPhpType != null) {
            myPhpType = myPhpType.map(e -> StringUtil.trimStart((String)e, (String)"\\___PHPSTORM_HELPERS"));
        }
        presentation.setItemText(this.getLookupString());
        PhpNamedElement myNamedElement = this.getNamedElement();
        @NotNull String typeText = "";
        if (myNamedElement != null) {
            if (deprecated) {
                presentation.setStrikeout(true);
            }
            if (myNamedElement instanceof PhpClass) {
                typeText = "";
                this.tailText = PhpLookupElement.getNamespaceName(this.myFQN, myNamedElement);
                presentation.setItemText(myNamedElement.getName());
            } else {
                PhpEnumCase.PhpDefaultValueDescriptor descriptor;
                String string = typeText = myPhpType != null ? myPhpType.toStringRelativized("\\") : "";
                if (myNamedElement instanceof Constant) {
                    StringBuilder builder2 = new StringBuilder();
                    String value = ((Constant)myNamedElement).getValuePresentation();
                    if (value != null) {
                        builder2.append(" = ").append(value);
                    }
                    builder2.append(PhpLookupElement.getNamespaceName(this.myFQN, myNamedElement));
                    this.tailText = builder2.toString();
                } else if (myNamedElement instanceof Field) {
                    String value = ((Field)myNamedElement).getDefaultValuePresentation();
                    if (value != null) {
                        this.tailText = " = " + value;
                    }
                    if (myPhpType != null) {
                        typeText = myPhpType.toStringRelativized("\\");
                    }
                } else if (myNamedElement instanceof PhpEnumCase && (descriptor = ((PhpEnumCase)myNamedElement).getDefaultValueDescriptor()) != null) {
                    this.tailText = " = " + ConstantImpl.getValuePresentation(descriptor.getValue());
                }
            }
        }
        if (myNamedElement instanceof Constant && PhpLangUtil.isBuiltInConstant(myNamedElement.getName(), myNamedElement.getProject())) {
            this.bold = true;
        } else {
            if (typeText.isEmpty() && myPhpType != null) {
                typeText = myPhpType.toStringRelativized("\\");
            }
            if (!this.tailText.isEmpty()) {
                presentation.setTailText(this.tailText, true);
            }
            if (!StringUtil.isEmpty((String)typeText) && !(myNamedElement instanceof PhpClass)) {
                presentation.setTypeText(typeText);
            }
            presentation.setIcon(this.icon);
        }
        if (this.bold) {
            presentation.setItemTextBold(true);
        }
        if (!this.myIsApplicable) {
            presentation.setItemTextForeground((Color)JBColor.RED);
        }
    }

    private static String getNamespaceName(@Nullable String fqn, @NotNull PhpNamedElement namedElement) {
        if (namedElement == null) {
            PhpLookupElement.$$$reportNull$$$0(19);
        }
        String namespaceName = fqn != null ? PhpLangUtil.getParentNamespaceFQN(fqn) : namedElement.getNamespaceName();
        return namespaceName.length() > 2 ? " [" + namespaceName.substring(1, namespaceName.length() - 1) + "]" : "";
    }

    @Nullable
    public PhpNamedElement getNamedElement() {
        return this.myNamedElementPointer != null ? (PhpNamedElement)this.myNamedElementPointer.getElement() : null;
    }

    @Nullable
    public PhpType getPhpType() {
        PhpNamedElement namedElement;
        if (this.myPhpType == null && (namedElement = this.getNamedElement()) != null) {
            this.myPhpType = namedElement.getGlobalType();
        }
        return this.myPhpType;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PhpLookupElement.$$$reportNull$$$0(20);
        }
        return project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhpLookupElement)) {
            return false;
        }
        PhpLookupElement that = (PhpLookupElement)((Object)o);
        return this.myFQN.equals(that.myFQN) && this.getId() == that.getId() && this.myIsClassElement == that.myIsClassElement;
    }

    public int hashCode() {
        return Objects.hash(this.myFQN, this.getId(), this.myIsClassElement);
    }

    private ID getId() {
        if (this.myId != null) {
            return this.myId;
        }
        PhpNamedElement myNamedElement = this.getNamedElement();
        if (myNamedElement instanceof Method) {
            this.myId = PhpMethodIndex.KEY;
        } else if (myNamedElement instanceof Function) {
            this.myId = PhpFunctionIndex.KEY;
        } else if (myNamedElement instanceof Variable || myNamedElement instanceof PhpDocVariable) {
            this.myId = PhpVariableIndex.KEY;
        } else if (myNamedElement instanceof Field) {
            this.myId = ((Field)myNamedElement).isConstant() ? CLASS_CONSTANT_FAKE_KEY : PhpFieldIndex.KEY;
        } else if (myNamedElement instanceof Constant) {
            this.myId = PhpConstantIndex.KEY;
        } else if (myNamedElement instanceof PhpClass) {
            this.myId = PhpClassIndex.KEY;
        } else if (myNamedElement instanceof Parameter) {
            this.myId = PARAM_FAKE_KEY;
        } else if (myNamedElement instanceof PhpUse) {
            this.myId = PhpUseReferenceNameIndex.KEY;
        } else if (myNamedElement instanceof PhpNamespace) {
            this.myId = PhpNamespaceIndex.KEY;
        } else if (myNamedElement instanceof PhpEnumCase) {
            this.myId = CLASS_CONSTANT_FAKE_KEY;
        }
        assert (myNamedElement != null);
        assert (this.myId != null) : myNamedElement.getClass().getName();
        return this.myId;
    }

    @NotNull
    PhpLookupElementType getLookupElementType() {
        if (this.myIsClassElement) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.CLASS_CONSTANT;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(21);
            }
            return phpLookupElementType;
        }
        ID id = this.getId();
        if (id == PhpMethodIndex.KEY) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.METHOD;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(22);
            }
            return phpLookupElementType;
        }
        if (id == PhpFunctionIndex.KEY) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.FUNCTION;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(23);
            }
            return phpLookupElementType;
        }
        if (id == PhpVariableIndex.KEY) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.VARIABLE;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(24);
            }
            return phpLookupElementType;
        }
        if (id == CLASS_CONSTANT_FAKE_KEY) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.CLASS_CONSTANT;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(25);
            }
            return phpLookupElementType;
        }
        if (id == PhpFieldIndex.KEY) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.FIELD;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(26);
            }
            return phpLookupElementType;
        }
        if (id == PhpConstantIndex.KEY) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.CONSTANT;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(27);
            }
            return phpLookupElementType;
        }
        if (id == PhpClassIndex.KEY) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.CLASS;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(28);
            }
            return phpLookupElementType;
        }
        if (id == PARAM_FAKE_KEY) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.PARAMETER;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(29);
            }
            return phpLookupElementType;
        }
        if (id == PhpUseReferenceNameIndex.KEY) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.USE;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(30);
            }
            return phpLookupElementType;
        }
        if (id == PhpNamespaceIndex.KEY) {
            PhpLookupElementType phpLookupElementType = PhpLookupElementType.NAMESPACE;
            if (phpLookupElementType == null) {
                PhpLookupElement.$$$reportNull$$$0(31);
            }
            return phpLookupElementType;
        }
        PhpLookupElementType phpLookupElementType = PhpLookupElementType.PHP_OTHER;
        if (phpLookupElementType == null) {
            PhpLookupElement.$$$reportNull$$$0(32);
        }
        return phpLookupElementType;
    }

    public static PhpLookupElement createVariableElement(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            PhpLookupElement.$$$reportNull$$$0(33);
        }
        if (name == null) {
            PhpLookupElement.$$$reportNull$$$0(34);
        }
        return new PhpLookupElement(name, PhpVariableIndex.KEY, project, PhpVariableInsertHandler.getInstance(), (PhpNamedElement)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)project).getVariablesByName(name))){

            @Override
            protected void doRender(LookupElementPresentation presentation, @Nullable PhpType myPhpType, boolean deprecated) {
                super.doRender(presentation, myPhpType, deprecated);
                presentation.setIcon(PhpIcons.VARIABLE);
            }
        };
    }

    public static PhpLookupElement createKeywordLookupElement(@NotNull String keyword, @NotNull StubIndexKey indexKey, @NotNull Icon ico, PhpType phpType, @NotNull Project project, InsertHandler handler) {
        if (keyword == null) {
            PhpLookupElement.$$$reportNull$$$0(35);
        }
        if (indexKey == null) {
            PhpLookupElement.$$$reportNull$$$0(36);
        }
        if (ico == null) {
            PhpLookupElement.$$$reportNull$$$0(37);
        }
        if (project == null) {
            PhpLookupElement.$$$reportNull$$$0(38);
        }
        return new PhpLookupElement(keyword, indexKey, ico, phpType, project, handler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 13, 14, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 2: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ico";
                break;
            }
            case 3: 
            case 6: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpLookupElement";
                break;
            }
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpLookupElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassElement";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canInsertArrow";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasPrimitiveOrArrayType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "insertArrowAtTailOffset";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapConstructorInParens";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceName";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createVariableElement";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordLookupElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 13, 14, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 -> new IllegalStateException(string);
        };
    }
}

