/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.google.common.base.Strings;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.intentions.PhpShowDateTimeExampleOutputIntention;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpDateRepresentationFormatCharactersCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final PhpType DATE_INTERVAL_TYPE = PhpType.from((String[])new String[]{"\\DateInterval"});

    private static @NotNull Map<Character, @Nls String> getDateTimeFormatCharactersWithDescriptions(Project project, Calendar calendar) {
        Map<Character, String> map = Map.ofEntries(Map.entry(Character.valueOf('d'), PhpBundle.message("day.of.the.month.2.digits.with.leading.zeros", new Object[0])), Map.entry(Character.valueOf('D'), PhpBundle.message("a.textual.representation.of.a.day.three.letters", new Object[0])), Map.entry(Character.valueOf('j'), PhpBundle.message("day.of.the.month.without.leading.zeros", new Object[0])), Map.entry(Character.valueOf('l'), PhpBundle.message("a.full.textual.representation.of.the.day.of.the.week", new Object[0])), Map.entry(Character.valueOf('N'), PhpBundle.message("iso.8601.numeric.representation.of.the.day.of.the.week", new Object[0])), Map.entry(Character.valueOf('S'), PhpBundle.message("english.ordinal.suffix.for.the.day.of.the.month.2.characters", new Object[0])), Map.entry(Character.valueOf('w'), PhpBundle.message("numeric.representation.of.the.day.of.the.week", new Object[0])), Map.entry(Character.valueOf('z'), PhpBundle.message("the.day.of.the.year.starting.from.0", new Object[0])), Map.entry(Character.valueOf('W'), PhpBundle.message("iso.8601.week.number.of.year.weeks.starting.on.monday", new Object[0])), Map.entry(Character.valueOf('F'), PhpBundle.message("a.full.textual.representation.of.a.month.such.as.january.or.march", new Object[0])), Map.entry(Character.valueOf('m'), PhpBundle.message("numeric.representation.of.a.month.with.leading.zeros", new Object[0])), Map.entry(Character.valueOf('M'), PhpBundle.message("a.short.textual.representation.of.a.month.three.letters", new Object[0])), Map.entry(Character.valueOf('n'), PhpBundle.message("numeric.representation.of.a.month.without.leading.zeros", new Object[0])), Map.entry(Character.valueOf('t'), PhpBundle.message("number.of.days.in.the.given.month", new Object[0])), Map.entry(Character.valueOf('L'), PhpBundle.message("whether.it.s.a.leap.year.1.or.0", new Object[0])), Map.entry(Character.valueOf('o'), PhpBundle.message("iso.8601.week.numbering.year", new Object[0])), Map.entry(Character.valueOf('X'), PhpBundle.message("an.expanded.full.numeric.representation.of.a.year.at.least.4.digits.with.or", new Object[0])), Map.entry(Character.valueOf('x'), PhpBundle.message("an.expanded.full.numeric.representation.if.requried.or.a.full.numeral.representation.like.y", new Object[0])), Map.entry(Character.valueOf('Y'), PhpBundle.message("a.full.numeric.representation.of.a.year.at.least.4.digits.with.for.years.bce", new Object[0])), Map.entry(Character.valueOf('y'), PhpBundle.message("a.two.digit.representation.of.a.year", new Object[0])), Map.entry(Character.valueOf('a'), PhpBundle.message("lowercase.ante.meridiem.and.post.meridiem.am.pm", new Object[0])), Map.entry(Character.valueOf('A'), PhpBundle.message("uppercase.ante.meridiem.and.post.meridiem.am.pm", new Object[0])), Map.entry(Character.valueOf('B'), PhpBundle.message("swatch.internet.time", new Object[0])), Map.entry(Character.valueOf('g'), PhpBundle.message("12.hour.format.of.an.hour.without.leading.zeros", new Object[0])), Map.entry(Character.valueOf('G'), PhpBundle.message("24.hour.format.of.an.hour.without.leading.zeros", new Object[0])), Map.entry(Character.valueOf('h'), PhpBundle.message("12.hour.format.of.an.hour.with.leading.zeros", new Object[0])), Map.entry(Character.valueOf('H'), PhpBundle.message("24.hour.format.of.an.hour.with.leading.zeros", new Object[0])), Map.entry(Character.valueOf('i'), PhpBundle.message("minutes.with.leading.zeros", new Object[0])), Map.entry(Character.valueOf('s'), PhpBundle.message("seconds.with.leading.zeros", new Object[0])), Map.entry(Character.valueOf('u'), PhpBundle.message("microseconds", new Object[0])), Map.entry(Character.valueOf('v'), PhpBundle.message("milliseconds", new Object[0])), Map.entry(Character.valueOf('e'), PhpBundle.message("timezone.identifier", new Object[0])), Map.entry(Character.valueOf('I'), PhpBundle.message("whether.or.not.the.date.is.in.daylight.saving.time.1.or.0", new Object[0])), Map.entry(Character.valueOf('O'), PhpBundle.message("difference.to.greenwich.time.gmt.without.colon.between.hours.and.minutes", new Object[0])), Map.entry(Character.valueOf('P'), PhpBundle.message("difference.to.greenwich.time.gmt.with.colon.between.hours.and.minutes", new Object[0])), Map.entry(Character.valueOf('p'), PhpBundle.message("the.same.as.p.but.returns.z.instead.of.00.00.available.as.of.php.8.0", new Object[0])), Map.entry(Character.valueOf('T'), PhpBundle.message("timezone.abbreviation.if.known.otherwise.the.gmt.offset", new Object[0])), Map.entry(Character.valueOf('Z'), PhpBundle.message("timezone.offset.in.seconds", new Object[0])), Map.entry(Character.valueOf('c'), PhpBundle.message("iso.8601.date", PhpShowDateTimeExampleOutputIntention.computeDateTimeExampleOutput(project, "c", calendar))), Map.entry(Character.valueOf('r'), PhpBundle.message("rfc.2822.rfc.5322.formatted.date", PhpShowDateTimeExampleOutputIntention.computeDateTimeExampleOutput(project, "r", calendar))), Map.entry(Character.valueOf('U'), PhpBundle.message("seconds.since.the.unix.epoch.january.1.1970.00.00.00.gmt", PhpShowDateTimeExampleOutputIntention.computeDateTimeExampleOutput(project, "U", calendar))));
        if (map == null) {
            PhpDateRepresentationFormatCharactersCompletionProvider.$$$reportNull$$$0(0);
        }
        return map;
    }

    private static @NotNull Map<Character, @Nls String> getDateIntervalFormatCharactersWithDescriptions() {
        Map<Character, String> map = Map.ofEntries(Map.entry(Character.valueOf('%'), PhpBundle.message("literal.%", new Object[0])), Map.entry(Character.valueOf('Y'), PhpBundle.message("years.numeric.at.least.2.digits.with.leading.0", new Object[0])), Map.entry(Character.valueOf('y'), PhpBundle.message("years.numeric", new Object[0])), Map.entry(Character.valueOf('M'), PhpBundle.message("months.numeric.at.least.2.digits.with.leading.0", new Object[0])), Map.entry(Character.valueOf('m'), PhpBundle.message("months.numeric", new Object[0])), Map.entry(Character.valueOf('D'), PhpBundle.message("days.numeric.at.least.2.digits.with.leading.0", new Object[0])), Map.entry(Character.valueOf('d'), PhpBundle.message("days.numeric", new Object[0])), Map.entry(Character.valueOf('a'), PhpBundle.message("total.number.of.days.as.a.result.of.a.datetime.diff.or.unknown.otherwise", new Object[0])), Map.entry(Character.valueOf('H'), PhpBundle.message("hours.numeric.at.least.2.digits.with.leading.0", new Object[0])), Map.entry(Character.valueOf('h'), PhpBundle.message("hours.numeric", new Object[0])), Map.entry(Character.valueOf('I'), PhpBundle.message("minutes.numeric.at.least.2.digits.with.leading.0", new Object[0])), Map.entry(Character.valueOf('i'), PhpBundle.message("minutes.numeric", new Object[0])), Map.entry(Character.valueOf('S'), PhpBundle.message("seconds.numeric.at.least.2.digits.with.leading.0", new Object[0])), Map.entry(Character.valueOf('s'), PhpBundle.message("seconds.numeric", new Object[0])), Map.entry(Character.valueOf('F'), PhpBundle.message("microseconds.numeric.at.least.6.digits.with.leading.0", new Object[0])), Map.entry(Character.valueOf('f'), PhpBundle.message("microseconds.numeric", new Object[0])), Map.entry(Character.valueOf('R'), PhpBundle.message("sign.minus.when.negative.plus.when.positive", new Object[0])), Map.entry(Character.valueOf('r'), PhpBundle.message("sign.minus.when.negative.empty.when.positive", new Object[0])));
        if (map == null) {
            PhpDateRepresentationFormatCharactersCompletionProvider.$$$reportNull$$$0(1);
        }
        return map;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        StringLiteralExpression formatString;
        PsiElement psiElement;
        if (parameters == null) {
            PhpDateRepresentationFormatCharactersCompletionProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PhpDateRepresentationFormatCharactersCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            PhpDateRepresentationFormatCharactersCompletionProvider.$$$reportNull$$$0(4);
        }
        if ((psiElement = parameters.getPosition().getParent()) instanceof StringLiteralExpression && PhpShowDateTimeExampleOutputIntention.isSuitableFormatPlace(formatString = (StringLiteralExpression)psiElement)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            DATE_REPRESENTATION dateRepresentation = PhpDateRepresentationFormatCharactersCompletionProvider.getDateRepresentation(formatString);
            for (Map.Entry<Character, String> entry : dateRepresentation.getDateRepresentationFormatCharactersWithDescriptions(formatString.getProject(), calendar).entrySet()) {
                PhpDateRepresentationFormatCharactersCompletionProvider.addStringLookupItem(result, String.valueOf(entry.getKey()), entry.getValue(), 1);
            }
            for (String pattern : dateRepresentation.PREDEFINED_PATTERNS) {
                PhpDateRepresentationFormatCharactersCompletionProvider.addStringLookupItem(result, pattern, PhpShowDateTimeExampleOutputIntention.computeDateTimeExampleOutput(formatString.getProject(), pattern, calendar), -1);
            }
            result.restartCompletionOnAnyPrefixChange();
        }
    }

    public static void addStringLookupItem(@NotNull CompletionResultSet result, String lookupString, String description, int priority) {
        if (result == null) {
            PhpDateRepresentationFormatCharactersCompletionProvider.$$$reportNull$$$0(5);
        }
        PhpDateRepresentationFormatCharactersCompletionProvider.addStringLookupItem(result, lookupString, description, priority, 2);
    }

    public static void addStringLookupItem(@NotNull CompletionResultSet result, String lookupString, String description, int priority, int pad) {
        if (result == null) {
            PhpDateRepresentationFormatCharactersCompletionProvider.$$$reportNull$$$0(6);
        }
        LookupElement element = PrioritizedLookupElement.withExplicitProximity((LookupElement)LookupElementBuilder.create((String)lookupString).withPresentableText(Strings.padEnd((String)lookupString, (int)pad, (char)' ')).withTypeText(description, true), (int)priority);
        String prefix = result.getPrefixMatcher().getPrefix();
        IntStream.range(0, lookupString.length() + 1).mapToObj(i -> lookupString.substring(0, i)).filter(prefix::endsWith).max(Comparator.comparingInt(String::length)).ifPresent(longestCommonPrefixSuffix -> result.withPrefixMatcher(longestCommonPrefixSuffix).addElement(element));
    }

    private static DATE_REPRESENTATION getDateRepresentation(StringLiteralExpression formatParameter) {
        ParameterListOwner plo = PhpPsiUtil.getParentOfClass((PsiElement)formatParameter, ParameterListOwner.class);
        if (plo instanceof MethodReference) {
            MethodReference methodRef = (MethodReference)plo;
            PhpExpression classRef = methodRef.getClassReference();
            assert (classRef != null);
            PhpType type = classRef.getGlobalType();
            if (DATE_INTERVAL_TYPE.isConvertibleFrom(type, PhpIndex.getInstance((Project)classRef.getProject()))) {
                return DATE_REPRESENTATION.DATE_INTERVAL;
            }
        }
        return DATE_REPRESENTATION.DATE_TIME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpDateRepresentationFormatCharactersCompletionProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeFormatCharactersWithDescriptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateIntervalFormatCharactersWithDescriptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpDateRepresentationFormatCharactersCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addStringLookupItem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum DATE_REPRESENTATION {
        DATE_TIME((List)List.of("Y-m-d", "H:i:s", "Ymd", "d-m-Y-H-i-s", "d/m/y H:i", "D, d M Y H:i:s")){

            @Override
            public Map<Character, @Nls String> getDateRepresentationFormatCharactersWithDescriptions(Project project, Calendar calendar) {
                return PhpDateRepresentationFormatCharactersCompletionProvider.getDateTimeFormatCharactersWithDescriptions(project, calendar);
            }
        }
        ,
        DATE_INTERVAL(Collections.emptyList()){

            @Override
            public Map<Character, @Nls String> getDateRepresentationFormatCharactersWithDescriptions(Project project, Calendar calendar) {
                return PhpDateRepresentationFormatCharactersCompletionProvider.getDateIntervalFormatCharactersWithDescriptions();
            }
        };

        private final List<String> PREDEFINED_PATTERNS;

        private DATE_REPRESENTATION(List<String> patterns) {
            this.PREDEFINED_PATTERNS = patterns;
        }

        abstract Map<Character, @Nls String> getDateRepresentationFormatCharactersWithDescriptions(Project var1, Calendar var2);
    }
}

