/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Processor;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.completion.ClassUsageContext;
import com.jetbrains.php.completion.PhpClassLookupElement;
import com.jetbrains.php.completion.PhpFqnPrefixMatcher;
import com.jetbrains.php.completion.PhpNamespacePrefixMatcher;
import com.jetbrains.php.completion.insert.PhpInsertHandlerUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.classAlias.PhpClassAliasIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpFieldType;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpParameterType;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpAttributesFQNsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassAliasFqnIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCompletionUtil {
    private static final Predicate<String> NOT_FROM_PHPSTORM_HELPERS_PREDICATE = s -> !"___PHPSTORM_HELPERS".equals(s);

    private PhpCompletionUtil() {
    }

    public static void showCompletion(@NotNull InsertionContext context) {
        if (context == null) {
            PhpCompletionUtil.$$$reportNull$$$0(0);
        }
        PhpCompletionUtil.showCompletion(context.getEditor());
    }

    public static void showCompletion(@NotNull Editor editor) {
        if (editor == null) {
            PhpCompletionUtil.$$$reportNull$$$0(1);
        }
        AutoPopupController.getInstance((Project)editor.getProject()).autoPopupMemberLookup(editor, null);
    }

    public static void addSubNamespaces(@NotNull String namespaceName, @NotNull CompletionResultSet result, PhpIndex index, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (namespaceName == null) {
            PhpCompletionUtil.$$$reportNull$$$0(2);
        }
        if (result == null) {
            PhpCompletionUtil.$$$reportNull$$$0(3);
        }
        PhpCompletionUtil.addSubNamespaces(null, namespaceName, result, insertHandler, false, index);
    }

    public static void addSubNamespaces(@Nullable Project project, @NotNull String namespaceName, @NotNull CompletionResultSet result, @Nullable InsertHandler<LookupElement> insertHandler, boolean onlyAttributes) {
        if (namespaceName == null) {
            PhpCompletionUtil.$$$reportNull$$$0(4);
        }
        if (result == null) {
            PhpCompletionUtil.$$$reportNull$$$0(5);
        }
        PhpCompletionUtil.addSubNamespaces(project, namespaceName, result, insertHandler, onlyAttributes, null);
    }

    public static void addSubNamespaces(@Nullable Project project, @NotNull String namespaceName, @NotNull CompletionResultSet result, @Nullable InsertHandler<LookupElement> insertHandler, boolean onlyAttributes, @Nullable PhpIndex phpIndex) {
        if (namespaceName == null) {
            PhpCompletionUtil.$$$reportNull$$$0(6);
        }
        if (result == null) {
            PhpCompletionUtil.$$$reportNull$$$0(7);
        }
        Consumer<String> adder = namespace -> {
            String shortName = PhpLangUtil.toShortName(namespace);
            String partialNamespaceName = StringUtil.trimStart((String)namespace, (String)PhpLangUtil.toPresentableFQN(namespaceName));
            LookupElementBuilder element = LookupElementBuilder.create((Object)partialNamespaceName, (String)shortName).withPresentableText(shortName).withIcon(PhpIcons.NAMESPACE).withInsertHandler(insertHandler);
            if (!PhpLangUtil.equalsClassNames(shortName, namespace)) {
                element = element.withTailText("(" + namespace + ")", true);
            }
            result.addElement((LookupElement)element);
        };
        Predicate<String> predicate = PhpCompletionUtil.createNamespacePredicate(project, onlyAttributes);
        LimitedProcessor<String> processor2 = new LimitedProcessor<String>(predicate, adder);
        PhpNamespacePrefixMatcher matcher = new PhpNamespacePrefixMatcher(result.getPrefixMatcher());
        if (phpIndex == null) {
            phpIndex = PhpIndex.getInstance((Project)project);
        }
        for (String childNamespaceFqn : matcher.sortMatching(phpIndex.getAllChildNamespacesFqns(PhpLangUtil.toFQN(namespaceName)))) {
            ProgressIndicatorProvider.checkCanceled();
            if (phpIndex.getNamespacesByName(childNamespaceFqn).isEmpty() || PhpCompletionUtil.processNamespacesPrefixes(childNamespaceFqn, PhpLangUtil.toFQN(namespaceName).length(), processor2)) continue;
            return;
        }
    }

    private static Predicate<String> createNamespacePredicate(@NotNull Project project, boolean onlyAttributes) {
        if (project == null) {
            PhpCompletionUtil.$$$reportNull$$$0(8);
        }
        if (onlyAttributes) {
            Collection attributesFQNs = FileBasedIndex.getInstance().getAllKeys(PhpAttributesFQNsIndex.KEY, project);
            return s -> NOT_FROM_PHPSTORM_HELPERS_PREDICATE.test((String)s) && ContainerUtil.exists((Iterable)attributesFQNs, attrFQN -> StringUtil.startsWith((CharSequence)attrFQN, (CharSequence)PhpLangUtil.toFQN(s)));
        }
        return NOT_FROM_PHPSTORM_HELPERS_PREDICATE;
    }

    private static boolean processNamespacesPrefixes(@NotNull String namespaceFqn, int indexFrom, @NotNull Processor<? super String> processor2) {
        if (namespaceFqn == null) {
            PhpCompletionUtil.$$$reportNull$$$0(9);
        }
        if (processor2 == null) {
            PhpCompletionUtil.$$$reportNull$$$0(10);
        }
        int separatorIndex = namespaceFqn.indexOf("\\", indexFrom);
        while (separatorIndex > 0) {
            if (!processor2.process((Object)PhpLangUtil.toPresentableFQN(namespaceFqn.substring(0, separatorIndex)))) {
                return false;
            }
            separatorIndex = namespaceFqn.indexOf("\\", separatorIndex + 1);
        }
        return processor2.process((Object)PhpLangUtil.toPresentableFQN(namespaceFqn));
    }

    @NotNull
    public static Collection<String> getAllChildNamespaceNames(@NotNull PhpIndex phpIndex, @NotNull String parent) {
        if (phpIndex == null) {
            PhpCompletionUtil.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            PhpCompletionUtil.$$$reportNull$$$0(12);
        }
        ArrayList<String> values = new ArrayList<String>();
        PriorityQueue<Object> toProcess = new PriorityQueue<Object>();
        toProcess.add(parent);
        while (!toProcess.isEmpty()) {
            String next = (String)toProcess.poll();
            Collection children = phpIndex.getChildNamespacesByParentName(next);
            for (String child : children) {
                String childQualifiedName = next + child;
                toProcess.add(childQualifiedName + "\\");
                values.add(PhpLangUtil.toPresentableFQN(childQualifiedName));
            }
        }
        ArrayList<String> arrayList = values;
        if (arrayList == null) {
            PhpCompletionUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public static <T extends PhpNamedElement> boolean hasNamespace(String namespaceName, boolean allowGlobal, T element) {
        if (StringUtil.isEmpty((String)namespaceName)) {
            return true;
        }
        String ns = element.getNamespaceName();
        return allowGlobal && ns.equals("\\") || ns.equalsIgnoreCase(namespaceName);
    }

    public static boolean hasNamespace(@NotNull PhpNamedElement element, @NotNull String namespaceFQN) {
        if (element == null) {
            PhpCompletionUtil.$$$reportNull$$$0(14);
        }
        if (namespaceFQN == null) {
            PhpCompletionUtil.$$$reportNull$$$0(15);
        }
        String classNamespace = element.getNamespaceName();
        return PhpLangUtil.equalsClassNames(namespaceFQN, StringUtil.trimEnd((String)classNamespace, (String)"\\"));
    }

    public static void installAutoCompletionAfterNamespaceSeparator(final @NotNull EditorTextField editorTextField, @NotNull Disposable disposable) {
        if (editorTextField == null) {
            PhpCompletionUtil.$$$reportNull$$$0(16);
        }
        if (disposable == null) {
            PhpCompletionUtil.$$$reportNull$$$0(17);
        }
        editorTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("\\".contentEquals(event.getNewFragment()) && event.getDocument().getTextLength() == event.getOffset() + 1) {
                    PhpCompletionUtil.showCompletion(editorTextField.getEditor());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/completion/PhpCompletionUtil$1", "documentChanged"));
            }
        }, disposable);
    }

    public static void installNamespaceCompletion(@NotNull EditorTextField field, @Nullable String initialVariant, @NotNull Disposable disposable) {
        if (field == null) {
            PhpCompletionUtil.$$$reportNull$$$0(18);
        }
        if (disposable == null) {
            PhpCompletionUtil.$$$reportNull$$$0(19);
        }
        final Project project = field.getProject();
        new PhpFullyQualifiedNameTextFieldCompletionProvider(){

            @Override
            protected void addCompletionVariants(@NotNull String namespaceName, @NotNull String prefix, @NotNull CompletionResultSet result) {
                if (namespaceName == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                PhpCompletionUtil.addSubNamespaces(project, namespaceName + "\\", result, PhpNamespaceWithoutEndSeparatorInsertHandler.INSTANCE, false);
                result.stopHere();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namespaceName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/completion/PhpCompletionUtil$2";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.apply(field, StringUtil.notNullize((String)initialVariant));
        PhpCompletionUtil.installAutoCompletionAfterNamespaceSeparator(field, disposable);
    }

    @Deprecated(forRemoval=true)
    public static void installClassCompletion(@NotNull EditorTextField field, @Nullable String initialVariant, @NotNull Disposable disposable) {
        if (field == null) {
            PhpCompletionUtil.$$$reportNull$$$0(20);
        }
        if (disposable == null) {
            PhpCompletionUtil.$$$reportNull$$$0(21);
        }
        PhpCompletionUtil.installClassCompletion(field, initialVariant, disposable, null, new String[0]);
    }

    public static void installClassCompletion(@NotNull EditorTextField field, @Nullable String initialVariant, @NotNull Disposable disposable, final @Nullable Condition<? super PhpClass> condition, final String ... additionalElements) {
        if (field == null) {
            PhpCompletionUtil.$$$reportNull$$$0(22);
        }
        if (disposable == null) {
            PhpCompletionUtil.$$$reportNull$$$0(23);
        }
        final Project project = field.getProject();
        new PhpFullyQualifiedNameTextFieldCompletionProvider(){

            @Override
            protected void addCompletionVariants(@NotNull String namespaceName, @NotNull String prefix, @NotNull CompletionResultSet result) {
                if (namespaceName == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    3.$$$reportNull$$$0(2);
                }
                PhpCompletionUtil.addClassCompletionVariants(namespaceName, prefix, result, project, (Condition<? super PhpClass>)condition, additionalElements);
                result.stopHere();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namespaceName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/completion/PhpCompletionUtil$3";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.apply(field, StringUtil.notNullize((String)initialVariant));
        PhpCompletionUtil.installAutoCompletionAfterNamespaceSeparator(field, disposable);
    }

    public static void installClassInterfaceCompletion(@NotNull EditorTextField field, @Nullable String initialVariant, @NotNull Disposable disposable, final @Nullable Condition<? super PhpClass> condition, final String ... additionalElements) {
        if (field == null) {
            PhpCompletionUtil.$$$reportNull$$$0(24);
        }
        if (disposable == null) {
            PhpCompletionUtil.$$$reportNull$$$0(25);
        }
        final Project project = field.getProject();
        new PhpFullyQualifiedNameTextFieldCompletionProvider(){

            @Override
            protected void addCompletionVariants(@NotNull String namespaceName, @NotNull String prefix, @NotNull CompletionResultSet result) {
                if (namespaceName == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    4.$$$reportNull$$$0(2);
                }
                PhpCompletionUtil.addClassCompletionVariants(namespaceName, prefix, result, project, (Condition<? super PhpClass>)condition, additionalElements);
                PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
                CamelHumpMatcher matcher = new CamelHumpMatcher(prefix);
                if (PhpLangUtil.isGlobalNamespaceName(namespaceName)) {
                    PhpCompletionUtil.addInterfaces(phpIndex, PhpCompletionUtil.createPredicate((Condition<? super PhpClass>)condition), clazz -> PhpCompletionUtil.addClassLookupElement(result, clazz, true), (PrefixMatcher)matcher);
                    for (String element : additionalElements) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)element));
                    }
                } else {
                    String namespaceFqn = PhpLangUtil.toFQN(namespaceName);
                    PhpCompletionUtil.addInterfaces(phpIndex, clazz -> PhpCompletionUtil.hasNamespace((PhpNamedElement)clazz, namespaceFqn), clazz -> PhpCompletionUtil.addClassLookupElement(result, clazz, false), (PrefixMatcher)matcher);
                }
                if (PhpLanguageFeature.CONSTANTS_IN_TRAITS.isSupported(project)) {
                    PhpCompletionUtil.addTraits(phpIndex, (PrefixMatcher)matcher, PhpCompletionUtil.createPredicate((Condition<? super PhpClass>)condition), clazz -> PhpCompletionUtil.addClassLookupElement(result, clazz, true));
                }
                result.stopHere();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namespaceName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/completion/PhpCompletionUtil$4";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.apply(field, StringUtil.notNullize((String)initialVariant));
        PhpCompletionUtil.installAutoCompletionAfterNamespaceSeparator(field, disposable);
    }

    private static void addClassCompletionVariants(@NotNull String namespaceName, @NotNull String prefix, @NotNull CompletionResultSet result, Project project, @Nullable Condition<? super PhpClass> condition, String[] additionalElements) {
        if (namespaceName == null) {
            PhpCompletionUtil.$$$reportNull$$$0(26);
        }
        if (prefix == null) {
            PhpCompletionUtil.$$$reportNull$$$0(27);
        }
        if (result == null) {
            PhpCompletionUtil.$$$reportNull$$$0(28);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
        CamelHumpMatcher prefixMatcher = new CamelHumpMatcher(prefix);
        if (PhpLangUtil.isGlobalNamespaceName(namespaceName)) {
            PhpCompletionUtil.addClasses(phpIndex, (PrefixMatcher)prefixMatcher, PhpCompletionUtil.createPredicate(condition), (? super PhpClass clazz) -> PhpCompletionUtil.addClassLookupElement(result, clazz, true));
            for (String element : additionalElements) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)element));
            }
        } else {
            String namespaceFqn = PhpLangUtil.toFQN(namespaceName);
            PhpCompletionUtil.addClasses(phpIndex, (PrefixMatcher)prefixMatcher, (? super PhpClass clazz) -> PhpCompletionUtil.hasNamespace((PhpNamedElement)clazz, namespaceFqn), (? super PhpClass clazz) -> PhpCompletionUtil.addClassLookupElement(result, clazz, false));
        }
        PhpCompletionUtil.addSubNamespaces(namespaceName, result, project);
    }

    public static void addSubNamespaces(@NotNull String namespaceName, @NotNull CompletionResultSet result, Project project) {
        if (namespaceName == null) {
            PhpCompletionUtil.$$$reportNull$$$0(29);
        }
        if (result == null) {
            PhpCompletionUtil.$$$reportNull$$$0(30);
        }
        PhpCompletionUtil.addSubNamespaces(project, namespaceName + "\\", result, PhpNamespaceSeparatorAppenderInsertHandler.INSTANCE, false);
    }

    @Deprecated
    public static void addClasses(@NotNull String namePrefix, @NotNull CompletionResultSet result, @NotNull PhpIndex phpIndex, @Nullable Condition<? super PhpClass> condition) {
        if (namePrefix == null) {
            PhpCompletionUtil.$$$reportNull$$$0(31);
        }
        if (result == null) {
            PhpCompletionUtil.$$$reportNull$$$0(32);
        }
        if (phpIndex == null) {
            PhpCompletionUtil.$$$reportNull$$$0(33);
        }
        PhpCompletionUtil.addClasses(phpIndex, (PrefixMatcher)new CamelHumpMatcher(namePrefix), PhpCompletionUtil.createPredicate(condition), (? super PhpClass clazz) -> PhpCompletionUtil.addClassLookupElement(result, clazz, true));
    }

    @NotNull
    private static Predicate<PhpClass> createPredicate(@Nullable Condition<? super PhpClass> condition) {
        Predicate<PhpClass> predicate = aClass -> condition == null || condition.value(aClass);
        if (predicate == null) {
            PhpCompletionUtil.$$$reportNull$$$0(34);
        }
        return predicate;
    }

    private static void addClassLookupElement(@NotNull CompletionResultSet result, @NotNull PhpClass clazz, boolean showNamespace) {
        if (result == null) {
            PhpCompletionUtil.$$$reportNull$$$0(35);
        }
        if (clazz == null) {
            PhpCompletionUtil.$$$reportNull$$$0(36);
        }
        result.addElement((LookupElement)new PhpClassLookupElement(clazz, showNamespace, (InsertHandler<LookupElement>)(showNamespace ? PhpClassFullNameInsertHandler.INSTANCE : null)));
    }

    public static boolean addClasses(@NotNull PhpIndex phpIndex, @NotNull PrefixMatcher prefixMatcher, @NotNull Predicate<? super PhpClass> predicate, @NotNull Consumer<? super PhpClass> adder) {
        if (phpIndex == null) {
            PhpCompletionUtil.$$$reportNull$$$0(37);
        }
        if (prefixMatcher == null) {
            PhpCompletionUtil.$$$reportNull$$$0(38);
        }
        if (predicate == null) {
            PhpCompletionUtil.$$$reportNull$$$0(39);
        }
        if (adder == null) {
            PhpCompletionUtil.$$$reportNull$$$0(40);
        }
        return PhpCompletionUtil.addClassEntries(phpIndex, PhpClassKind.CLASS, predicate, adder, prefixMatcher);
    }

    @NotNull
    public static ClassUsageContext getUsageContext(ClassReference reference) {
        ClassUsageContext context = new ClassUsageContext(false);
        PsiElement parent = reference.getParent();
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.INSTANCEOF_EXPRESSION)) {
            context.setInInstanceof(true);
        }
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.EXTENDS_LIST)) {
            context.setInExtends(true);
        }
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.IMPLEMENTS_LIST)) {
            context.setInImplements(true);
        }
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.NEW_EXPRESSION)) {
            context.setInNew(true);
        }
        if (PhpPsiUtil.isOfType(parent, (IElementType)PhpStubElementTypes.ATTRIBUTE)) {
            context.setInAttribute(true);
        }
        if (parent instanceof PhpParameterType) {
            context.setInParameterType(true);
        }
        if (parent instanceof PhpFieldType) {
            context.setInFieldType(true);
        }
        if (parent instanceof PhpReturnType) {
            context.setInReturnType(true);
        }
        if (PhpPsiUtil.isOfType(parent, (IElementType)PhpStubElementTypes.USE) && PhpPsiUtil.isOfType(parent.getParent().getParent(), (IElementType)PhpStubElementTypes.CLASS)) {
            context.setInClassUse(true);
        }
        ClassUsageContext classUsageContext = context;
        if (classUsageContext == null) {
            PhpCompletionUtil.$$$reportNull$$$0(41);
        }
        return classUsageContext;
    }

    public static void moveCaretRelativelyWithScroll(Editor editor, int columnShift) {
        editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + columnShift);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public static boolean addInterfaces(@NotNull PhpIndex phpIndex, @NotNull Predicate<? super PhpClass> predicate, @NotNull Consumer<? super PhpClass> adder, @NotNull PrefixMatcher prefixMatcher) {
        if (phpIndex == null) {
            PhpCompletionUtil.$$$reportNull$$$0(42);
        }
        if (predicate == null) {
            PhpCompletionUtil.$$$reportNull$$$0(43);
        }
        if (adder == null) {
            PhpCompletionUtil.$$$reportNull$$$0(44);
        }
        if (prefixMatcher == null) {
            PhpCompletionUtil.$$$reportNull$$$0(45);
        }
        return PhpCompletionUtil.addClassEntries(phpIndex, PhpClassKind.INTERFACE, predicate, adder, prefixMatcher);
    }

    public static boolean addClassEntries(@NotNull PhpIndex phpIndex, @NotNull PhpClassKind classKind, @NotNull Predicate<? super PhpClass> predicate, @NotNull Consumer<? super PhpClass> adder, @NotNull PrefixMatcher prefixMatcher) {
        if (phpIndex == null) {
            PhpCompletionUtil.$$$reportNull$$$0(46);
        }
        if (classKind == null) {
            PhpCompletionUtil.$$$reportNull$$$0(47);
        }
        if (predicate == null) {
            PhpCompletionUtil.$$$reportNull$$$0(48);
        }
        if (adder == null) {
            PhpCompletionUtil.$$$reportNull$$$0(49);
        }
        if (prefixMatcher == null) {
            PhpCompletionUtil.$$$reportNull$$$0(50);
        }
        return PhpCompletionUtil.addClassEntries(phpIndex, classKind, prefixMatcher, new LimitedProcessor<PhpClass>(predicate, adder));
    }

    public static boolean addClassEntries(@NotNull PhpIndex phpIndex, @NotNull PhpClassKind classKind, @NotNull PrefixMatcher prefixMatcher, LimitedProcessor<PhpClass> processor2) {
        if (phpIndex == null) {
            PhpCompletionUtil.$$$reportNull$$$0(51);
        }
        if (classKind == null) {
            PhpCompletionUtil.$$$reportNull$$$0(52);
        }
        if (prefixMatcher == null) {
            PhpCompletionUtil.$$$reportNull$$$0(53);
        }
        if (prefixMatcher instanceof PhpFqnPrefixMatcher) {
            Collection<String> fqns = classKind.getAllFqns(phpIndex, prefixMatcher);
            for (String fqn : prefixMatcher.sortMatching(fqns)) {
                if (ContainerUtil.process(classKind.getEntriesByFqn(phpIndex, fqn), processor2)) continue;
                return false;
            }
        } else {
            Collection names = classKind.getAllFqns(phpIndex, null).stream().map(PhpLangUtil::toShortName).distinct().collect(Collectors.toList());
            for (String name : prefixMatcher.sortMatching(names)) {
                if (ContainerUtil.process(classKind.getEntriesByName(phpIndex, name), processor2)) continue;
                return false;
            }
        }
        if (prefixMatcher instanceof PhpFqnPrefixMatcher) {
            PhpIndexImpl.CollectFilteredUniquesProcessor uniquesProcessor = new PhpIndexImpl.CollectFilteredUniquesProcessor(prefixMatcher);
            FileBasedIndex.getInstance().processAllKeys(PhpClassAliasFqnIndex.KEY, (Processor)uniquesProcessor, phpIndex.getSearchScope(), null);
            for (String aliasFQN : prefixMatcher.sortMatching(uniquesProcessor.getResults())) {
                if (!PhpCompletionUtil.collectAliasesByFQN(phpIndex, classKind, processor2, aliasFQN)) continue;
                return false;
            }
        } else {
            for (String name : classKind.getAliasesNames(phpIndex)) {
                classKind.getEntriesByName(phpIndex, name).forEach(arg_0 -> processor2.process(arg_0));
            }
        }
        return true;
    }

    private static boolean collectAliasesByFQN(@NotNull PhpIndex phpIndex, @NotNull PhpClassKind classKind, LimitedProcessor<PhpClass> processor2, String aliasFQN) {
        if (phpIndex == null) {
            PhpCompletionUtil.$$$reportNull$$$0(54);
        }
        if (classKind == null) {
            PhpCompletionUtil.$$$reportNull$$$0(55);
        }
        String fqn = StringUtil.toLowerCase((String)aliasFQN);
        Project project = phpIndex.getSearchScope().getProject();
        List aliasesByName = project != null ? PhpClassAliasIndex.getInstance((Project)project).getAllAliasesByName(PhpLangUtil.toShortName(fqn)) : Collections.emptyList();
        for (PhpClassAlias alias : phpIndex.filterByNamespace(aliasesByName, PhpIndexImpl.getNamespace(fqn))) {
            if (!classKind.accepts(alias) || processor2.process((PhpClass)alias)) continue;
            return true;
        }
        return false;
    }

    public static boolean addTraits(@NotNull PhpIndex phpIndex, @NotNull PrefixMatcher prefixMatcher, @NotNull Predicate<? super PhpClass> predicate, @NotNull Consumer<? super PhpClass> adder) {
        if (phpIndex == null) {
            PhpCompletionUtil.$$$reportNull$$$0(56);
        }
        if (prefixMatcher == null) {
            PhpCompletionUtil.$$$reportNull$$$0(57);
        }
        if (predicate == null) {
            PhpCompletionUtil.$$$reportNull$$$0(58);
        }
        if (adder == null) {
            PhpCompletionUtil.$$$reportNull$$$0(59);
        }
        return PhpCompletionUtil.addClassEntries(phpIndex, PhpClassKind.TRAIT, predicate, adder, prefixMatcher);
    }

    @NotNull
    public static PsiNamePatternCondition<PsiElement> getDocTagNamedPattern(String ... names) {
        if (names == null) {
            PhpCompletionUtil.$$$reportNull$$$0(60);
        }
        return new PsiNamePatternCondition<PsiElement>("withName", (ElementPattern)StandardPatterns.string().oneOf(names)){

            public String getPropertyValue(@NotNull Object o) {
                if (o == null) {
                    5.$$$reportNull$$$0(0);
                }
                return o instanceof PhpDocTag ? ((PhpDocTag)o).getName() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/php/completion/PhpCompletionUtil$5", "getPropertyValue"));
            }
        };
    }

    @NotNull
    public static Collection<PhpClass> getAllClasses(@Nullable PrefixMatcher matcher, @NotNull PhpIndex phpIndex) {
        if (phpIndex == null) {
            PhpCompletionUtil.$$$reportNull$$$0(61);
        }
        Collection collection = phpIndex.getAllClassFqns(matcher).stream().flatMap(fqn -> phpIndex.getClassesByFQN(fqn).stream()).collect(Collectors.toSet());
        if (collection == null) {
            PhpCompletionUtil.$$$reportNull$$$0(62);
        }
        return collection;
    }

    public static int getLimit() {
        return Registry.intValue((String)"ide.completion.variant.limit") / 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 34, 41, 62 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 28: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceFqn";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 33: 
            case 37: 
            case 42: 
            case 46: 
            case 51: 
            case 54: 
            case 56: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpIndex";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 34: 
            case 41: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceFQN";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorTextField";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 38: 
            case 45: 
            case 50: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 39: 
            case 43: 
            case 48: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 40: 
            case 44: 
            case 49: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adder";
                break;
            }
            case 47: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classKind";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChildNamespaceNames";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createPredicate";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageContext";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showCompletion";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addSubNamespaces";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNamespacePredicate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processNamespacesPrefixes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllChildNamespaceNames";
                break;
            }
            case 13: 
            case 34: 
            case 41: 
            case 62: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasNamespace";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "installAutoCompletionAfterNamespaceSeparator";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "installNamespaceCompletion";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "installClassCompletion";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "installClassInterfaceCompletion";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addClassCompletionVariants";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addClasses";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addClassLookupElement";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addInterfaces";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addClassEntries";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "collectAliasesByFQN";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addTraits";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getDocTagNamedPattern";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 34, 41, 62 -> new IllegalStateException(string);
        };
    }

    static final class LimitedProcessor<T>
    implements Processor<T> {
        private int myLimit;
        @NotNull
        private final Predicate<? super T> predicate;
        @NotNull
        private final Consumer<? super T> adder;

        public LimitedProcessor(@NotNull Predicate<? super T> predicate, @NotNull Consumer<? super T> adder) {
            if (predicate == null) {
                LimitedProcessor.$$$reportNull$$$0(0);
            }
            if (adder == null) {
                LimitedProcessor.$$$reportNull$$$0(1);
            }
            this.myLimit = PhpCompletionUtil.getLimit();
            this.predicate = predicate;
            this.adder = adder;
        }

        public boolean process(T value) {
            ProgressIndicatorProvider.checkCanceled();
            if (this.predicate.test(value)) {
                this.adder.accept(value);
                --this.myLimit;
            }
            return this.myLimit > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "predicate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "adder";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionUtil$LimitedProcessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpNamespaceSeparatorAppenderInsertHandler
    implements InsertHandler<LookupElement> {
        private static final InsertHandler<LookupElement> INSTANCE = new PhpNamespaceSeparatorAppenderInsertHandler();

        private PhpNamespaceSeparatorAppenderInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                PhpNamespaceSeparatorAppenderInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                PhpNamespaceSeparatorAppenderInsertHandler.$$$reportNull$$$0(1);
            }
            PhpInsertHandlerUtil.insertStringAtCaret(context, "\\");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionUtil$PhpNamespaceSeparatorAppenderInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpClassFullNameInsertHandler
    implements InsertHandler<LookupElement> {
        private static final InsertHandler<LookupElement> INSTANCE = new PhpClassFullNameInsertHandler();

        private PhpClassFullNameInsertHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Object object;
            if (context == null) {
                PhpClassFullNameInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                PhpClassFullNameInsertHandler.$$$reportNull$$$0(1);
            }
            if ((object = item.getObject()) instanceof PhpClass) {
                try {
                    String namespaceFQN = ((PhpClass)object).getNamespaceName();
                    String namespaceName = StringUtil.trimStart((String)namespaceFQN, (String)"\\");
                    context.getDocument().insertString(context.getStartOffset(), (CharSequence)namespaceName);
                }
                finally {
                    PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionUtil$PhpClassFullNameInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum PhpClassKind {
        CLASS{

            @Override
            Collection<String> getAllFqns(@NotNull PhpIndex index, PrefixMatcher prefixMatcher) {
                if (index == null) {
                    1.$$$reportNull$$$0(0);
                }
                return index.getAllClassFqns(prefixMatcher);
            }

            @Override
            Collection<String> getAliasesNames(@NotNull PhpIndex index) {
                if (index == null) {
                    1.$$$reportNull$$$0(1);
                }
                return index.getClassAliasesNames();
            }

            @Override
            Collection<PhpClass> getEntriesByFqn(PhpIndex index, String fqn) {
                return index.getClassesByFQN(fqn);
            }

            @Override
            Collection<PhpClass> getEntriesByName(PhpIndex index, String name) {
                return index.getClassesByName(name);
            }

            @Override
            boolean accepts(PhpClassAlias alias) {
                return !alias.isInterface() && !alias.isTrait();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "index";
                objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionUtil$PhpClassKind$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getAllFqns";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getAliasesNames";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        INTERFACE{

            @Override
            Collection<String> getAllFqns(@NotNull PhpIndex index, PrefixMatcher prefixMatcher) {
                if (index == null) {
                    2.$$$reportNull$$$0(0);
                }
                return index.getAllInterfacesFqns(prefixMatcher);
            }

            @Override
            Collection<String> getAliasesNames(@NotNull PhpIndex index) {
                if (index == null) {
                    2.$$$reportNull$$$0(1);
                }
                return index.getInterfaceAliasesNames();
            }

            @Override
            Collection<PhpClass> getEntriesByFqn(PhpIndex index, String fqn) {
                return index.getInterfacesByFQN(fqn);
            }

            @Override
            Collection<PhpClass> getEntriesByName(PhpIndex index, String name) {
                return index.getInterfacesByName(name);
            }

            @Override
            boolean accepts(PhpClassAlias alias) {
                return alias.isInterface();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "index";
                objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionUtil$PhpClassKind$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getAllFqns";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getAliasesNames";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        TRAIT{

            @Override
            Collection<String> getAllFqns(@NotNull PhpIndex index, @Nullable PrefixMatcher prefixMatcher) {
                if (index == null) {
                    3.$$$reportNull$$$0(0);
                }
                return ((PhpIndexImpl)index).getAllTraitsFqns(prefixMatcher);
            }

            @Override
            Collection<String> getAliasesNames(@NotNull PhpIndex index) {
                if (index == null) {
                    3.$$$reportNull$$$0(1);
                }
                return ((PhpIndexImpl)index).getTraitsAliasesNames();
            }

            @Override
            Collection<PhpClass> getEntriesByFqn(PhpIndex index, String fqn) {
                return index.getTraitsByFQN(fqn);
            }

            @Override
            Collection<PhpClass> getEntriesByName(PhpIndex index, String name) {
                return index.getTraitsByName(name);
            }

            @Override
            boolean accepts(PhpClassAlias alias) {
                return alias.isTrait();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "index";
                objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionUtil$PhpClassKind$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getAllFqns";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getAliasesNames";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        abstract Collection<String> getAllFqns(@NotNull PhpIndex var1, @Nullable PrefixMatcher var2);

        abstract Collection<String> getAliasesNames(@NotNull PhpIndex var1);

        abstract Collection<PhpClass> getEntriesByFqn(PhpIndex var1, String var2);

        abstract Collection<PhpClass> getEntriesByName(PhpIndex var1, String var2);

        abstract boolean accepts(PhpClassAlias var1);
    }

    private static class PhpNamespaceWithoutEndSeparatorInsertHandler
    implements InsertHandler<LookupElement> {
        private static final InsertHandler<LookupElement> INSTANCE = new PhpNamespaceWithoutEndSeparatorInsertHandler();

        private PhpNamespaceWithoutEndSeparatorInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Object qualifier;
            if (context == null) {
                PhpNamespaceWithoutEndSeparatorInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                PhpNamespaceWithoutEndSeparatorInsertHandler.$$$reportNull$$$0(1);
            }
            if ((qualifier = item.getObject()) instanceof String) {
                PhpInsertHandlerUtil.insertQualifier(context, (String)qualifier);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionUtil$PhpNamespaceWithoutEndSeparatorInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class PhpFullyQualifiedNameTextFieldCompletionProvider
    extends TextFieldCompletionProvider
    implements DumbAware {
        protected final void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (text == null) {
                PhpFullyQualifiedNameTextFieldCompletionProvider.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                PhpFullyQualifiedNameTextFieldCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpFullyQualifiedNameTextFieldCompletionProvider.$$$reportNull$$$0(2);
            }
            String namespaceName = PhpLangUtil.getParentQualifiedName(text.substring(0, offset));
            this.addCompletionVariants(namespaceName, prefix, result);
        }

        @NotNull
        protected final String getPrefix(@NotNull String currentTextPrefix) {
            if (currentTextPrefix == null) {
                PhpFullyQualifiedNameTextFieldCompletionProvider.$$$reportNull$$$0(3);
            }
            String string = PhpLangUtil.toShortName(currentTextPrefix);
            if (string == null) {
                PhpFullyQualifiedNameTextFieldCompletionProvider.$$$reportNull$$$0(4);
            }
            return string;
        }

        protected abstract void addCompletionVariants(@NotNull String var1, @NotNull String var2, @NotNull CompletionResultSet var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentTextPrefix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionUtil$PhpFullyQualifiedNameTextFieldCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionUtil$PhpFullyQualifiedNameTextFieldCompletionProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletionVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPrefix";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

