/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.CollectionPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.LineReader;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionDFAnalyzer;
import com.jetbrains.php.completion.ClassUsageContext;
import com.jetbrains.php.completion.CompletionResultSetWrapper;
import com.jetbrains.php.completion.PhpArgumentSetCompletionProvider;
import com.jetbrains.php.completion.PhpArrayIndexCompletionProvider;
import com.jetbrains.php.completion.PhpArrayShapeIndexCompletionProvider;
import com.jetbrains.php.completion.PhpClassAndMethodNamesInStringLiteralCompletionProvider;
import com.jetbrains.php.completion.PhpClassStaticMemberLookupElement;
import com.jetbrains.php.completion.PhpCompletionSorting;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.PhpDateRepresentationFormatCharactersCompletionProvider;
import com.jetbrains.php.completion.PhpFqnPrefixMatcher;
import com.jetbrains.php.completion.PhpFunctionNamesInStringLiteralCompletionProvider;
import com.jetbrains.php.completion.PhpGlobalsArrayIndexCompletionProvider;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.PhpObjectShapeCompletionProvider;
import com.jetbrains.php.completion.PhpOpenModeCharactersCompletionProvider;
import com.jetbrains.php.completion.PhpRegExpPatternModifierCompletionProvider;
import com.jetbrains.php.completion.PhpRegexpCapturedGroupNamesArrayIndexCompletionProvider;
import com.jetbrains.php.completion.PhpSmartFunctionParametersLookupElement;
import com.jetbrains.php.completion.PhpTestMockMethodCompletionProvider;
import com.jetbrains.php.completion.PhpUNameModeCompletionProvider;
import com.jetbrains.php.completion.PhpVariantsUtil;
import com.jetbrains.php.completion.UsageContext;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionArgumentLookupElement;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionCallArgumentLookupElement;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedInstanceMethodCallArgumentLookupElement;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedStaticMethodCallArgumentLookupElement;
import com.jetbrains.php.completion.insert.PhpCastTypeInsertHandler;
import com.jetbrains.php.completion.insert.PhpClassConstructorInsertHandler;
import com.jetbrains.php.completion.insert.PhpClassStaticInsertHandler;
import com.jetbrains.php.completion.insert.PhpDocTagInsertHandler;
import com.jetbrains.php.completion.insert.PhpDocVariableInsertHandler;
import com.jetbrains.php.completion.insert.PhpFunctionInsertHandler;
import com.jetbrains.php.completion.insert.PhpNamedElementInStringLiteralInsertHandler;
import com.jetbrains.php.completion.insert.PhpNamespaceInsertHandler;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.completion.insert.PhpTypeReferenceInsertHandler;
import com.jetbrains.php.completion.insert.PhpVariableInsertHandler;
import com.jetbrains.php.completion.phpunit.PhpUnitCoversClassInsertHandler;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugRuntimeEnvironment;
import com.jetbrains.php.injection.PhpInjectionUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpUnitDataProviderAttributeReferenceContributor;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.PhpDocLinkResolver;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocCoversTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocDataProviderTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocExpectedExceptionTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLangTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocThrowsTag;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMethodInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpClassCantBeUsedAsAttributeInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpInapplicableAttributeTargetDeclarationInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.PhpTypeCodeFragment;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpCallableMethod;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpGoto;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclarationOwner;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpCloneImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpGotoImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpMatchExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpDocTagNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFlatCollectionIndexBase;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPutEnvArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsRegistry;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedReturnValuesIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.util.PhpStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final String PHP_OPENING_TAG_LOOKUP_STRING = "php";
    private static final PatternCondition<PsiElement> CONSTRUCTOR_PATTERN = new PatternCondition<PsiElement>("constructor"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return element instanceof Method && ((Method)element).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionContributor$1", "accepts"));
        }
    };
    private static final PatternCondition<VirtualFile> META_FILE_PATTERN = new PatternCondition<VirtualFile>("isPhpstormMetaFile"){

        public boolean accepts(@NotNull VirtualFile file, ProcessingContext context) {
            if (file == null) {
                2.$$$reportNull$$$0(0);
            }
            return PhpParameterBasedTypeProvider.isMeta(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/completion/PhpCompletionContributor$2", "accepts"));
        }
    };
    private static final PhpClassRefCompletionProvider PHP_CLASS_REF_COMPLETION_PROVIDER = new PhpClassRefCompletionProvider();
    private static final PhpFuncRefCompletionProvider PHP_FUNC_REF_COMPLETION_PROVIDER = new PhpFuncRefCompletionProvider();
    @NonNls
    public static final SortedSet<String> PHP_PREDEFINED_FUNCTIONS = new TreeSet<String>();
    private static final Condition<PsiElement> CHILD_OF_FOREACH = element -> element.getParent() instanceof ForeachStatement;
    public static final PatternCondition<FunctionReference> GETENV_FUNCTION_REFERENCE = new PatternCondition<FunctionReference>("withGetEnvFunction"){

        public boolean accepts(@NotNull FunctionReference functionReference, ProcessingContext context) {
            if (functionReference == null) {
                3.$$$reportNull$$$0(0);
            }
            return PhpLangUtil.equalsClassNames("getenv", functionReference.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "com/jetbrains/php/completion/PhpCompletionContributor$3", "accepts"));
        }
    };
    private static final PsiElementPattern.Capture<PsiElement> INSIDE_GETENV_ARGUMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class)).withSuperParent(2, ParameterList.class)).withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement(FunctionReference.class).with(GETENV_FUNCTION_REFERENCE));
    private static final PatternCondition<PsiElement> VERSION_COMPARE_ARGUMENT = new PatternCondition<PsiElement>("phpVersionCompareArgument"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                4.$$$reportNull$$$0(0);
            }
            return PhpCompletionContributor.isVersionCompareVersionArgument(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionContributor$4", "accepts"));
        }
    };
    private static final String[] castTypesStrings;
    private static final String[] typeDeclarationsStrings;
    private static final String[] phpDocTypesStrings;
    private static final String[] functags;
    private static final String[] classtags;
    private static final String[] vartags;
    private static final String[] everywheretags;
    private static final String @NlsSafe [] phpunittags;
    private static final String[] traitSpecificDocTags;
    private static final Collection<String> possibleInlineDocTags;

    private static void readFileToSet(@NotNull String filename, @NotNull Set<String> set) {
        if (filename == null) {
            PhpCompletionContributor.$$$reportNull$$$0(0);
        }
        if (set == null) {
            PhpCompletionContributor.$$$reportNull$$$0(1);
        }
        InputStream predefined = null;
        try {
            predefined = PhpCompletionContributor.class.getResourceAsStream(filename);
            if (predefined != null) {
                LineReader lineReader = new LineReader(predefined);
                List list = lineReader.readLines();
                for (byte[] bytes : list) {
                    set.add(new String(bytes, StandardCharsets.UTF_8));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (predefined != null) {
                try {
                    predefined.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void addCastTypes(@NotNull CompletionResultSet result) {
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(2);
        }
        PhpCastTypeInsertHandler insertHandler = PhpCastTypeInsertHandler.getInstance();
        for (String type : castTypesStrings) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)type).withPresentableText("(" + type + ")").withInsertHandler((InsertHandler)insertHandler));
        }
    }

    private static void addTypeDeclarations(@NotNull Project project, @NotNull CompletionResultSet result, @NotNull PhpTypeDeclaration position, @Nullable PhpClass currentClass, boolean superClassExists) {
        if (project == null) {
            PhpCompletionContributor.$$$reportNull$$$0(3);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(4);
        }
        if (position == null) {
            PhpCompletionContributor.$$$reportNull$$$0(5);
        }
        boolean isTypeCodeFragment = position.getContainingFile() instanceof PhpTypeCodeFragment;
        Field field = (Field)PhpPsiUtil.getChildByCondition(position.getParent(), (Condition<? super PsiElement>)((Condition)Field.class::isInstance));
        if (field != null && !field.getModifier().isStatic()) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)"static").withBoldness(true).withInsertHandler((InsertHandler)PhpTypeReferenceInsertHandler.getInstance()));
        }
        for (String declaration : typeDeclarationsStrings) {
            if (isTypeCodeFragment && (PhpLangUtil.isReturnTypeHint(declaration, project) || PhpUndefinedClassInspection.canBeUsedInTypeDeclaration(position, declaration) || "self".equalsIgnoreCase(declaration) || "parent".equalsIgnoreCase(declaration))) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)declaration).withBoldness(true));
                continue;
            }
            if (!PhpUndefinedClassInspection.isSuitableTypeDeclarationForPosition(project, position, declaration) && !PhpUndefinedClassInspection.canBeUsedInTypeDeclaration(position, declaration) && (!"self".equalsIgnoreCase(declaration) || currentClass == null) && (!"parent".equalsIgnoreCase(declaration) || !superClassExists)) continue;
            result.addElement((LookupElement)LookupElementBuilder.create((String)declaration).withBoldness(true).withInsertHandler((InsertHandler)PhpTypeReferenceInsertHandler.getInstance()));
        }
    }

    public static void addPhpDocTypes(@NotNull CompletionResultSet result) {
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(6);
        }
        for (String type : phpDocTypesStrings) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)type).withBoldness(true));
        }
    }

    public PhpCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class), new PhpOpenModeCharactersCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class), new PhpUNameModeCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(ClassReference.class)).withSuperParent(2, Catch.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(ClassReference.class)).withSuperParent(2, Catch.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, PhpThrowExpression.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, PhpThrowExpression.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocExpectedExceptionTag.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocExpectedExceptionTag.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocThrowsTag.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocThrowsTag.class), new PhpExceptionCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(Variable.class)).withSuperParent(2, Catch.class), new PhpCatchVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpReference.class), new PhpOpeningTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ArrayIndex.class), new PhpArrayIndexCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ArrayIndex.class), new PhpArrayShapeIndexCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(FieldReference.class), new PhpObjectShapeCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ArrayIndex.class), new PhpRegexpCapturedGroupNamesArrayIndexCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ArrayIndex.class), new PhpGlobalsArrayIndexCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpElementTypes.ARRAY_KEY)), new PhpArrayShapeIndexCompletionProvider.PhpArrayShapeInLiteralCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpElementTypes.ARRAY_VALUE).withParent(ArrayCreationExpression.class)), new PhpArrayShapeIndexCompletionProvider.PhpArrayShapeInLiteralCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PhpReference.class).andNot((ElementPattern)PlatformPatterns.psiElement(Variable.class))), new PhpNamespaceCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpDocRef.class), new PhpNamespaceCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class), new PhpGlobalVariableCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpCompletionContributor.compactFunctionCallArgument()), new PhpVariableCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpCompletionContributor.compactFunctionCallArgument()), new PhpVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(Variable.class), new PhpVariableCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(Variable.class), new PhpVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement((IElementType)PhpElementTypes.EQUALITY_EXPRESSION), PlatformPatterns.psiElement((IElementType)PhpElementTypes.BIT_EXPRESSION)})), new PhpExpectedReturnValuesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PhpCase.class)), new PhpExpectedReturnValuesInStatementWithArgumentCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PhpReturn.class)), new PhpExpectedReturnValuesInStatementWithArgumentCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PhpMatchArm.class)), new PhpExpectedReturnValuesInMatchExpressionCompletionProvider());
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withSuperParent(2, ParameterList.class), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpElementTypes.BIT_EXPRESSION))).withSuperParent(3, ParameterList.class)}), new PhpExpectedFunctionArgumentsCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(AssignmentExpression.class)), new PhpExpectedPropertyValuesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(BinaryExpression.class)), new PhpExpectedPropertyValuesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)INSIDE_GETENV_ARGUMENT, new PhpGetEnvArgumentCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(MemberReference.class), new PhpMemberRefCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpCallableMethod.class), new PhpMemberRefCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(MemberReference.class), new PhpMemberRefCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpMemberRefCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpMemberRefCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpQualifiedFunctionAndConstantCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpQualifiedFunctionAndConstantCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(1, PhpDocPsiElement.class), new PhpDocCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpDocTokenTypes.DOC_IDENTIFIER).withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpDocElementTypes.phpDocTagValue)), new PhpDocCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocDataProviderTag.class), new PhpDataProviderTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocCoversTag.class), new PhpCoversTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PhpDocTag.class).with(PhpCompletionUtil.getDocTagNamedPattern("@coversDefaultClass"))), new PhpCoversTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocLangTag.class), new PhpLangTagCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(FunctionReference.class), PHP_FUNC_REF_COMPLETION_PROVIDER);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpNamespace.class), new PhpNamespaceCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpGoto.class), new PhpGotoLabelCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(Parameter.class), new TypeHintSuggestionsProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(Field.class), new TypeHintSuggestionsProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(Parameter.class), new PhpParameterNameFromDocTagsProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)PhpElementTypes.CLASS_REFERENCE).beforeLeaf((ElementPattern)StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement((IElementType)PhpTokenTypes.VARIABLE)))), new PhpParameterNameFromDocTagsProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(Parameter.class)).withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement().with(CONSTRUCTOR_PATTERN)), new PhpFieldNamesForConstructorParametersCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ForeachStatement.class), new PhpForeachKeyAndValueCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(3, ForeachStatement.class), new PhpForeachKeyAndValueCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement(StringLiteralExpression.class)))).withSuperParent(2, ParenthesizedExpression.class), new PhpCastCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ParameterList.class), new PhpSmartFunctionParametersCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)PhpTokenTypes.IDENTIFIER).withParent(PhpClass.class), new PhpClassNameByFileNameCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class), new PhpStringLiteralClassesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class), new PhpRegExpPatternModifierCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(StringLiteralExpression.class)), new PhpFunctionNamesInStringLiteralCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(2, ParameterList.class)).inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().with(META_FILE_PATTERN)), new PhpArgumentSetCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class)).withSuperParent(3, PhpCompletionContributor.functionCallArgument((PsiElementPattern.Capture<? extends PsiElement>)PlatformPatterns.psiElement(ArrayCreationExpression.class))), new PhpClassAndMethodNamesInStringLiteralCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class), new PhpClassAndMethodNamesInStringLiteralCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class), new PhpTestMockMethodCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class)).with(VERSION_COMPARE_ARGUMENT), new PhpVersionsCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class), new PhpDateRepresentationFormatCharactersCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpReference.class), new PhpGlobalCompletionProviderFacade());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpReference.class), new PhpGlobalCompletionProviderFacade());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpUndeclaredVariableCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(ConstantReference.class), new PhpUndeclaredVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(Variable.class), new PhpUndeclaredVariableCompletionProvider());
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().withParent(Variable.class), new PhpUndeclaredVariableCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class), new PhpCloneWithPropertiesCompletionProvider());
    }

    @NotNull
    private static PsiElementPattern.Capture<StringLiteralExpression> compactFunctionCallArgument() {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)PlatformPatterns.psiElement(StringLiteralExpression.class).with((PatternCondition)new PatternCondition<StringLiteralExpression>("compact function call argument"){

            public boolean accepts(@NotNull StringLiteralExpression expression, ProcessingContext context) {
                if (expression == null) {
                    5.$$$reportNull$$$0(0);
                }
                return PhpControlFlowBuilder.isCompactFunctionVariable(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/php/completion/PhpCompletionContributor$5", "accepts"));
            }
        });
        if (capture == null) {
            PhpCompletionContributor.$$$reportNull$$$0(7);
        }
        return capture;
    }

    private static PsiElementPattern.Capture<? extends PsiElement> functionCallArgument(PsiElementPattern.Capture<? extends PsiElement> patter) {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)patter.withParent(ParameterList.class)).withSuperParent(2, FunctionReference.class);
    }

    private static PsiElementPattern.Capture<? extends PsiElement> methodRefInArray() {
        CollectionPattern collection = StandardPatterns.collection(PsiElement.class);
        CollectionPattern firstIsRef = collection.first((ElementPattern)PlatformPatterns.psiElement().withChild((ElementPattern)PlatformPatterns.psiElement(PhpReference.class)));
        PsiElementPattern.Capture arrayCreationWithFirstRef = (PsiElementPattern.Capture)PlatformPatterns.psiElement(ArrayCreationExpression.class).withChildren((ElementPattern)collection.filter((ElementPattern)PlatformPatterns.psiElement(PhpPsiElement.class), (ElementPattern)firstIsRef));
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class)).withSuperParent(3, (ElementPattern)arrayCreationWithFirstRef);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement prevElement;
        PsiFile file;
        PsiElement currElement;
        PhpExpression expression;
        if (context == null) {
            PhpCompletionContributor.$$$reportNull$$$0(8);
        }
        if ((expression = (PhpExpression)ObjectUtils.tryCast((Object)TargetElementUtil.findReference((Editor)context.getEditor(), (int)context.getSelectionEndOffset()), PhpExpression.class)) != null && expression.getParent() instanceof StringLiteralExpression && PhpPsiUtil.isOfType(expression.getLastChild(), PhpTokenTypes.chRBRACE)) {
            context.setReplacementOffset(context.getSelectionEndOffset());
        } else if (expression instanceof MemberReference && (currElement = (file = context.getFile()).findElementAt(context.getSelectionEndOffset())) instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)currElement.getText()) > 0 && PhpPsiUtil.isOfType(prevElement = file.findElementAt(context.getSelectionEndOffset() - 1), PhpTokenTypes.ARROW)) {
            context.setReplacementOffset(context.getSelectionEndOffset());
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpCompletionContributor.$$$reportNull$$$0(9);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(10);
        }
        super.fillCompletionVariants(parameters, PhpCompletionSorting.addPhpSorting(parameters, result));
    }

    @NotNull
    public static Collection<PsiElement> unwrapOperands(@NotNull BinaryExpression expression) {
        if (expression == null) {
            PhpCompletionContributor.$$$reportNull$$$0(11);
        }
        SmartList result = new SmartList();
        PsiElement left = expression.getLeftOperand();
        if (left instanceof BinaryExpression) {
            result.addAll(PhpCompletionContributor.unwrapOperands((BinaryExpression)left));
        } else {
            ContainerUtil.addIfNotNull((Collection)result, (Object)left);
        }
        PsiElement right = expression.getRightOperand();
        if (right instanceof BinaryExpression) {
            result.addAll(PhpCompletionContributor.unwrapOperands((BinaryExpression)right));
        } else {
            ContainerUtil.addIfNotNull((Collection)result, (Object)right);
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpCompletionContributor.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    public static boolean inAttribute(PsiElement element) {
        return PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)PhpAttribute.class::isInstance), (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
    }

    private static Collection<String> findMethodsNamesFromDfa(@NotNull PhpExpression classReference) {
        PhpAccessInstruction instruction;
        PhpMethodExistsNameFinder analyzer;
        PhpUndefinedMethodInspection.Reachability reachability;
        if (classReference == null) {
            PhpCompletionContributor.$$$reportNull$$$0(13);
        }
        String methodName = (reachability = PhpUndefinedMethodInspection.performReachingDefinition(analyzer = new PhpMethodExistsNameFinder(classReference), (PhpInstruction)(instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)classReference, PhpAccessInstruction.class)))) != PhpUndefinedMethodInspection.Reachability.UNDEFINED ? analyzer.myFoundMethodName : null;
        HashSet<String> res = new HashSet<String>();
        ContainerUtil.addIfNotNull(res, (Object)methodName);
        res.addAll(PhpUndefinedMethodInspection.findMethodsFromPhpUnitMockBuilder((PhpAccessVariableInstruction)ObjectUtils.tryCast((Object)instruction, PhpAccessVariableInstruction.class)));
        return res;
    }

    public static Collection<LookupElement> getMethodsNamesFromDfa(@Nullable PhpExpression classReference, Collection<? super String> visitedMethodNames) {
        ArrayList<LookupElement> res = new ArrayList<LookupElement>();
        if (classReference != null) {
            for (String methodName : PhpCompletionContributor.findMethodsNamesFromDfa(classReference)) {
                if (!visitedMethodNames.add(methodName)) continue;
                res.add((LookupElement)LookupElementBuilder.create((String)methodName).withIcon(PhpIcons.METHOD));
            }
        }
        return res;
    }

    public static boolean isVersionCompareVersionArgument(@NotNull PsiElement position) {
        PsiElement functionCall;
        PsiElement argument;
        PsiElement parent;
        if (position == null) {
            PhpCompletionContributor.$$$reportNull$$$0(14);
        }
        return (parent = (argument = position.getParent()).getParent()) instanceof ParameterList && (functionCall = parent.getParent()) instanceof FunctionReference && PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)functionCall, "version_compare") && (((FunctionReference)functionCall).getParameter(0) == argument || ((FunctionReference)functionCall).getParameter(1) == argument);
    }

    static PsiElement findPrevElement(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpCompletionContributor.$$$reportNull$$$0(15);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(16);
        }
        return parameters.getOriginalFile().findElementAt(parameters.getOffset() - 1 - result.getPrefixMatcher().getPrefix().length());
    }

    @Nullable
    public static PhpClass findAnonymousClass(PsiElement position, String anonymousClassFqn) {
        int anonymousClassOffset = Integer.parseInt(anonymousClassFqn.substring("__anonymous@".length()));
        return (PhpClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)position.getContainingFile(), (int)anonymousClassOffset, PhpClass.class, (boolean)true);
    }

    @NotNull
    private static Collection<PhpClass> findClasses(PhpExpression classReference, String fqn, PhpIndex index) {
        PhpClass containingClass;
        if (PhpLangUtil.isThisReference((PsiElement)classReference) && (containingClass = PhpClassImpl.getContainingClass((PsiElement)classReference)) != null && PhpLangUtil.equalsClassNames(containingClass.getFQN(), fqn)) {
            Set<PhpClass> set = Collections.singleton(containingClass);
            if (set == null) {
                PhpCompletionContributor.$$$reportNull$$$0(17);
            }
            return set;
        }
        LinkedHashSet<PhpClass> phpClasses = new LinkedHashSet<PhpClass>(index.getAnyByFQN(fqn));
        phpClasses.addAll(PhpLangUtil.getLocalClasses((PsiElement)classReference, fqn));
        LinkedHashSet<PhpClass> linkedHashSet = phpClasses;
        if (linkedHashSet == null) {
            PhpCompletionContributor.$$$reportNull$$$0(18);
        }
        return linkedHashSet;
    }

    @Nullable
    static ClassReference getTraitReference(@NotNull PhpTraitUseRule traitUseRule) {
        PsiElement classReference;
        MethodReference methodReference;
        if (traitUseRule == null) {
            PhpCompletionContributor.$$$reportNull$$$0(19);
        }
        if ((methodReference = traitUseRule.getOriginalReference()) != null && (classReference = methodReference.getFirstChild()) instanceof ClassReference) {
            return (ClassReference)classReference;
        }
        return null;
    }

    private static void fillContextByPosition(UsageContext usageContext, PsiElement position, PhpClass containingClass) {
        Method method = PhpPsiUtil.getParentOfClass(position, true, Method.class);
        usageContext.setScope(method != null ? method.getModifier().getState() : null);
        usageContext.setTargetObjectClass(containingClass);
        usageContext.setClassForAccessFilter(containingClass);
        usageContext.setHavePredecessorClassReference(false);
        usageContext.setInAttribute(PhpCompletionContributor.inAttribute(position));
    }

    public static void handleOverflow(CompletionResultSet set) {
        set.restartCompletionOnAnyPrefixChange();
        set.addLookupAdvertisement(AnalysisBundle.message((String)"completion.not.all.variants.are.shown", (Object[])new Object[0]));
    }

    private static boolean isInInterface(@Nullable PsiElement position) {
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
        return containingClass != null && containingClass.isInterface();
    }

    private static boolean shouldAddClass(@NotNull PhpClass aClass, @NotNull ClassUsageContext context, @Nullable PhpClass current) {
        if (aClass == null) {
            PhpCompletionContributor.$$$reportNull$$$0(20);
        }
        if (context == null) {
            PhpCompletionContributor.$$$reportNull$$$0(21);
        }
        if (aClass.isInterface() || aClass.isTrait() || aClass.isEnum()) {
            return false;
        }
        String currentFqn = current != null ? current.getFQN() : null;
        String itemFqn = aClass.getFQN();
        if (current != null && (context.isInExtends() || context.isInImplements()) && PhpLangUtil.equalsClassNames(currentFqn, itemFqn) || itemFqn.startsWith("\\___PHPSTORM_HELPERS")) {
            return false;
        }
        return !context.isInExtends() && !context.isInImplements() || (current != null || !aClass.isReadonly()) && (current == null || aClass.isReadonly() == current.isReadonly());
    }

    private static boolean shouldAddEnum(@NotNull PhpClass aClass, @NotNull ClassUsageContext context) {
        if (aClass == null) {
            PhpCompletionContributor.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PhpCompletionContributor.$$$reportNull$$$0(23);
        }
        if (!aClass.isEnum()) {
            return false;
        }
        return !context.isInExtends() && !context.isInImplements() && !context.isInNew();
    }

    public static boolean isSuitableForPhpDocMethodType(PsiElement position) {
        return position instanceof PhpDocMethod && !PhpPsiUtil.isOfType((PsiElement)((PhpDocMethod)position).getPrevPsiSibling(), (IElementType)PhpDocElementTypes.phpDocMethodType);
    }

    private static Collection<PhpUse> getUses(PsiElement position) {
        PhpUseList useList = PhpUseImpl.getUseList(position);
        if (useList != null && !useList.isTraitImport()) {
            return Collections.emptyList();
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(position);
        if (scope == null) {
            return Collections.emptyList();
        }
        SmartList uses = new SmartList();
        for (PhpUseList list : PhpCodeInsightUtil.collectImports(scope)) {
            for (PhpUse use : list.getDeclarations()) {
                String name = use.getName();
                if (StringUtil.isEmpty((String)name)) continue;
                uses.add(use);
            }
        }
        return uses;
    }

    @Nullable
    public static String createDocParamPresentation(PhpDocParamTag paramTag) {
        Function function;
        PhpDocComment docComment = PhpPsiUtil.getParentOfClass((PsiElement)paramTag, PhpDocComment.class);
        Function function2 = function = docComment != null ? (Function)ObjectUtils.tryCast((Object)docComment.getOwner(), Function.class) : null;
        if (function == null) {
            return null;
        }
        String name = paramTag.getVarName();
        Parameter actualParameter = (Parameter)ContainerUtil.find((Object[])function.getParameters(), parameter -> parameter.getName().equalsIgnoreCase(name));
        if (actualParameter == null) {
            return null;
        }
        boolean variadic = actualParameter.isVariadic();
        PhpType paramType = PhpDocUtil.getParameterType(actualParameter);
        if (paramType == null || paramType.isEmpty()) {
            return null;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)function);
        String parameterName = actualParameter.getName();
        if (variadic) {
            PhpType elementType = paramType.elementType();
            return String.format("%s ...$%s", PhpDocUtil.getTypePresentation(paramTag.getProject(), elementType, scope, actualParameter.getTypeDeclaration()), parameterName);
        }
        return String.format("%s $%s", PhpDocUtil.getTypePresentation(paramTag.getProject(), paramType, scope, actualParameter.getTypeDeclaration()), parameterName);
    }

    public static boolean afterPhpDocRefAndStaticModifier(PsiElement position, PsiElement parent) {
        return parent instanceof PhpDocRef && PhpPsiUtil.isOfType(position.getPrevSibling(), PhpDocTokenTypes.DOC_STATIC);
    }

    public static List<LookupElement> collectMembersOfClassByDocRef(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, PsiElement position, PsiElement parent, boolean addFields) {
        if (parameters == null) {
            PhpCompletionContributor.$$$reportNull$$$0(24);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(25);
        }
        SmartList members = new SmartList();
        for (PhpDocLinkResolver.Result element : PhpDocLinkResolver.resolve(parent.getText(), position)) {
            PhpClass phpClass = element.getPhpClass();
            if (phpClass == null) continue;
            boolean includeMagic = parameters.getInvocationCount() > 1;
            members.addAll(PhpVariantsUtil.getLookupItems(phpClass.getMethods(), includeMagic, null));
            if (!addFields) continue;
            members.addAll(PhpVariantsUtil.getLookupItems(phpClass.getFields(), includeMagic, null));
        }
        return members;
    }

    public static void addClassesAndFunctions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpCompletionContributor.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PhpCompletionContributor.$$$reportNull$$$0(27);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(28);
        }
        PHP_CLASS_REF_COMPLETION_PROVIDER.addCompletions(parameters, context, result);
        PHP_FUNC_REF_COMPLETION_PROVIDER.addCompletions(parameters, context, result);
    }

    @NotNull
    private static CompletionResultSet patchResultIfNeeded(@NotNull CompletionResultSet result) {
        String prefix;
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(29);
        }
        if ((prefix = result.getPrefixMatcher().getPrefix()).startsWith("${")) {
            result = result.withPrefixMatcher(prefix.substring(2));
        } else if (prefix.startsWith("{$")) {
            result = result.withPrefixMatcher(prefix.substring(2));
        } else if (prefix.startsWith("$")) {
            result = result.withPrefixMatcher(prefix.substring(1));
        }
        CompletionResultSet completionResultSet = result;
        if (completionResultSet == null) {
            PhpCompletionContributor.$$$reportNull$$$0(30);
        }
        return completionResultSet;
    }

    static boolean isGlobal(PsiElement position) {
        PsiElement sibling;
        Variable variable = (Variable)PhpPsiUtil.getParentByCondition(position, false, (Condition<? super PsiElement>)Variable.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (variable != null && variable.getParent() instanceof Global && PhpPsiUtil.findNextSiblingOfAnyType(variable.getFirstChild(), PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE) == null) {
            return true;
        }
        Statement statement = (Statement)PhpPsiUtil.getParentByCondition(position, false, (Condition<? super PsiElement>)Statement.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        return statement != null && (sibling = statement.getPrevSibling()) instanceof Global && !PhpPsiUtil.isOfType(sibling.getLastChild(), PhpTokenTypes.opSEMICOLON);
    }

    private static boolean isList(PsiElement position) {
        MultiassignmentExpression list = (MultiassignmentExpression)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)MultiassignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        return list != null && !PsiTreeUtil.isAncestor((PsiElement)list.getValue(), (PsiElement)position, (boolean)true);
    }

    private static Collection<String> suggestNames(@NotNull PsiElement element, @Nullable PsiElement context) {
        if (element == null) {
            PhpCompletionContributor.$$$reportNull$$$0(31);
        }
        HashSet<String> result = new HashSet<String>();
        NameSuggestionProvider.suggestNames((PsiElement)element, (PsiElement)context, result);
        return result;
    }

    static boolean isNamespace(PsiElement prev) {
        return prev instanceof PhpNamespaceReference || PhpPsiUtil.isOfType(prev, PhpTokenTypes.NAMESPACE_RESOLUTION) && PhpPsiUtil.isOfType(prev.getPrevSibling(), PhpTokenTypes.kwNAMESPACE);
    }

    @Nullable
    private static String getNamespace(PsiElement prev, PsiElement parent) {
        if (prev instanceof PhpNamespaceReference) {
            return ((PhpNamespaceReference)prev).getFullName();
        }
        if (parent instanceof PhpReference) {
            return ((PhpReference)parent).getNamespaceName();
        }
        return null;
    }

    private static void addFunctionVariants(@NotNull Project project, PsiElement grandParent, @Nullable String namespaceName, @NotNull CompletionResultSetWrapper result, CompletionParameters parameters, boolean filterSpecialReferences) {
        if (project == null) {
            PhpCompletionContributor.$$$reportNull$$$0(32);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(33);
        }
        if (grandParent instanceof PhpUse && !PhpUseImpl.isOfFunction((PhpUse)grandParent)) {
            return;
        }
        if (PhpCompletionContributor.inAttribute(grandParent)) {
            return;
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
        int limit = PhpCompletionUtil.getLimit();
        Collection<String> fqn = PhpCompletionContributor.isDefaultValue(grandParent) ? Collections.singleton("array") : PhpCompletionContributor.getAllFunctionFQNs(project, result);
        PhpNamespace namespace = PhpPsiUtil.getParentOfClass(parameters.getPosition(), PhpNamespace.class);
        String metaNamespace = StringUtil.trimEnd((String)"\\PHPSTORM_META\\", (char)'\\');
        boolean insideMetaNamespace = namespace != null && PhpLangUtil.equalsNamespaceNames(namespace.getFQN(), metaNamespace);
        for (String functionName : fqn) {
            if (namespaceName != null) {
                functions = ContainerUtil.map((Collection)phpIndex.getFunctionsByFQN(namespaceName + functionName), function -> PhpVariantsUtil.getLookupItem((PhpNamedElement)function, null));
                result.addAllElements(functions);
                limit -= functions.size();
            } else if (!filterSpecialReferences || !PhpReferenceInsertHandler.SPECIAL_REFERENCES.contains(functionName)) {
                functions = phpIndex.getFunctionsByName(functionName).stream().filter(e -> insideMetaNamespace || !PhpLangUtil.equalsClassNames(e.getNamespaceName(), "\\PHPSTORM_META\\")).map(function -> PhpVariantsUtil.getLookupItem((PhpNamedElement)function, null)).collect(Collectors.toList());
                result.addAllElements(functions);
                limit -= functions.size();
            }
            if (limit > 0) continue;
            PhpCompletionContributor.handleOverflow(result.getResult());
            break;
        }
        if (parameters.getInvocationCount() > 1) {
            PhpCompletionContributor.addAllClassesStaticMembers(result, parameters, phpIndex, false);
        }
    }

    private static Collection<String> getAllFunctionFQNs(@NotNull Project project, @NotNull CompletionResultSetWrapper result) {
        if (project == null) {
            PhpCompletionContributor.$$$reportNull$$$0(34);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(35);
        }
        CollectFilteredUniquesProcessor processor2 = new CollectFilteredUniquesProcessor(result.getPrefixMatcher());
        FileBasedIndex.getInstance().processAllKeys(PhpFunctionNameIndex.KEY, (Processor)processor2, project);
        return result.getPrefixMatcher().sortMatching(processor2.getResults());
    }

    public static boolean isDefaultValue(PsiElement grandParent) {
        return PhpPsiUtil.getParentByCondition(grandParent, false, (Condition<? super PsiElement>)((Condition)PhpCompletionContributor::insideDefaultValue), (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
    }

    private static boolean insideDefaultValue(PsiElement p) {
        return PhpPsiUtil.isOfType(p, PhpElementTypes.PARAMETER_DEFAULT_VALUE) || p instanceof Field || p instanceof PhpEnumCase;
    }

    private static void addConstantVariants(@NotNull Project project, @Nullable String namespaceName, @NotNull CompletionResultSetWrapper result, CompletionParameters parameters, boolean filterSpecialReferences) {
        if (project == null) {
            PhpCompletionContributor.$$$reportNull$$$0(36);
        }
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(37);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
        int limit = PhpCompletionUtil.getLimit();
        CollectFilteredUniquesProcessor processor2 = new CollectFilteredUniquesProcessor(result.getPrefixMatcher());
        FileBasedIndex.getInstance().processAllKeys(PhpConstantNameIndex.KEY, (Processor)processor2, project);
        List resultWithKeywordsFirst = ContainerUtil.sorted((Collection)processor2.getResults(), Comparator.comparing(e -> !PhpLangUtil.isBuiltInConstant(e, project)));
        for (String constantName : result.getPrefixMatcher().sortMatching((Collection)resultWithKeywordsFirst)) {
            if (namespaceName != null) {
                for (LookupElement element : PhpVariantsUtil.getLookupItems(phpIndex.getConstantsByFQN(namespaceName + constantName), true, null)) {
                    result.addElement(element);
                    if (--limit > 0) continue;
                    PhpCompletionContributor.handleOverflow(result.getResult());
                    return;
                }
                continue;
            }
            if (filterSpecialReferences && PhpReferenceInsertHandler.SPECIAL_REFERENCES.contains(constantName)) continue;
            for (LookupElement element : PhpVariantsUtil.getLookupItems(phpIndex.getConstantsByName(constantName), true, null)) {
                result.addElement(element);
                if (--limit > 0) continue;
                PhpCompletionContributor.handleOverflow(result.getResult());
                return;
            }
        }
        if (parameters.getInvocationCount() > 1) {
            PhpCompletionContributor.addAllClassesStaticMembers(result, parameters, phpIndex, true);
        }
    }

    private static void addAllClassesStaticMembers(@NotNull CompletionResultSetWrapper result, CompletionParameters parameters, PhpIndex phpIndex, boolean fields) {
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(38);
        }
        UsageContext usageContext = PhpCompletionContributor.getContext(parameters);
        for (String classFqn : phpIndex.getAllClassFqns(null)) {
            for (PhpClass aClass : phpIndex.getClassesByFQN(classFqn)) {
                List<Field> members = Arrays.asList(fields ? aClass.getOwnFields() : aClass.getOwnMethods());
                for (PhpClassMember phpClassMember : members) {
                    if (!PhpCompletionContributor.accessibleStaticMember(usageContext, phpClassMember, members)) continue;
                    result.addElement(new PhpClassStaticMemberLookupElement(phpClassMember));
                }
            }
        }
        if (fields) {
            for (String fqn : phpIndex.getAllInterfacesFqns(null)) {
                for (PhpClass anInterface : phpIndex.getInterfacesByFQN(fqn)) {
                    List<Field> ownFields = Arrays.asList(anInterface.getOwnFields());
                    for (Field field : ownFields) {
                        if (!PhpCompletionContributor.accessibleStaticMember(usageContext, (PhpClassMember)field, ownFields)) continue;
                        result.addElement(new PhpClassStaticMemberLookupElement((PhpClassMember)field));
                    }
                }
            }
        }
    }

    public static boolean accessibleStaticMember(UsageContext usageContext, PhpClassMember classMember, Collection<? extends PhpNamedElement> allElements) {
        return classMember.getModifier().isStatic() && (!(classMember instanceof Field) || ((Field)classMember).isConstant()) && PhpVariantsUtil.shouldAdd((PhpNamedElement)classMember, usageContext, allElements, false);
    }

    @Nullable
    private static String getNamespaceNameForGroupUse(@NotNull PsiElement position) {
        PhpNamespaceReference namespaceReference;
        PhpUseList useList;
        if (position == null) {
            PhpCompletionContributor.$$$reportNull$$$0(39);
        }
        if ((useList = PhpUseImpl.getUseList(position)) != null && (namespaceReference = useList.getNamespaceReference()) != null) {
            return PhpLangUtil.toFQN(namespaceReference.getFullName());
        }
        return null;
    }

    static boolean isForeachKeyOrValue(@NotNull PsiElement position) {
        Object parent;
        if (position == null) {
            PhpCompletionContributor.$$$reportNull$$$0(40);
        }
        if ((parent = PhpPsiUtil.getParentByCondition(position, CHILD_OF_FOREACH, (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF)) != null && PhpCompletionContributor.isInsideParentheses(parent)) {
            PsiElement array = ((ForeachStatement)parent.getParent()).getArray();
            return null == PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)((Condition)element -> element == array), (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF);
        }
        return false;
    }

    static boolean isInsideParentheses(PsiElement parent) {
        PsiElement sibling = PhpPsiUtil.findPrevSiblingOfAnyType(parent, PhpTokenTypes.chLPAREN, PhpTokenTypes.chRPAREN);
        return PhpPsiUtil.isOfType(sibling, PhpTokenTypes.chLPAREN);
    }

    static boolean isIssetOrUnset(PsiElement position) {
        if (PhpPsiUtil.isOfType(position, PhpTokenTypes.IDENTIFIER)) {
            position = position.getParent();
        }
        if (position instanceof ConstantReference) {
            position = position.getParent();
        }
        return position instanceof PhpIsset || position instanceof PhpUnset;
    }

    static boolean isClosureUse(@NotNull PsiElement position) {
        PhpUseList useList;
        if (position == null) {
            PhpCompletionContributor.$$$reportNull$$$0(41);
        }
        return PhpPsiUtil.getParentByCondition((PsiElement)(useList = PhpUseImpl.getUseList(position)), (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
    }

    private static void visitScopeHolderBranches(PsiElement position, final @NotNull Processor<PsiElement> processor2) {
        Object parent;
        PhpScopeHolder scopeHolder;
        if (processor2 == null) {
            PhpCompletionContributor.$$$reportNull$$$0(42);
        }
        if ((scopeHolder = PhpPsiUtil.getScopeHolder(position)) != null && (parent = PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)((Condition)e -> {
            PsiElement elementParent = e.getParent();
            return elementParent != null && elementParent.getParent() == scopeHolder;
        }))) != null) {
            PhpRadialSiblingIterator iterator = new PhpRadialSiblingIterator((PsiElement)parent);
            final int[] count = new int[1];
            while (iterator.hasNext() && count[0] < 500) {
                ((PsiElement)iterator.next()).accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        count[0] = count[0] + 1;
                        if (processor2.process((Object)element)) {
                            if (count[0] >= 500) {
                                this.stopWalking();
                            } else {
                                super.visitElement(element);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionContributor$6", "visitElement"));
                    }
                });
            }
        }
    }

    private static boolean isAlreadyCovered(@NotNull PsiElement element, @NotNull PhpExpectedFunctionArgument argument) {
        PsiElement parent;
        if (element == null) {
            PhpCompletionContributor.$$$reportNull$$$0(43);
        }
        if (argument == null) {
            PhpCompletionContributor.$$$reportNull$$$0(44);
        }
        if ((parent = element.getParent()) instanceof PhpMatchExpression) {
            return ContainerUtil.exists(PhpMatchExpressionImpl.getAllConditions((PhpMatchExpression)parent), arg_0 -> ((PhpExpectedFunctionArgument)argument).matches(arg_0));
        }
        if (parent instanceof PhpSwitch) {
            return StreamEx.of((Object[])((PhpSwitch)parent).getAllCases()).map(ControlStatement::getCondition).nonNull().anyMatch(arg_0 -> ((PhpExpectedFunctionArgument)argument).matches(arg_0));
        }
        return false;
    }

    @NotNull
    public static UsageContext getContext(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            PhpCompletionContributor.$$$reportNull$$$0(45);
        }
        PhpClass phpClass = PhpPsiUtil.getParentOfClass(parameters.getPosition(), PhpClass.class);
        UsageContext usageContext = new UsageContext(PhpModifier.State.STATIC);
        PhpCompletionContributor.fillContextByPosition(usageContext, parameters.getPosition(), phpClass);
        UsageContext usageContext2 = usageContext;
        if (usageContext2 == null) {
            PhpCompletionContributor.$$$reportNull$$$0(46);
        }
        return usageContext2;
    }

    public static void addExpectedValues(@NotNull CompletionResultSet result, PsiElement parentElement, Stream<PhpExpectedFunctionArgument> arguments) {
        if (result == null) {
            PhpCompletionContributor.$$$reportNull$$$0(47);
        }
        PhpCompletionContributor.expectedValues(parentElement, arguments).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
    }

    public static StreamEx<LookupElement> expectedValues(PsiElement parentElement, Stream<? extends PhpExpectedFunctionArgument> arguments) {
        return (StreamEx)((StreamEx)((StreamEx)StreamEx.of(arguments).filter(argument -> PhpExpectedFunctionArgumentLookupElement.accept(argument, parentElement))).map(argument -> PhpExpectedFunctionArgumentLookupElement.create(parentElement.getProject(), parentElement, argument)).filter(Objects::nonNull)).distinct(LookupElement::getLookupString);
    }

    @NotNull
    static String getCompletionActionShortcut() {
        String string = KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion");
        if (string == null) {
            PhpCompletionContributor.$$$reportNull$$$0(48);
        }
        return string;
    }

    static {
        PhpCompletionContributor.readFileToSet("functions.txt", PHP_PREDEFINED_FUNCTIONS);
        castTypesStrings = new String[]{"int", "integer", "bool", "boolean", "float", "double", "real", "string", "array", "object", "unset", "binary"};
        typeDeclarationsStrings = new String[]{"self", "parent", "array", "callable", "bool", "float", "int", "string", "void", "object", "false", "null", "mixed", "static", "never", "true"};
        phpDocTypesStrings = new String[]{"int", "integer", "bool", "boolean", "float", "double", "string", "array", "object", "callable", "true", "false", "null", "mixed", "resource", "void", "self", "static", "parent", "$this"};
        functags = new String[]{"@deprecated", "@inheritDoc", "@param", "@return", "@throws", "@codeCoverageIgnore", "@final"};
        classtags = new String[]{"@deprecated", "@inheritDoc", "@method", "@property", "@property-read", "@property-write", "@mixin", "@codeCoverageIgnore", "@final"};
        vartags = new String[]{"@deprecated", "@global", "@psalm-trace", "@var"};
        everywheretags = new String[]{"@api", "@internal", "@author", "@copyright", "@example", "@license", "@package", "@see", "@link", "@uses", "@since", "@version", "@todo"};
        phpunittags = new String[]{"@after", "@afterClass", "@backupGlobals", "@backupStaticAttributes", "@before", "@beforeClass", "@codeCoverageIgnore", "@covers", "@coversDefaultClass", "@coversNothing", "@dataProvider", "@depends", "@expectedException", "@expectedExceptionCode", "@expectedExceptionMessage", "@expectedExceptionMessageRegExp", "@group", "@large", "@medium", "@outputBuffering", "@preserveGlobalState", "@requires", "@runTestsInSeparateProcesses", "@runInSeparateProcess", "@small", "@test", "@testdox", "@ticket", "@uses"};
        traitSpecificDocTags = new String[]{"@require-extends", "@require-implements"};
        possibleInlineDocTags = CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList("@example", "@internal", "@inheritdoc", "@link", "@see"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12, 17, 18, 30, 46, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 16: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 14: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 7: 
            case 12: 
            case 17: 
            case 18: 
            case 30: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionContributor";
                break;
            }
            case 8: 
            case 21: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 15: 
            case 24: 
            case 26: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traitUseRule";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 31: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "compactFunctionCallArgument";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapOperands";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "patchResultIfNeeded";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionActionShortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFileToSet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCastTypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTypeDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPhpDocTypes";
                break;
            }
            case 7: 
            case 12: 
            case 17: 
            case 18: 
            case 30: 
            case 46: 
            case 48: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unwrapOperands";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsNamesFromDfa";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isVersionCompareVersionArgument";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findPrevElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTraitReference";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddEnum";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectMembersOfClassByDocRef";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addClassesAndFunctions";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "patchResultIfNeeded";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "suggestNames";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionVariants";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getAllFunctionFQNs";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addConstantVariants";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addAllClassesStaticMembers";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceNameForGroupUse";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isForeachKeyOrValue";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isClosureUse";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitScopeHolderBranches";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyCovered";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addExpectedValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12, 17, 18, 30, 46, 48 -> new IllegalStateException(string);
        };
    }

    private static class PhpExceptionCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpExceptionCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            boolean smart;
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpExceptionCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpExceptionCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpExceptionCompletionProvider.$$$reportNull$$$0(2);
            }
            ClassUsageContext usageContext = (parent = (position = parameters.getPosition().getOriginalElement()).getParent()) instanceof ClassReference ? PhpCompletionUtil.getUsageContext((ClassReference)parent) : new ClassUsageContext(false);
            PhpIndex index = PhpIndex.getInstance((Project)parameters.getPosition().getProject());
            boolean inNamespace = parent instanceof PhpReference && PhpCompletionContributor.isNamespace(position.getPrevSibling());
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
            PhpIndex.getInstance((Project)position.getProject()).processAllSubclasses("\\Throwable", c -> {
                PhpExceptionCompletionProvider.addElement(parent, usageContext, index, inNamespace, wrappedResult, c);
                return true;
            });
            for (PhpClass c2 : index.getAnyByFQN("\\Throwable")) {
                PhpExceptionCompletionProvider.addElement(parent, usageContext, index, inNamespace, wrappedResult, c2);
            }
            boolean bl = smart = parameters.getCompletionType() == CompletionType.SMART;
            if (parameters.getInvocationCount() <= 1 || smart) {
                result.stopHere();
                if (!smart) {
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.all.classes", PhpCompletionContributor.getCompletionActionShortcut()));
                }
            }
        }

        private static void addElement(PsiElement parent, ClassUsageContext usageContext, PhpIndex index, boolean inNamespace, CompletionResultSetWrapper wrappedResult, PhpClass c) {
            PhpLookupElement item;
            if (parent instanceof PhpReference && inNamespace) {
                c = (PhpClass)ContainerUtil.getFirstItem((Collection)index.filterByNamespace(Collections.singleton(c), ((PhpReference)parent).getNamespaceName()));
            }
            PhpLookupElement phpLookupElement = item = c != null ? PhpVariantsUtil.getLookupItemForClass(c, usageContext) : null;
            if (item != null) {
                wrappedResult.addElement(item);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpExceptionCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpCatchVariableCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpCatchVariableCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement variable;
            if (parameters == null) {
                PhpCatchVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpCatchVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpCatchVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((variable = (position = parameters.getPosition().getOriginalElement()).getParent()) instanceof Variable) {
                PhpCompletionContributor.suggestNames(variable, position).stream().map(s -> "$" + s).map(LookupElementBuilder::create).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
                if (parameters.getInvocationCount() <= 1) {
                    result.stopHere();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpCatchVariableCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpOpeningTagCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpOpeningTagCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement prevElement;
            if (parameters == null) {
                PhpOpeningTagCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpOpeningTagCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpOpeningTagCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.isOfType(prevElement = PhpCompletionContributor.findPrevElement(parameters, result), PhpTokenTypes.PHP_OPENING_TAG)) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)PhpCompletionContributor.PHP_OPENING_TAG_LOOKUP_STRING).withPresentableText("<?php"));
                result.stopHere();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpOpeningTagCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpNamespaceCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpNamespaceCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            String namespaceName;
            PsiElement position;
            PsiElement parent;
            PsiElement grandParent;
            if (parameters == null) {
                PhpNamespaceCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpNamespaceCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpNamespaceCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((grandParent = (parent = (position = parameters.getPosition().getOriginalElement()).getParent()).getParent()) instanceof PhpTypeDeclaration) {
                grandParent = grandParent.getParent();
            }
            if (PhpPsiUtil.isOfType(grandParent, PhpElementTypes.CLASS_FIELDS) && (!PhpLanguageFeature.TYPED_PROPERTIES.isSupported(position.getProject()) || PhpCompletionContributor.isInInterface(position))) {
                return;
            }
            if (PhpPsiUtil.isOfType(grandParent, PhpElementTypes.CLASS_CONSTANTS) && !PhpLanguageFeature.TYPED_CLASS_CONSTANTS.isSupported(position.getProject())) {
                return;
            }
            if (parent instanceof MemberReference || parent instanceof PhpCallableMethod) {
                return;
            }
            if (parent instanceof PhpGoto) {
                return;
            }
            if (parent instanceof ClassReference && PhpCompletionUtil.getUsageContext((ClassReference)parent).isInClassUse()) {
                return;
            }
            if (PhpCompletionContributor.isList(position) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpCompletionContributor.isIssetOrUnset(position) || PhpCompletionContributor.isClosureUse(position) || PhpCompletionContributor.isGlobal(position)) {
                return;
            }
            if (PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpTraitUseRule.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null) {
                return;
            }
            if (parent instanceof PhpReference) {
                namespaceName = ((PhpReference)parent).getNamespaceName();
            } else if (parent instanceof PhpNamespace) {
                namespaceName = ((PhpNamespace)parent).getParentNamespaceName();
            } else if (parent instanceof PhpDocRef) {
                namespaceName = PhpCompletionContributor.getNamespace(position.getPrevSibling(), null);
                if (namespaceName == null) {
                    return;
                }
            } else {
                return;
            }
            PhpCompletionUtil.addSubNamespaces(position.getProject(), namespaceName, result, PhpNamespaceInsertHandler.getInstance(), grandParent instanceof PhpAttribute);
            if (!(parent instanceof PhpNamespace) && !PhpCompletionContributor.isNamespace(position.getPrevSibling()) && PhpUseImpl.getUseList(position) == null && PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) == null) {
                LookupElementBuilder lookupElement = LookupElementBuilder.create((String)"namespace").withTailText("(" + namespaceName + ")", true).withIcon(PhpIcons.NAMESPACE).withBoldness(true).withInsertHandler((InsertHandler)PhpNamespaceInsertHandler.getInstance());
                result.addElement((LookupElement)lookupElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpNamespaceCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class PhpVariableCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        protected PhpVariableCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            result = PhpCompletionContributor.patchResultIfNeeded(result);
            PsiElement position = parameters.getPosition();
            boolean global = PhpCompletionContributor.isGlobal(position);
            boolean allGlobals = parameters.getInvocationCount() > 1 || global;
            PhpUseList useList = PhpUseImpl.getUseList(position);
            if (useList != null) {
                allGlobals = false;
                position = useList.getParent().getParent();
            } else if (!allGlobals) {
                result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.global.variants", PhpCompletionContributor.getCompletionActionShortcut()));
            }
            if (PhpCompletionContributor.isNamespace(position.getPrevSibling()) || PhpCompletionContributor.isForeachKeyOrValue(position)) {
                return;
            }
            boolean smart = parameters.getCompletionType() == CompletionType.SMART;
            boolean allSuperGlobals = !smart && !global && useList == null && (allGlobals || !PhpCompletionContributor.isList(position) && !PhpCompletionContributor.isIssetOrUnset(position));
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
            PhpVariantsUtil.getVariableVariants(position, parameters.getOriginalPosition(), allGlobals, allSuperGlobals).stream().filter(e -> useList == null || !"this".equals(e.getLookupString())).forEach(wrappedResult::addElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpVariableCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpGlobalVariableCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpGlobalVariableCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiReference reference;
            if (parameters == null) {
                PhpGlobalVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpGlobalVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpGlobalVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((reference = (position = parameters.getPosition()).getContainingFile().findReferenceAt(parameters.getOffset())) instanceof PhpUnitDataProviderAttributeReferenceContributor.PhpDataProviderReferenceProvider.PhpGlobalVariableCallbackReference) {
                PhpGlobalsArrayIndexCompletionProvider.addGlobalVariables(position.getProject(), position.getParent(), result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpGlobalVariableCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpExpectedReturnValuesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpExpectedReturnValuesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpExpectedReturnValuesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpExpectedReturnValuesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpExpectedReturnValuesCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            BinaryExpression binaryExpression = (BinaryExpression)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)((Condition)BinaryExpression.class::isInstance), (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (binaryExpression == null) {
                return;
            }
            boolean bitExpression = PhpPsiUtil.isOfType((PsiElement)binaryExpression, PhpElementTypes.BIT_EXPRESSION);
            for (PsiElement operand : PhpCompletionContributor.unwrapOperands(binaryExpression)) {
                if (PsiTreeUtil.isAncestor((PsiElement)operand, (PsiElement)position, (boolean)false)) continue;
                PhpExpectedReturnValuesCompletionProvider.addExpectedValuesForElement(operand, position, result, bitExpression);
            }
        }

        private static void addExpectedValuesForElement(@Nullable PsiElement element, PsiElement position, @NotNull CompletionResultSet result, boolean bitExpression) {
            if (result == null) {
                PhpExpectedReturnValuesCompletionProvider.$$$reportNull$$$0(3);
            }
            if (element == null) {
                return;
            }
            Object parameter = PhpPsiUtil.getParentByCondition(position, false, PhpExpectedFunctionArgumentLookupElement.ELEMENT_CAN_BE_EXPECTED_ARGUMENT, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
            if (parameter == null) {
                return;
            }
            List<PhpExpectedFunctionArgument> arguments = PhpExpectedFunctionArgumentsRegistry.fromMethodReference(element).stream().flatMap(c -> c.getValues(element, true).stream()).filter(c -> !PhpCompletionContributor.isAlreadyCovered(element, c)).toList();
            if (arguments.isEmpty()) {
                return;
            }
            PhpCompletionContributor.addExpectedValues(result, parameter, arguments.stream().filter(e -> e.isFlag() == bitExpression));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpExpectedReturnValuesCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addExpectedValuesForElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpExpectedReturnValuesInStatementWithArgumentCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpExpectedReturnValuesInStatementWithArgumentCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            StatementWithArgument phpSwitch;
            if (parameters == null) {
                PhpExpectedReturnValuesInStatementWithArgumentCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpExpectedReturnValuesInStatementWithArgumentCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpExpectedReturnValuesInStatementWithArgumentCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((phpSwitch = (StatementWithArgument)PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), (Condition<? super PsiElement>)Conditions.or((Condition)PhpSwitch.INSTANCEOF, (Condition)PhpReturn.INSTANCEOF))) == null) {
                return;
            }
            PhpExpectedReturnValuesCompletionProvider.addExpectedValuesForElement(phpSwitch.getArgument(), position, result, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpExpectedReturnValuesInStatementWithArgumentCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpExpectedReturnValuesInMatchExpressionCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpExpectedReturnValuesInMatchExpressionCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            boolean isInsideMatchArmCondition;
            if (parameters == null) {
                PhpExpectedReturnValuesInMatchExpressionCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpExpectedReturnValuesInMatchExpressionCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpExpectedReturnValuesInMatchExpressionCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PhpMatchExpression matchExpression = PhpPsiUtil.getParentOfClass(position, PhpMatchExpression.class);
            boolean bl = isInsideMatchArmCondition = PhpPsiUtil.getPrevSiblingByCondition(position.getParent(), (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opHASH_ARRAY))) == null;
            if (matchExpression == null || !isInsideMatchArmCondition) {
                return;
            }
            PhpExpectedReturnValuesCompletionProvider.addExpectedValuesForElement((PsiElement)matchExpression.getArgument(), position, result, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpExpectedReturnValuesInMatchExpressionCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpExpectedFunctionArgumentsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpExpectedFunctionArgumentsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            FunctionReference functionReference;
            Function function;
            PsiElement position;
            PsiElement parameter;
            ParameterList parameterList;
            if (parameters == null) {
                PhpExpectedFunctionArgumentsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpExpectedFunctionArgumentsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpExpectedFunctionArgumentsCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(parameter = PhpExpectedFunctionArgumentsCompletionProvider.getParameter(position = parameters.getPosition().getOriginalElement()), (Condition<? super PsiElement>)ParameterList.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) == null) {
                return;
            }
            int argumentIndex = PhpWorkaroundUtil.resolveMappedParameterIndex((PsiElement)ContainerUtil.find((Object[])parameterList.getParameters(), arg -> PsiTreeUtil.isAncestor((PsiElement)arg, (PsiElement)position, (boolean)false)));
            if (argumentIndex >= 0 && (function = PhpExpectedFunctionArgumentsCompletionProvider.getFunction(position, functionReference = (FunctionReference)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF))) != null) {
                boolean bitExpression = PhpPsiUtil.isOfType(parameter.getParent(), PhpElementTypes.BIT_EXPRESSION);
                List arguments = PhpExpectedFunctionArgumentsRegistry.fromMethodReference((PsiElement)functionReference).stream().flatMap(c -> c.getParameterValues(function, argumentIndex).stream()).toList();
                PhpCompletionContributor.addExpectedValues(result, parameter, arguments.stream().filter(argument -> !bitExpression || argument.isFlag()));
                Set<String> argumentsSet = arguments.stream().map(PhpExpectedFunctionArgument::getArgumentSet).collect(Collectors.toSet());
                if (!argumentsSet.isEmpty()) {
                    PhpExpectedFunctionArgumentsCompletionProvider.fillExpectedFunctionCallsWithArgumentsSet(parameter.getProject(), parameters, result, argumentsSet);
                }
            }
        }

        @Nullable
        private static PsiElement getParameter(PsiElement position) {
            if (PhpExpectedFunctionArgumentLookupElement.ELEMENT_CAN_BE_EXPECTED_ARGUMENT.value((Object)position)) {
                return position;
            }
            PsiElement parent = position.getParent();
            return PhpExpectedFunctionArgumentLookupElement.ELEMENT_CAN_BE_EXPECTED_ARGUMENT.value((Object)parent) ? parent : null;
        }

        private static void fillExpectedFunctionCallsWithArgumentsSet(@NotNull Project project, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull Set<String> argumentsSet) {
            if (project == null) {
                PhpExpectedFunctionArgumentsCompletionProvider.$$$reportNull$$$0(3);
            }
            if (parameters == null) {
                PhpExpectedFunctionArgumentsCompletionProvider.$$$reportNull$$$0(4);
            }
            if (result == null) {
                PhpExpectedFunctionArgumentsCompletionProvider.$$$reportNull$$$0(5);
            }
            if (argumentsSet == null) {
                PhpExpectedFunctionArgumentsCompletionProvider.$$$reportNull$$$0(6);
            }
            Collection<Function> functions = PhpExpectedFunctionArgumentsCompletionProvider.collectionFunctionsWithMatchingExpectedReturnSet(project, argumentsSet);
            Map<String, Collection<PhpLookupElement>> localsWithType = PhpExpectedFunctionArgumentsCompletionProvider.collectLocalElementsByType(parameters.getPosition());
            UsageContext usageContext = PhpCompletionContributor.getContext(parameters);
            CompletionResultSet patchedResult = PhpCompletionContributor.patchResultIfNeeded(result);
            for (Function function : functions) {
                if (function instanceof Method) {
                    PhpClass containingClass;
                    if (PhpCompletionContributor.accessibleStaticMember(usageContext, (PhpClassMember)((Method)function), functions)) {
                        patchedResult.addElement((LookupElement)new PhpExpectedStaticMethodCallArgumentLookupElement((PhpClassMember)function));
                        continue;
                    }
                    if (((Method)function).isStatic() || (containingClass = ((Method)function).getContainingClass()) == null || !localsWithType.containsKey(containingClass.getFQN())) continue;
                    for (PhpLookupElement element : localsWithType.get(containingClass.getFQN())) {
                        String lookupString = element.getLookupString();
                        if (StringUtil.equals((CharSequence)"this", (CharSequence)lookupString)) continue;
                        patchedResult.addElement((LookupElement)new PhpExpectedInstanceMethodCallArgumentLookupElement((PhpClassMember)((Method)function), lookupString));
                    }
                    continue;
                }
                patchedResult.addElement((LookupElement)new PhpExpectedFunctionCallArgumentLookupElement((PhpNamedElement)function));
            }
        }

        private static Map<String, Collection<PhpLookupElement>> collectLocalElementsByType(PsiElement position) {
            HashMap<String, Collection<PhpLookupElement>> result = new HashMap<String, Collection<PhpLookupElement>>();
            for (LookupElement variant : VariableImpl.getVariableVariants(position, true)) {
                PhpType type;
                if (!(variant instanceof PhpLookupElement) || (type = ((PhpLookupElement)variant).getPhpType()) == null) continue;
                for (String fqn : type.getTypes()) {
                    if (!PhpLangUtil.isFqn(fqn)) continue;
                    result.computeIfAbsent(fqn, k -> new HashSet()).add((PhpLookupElement)variant);
                }
            }
            return result;
        }

        @NotNull
        private static Collection<Function> collectionFunctionsWithMatchingExpectedReturnSet(Project project, Set<String> argumentsSet) {
            HashSet<Function> functionsWithMatchingExpectedReturnArguments = new HashSet<Function>();
            PhpIndex index = PhpIndex.getInstance((Project)project);
            for (String fqn : PhpExpectedFunctionArgumentsCompletionProvider.collectFunctionsFqnsWithMatchingExpectedReturnsSet(project, argumentsSet)) {
                if (fqn.indexOf(46) > 0) {
                    String[] classFqnAndMethodName = fqn.split("\\.", 2);
                    if (classFqnAndMethodName.length != 2) continue;
                    StreamEx.of((Collection)index.getClassesByFQN(classFqnAndMethodName[0])).map(aClass -> aClass.findOwnMethodByName((CharSequence)classFqnAndMethodName[1])).nonNull().forEach(functionsWithMatchingExpectedReturnArguments::add);
                    continue;
                }
                functionsWithMatchingExpectedReturnArguments.addAll(index.getFunctionsByFQN(fqn));
            }
            HashSet<Function> hashSet = functionsWithMatchingExpectedReturnArguments;
            if (hashSet == null) {
                PhpExpectedFunctionArgumentsCompletionProvider.$$$reportNull$$$0(7);
            }
            return hashSet;
        }

        @NotNull
        private static Collection<String> collectFunctionsFqnsWithMatchingExpectedReturnsSet(Project project, Set<String> expectedArgumentsSet) {
            HashSet<String> functionsFqnsWithMatchingExpectedReturnArgumentsSet = new HashSet<String>();
            for (String expectedFunctionFqn : FileBasedIndex.getInstance().getAllKeys(PhpExpectedReturnValuesIndex.KEY, project)) {
                boolean functionHasOneOfExpectedReturnArgumentsSet = ContainerUtil.find(PhpExpectedFunctionArgumentsIndex.getUnpackedArguments(project, expectedFunctionFqn, PhpExpectedReturnValuesIndex.KEY), argument -> {
                    String argumentSet = StringUtil.notNullize((String)argument.getArgumentSet());
                    return expectedArgumentsSet.contains(argumentSet);
                }) != null;
                if (!functionHasOneOfExpectedReturnArgumentsSet) continue;
                functionsFqnsWithMatchingExpectedReturnArgumentsSet.add(expectedFunctionFqn);
            }
            HashSet<String> hashSet = functionsFqnsWithMatchingExpectedReturnArgumentsSet;
            if (hashSet == null) {
                PhpExpectedFunctionArgumentsCompletionProvider.$$$reportNull$$$0(8);
            }
            return hashSet;
        }

        @Nullable
        private static Function getFunction(PsiElement position, FunctionReference functionReference) {
            PhpPsiElement classReference;
            if (functionReference != null) {
                return FunctionReferenceImpl.resolveFunction((PhpReference)functionReference);
            }
            PhpPsiElement constructorInvocation = (PhpPsiElement)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)Conditions.or((Condition)NewExpression.INSTANCEOF, PhpAttribute.class::isInstance), (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (constructorInvocation != null && (classReference = constructorInvocation.getFirstPsiChild()) instanceof ClassReference) {
                return FunctionReferenceImpl.resolveFunction((PhpReference)((ClassReference)classReference));
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argumentsSet";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpExpectedFunctionArgumentsCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpExpectedFunctionArgumentsCompletionProvider";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectionFunctionsWithMatchingExpectedReturnSet";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectFunctionsFqnsWithMatchingExpectedReturnsSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fillExpectedFunctionCallsWithArgumentsSet";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpExpectedPropertyValuesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpExpectedPropertyValuesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            AssignmentExpression assignmentExpression;
            if (parameters == null) {
                PhpExpectedPropertyValuesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpExpectedPropertyValuesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpExpectedPropertyValuesCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((assignmentExpression = PhpPsiUtil.getParentOfClass(position = parameters.getPosition().getOriginalElement(), AssignmentExpression.class)) == null) {
                return;
            }
            BinaryExpression expression = PhpPsiUtil.getParentOfClass(position, BinaryExpression.class);
            FieldReference fieldReference = (FieldReference)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), FieldReference.class);
            if (fieldReference == null) {
                return;
            }
            if (expression != null) {
                PhpExpectedReturnValuesCompletionProvider.addExpectedValuesForElement((PsiElement)fieldReference, position, result, PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.BIT_EXPRESSION));
            } else {
                PhpExpectedReturnValuesCompletionProvider.addExpectedValuesForElement((PsiElement)fieldReference, position, result, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpExpectedPropertyValuesCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpGetEnvArgumentCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpGetEnvArgumentCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            ParameterList parameterList;
            if (parameters == null) {
                PhpGetEnvArgumentCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpGetEnvArgumentCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpGetEnvArgumentCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), (Condition<? super PsiElement>)ParameterList.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) == null) {
                return;
            }
            if (PhpWorkaroundUtil.getArgumentIndex(position, parameterList) != 0) {
                return;
            }
            FileBasedIndex index = FileBasedIndex.getInstance();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)parameterList.getProject());
            index.processAllKeys(PhpPutEnvArgumentsIndex.KEY, putEnvArgument -> {
                if (PhpGetEnvArgumentCompletionProvider.belongsToProject(putEnvArgument, scope)) {
                    PhpPutEnvArgumentsIndex.PhpEnvArgument onlyValue = (PhpPutEnvArgumentsIndex.PhpEnvArgument)ContainerUtil.getOnlyItem((Collection)index.getValues(PhpPutEnvArgumentsIndex.KEY, putEnvArgument, scope));
                    LookupElementBuilder lookupElement = LookupElementBuilder.create((String)putEnvArgument);
                    if (onlyValue != null && StringUtil.isNotEmpty((String)onlyValue.getValue())) {
                        result.addElement((LookupElement)lookupElement.withTypeText(onlyValue.getValue(), true));
                    } else {
                        result.addElement((LookupElement)lookupElement);
                    }
                }
                return true;
            }, parameterList.getProject());
        }

        private static boolean belongsToProject(String putEnvArgument, GlobalSearchScope filter) {
            return !FileBasedIndex.getInstance().getContainingFiles(PhpPutEnvArgumentsIndex.KEY, (Object)putEnvArgument, filter).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpGetEnvArgumentCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class PhpMemberRefCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final String META_NAMESPACE_NAME = PhpLangUtil.toName("\\PHPSTORM_META\\");

        protected PhpMemberRefCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            boolean smart;
            if (parameters == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement().getParent();
            boolean bl = smart = parameters.getCompletionType() == CompletionType.SMART;
            if (PhpCompletionContributor.isNamespace(parameters.getPosition().getPrevSibling()) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpCompletionContributor.isClosureUse(position) || PhpCompletionContributor.isGlobal(position)) {
                return;
            }
            PhpMemberRefCompletionProvider.addPropertyHooksReference(position, result);
            HashSet<String> addedFieldNames = new HashSet<String>();
            HashSet addedMethodNames = new HashSet();
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapMemorableResult(parameters, context, result, addedFieldNames, addedMethodNames);
            if (position instanceof ConstantReference) {
                PhpClass phpClass = PhpPsiUtil.getParentOfClass(position, PhpClass.class);
                if (phpClass != null) {
                    boolean includeMagic;
                    UsageContext usageContext = new UsageContext(PhpModifier.State.DYNAMIC);
                    PhpCompletionContributor.fillContextByPosition(usageContext, position, phpClass);
                    boolean bl2 = includeMagic = parameters.getInvocationCount() > 1 || parameters.getPosition().getText().startsWith("__");
                    if (!includeMagic) {
                        result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                    }
                    if (!PhpCompletionContributor.isDefaultValue(position) && !PhpCompletionContributor.isIssetOrUnset(position)) {
                        wrappedResult.addAllElements(PhpVariantsUtil.getLookupItems(phpClass.getMethods(), includeMagic, usageContext));
                    }
                    wrappedResult.addAllElements(PhpVariantsUtil.getLookupItems(phpClass.getFields(), includeMagic, usageContext));
                }
            } else if (position instanceof MemberReference || position instanceof PhpCallableMethod) {
                String fieldName;
                boolean includeMagic;
                boolean isStatic;
                PhpDebugRuntimeEnvironment environment;
                String name;
                PhpExpression classReference;
                PsiElement parent = position.getParent();
                if (parent instanceof PhpTraitUseRule) {
                    PhpMemberRefCompletionProvider.addTraitUseRuleMethods(result, position, (PhpTraitUseRule)parent);
                    if (parameters.getInvocationCount() <= 1 || smart) {
                        if (!smart) {
                            result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                        }
                        return;
                    }
                }
                PhpExpression phpExpression = classReference = position instanceof MemberReference ? ((MemberReference)position).getClassReference() : ((PhpCallableMethod)position).getClassReference();
                if (classReference == null) {
                    return;
                }
                PhpType phpType = classReference.getGlobalType();
                PsiFile containingFile = classReference.getContainingFile();
                if (classReference instanceof PhpReference && containingFile instanceof PhpExpressionCodeFragment) {
                    phpType = new PhpType().add(phpType);
                    StreamEx.of((Collection)((PhpExpressionCodeFragment)containingFile).resolve((PhpReference)classReference)).select(PhpTypedElement.class).map(PhpTypedElement::getGlobalType).forEach(arg_0 -> ((PhpType)phpType).add(arg_0));
                }
                if (StringUtil.isNotEmpty((String)(name = classReference.getName())) && (environment = PhpDebugUtil.getCurrentRuntimeEnvironment(classReference.getProject())) != null) {
                    phpType = new PhpType().add(phpType).add(environment.getType(name));
                }
                boolean bl3 = isStatic = position instanceof MemberReference ? ((MemberReference)position).isStatic() : ((PhpCallableMethod)position).isStatic();
                PhpModifier.State referenceType = position instanceof MemberReference ? ((MemberReference)position).getReferenceType() : (isStatic ? PhpModifier.State.STATIC : PhpModifier.State.DYNAMIC);
                UsageContext usageContext = new UsageContext(referenceType);
                usageContext.setHavePredecessorClassReference(true);
                Set set = phpType.getTypesWithParametrisedParts();
                boolean bl4 = includeMagic = parameters.getInvocationCount() > 1 || parameters.getPosition().getText().startsWith("__");
                if (!includeMagic) {
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                }
                for (String fqn : set) {
                    PhpClass anonymousClass;
                    List parts;
                    String genericInstantiationType = PhpGenericsBaseExtendedWithGenericTypeProvider.findGenericInstantiationType(phpType, fqn);
                    usageContext.setGenericInstantiationType(genericInstantiationType);
                    Project project = position.getProject();
                    while (classReference instanceof MemberReference && ("$this".equals(fqn) || "static".equals(fqn))) {
                        classReference = ((MemberReference)classReference).getClassReference();
                        assert (classReference != null);
                        fqn = (String)ContainerUtil.getFirstItem((Collection)classReference.getGlobalType().getTypesSorted());
                    }
                    if (classReference instanceof Variable && ("$this".equals(fqn) || "static".equals(fqn))) {
                        PhpClass aClass = PhpPsiUtil.getParentOfClass((PsiElement)classReference, PhpClass.class);
                        if (aClass == null) continue;
                        fqn = aClass.getFQN();
                    }
                    if (fqn.startsWith("\\class-string") && genericInstantiationType != null && !(parts = PhpType.getParametrizedParts((String)genericInstantiationType)).isEmpty()) {
                        fqn = (String)parts.get(0);
                    }
                    PhpIndex index = PhpIndex.getInstance((Project)project);
                    ArrayDeque<PhpClass> classes = new ArrayDeque<PhpClass>(PhpCompletionContributor.findClasses(classReference, fqn, index));
                    if (isStatic && classReference instanceof Variable) {
                        for (String dynamicFQN : ClassReferenceImpl.inferDynamicClassReferenceFQNs((Variable)classReference)) {
                            classes.addAll(index.getAnyByFQN(dynamicFQN));
                        }
                    }
                    if (PhpLangUtil.isThisReference((PsiElement)classReference)) {
                        ContainerUtil.addIfNotNull(classes, (Object)PhpPsiUtil.getParentOfClass((PsiElement)classReference, PhpClass.class));
                    }
                    while (!classes.isEmpty()) {
                        PhpClass phpClass = (PhpClass)classes.removeFirst();
                        if (phpClass.isTrait()) {
                            Collection users = index.getNestedTraitUsages(phpClass, null);
                            classes.addAll(users);
                            usageContext.setTraitUsers(new HashSet<PhpClass>(users));
                        }
                        PhpMemberRefCompletionProvider.addMembersForClass((PhpReference)position, wrappedResult, parent, name, usageContext, includeMagic, phpClass);
                    }
                    if (fqn == null || !fqn.startsWith("__anonymous@") || (anonymousClass = PhpCompletionContributor.findAnonymousClass(position, fqn)) == null) continue;
                    PhpMemberRefCompletionProvider.addMembersForClass((PhpReference)position, wrappedResult, parent, name, usageContext, includeMagic, anonymousClass);
                }
                PhpAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)classReference, PhpAccessInstruction.class);
                PhpCompletionContributor.getMethodsNamesFromDfa(classReference, addedMethodNames).forEach(wrappedResult::addElement);
                PhpFieldExistsNameFinder fieldExistsNameFinder = new PhpFieldExistsNameFinder(classReference);
                if (position instanceof FieldReference && PhpUndefinedMethodInspection.performReachingDefinition(fieldExistsNameFinder, (PhpInstruction)instruction) != PhpUndefinedMethodInspection.Reachability.UNDEFINED && (fieldName = fieldExistsNameFinder.myFoundFieldName) != null && addedFieldNames.add(fieldName)) {
                    wrappedResult.addElement((LookupElement)LookupElementBuilder.create((String)fieldName).withIcon(PhpIcons.FIELD));
                }
                if (instruction != null && position instanceof FieldReference) {
                    PhpUndefinedFieldInspection.processReachability(classReference, null, (PhpInstruction)instruction, (Ref<Boolean>)new Ref(), (Ref<Boolean>)new Ref(), writeFieldRef -> {
                        String fieldName = writeFieldRef.getName();
                        if (fieldName != null && addedFieldNames.add(fieldName)) {
                            LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)writeFieldRef, (String)fieldName).withTypeText(writeFieldRef.getGlobalType().toStringRelativized("\\")).withIcon(PhpIcons.FIELD);
                            wrappedResult.addElement((LookupElement)lookupElement);
                        }
                    });
                }
                if (usageContext.getState().isStatic() && !usageContext.isThis() && PhpLanguageFeature.CLASS_NAME_CONST.isSupported(position.getProject())) {
                    wrappedResult.addElement((LookupElement)LookupElementBuilder.create((String)"class"));
                }
            }
        }

        private static void addPropertyHooksReference(PsiElement position, CompletionResultSet result) {
            if (!PhpLanguageFeature.PROPERTY_HOOKS.isSupported(position.getProject())) {
                return;
            }
            MemberReference reference = (MemberReference)ObjectUtils.tryCast((Object)position, MemberReference.class);
            if (reference == null) {
                return;
            }
            FieldReference parentFieldReference = (FieldReference)ObjectUtils.tryCast((Object)reference.getClassReference(), FieldReference.class);
            if (parentFieldReference == null) {
                return;
            }
            ClassReference parentReference = (ClassReference)ObjectUtils.tryCast((Object)parentFieldReference.getClassReference(), ClassReference.class);
            if (parentReference == null || !"parent".equals(parentReference.getName())) {
                return;
            }
            if (PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpPropertyHook.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) == null) {
                return;
            }
            InsertHandler<LookupElement> handler = new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    Document document;
                    int offset;
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((offset = context.getEditor().getCaretModel().getOffset()) < (document = context.getDocument()).getTextLength() && document.getText().charAt(offset) != '(') {
                        document.insertString(offset, (CharSequence)"()");
                        context.getEditor().getCaretModel().moveToOffset(offset + 1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpMemberRefCompletionProvider$1";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            result.addAllElements((Iterable)ContainerUtil.map(List.of("set", "get"), arg_0 -> PhpMemberRefCompletionProvider.lambda$addPropertyHooksReference$1(handler, arg_0)));
        }

        private static void addMembersForClass(PhpReference position, CompletionResultSetWrapper wrappedResult, PsiElement parent, String name, UsageContext usageContext, boolean includeMagic, PhpClass phpClass) {
            PhpClass currentClass = PhpClassImpl.getContainingClass((PsiElement)position);
            boolean resolveThis = currentClass == null && "this".equals(name);
            Collection<Object> classesForAccess = resolveThis ? PhpAnnotatorVisitor.resolveCurrentScope(position, PhpModifier.Access.PRIVATE) : ContainerUtil.createMaybeSingletonList((Object)currentClass);
            usageContext.setClassesForAccessFilter(classesForAccess);
            usageContext.setTargetObjectClass(phpClass);
            usageContext.setThis("this".equals(name));
            usageContext.setStaticOrSelfKeyword("static".equals(name) || "self".equals(name));
            if (!(PhpCompletionContributor.isDefaultValue((PsiElement)position) || VariableImpl.inMultiAssignment(parent) || parent instanceof Variable && !PhpPsiUtil.isOfType(position.getPrevSibling(), PhpTokenTypes.chLBRACE))) {
                if (PhpMemberRefCompletionProvider.isPositionInMeta(position)) {
                    wrappedResult.addAllElements(ContainerUtil.map((Collection)phpClass.getMethods(), element -> PhpVariantsUtil.getLookupItem((PhpNamedElement)element, usageContext)));
                } else {
                    Collection<LookupElement> methodElements = PhpMemberRefCompletionProvider.getMethodLookupElements(usageContext, includeMagic, phpClass);
                    wrappedResult.addAllElements(methodElements);
                }
            }
            if (!(position instanceof MethodReference) && !(position instanceof PhpCallableMethod)) {
                if (usageContext.getGenericInstantiationType() != null && phpClass.hasGenericMixins()) {
                    Collection<LookupElement> fieldElements = PhpMemberRefCompletionProvider.getFieldLookupElements(usageContext, includeMagic, phpClass);
                    wrappedResult.addAllElements(fieldElements);
                } else {
                    wrappedResult.addAllElements(PhpVariantsUtil.getLookupItems(phpClass.getFields(), includeMagic, usageContext));
                }
            }
            if (position instanceof ClassConstantReference && phpClass.isEnum()) {
                for (PhpEnumCase enumCase : phpClass.getEnumCases()) {
                    wrappedResult.addElement(PhpVariantsUtil.getLookupItem((PhpNamedElement)enumCase, usageContext));
                }
            }
        }

        @NotNull
        private static Collection<LookupElement> getMethodLookupElements(UsageContext usageContext, boolean includeMagic, PhpClass phpClass) {
            HashSet<LookupElement> methodElements = new HashSet<LookupElement>();
            HashMap<String, Method> allMethods = new HashMap<String, Method>();
            PhpClassHierarchyUtils.HierarchyMethodProcessor methodsProcessor = PhpClassImpl.getCollectingMethodProcessor(allMethods);
            PhpClassHierarchyUtils.processMethodsWithGenericMixins((PhpClass)phpClass, (PhpClass)phpClass, (method, subClass, baseClass) -> {
                methodsProcessor.process(method, subClass, baseClass);
                if (!method.isStatic() && usageContext.getState().isStatic() && ArrayUtil.contains((Object)subClass, (Object[])baseClass.getMixins()) && baseClass.findMethodByName((CharSequence)"__callStatic") != null) {
                    methodElements.addAll(PhpVariantsUtil.getLookupItems(Collections.singleton(method), includeMagic, usageContext.copyWithDynamic()));
                }
                return true;
            }, (boolean)false, (boolean)true, (String)usageContext.getGenericInstantiationType());
            methodElements.addAll(PhpVariantsUtil.getLookupItems(allMethods.values(), includeMagic, usageContext));
            HashSet<LookupElement> hashSet = methodElements;
            if (hashSet == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(3);
            }
            return hashSet;
        }

        @NotNull
        private static Collection<LookupElement> getFieldLookupElements(UsageContext usageContext, boolean includeMagic, PhpClass phpClass) {
            HashSet<LookupElement> fieldElements = new HashSet<LookupElement>();
            PhpClassHierarchyUtils.processFieldsWithGenericMixins((PhpClass)phpClass, (PhpClass)phpClass, (member, subClass, baseClass) -> {
                fieldElements.addAll(PhpVariantsUtil.getLookupItems(Collections.singleton(member), includeMagic, usageContext));
                return true;
            }, (boolean)false, (boolean)true, (String)usageContext.getGenericInstantiationType());
            HashSet<LookupElement> hashSet = fieldElements;
            if (hashSet == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(4);
            }
            return hashSet;
        }

        private static void addTraitUseRuleMethods(@NotNull CompletionResultSet result, @NotNull PsiElement position, @NotNull PhpTraitUseRule traitUseRule) {
            if (result == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(5);
            }
            if (position == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(6);
            }
            if (traitUseRule == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(7);
            }
            ClassReference traitReference = PhpCompletionContributor.getTraitReference(traitUseRule);
            PhpClass phpClass = PhpPsiUtil.getParentOfClass(position, PhpClass.class);
            if (traitReference != null) {
                PsiElement trait = traitReference.resolve();
                if (trait instanceof PhpClass && ((PhpClass)trait).isTrait()) {
                    PhpMemberRefCompletionProvider.addTraitMethods(result, phpClass, (PhpClass)trait);
                }
            } else {
                PhpIndex phpIndex = PhpIndex.getInstance((Project)position.getProject());
                for (String traitName : traitUseRule.getTraitNames()) {
                    for (PhpClass trait : phpIndex.getTraitsByFQN(traitName)) {
                        PhpMemberRefCompletionProvider.addTraitMethods(result, phpClass, trait);
                    }
                }
            }
        }

        private static void addTraitMethods(@NotNull CompletionResultSet result, @Nullable PhpClass phpClass, @NotNull PhpClass trait) {
            if (result == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(8);
            }
            if (trait == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(9);
            }
            UsageContext usageContext = new UsageContext(PhpModifier.State.PARENT);
            usageContext.setClassForAccessFilter(phpClass);
            usageContext.setTargetObjectClass(trait);
            result.addAllElements(PhpVariantsUtil.getLookupItems(trait.getMethods(), false, usageContext));
        }

        private static boolean isPositionInMeta(@NotNull PhpReference position) {
            PhpNamespace namespace;
            if (position == null) {
                PhpMemberRefCompletionProvider.$$$reportNull$$$0(10);
            }
            return (namespace = (PhpNamespace)PsiTreeUtil.getTopmostParentOfType((PsiElement)position, PhpNamespace.class)) != null && META_NAMESPACE_NAME.equals(namespace.getName()) && PhpParameterBasedTypeProvider.isMeta(position.getOriginalElement().getContainingFile().getOriginalFile());
        }

        private static /* synthetic */ LookupElementBuilder lambda$addPropertyHooksReference$1(1 handler, String it) {
            return LookupElementBuilder.create((String)it).withIcon(PhpIcons.METHOD).withInsertHandler((InsertHandler)handler);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpMemberRefCompletionProvider";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traitUseRule";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trait";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpMemberRefCompletionProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodLookupElements";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldLookupElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addTraitUseRuleMethods";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addTraitMethods";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isPositionInMeta";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }

        private static final class PhpFieldExistsNameFinder
        extends PhpUndefinedFieldInspection.PhpFieldExistsReachingDFAnalyzer {
            private String myFoundFieldName;

            private PhpFieldExistsNameFinder(@Nullable PhpExpression classReference) {
                super(classReference, null);
            }

            @Override
            @Nullable
            protected PhpReachingDefinitionDFAnalyzer.Result createResult(String methodNameInsideMethodExists, boolean result) {
                this.myFoundFieldName = methodNameInsideMethodExists;
                return super.createResult(methodNameInsideMethodExists, result);
            }
        }
    }

    private static class PhpQualifiedFunctionAndConstantCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpQualifiedFunctionAndConstantCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            String namespaceName;
            if (parameters == null) {
                PhpQualifiedFunctionAndConstantCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpQualifiedFunctionAndConstantCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpQualifiedFunctionAndConstantCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PsiElement parent = position.getParent();
            PsiElement grandParent = parent.getParent();
            if (PhpCompletionContributor.isNamespace(position.getPrevSibling()) && parent instanceof PhpReference && PhpLangUtil.isFqn(namespaceName = ((PhpReference)parent).getNamespaceName()) && !PhpLangUtil.isGlobalNamespaceFQN(namespaceName)) {
                CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
                if (!(grandParent instanceof PhpUse) || PhpUseImpl.isOfConst((PhpUse)grandParent)) {
                    PhpCompletionContributor.addConstantVariants(position.getProject(), namespaceName, wrappedResult, parameters, false);
                }
                PhpCompletionContributor.addFunctionVariants(position.getProject(), grandParent, namespaceName, wrappedResult, parameters, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpQualifiedFunctionAndConstantCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpDocCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final Collection<String> DEPRECATED_DOC_TAGS = Set.of("@expectedException", "@expectedExceptionMessage", "@expectedExceptionCode", "@expectedExceptionMessageRegExp");

        private PhpDocCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpDocCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDocCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpDocCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PsiElement parent = position.getParent();
            PhpDocComment docComment = PhpPsiUtil.getParentOfClass(position, PhpDocComment.class);
            PhpDocTag docTag = PhpPsiUtil.getParentOfClass(position, PhpDocTag.class);
            if (docComment == null) {
                return;
            }
            PhpPsiElement next = docComment.getNextPsiSibling();
            if (next instanceof GroupStatement) {
                next = next.getFirstPsiChild();
            }
            if (parent instanceof PhpDocComment || parent instanceof PhpDocTag) {
                PhpDocCompletionProvider.addDocTagLookupElements(result, parent, docComment, next, position, parameters.getOriginalPosition());
            } else if (parent instanceof PhpDocVariable || PhpDocCompletionProvider.isSuitableForPhpDocVariable(position)) {
                result = PhpCompletionContributor.patchResultIfNeeded(result);
                if (next instanceof Function) {
                    for (Parameter p : ((Function)next).getParameters()) {
                        if (p.getDocTag() != null) continue;
                        PhpLookupElement item = PhpVariantsUtil.getLookupItem((PhpNamedElement)p, null);
                        item.handler = PhpDocVariableInsertHandler.getInstance();
                        result.addElement((LookupElement)item);
                    }
                } else if (next != null) {
                    SmartList elements = new SmartList();
                    next.accept((PsiElementVisitor)new PhpElementVisitor((Collection)elements){
                        int visited;
                        final /* synthetic */ Collection val$elements;
                        {
                            this.val$elements = collection;
                        }

                        public void visitElement(@NotNull PsiElement element) {
                            PsiElement variableParent;
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            ++this.visited;
                            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.VARIABLE) && (variableParent = element.getParent()) instanceof PhpNamedElement) {
                                PhpLookupElement lookupElement = PhpVariantsUtil.getLookupItem((PhpNamedElement)variableParent, null);
                                lookupElement.handler = PhpVariableInsertHandler.getInstance();
                                this.val$elements.add(lookupElement);
                            }
                        }

                        public void visitPhpElement(PhpPsiElement element) {
                            if (this.visited < 100 && this.val$elements.size() < 10 && !(element instanceof GroupStatement)) {
                                element.acceptChildren((PsiElementVisitor)this);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionContributor$PhpDocCompletionProvider$1", "visitElement"));
                        }
                    });
                    result.addAllElements((Iterable)elements);
                }
            } else if (!PhpUnitUtil.isPhpUnitTag(docTag) && PhpCompletionContributor.afterPhpDocRefAndStaticModifier(position, parent)) {
                result.addAllElements(PhpCompletionContributor.collectMembersOfClassByDocRef(parameters, result, position, parent, true));
            } else if (docTag != null && !PhpUnitUtil.isPhpUnitTag(docTag)) {
                PhpCompletionContributor.addClassesAndFunctions(parameters, context, result);
                if ("@see".equals(docTag.getName())) {
                    CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
                    PhpCompletionContributor.addConstantVariants(position.getProject(), PhpCompletionContributor.getNamespace(position.getPrevSibling(), parent), wrappedResult, parameters, false);
                }
            }
        }

        private static void addDocTagLookupElements(@NotNull CompletionResultSet result, PsiElement parent, PhpDocComment docComment, PhpPsiElement next, PsiElement position, @Nullable PsiElement originalPosition) {
            if (result == null) {
                PhpDocCompletionProvider.$$$reportNull$$$0(3);
            }
            Collection<String> applicableTags = PhpDocCompletionProvider.getApplicableDocTags(next, originalPosition);
            PhpDocTag docTag = PhpPsiUtil.getParentOfClass(position, PhpDocTag.class);
            boolean startOfInlineDocTag = docTag != null && PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)docTag, true), PhpDocTokenTypes.DOC_LBRACE);
            boolean at = parent instanceof PhpDocTag;
            for (String applicableTag : applicableTags) {
                if (startOfInlineDocTag && !possibleInlineDocTags.contains(applicableTag)) continue;
                result.addElement((LookupElement)PhpDocCompletionProvider.createDocTagLookup(at, applicableTag));
            }
            if (next instanceof Function && (!startOfInlineDocTag || possibleInlineDocTags.contains("@param"))) {
                PhpDocCompletionProvider.addMissingParamDocTagElements(result, docComment, (Function)next, at);
            }
        }

        private static Collection<String> getApplicableDocTags(PhpPsiElement next, PsiElement originalPosition) {
            ArrayList<String> result = new ArrayList<String>();
            if (next instanceof PhpClass) {
                PhpClass klass = (PhpClass)next;
                Collections.addAll(result, classtags);
                if (PhpUnitUtil.isTestClass(klass, false)) {
                    Collections.addAll(result, phpunittags);
                }
                if (klass.isTrait()) {
                    Collections.addAll(result, traitSpecificDocTags);
                }
            } else if (next instanceof Function) {
                Collections.addAll(result, functags);
                if (next instanceof Method && PhpUnitUtil.isTestMethod((Method)next)) {
                    Collections.addAll(result, phpunittags);
                }
            } else if (PhpInjectionUtil.getLargestStringLiteral((PsiElement)next) != null) {
                result.add("@lang");
            } else {
                Collections.addAll(result, vartags);
            }
            Collections.addAll(result, everywheretags);
            if (originalPosition != null) {
                String originalPositionText = originalPosition.getText();
                PhpFlatCollectionIndexBase.processValues(PhpDocTagNameIndex.KEY, (file, value) -> {
                    for (String customTag : value) {
                        if (customTag.equalsIgnoreCase(originalPositionText) || !customTag.startsWith("@")) continue;
                        result.add(customTag);
                    }
                    return true;
                }, GlobalSearchScope.allScope((Project)originalPosition.getProject()));
            }
            return result;
        }

        private static void addMissingParamDocTagElements(@NotNull CompletionResultSet result, PhpDocComment docComment, Function next, boolean at) {
            if (result == null) {
                PhpDocCompletionProvider.$$$reportNull$$$0(4);
            }
            Set actualDocParamNames = ContainerUtil.map2Set((Collection)docComment.getParamTags(), PhpDocParamTag::getVarName);
            Arrays.stream(next.getParameters()).map(Parameter::getName).filter(name -> !actualDocParamNames.contains(name)).map(name -> new PhpParamDocTagLookupElement((String)name, at)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }

        private static boolean isSuitableForPhpDocVariable(PsiElement position) {
            if (position.getPrevSibling() == null) {
                PsiElement grandParent;
                PhpPsiElement prevPsiSibling;
                PsiElement parent = position.getParent();
                if (PhpPsiUtil.isOfType(parent, (IElementType)PhpDocElementTypes.phpDocType)) {
                    return PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(parent, true), PhpDocTokenTypes.DOC_TAG_NAME) && !PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace(parent, true), (IElementType)PhpDocElementTypes.phpDocVariable);
                }
                if (PhpPsiUtil.isOfType(parent, (IElementType)PhpDocElementTypes.phpDocTagValue) && (prevPsiSibling = ((PhpPsiElement)parent).getPrevPsiSibling()) instanceof PhpDocType && (grandParent = parent.getParent()) instanceof PhpDocParamTag && ((PhpDocParamTag)grandParent).getFirstPsiChild() == prevPsiSibling) {
                    return true;
                }
            }
            return false;
        }

        private static LookupElementBuilder createDocTagLookup(boolean at, @NotNull String s) {
            if (s == null) {
                PhpDocCompletionProvider.$$$reportNull$$$0(5);
            }
            String lookupString = at ? s.substring(1) : s;
            LookupElementBuilder builder2 = LookupElementBuilder.create((String)lookupString).withBoldness(true);
            if (DEPRECATED_DOC_TAGS.contains(s)) {
                builder2 = builder2.strikeout();
            }
            if ("@inheritDoc".equals(s)) {
                return builder2.withInsertHandler((InsertHandler)PhpDocTagInsertHandler.INSTANCE_WITHOUT_SPACE_SYMBOL);
            }
            return builder2.withInsertHandler((InsertHandler)PhpDocTagInsertHandler.INSTANCE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpDocCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDocTagLookupElements";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMissingParamDocTagElements";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createDocTagLookup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class PhpParamDocTagLookupElement
        extends LookupElement {
            private final String myName;
            private final boolean myAt;

            private PhpParamDocTagLookupElement(String name, boolean at) {
                this.myName = name;
                this.myAt = at;
            }

            public void handleInsert(@NotNull InsertionContext context) {
                PhpDocParamTag paramTag;
                if (context == null) {
                    PhpParamDocTagLookupElement.$$$reportNull$$$0(0);
                }
                if ((paramTag = PhpPsiUtil.getParentOfClass(PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset()), PhpDocParamTag.class)) == null) {
                    return;
                }
                String paramPresentation = PhpCompletionContributor.createDocParamPresentation(paramTag);
                if (paramPresentation == null) {
                    return;
                }
                PhpDocTag docTagWithType = PhpPsiElementFactory.createPhpDocTag(context.getProject(), "@param " + paramPresentation);
                paramTag.replace((PsiElement)docTagWithType);
            }

            @NotNull
            public String getLookupString() {
                String string = (this.myAt ? "@param".substring(1) : "@param") + " $" + this.myName;
                if (string == null) {
                    PhpParamDocTagLookupElement.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpDocCompletionProvider$PhpParamDocTagLookupElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpDocCompletionProvider$PhpParamDocTagLookupElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleInsert";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static class PhpDataProviderTagCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpDataProviderTagCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement parent;
            PsiElement position;
            if (parameters == null) {
                PhpDataProviderTagCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDataProviderTagCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpDataProviderTagCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpCompletionContributor.afterPhpDocRefAndStaticModifier(position = parameters.getPosition().getOriginalElement(), parent = position.getParent())) {
                result.addAllElements(PhpCompletionContributor.collectMembersOfClassByDocRef(parameters, result, position, parent, false));
                return;
            }
            PhpClass containingClass = PhpPsiUtil.getParentOfClass(position, PhpClass.class);
            if (containingClass != null) {
                for (Method m : containingClass.getOwnMethods()) {
                    if (PhpUnitUtil.isTestMethod(m)) continue;
                    result.addElement((LookupElement)new PhpLookupElement((PhpNamedElement)m));
                }
                if (parameters.getInvocationCount() <= 1) {
                    result.stopHere();
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                    return;
                }
            }
            PhpCompletionContributor.addClassesAndFunctions(parameters, context, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpDataProviderTagCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpCoversTagCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpCoversTagCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition();
            Project project = position.getProject();
            PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
            if (!PhpPsiUtil.isOfType(position.getPrevSibling(), PhpDocTokenTypes.DOC_STATIC)) {
                PhpCoversTagCompletionProvider.addNonTestClasses(parameters, result, position, phpIndex);
                return;
            }
            PsiElement parent = position.getParent();
            if (PhpCompletionContributor.afterPhpDocRefAndStaticModifier(position, parent)) {
                for (LookupElement element : PhpCompletionContributor.collectMembersOfClassByDocRef(parameters, result, position, parent, false)) {
                    ((PhpLookupElement)element).handler = null;
                    result.addElement(element);
                }
                if (parameters.getInvocationCount() > 1) {
                    for (PhpModifier.Access access : PhpModifier.Access.values()) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)("<" + access.toString() + ">")).withIcon(PhpIcons.METHOD));
                        result.addElement((LookupElement)LookupElementBuilder.create((String)("<!" + access.toString() + ">")).withIcon(PhpIcons.METHOD));
                    }
                }
            } else {
                PhpCoversTagCompletionProvider.addCoveredFunctionVariants(parameters, context, result, phpIndex, project, PhpUnitUtil.getDefaultCoveredClassName(PhpPsiUtil.getParentOfClass(position, PhpClass.class)));
            }
        }

        private static void addCoveredFunctionVariants(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result, @NotNull PhpIndex phpIndex, @NotNull Project project, @Nullable String coveredClassName) {
            if (parameters == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(3);
            }
            if (result == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(4);
            }
            if (phpIndex == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(5);
            }
            if (project == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(6);
            }
            if (coveredClassName != null) {
                boolean includeMagic = parameters.getInvocationCount() > 1;
                for (PhpClass phpClass : phpIndex.getClassesByFQN(PhpLangUtil.toFQN(coveredClassName))) {
                    for (LookupElement element : PhpVariantsUtil.getLookupItems(phpClass.getMethods(), includeMagic, null)) {
                        ((PhpLookupElement)element).handler = null;
                        result.addElement(element);
                    }
                }
            } else {
                PhpCompletionContributor.addFunctionVariants(project, null, null, PhpCompletionSorting.wrapResult(parameters, context, result), parameters, true);
            }
        }

        private static void addNonTestClasses(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull PsiElement position, @NotNull PhpIndex phpIndex) {
            if (parameters == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(7);
            }
            if (result == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(8);
            }
            if (position == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(9);
            }
            if (phpIndex == null) {
                PhpCoversTagCompletionProvider.$$$reportNull$$$0(10);
            }
            String namespace = PhpCompletionContributor.getNamespace(position.getPrevSibling(), position);
            Predicate<PhpClass> predicate = clazz -> (namespace == null || PhpLangUtil.equalsNamespaceNames(clazz.getNamespaceName(), namespace)) && !PhpUnitUtil.isTestClass(clazz, false);
            Consumer<PhpClass> adder = clazz -> {
                PhpLookupElement item = PhpVariantsUtil.getLookupItem((PhpNamedElement)clazz, null);
                item.handler = PhpUnitCoversClassInsertHandler.INSTANCE;
                result.addElement((LookupElement)item);
            };
            PhpCompletionUtil.addClasses(phpIndex, result.getPrefixMatcher(), predicate, adder);
            if (parameters.getInvocationCount() <= 1) {
                result.stopHere();
                result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpIndex";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpCoversTagCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCoveredFunctionVariants";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addNonTestClasses";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpLangTagCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpLangTagCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpLangTagCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpLangTagCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpLangTagCompletionProvider.$$$reportNull$$$0(2);
            }
            result.addElement((LookupElement)LookupElementBuilder.create((String)"text"));
            Collection languages = Language.getRegisteredLanguages();
            for (Language language : languages) {
                String id;
                if (!LanguageUtil.isInjectableLanguage((Language)language) || !StringUtil.isNotEmpty((String)(id = language.getID()))) continue;
                result.addElement((LookupElement)LookupElementBuilder.create((String)id));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpLangTagCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpFuncRefCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpFuncRefCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpFuncRefCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpFuncRefCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpFuncRefCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!((parent = (position = parameters.getPosition().getOriginalElement()).getParent()) instanceof FunctionReference && !(parent instanceof MemberReference) || parent instanceof PhpDocRef)) {
                return;
            }
            PsiElement prev = position.getPrevSibling();
            if (PhpPsiUtil.isOfType(prev, PhpTokenTypes.ARROW)) {
                return;
            }
            String namespaceName = PhpCompletionContributor.getNamespaceNameForGroupUse(position);
            if (namespaceName == null && PhpCompletionContributor.isNamespace(prev)) {
                String fqn = PhpCompletionContributor.getNamespace(prev, parent);
                namespaceName = fqn != null ? PhpLangUtil.toFQN(fqn) : null;
            }
            PhpCompletionContributor.addFunctionVariants(position.getProject(), null, namespaceName, PhpCompletionSorting.wrapResult(parameters, context, result), parameters, parent.getParent() instanceof PhpUse);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpFuncRefCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpGotoLabelCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpGotoLabelCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, final @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpGotoLabelCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpGotoLabelCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpGotoLabelCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement scope = PhpGotoImpl.getVisibilityScope(parameters.getPosition());
            scope.accept((PsiElementVisitor)new PhpGotoImpl.PhpGotoBaseVisitor(scope){

                public void visitPhpGotoLabel(PhpGotoLabel label) {
                    result.addElement((LookupElement)LookupElementBuilder.create((PsiNamedElement)label));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpGotoLabelCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TypeHintSuggestionsProvider
    extends CompletionProvider<CompletionParameters> {
        public static final char NAMESPACE_SEPARATOR = '\\';
        public static final char VARIABLE_PREFIX = '$';

        private TypeHintSuggestionsProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet resultSet) {
            PsiElement position;
            PhpTypeDeclarationOwner element;
            if (parameters == null) {
                TypeHintSuggestionsProvider.$$$reportNull$$$0(0);
            }
            if (processingContext == null) {
                TypeHintSuggestionsProvider.$$$reportNull$$$0(1);
            }
            if (resultSet == null) {
                TypeHintSuggestionsProvider.$$$reportNull$$$0(2);
            }
            if ((element = PhpPsiUtil.getParentOfClass(position = parameters.getPosition(), PhpTypeDeclarationOwner.class)) != null) {
                Collection<String> names = PhpCompletionContributor.suggestNames((PsiElement)element, position);
                String positionText = position.getText();
                for (String name : names) {
                    String lookupName;
                    if (StringUtil.containsChar((String)name, (char)'\\') || positionText.equals(lookupName = "$" + name)) continue;
                    resultSet.addElement((LookupElement)LookupElementBuilder.create((String)lookupName));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processingContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultSet";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$TypeHintSuggestionsProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpParameterNameFromDocTagsProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpParameterNameFromDocTagsProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Function function;
            if (parameters == null) {
                PhpParameterNameFromDocTagsProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpParameterNameFromDocTagsProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpParameterNameFromDocTagsProvider.$$$reportNull$$$0(2);
            }
            if ((function = PhpPsiUtil.getParentOfClass(parameters.getPosition(), Function.class)) == null) {
                return;
            }
            PhpDocComment comment = function.getDocComment();
            if (comment == null) {
                return;
            }
            Set tagsForExistingParameters = ContainerUtil.map2Set((Object[])function.getParameters(), Parameter::getDocTag);
            comment.getParamTags().stream().filter(paramTag -> !tagsForExistingParameters.contains(paramTag)).map(paramTag -> new PhpParameterFromTagLookupElement((PhpDocParamTag)paramTag, function)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpParameterNameFromDocTagsProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpFieldNamesForConstructorParametersCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpFieldNamesForConstructorParametersCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet resultSet) {
            if (parameters == null) {
                PhpFieldNamesForConstructorParametersCompletionProvider.$$$reportNull$$$0(0);
            }
            if (processingContext == null) {
                PhpFieldNamesForConstructorParametersCompletionProvider.$$$reportNull$$$0(1);
            }
            if (resultSet == null) {
                PhpFieldNamesForConstructorParametersCompletionProvider.$$$reportNull$$$0(2);
            }
            ParameterList parameterList = PhpPsiUtil.getParentOfClass(parameters.getPosition(), ParameterList.class);
            PhpClass phpClass = PhpPsiUtil.getParentOfClass((PsiElement)parameterList, PhpClass.class);
            if (parameterList != null && phpClass != null) {
                Set usedParameterNames = StreamEx.of((Object[])parameterList.getParameters()).select(Parameter.class).map(Parameter::getName).toSet();
                ((StreamEx)((StreamEx)StreamEx.of((Object[])phpClass.getOwnFields()).filter(field -> !field.isConstant())).map(field -> field.getName()).filter(fieldName -> !usedParameterNames.contains(fieldName))).map(fieldName -> LookupElementBuilder.create((String)("$" + fieldName)).withIcon(PhpIcons.FIELD)).forEach(arg_0 -> ((CompletionResultSet)resultSet).addElement(arg_0));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processingContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultSet";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpFieldNamesForConstructorParametersCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpForeachKeyAndValueCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpForeachKeyAndValueCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            if (parameters == null) {
                PhpForeachKeyAndValueCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpForeachKeyAndValueCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpForeachKeyAndValueCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpCompletionContributor.isForeachKeyOrValue(position = parameters.getPosition().getOriginalElement())) {
                if (result.getPrefixMatcher().getPrefix().startsWith("$")) {
                    PsiElement parent = position.getParent();
                    Collection<String> names = PhpCompletionContributor.suggestNames(parent, position);
                    for (String name : names) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)("$" + name)));
                    }
                } else {
                    Collection functions = PhpIndex.getInstance((Project)position.getProject()).getFunctionsByName("list");
                    result.addAllElements(PhpVariantsUtil.getLookupItems(functions, false, null));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpForeachKeyAndValueCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpCastCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpCastCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpCastCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpCastCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpCastCompletionProvider.$$$reportNull$$$0(2);
            }
            PhpCompletionContributor.addCastTypes(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpCastCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpSmartFunctionParametersCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpSmartFunctionParametersCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Parameter parameter;
            Function function;
            PsiElement[] referenceParameters;
            PsiElement position;
            if (parameters == null) {
                PhpSmartFunctionParametersCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpSmartFunctionParametersCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpSmartFunctionParametersCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!((position = parameters.getPosition().getOriginalElement()).getParent() instanceof ConstantReference)) {
                return;
            }
            if (TemplateManager.getInstance((Project)position.getProject()).getActiveTemplate(parameters.getEditor()) != null) {
                return;
            }
            ParameterList parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)ParameterList.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (parameterList != null && ((referenceParameters = parameterList.getParameters()).length == 0 || referenceParameters.length == 1 && referenceParameters[0] == position.getParent()) && (function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)(parameter = PhpWorkaroundUtil.getFunctionParameter(position)), (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null) {
                result.addElement((LookupElement)new PhpSmartFunctionParametersLookupElement(function));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpSmartFunctionParametersCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpClassNameByFileNameCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpClassNameByFileNameCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiFile file;
            String name;
            PsiElement position;
            PsiElement sibling;
            if (parameters == null) {
                PhpClassNameByFileNameCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpClassNameByFileNameCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpClassNameByFileNameCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpPsiUtil.isOfType(sibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(position = parameters.getPosition().getOriginalElement(), true), PhpTokenTypes.kwCLASS, PhpTokenTypes.kwINTERFACE, PhpTokenTypes.kwTRAIT, PhpTokenTypes.kwENUM) && PhpNameUtil.isValidClassName(name = PhpNameUtil.getNameWithoutExtension((file = position.getContainingFile()).getName()))) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)name));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpClassNameByFileNameCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpStringLiteralClassesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(2);
            }
            if (parameters.isExtendedCompletion() || PhpStringLiteralClassesCompletionProvider.isClassReferenceInString(parameters)) {
                PhpStringLiteralClassesCompletionProvider.addCompletions(parameters, result);
            }
        }

        private static boolean isClassReferenceInString(@NotNull CompletionParameters parameters) {
            if (parameters == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(3);
            }
            return parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset()) instanceof PhpCallbackReferenceBase.PhpClassCallbackReference;
        }

        public static void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(4);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(5);
            }
            if (PhpPsiUtil.isOfType(parent = (position = parameters.getPosition().getOriginalElement()).getParent(), PhpElementTypes.HEREDOC)) {
                return;
            }
            result = PhpStringLiteralClassesCompletionProvider.patchPrefixMatcher(result, position);
            String prefixWithoutEscaping = PhpStringLiteralClassesCompletionProvider.getPrefixWithoutEscaping(parent, result.getPrefixMatcher());
            String namespace = PhpStringLiteralClassesCompletionProvider.getNamespace(prefixWithoutEscaping);
            PhpIndex phpIndex = PhpIndex.getInstance((Project)position.getProject());
            PhpStringLiteralClassesCompletionProvider.addMatchedSubNamespaces(result.getPrefixMatcher(), namespace, result, phpIndex);
            PhpStringLiteralClassesCompletionProvider.addMatchedPhpClasses(result.getPrefixMatcher(), namespace, result, phpIndex, PhpLangUtil.toShortName(prefixWithoutEscaping));
        }

        @NotNull
        public static CompletionResultSet patchPrefixMatcher(@NotNull CompletionResultSet result, PsiElement position) {
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(6);
            }
            String prefix = result.getPrefixMatcher().getPrefix();
            if (position.getText().startsWith("\\") && !prefix.startsWith("\\")) {
                result = result.withPrefixMatcher("\\" + prefix);
            }
            CompletionResultSet completionResultSet = result;
            if (completionResultSet == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(7);
            }
            return completionResultSet;
        }

        @NotNull
        public static String getNamespace(String prefixWithoutEscaping) {
            Object namespace = PhpLangUtil.toFQN(PhpLangUtil.getParentQualifiedName(prefixWithoutEscaping));
            if (!((String)namespace).endsWith("\\") && !StringUtil.isEmpty((String)namespace)) {
                namespace = (String)namespace + "\\";
            }
            String string = namespace;
            if (string == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(8);
            }
            return string;
        }

        protected static String getPrefixWithoutEscaping(PsiElement parent, PrefixMatcher prefixMatcher) {
            boolean singleLiteral = PhpPsiUtil.isOfType(parent, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE);
            return PhpStringUtil.unescapeText(prefixMatcher.getPrefix(), singleLiteral);
        }

        public static void addMatchedSubNamespaces(@NotNull PrefixMatcher prefixMatcher, @NotNull String namespace, @NotNull CompletionResultSet result, @NotNull PhpIndex phpIndex) {
            if (prefixMatcher == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(9);
            }
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(10);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(11);
            }
            if (phpIndex == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(12);
            }
            Collection<String> phpNamespaces = PhpCompletionUtil.getAllChildNamespaceNames(phpIndex, namespace);
            for (String i : phpNamespaces) {
                String fqn = PhpLangUtil.toFQN(i);
                if (fqn.startsWith("\\___PHPSTORM_HELPERS")) continue;
                for (PhpNamespace phpNamespace : phpIndex.getNamespacesByName(fqn)) {
                    PhpLookupElement element = new PhpLookupElement((PhpNamedElement)phpNamespace);
                    element.handler = PhpNamedElementInStringLiteralInsertHandler.getInstance();
                    element.lookupString = PhpStringLiteralClassesCompletionProvider.adjustNamespaceToPrefix(phpNamespace.getFQN(), prefixMatcher.getPrefix());
                    result.addElement((LookupElement)element);
                }
            }
        }

        private static void addMatchedPhpClasses(@NotNull PrefixMatcher prefixMatcher, @NotNull String namespace, @NotNull CompletionResultSet result, @NotNull PhpIndex phpIndex, @NotNull String classPrefix) {
            if (prefixMatcher == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(13);
            }
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(14);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(15);
            }
            if (phpIndex == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(16);
            }
            if (classPrefix == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(17);
            }
            boolean globalNamespace = PhpLangUtil.isGlobalNamespaceFQN(namespace);
            PrefixMatcher matcher = prefixMatcher.cloneWithPrefix(classPrefix);
            Predicate<PhpClass> predicate = aClass -> PhpStringLiteralClassesCompletionProvider.filterElement(namespace, globalNamespace, (PhpNamedElement)aClass);
            Consumer<PhpClass> adder = aClass -> PhpStringLiteralClassesCompletionProvider.addElement(prefixMatcher, namespace, result, globalNamespace, (PhpNamedElement)aClass);
            PhpCompletionUtil.addClasses(phpIndex, matcher, predicate, adder);
            PhpCompletionUtil.addInterfaces(phpIndex, predicate, adder, matcher);
            PhpCompletionUtil.addTraits(phpIndex, prefixMatcher, predicate, adder);
        }

        public static boolean filterElement(@NotNull String namespace, boolean globalNamespace, PhpNamedElement element) {
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(18);
            }
            if (!globalNamespace && !PhpCompletionUtil.hasNamespace(namespace, false, element)) {
                return false;
            }
            return !element.getFQN().startsWith("\\___PHPSTORM_HELPERS");
        }

        public static void addElement(@NotNull PrefixMatcher prefixMatcher, @NotNull String namespace, @NotNull CompletionResultSet result, boolean globalNamespace, PhpNamedElement namedElement) {
            if (prefixMatcher == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(19);
            }
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(20);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(21);
            }
            PhpLookupElement element = new PhpLookupElement(namedElement);
            element.handler = PhpNamedElementInStringLiteralInsertHandler.getInstance();
            if (!globalNamespace) {
                element.lookupString = PhpStringLiteralClassesCompletionProvider.adjustNamespaceToPrefix(namespace, prefixMatcher.getPrefix()) + namedElement.getName();
            }
            result.addElement((LookupElement)element);
        }

        @NotNull
        public static String adjustNamespaceToPrefix(@NotNull String namespace, @NotNull String prefix) {
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(22);
            }
            if (prefix == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(23);
            }
            Object object = namespace = prefix.startsWith("\\") ? namespace : PhpLangUtil.toPresentableFQN((String)namespace);
            if (!StringUtil.isEmpty((String)namespace)) {
                namespace = (String)namespace + "\\";
            }
            if (prefix.contains("\\\\")) {
                namespace = StringUtil.replace((String)namespace, (String)"\\", (String)"\\\\");
            }
            Object object2 = namespace;
            if (object2 == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(24);
            }
            return object2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 24 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 11: 
                case 15: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 7: 
                case 8: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpStringLiteralClassesCompletionProvider";
                    break;
                }
                case 9: 
                case 13: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixMatcher";
                    break;
                }
                case 10: 
                case 14: 
                case 18: 
                case 20: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpIndex";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classPrefix";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpStringLiteralClassesCompletionProvider";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "patchPrefixMatcher";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustNamespaceToPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isClassReferenceInString";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "patchPrefixMatcher";
                    break;
                }
                case 7: 
                case 8: 
                case 24: {
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addMatchedSubNamespaces";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "addMatchedPhpClasses";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "filterElement";
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustNamespaceToPrefix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 24 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpVersionsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final int MAX_MINOR_PHP_VERSION = 50;

        private PhpVersionsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpVersionsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpVersionsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpVersionsCompletionProvider.$$$reportNull$$$0(2);
            }
            Arrays.stream(PhpLanguageLevel.values()).flatMap(v -> IntStream.range(0, 50).mapToObj(minor -> v.getPresentableName() + "." + minor)).map(LookupElementBuilder::create).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpVersionsCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpGlobalCompletionProviderFacade
    extends CompletionProvider<CompletionParameters> {
        private PhpGlobalCompletionProviderFacade() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpGlobalCompletionProviderFacade.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpGlobalCompletionProviderFacade.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpGlobalCompletionProviderFacade.$$$reportNull$$$0(2);
            }
            if (CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 2 && !StringUtil.isCapitalized((String)result.getPrefixMatcher().getPrefix())) {
                PhpExpressionGlobalCompletionProvider.INSTANCE.addCompletions(parameters, context, result);
                PHP_CLASS_REF_COMPLETION_PROVIDER.addCompletions(parameters, context, result);
            } else {
                PHP_CLASS_REF_COMPLETION_PROVIDER.addCompletions(parameters, context, result);
                PhpExpressionGlobalCompletionProvider.INSTANCE.addCompletions(parameters, context, result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpGlobalCompletionProviderFacade";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpUndeclaredVariableCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpUndeclaredVariableCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            if (parameters == null) {
                PhpUndeclaredVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpUndeclaredVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpUndeclaredVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpUseImpl.getUseList(position = parameters.getPosition().getOriginalElement()) != null || PhpCompletionContributor.isNamespace(position.getPrevSibling()) || PhpCompletionContributor.isForeachKeyOrValue(position)) {
                return;
            }
            Function function = PhpPsiUtil.getParentOfClass(position, Function.class);
            Set parameterNames = function != null ? Arrays.stream(function.getParameters()).map(Parameter::getName).collect(Collectors.toSet()) : Collections.emptySet();
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, PhpCompletionContributor.patchResultIfNeeded(result));
            PhpCompletionContributor.visitScopeHolderBranches(position, (Processor<PsiElement>)((Processor)element -> {
                if (element instanceof Variable && position.getParent() != element && !parameterNames.contains(((Variable)element).getName())) {
                    wrappedResult.addElement(PhpVariantsUtil.getLookupItem((PhpNamedElement)((Variable)element), null));
                    return false;
                }
                return true;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpUndeclaredVariableCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpCloneWithPropertiesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpCloneWithPropertiesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PhpPsiElement value;
            PsiElement position;
            if (parameters == null) {
                PhpCloneWithPropertiesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpCloneWithPropertiesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpCloneWithPropertiesCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!PhpLanguageFeature.CLONE_WITH_PROPERTIES.isSupported((position = parameters.getPosition().getOriginalElement()).getProject())) {
                return;
            }
            PhpCloneImpl clone = (PhpCloneImpl)((Object)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)((Condition)it -> it instanceof PhpCloneImpl), (Condition<? super PsiElement>)Statement.INSTANCEOF));
            if (clone == null) {
                return;
            }
            PhpPsiElement withProperties = clone.getWithProperties();
            if (withProperties != null && !withProperties.getTextRange().contains(parameters.getOffset())) {
                return;
            }
            ArrayHashElement arrayHashElement = (ArrayHashElement)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)ArrayHashElement.INSTANCEOF, (Condition<? super PsiElement>)ArrayCreationExpression.INSTANCEOF);
            if (arrayHashElement != null && (value = arrayHashElement.getValue()) != null && value.getTextRange().getStartOffset() <= position.getTextRange().getStartOffset()) {
                return;
            }
            Collection<String> fieldNames = PhpCloneImpl.getAllowedPropertiesNames(clone);
            for (String fieldName : fieldNames) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)fieldName).withPresentableText(fieldName));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpCloneWithPropertiesCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PhpMethodExistsNameFinder
    extends PhpUndefinedMethodInspection.PhpMethodExistsReachingDFAnalyzer {
        private String myFoundMethodName;

        private PhpMethodExistsNameFinder(@NotNull PhpExpression classReference) {
            if (classReference == null) {
                PhpMethodExistsNameFinder.$$$reportNull$$$0(0);
            }
            super(classReference, null);
        }

        @Override
        @Nullable
        protected PhpReachingDefinitionDFAnalyzer.Result createResult(String methodNameInsideMethodExists, boolean result) {
            this.myFoundMethodName = methodNameInsideMethodExists;
            return super.createResult(methodNameInsideMethodExists, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classReference", "com/jetbrains/php/completion/PhpCompletionContributor$PhpMethodExistsNameFinder", "<init>"));
        }
    }

    private static class PhpClassRefCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpClassRefCompletionProvider() {
        }

        private static void addTraitUseRuleTraits(@NotNull CompletionResultSet result, @NotNull PsiElement position, @NotNull PhpTraitUseRule traitUseRule) {
            if (result == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(0);
            }
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(1);
            }
            if (traitUseRule == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(2);
            }
            boolean methodReference = position instanceof MethodReference && !(position.getFirstChild() instanceof ClassReference);
            boolean classReference = PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(position, true), PhpTokenTypes.kwINSTEADOF);
            if (methodReference || classReference) {
                ClassReference traitReference;
                String traitToSkip = null;
                if (classReference && (traitReference = PhpCompletionContributor.getTraitReference(traitUseRule)) != null) {
                    traitToSkip = traitReference.getName();
                }
                PhpIndex phpIndex = PhpIndex.getInstance((Project)position.getProject());
                ClassUsageContext usageContext = methodReference ? ClassUsageContext.STATIC : new ClassUsageContext(false);
                usageContext.setInClassUse(true);
                PhpUseList useList = PhpUseImpl.getUseList((PsiElement)traitUseRule);
                if (useList != null) {
                    for (PhpUse use : useList.getDeclarations()) {
                        String traitName;
                        if (classReference && use.getName().equals(traitToSkip)) continue;
                        PhpReference reference = use.getTargetReference();
                        String string = traitName = reference != null ? reference.getFQN() : null;
                        if (traitName == null) continue;
                        if (!use.getName().equals(PhpLangUtil.toShortName(traitName))) {
                            PhpLookupElement element = new PhpLookupElement((PhpNamedElement)use);
                            element.handler = PhpVariantsUtil.getInsertHandlerForClassContext(usageContext);
                            result.addElement((LookupElement)element);
                            continue;
                        }
                        for (PhpClass phpClass : phpIndex.getTraitsByFQN(traitName)) {
                            PhpLookupElement lookupItem = PhpVariantsUtil.getLookupItemForClass(phpClass, usageContext);
                            if (lookupItem == null) continue;
                            result.addElement((LookupElement)lookupItem);
                        }
                    }
                }
            }
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet result) {
            boolean restrict;
            ClassUsageContext context;
            boolean smart;
            PsiElement position;
            PsiElement parent;
            if (parameters == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(3);
            }
            if (processingContext == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(4);
            }
            if (result == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(5);
            }
            PsiElement psiElement = parent = (position = parameters.getPosition().getOriginalElement().getParent()) != null ? position.getParent() : null;
            if (parent instanceof PhpTypeDeclaration) {
                parent = parent.getParent();
            }
            if (PhpPsiUtil.isOfType(parent, PhpElementTypes.CLASS_FIELDS) && (!PhpLanguageFeature.TYPED_PROPERTIES.isSupported(position.getProject()) || PhpCompletionContributor.isInInterface(position))) {
                return;
            }
            if (PhpPsiUtil.isOfType(parent, PhpElementTypes.CLASS_CONSTANTS) && !PhpLanguageFeature.TYPED_CLASS_CONSTANTS.isSupported(position.getProject())) {
                return;
            }
            boolean bl = smart = parameters.getCompletionType() == CompletionType.SMART;
            if (parent instanceof PhpTraitUseRule) {
                PhpClassRefCompletionProvider.addTraitUseRuleTraits(result, position, (PhpTraitUseRule)parent);
                if (parameters.getInvocationCount() <= 1 || smart) {
                    if (!smart) {
                        result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                    }
                    return;
                }
            }
            if (!(position instanceof ClassReference || position instanceof ConstantReference || position instanceof PhpDocType || position instanceof PhpDocRef || PhpCompletionContributor.isSuitableForPhpDocMethodType(position))) {
                return;
            }
            if (PhpCompletionContributor.isList(position) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpCompletionContributor.isIssetOrUnset(position) || PhpCompletionContributor.isClosureUse(position) || PhpCompletionContributor.isGlobal(position)) {
                return;
            }
            if (parent instanceof PhpUse && (PhpUseImpl.isOfFunction((PhpUse)parent) || PhpUseImpl.isOfConst((PhpUse)parent))) {
                return;
            }
            ClassUsageContext classUsageContext = context = position instanceof ClassReference ? PhpCompletionUtil.getUsageContext((ClassReference)position) : new ClassUsageContext(position instanceof ConstantReference);
            if (parameters.getInvocationCount() > 1 && !smart) {
                context = new ClassUsageContext(false);
            }
            boolean nsp = PhpCompletionContributor.isNamespace(parameters.getPosition().getPrevSibling()) || PhpCompletionContributor.getNamespaceNameForGroupUse(position) != null;
            boolean bl2 = restrict = smart || parameters.getInvocationCount() <= 1 && (nsp || result.getPrefixMatcher().getPrefix().isEmpty());
            if (restrict && !smart) {
                result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.global.variants", PhpCompletionContributor.getCompletionActionShortcut()));
            }
            CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, processingContext, result);
            PhpClass currentClass = (PhpClass)PhpPsiUtil.getParentByCondition(parent, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
            if (!nsp) {
                PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)ObjectUtils.tryCast((Object)position.getParent(), PhpTypeDeclaration.class);
                if (typeDeclaration != null) {
                    boolean superClassExists = currentClass != null && !currentClass.getSuperClasses().isEmpty();
                    PhpCompletionContributor.addTypeDeclarations(position.getProject(), result, typeDeclaration, currentClass, superClassExists);
                }
                if (position instanceof PhpDocType || position instanceof ClassReference && (PhpPsiUtil.isOfType(parent, (IElementType)PhpDocElementTypes.phpDocMethodType) || PhpCompletionContributor.isSuitableForPhpDocMethodType(position))) {
                    PhpCompletionContributor.addPhpDocTypes(result);
                }
                if (!PhpUnitUtil.isInPhpUnitTag(position)) {
                    PhpClassRefCompletionProvider.addUsedClassesAndNamespaces(wrappedResult, position, context);
                }
            }
            PhpClassRefCompletionProvider.addClassesContextAware(nsp, position, parameters, context, wrappedResult, restrict);
            Project project = position.getProject();
            if (!(nsp || !context.isInNew() && (!context.isGeneric() && !context.isStatic() || parent instanceof PhpUse || parent instanceof Parameter || parent instanceof Function || parent instanceof PhpReturnType || context.isInTypeDeclaration() || position instanceof PhpDocType || position instanceof PhpDocRef || PhpPsiUtil.isOfType(parent, (IElementType)PhpDocElementTypes.phpDocMethodType) || PhpCompletionContributor.isSuitableForPhpDocMethodType(position)))) {
                wrappedResult.addElement(PhpClassRefCompletionProvider.getBindingKeyword("parent", context, project, currentClass != null ? currentClass.getSuperFQN() : null));
                wrappedResult.addElement(PhpClassRefCompletionProvider.getBindingKeyword("self", context, project, currentClass != null ? currentClass.getFQN() : null));
                wrappedResult.addElement(PhpClassRefCompletionProvider.getBindingKeyword("static", context, project, currentClass != null ? currentClass.getFQN() : null));
            }
        }

        private static void addUsedClassesAndNamespaces(@NotNull CompletionResultSetWrapper wrappedResult, @NotNull PsiElement position, @NotNull ClassUsageContext context) {
            if (wrappedResult == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(6);
            }
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(7);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(8);
            }
            for (PhpUse use : PhpCompletionContributor.getUses(position)) {
                PhpClass aClass;
                if (use == null || PhpUseImpl.isOfFunction(use) || PhpUseImpl.isOfConst(use) || (aClass = PhpClassRefCompletionProvider.getClass(use)) != null && !PhpClassRefCompletionProvider.shouldAddElement(position, context, aClass)) continue;
                wrappedResult.addElement(PhpClassRefCompletionProvider.createLookupElement(context, use));
            }
        }

        private static void addClassesContextAware(boolean nsp, @NotNull PsiElement position, @NotNull CompletionParameters parameters, @NotNull ClassUsageContext context, @NotNull CompletionResultSetWrapper result, boolean restrict) {
            Predicate<PhpClass> predicate;
            PhpIndex phpIndex;
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(9);
            }
            if (parameters == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(10);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(11);
            }
            if (result == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(12);
            }
            PrefixMatcher matcher = result.getPrefixMatcher();
            Object prefixMatcher = nsp || !PhpVariantsUtil.fqcnCompletionEnabled() ? matcher : new PhpFqnPrefixMatcher(matcher);
            if (PhpClassRefCompletionProvider.addVariants(context, prefixMatcher, phpIndex = PhpIndex.getInstance((Project)position.getProject()), predicate = phpClass -> PhpVariantsUtil.lookupItemForClassAvailable(phpClass, context) && PhpClassRefCompletionProvider.shouldAddElement(position, context, phpClass) && PhpClassRefCompletionProvider.filterByNamespace(phpClass, restrict, position, parameters, nsp), phpClass -> PhpClassRefCompletionProvider.addLookupElement(phpClass, context, position, result)) || (context.isStatic() || context.isGeneric()) && PhpClassRefCompletionProvider.addClassElements(position, context, result, prefixMatcher, phpIndex, predicate)) {
                PhpCompletionContributor.handleOverflow(result.getResult());
            }
        }

        private static boolean addClassElements(@NotNull PsiElement position, @NotNull ClassUsageContext context, @NotNull CompletionResultSetWrapper result, PrefixMatcher prefixMatcher, PhpIndex phpIndex, Predicate<PhpClass> predicate) {
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(13);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(14);
            }
            if (result == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(15);
            }
            if (PhpPsiUtil.getParentOfClass(position, PhpDocComment.class) == null && PhpPsiUtil.getParentOfClass(position, PhpUse.class) == null) {
                return PhpClassRefCompletionProvider.addAllClasses(prefixMatcher, phpIndex, new PhpCompletionUtil.LimitedProcessor<PhpClass>(predicate, phpClass -> {
                    PhpLookupElement element = PhpVariantsUtil.getLookupItemForClass(phpClass, context);
                    if (element != null) {
                        result.addElement(element.createClassElement());
                    }
                }));
            }
            return false;
        }

        private static boolean addVariants(@NotNull ClassUsageContext context, @NotNull PrefixMatcher prefixMatcher, PhpIndex phpIndex, Predicate<PhpClass> predicate, Consumer<PhpClass> adder) {
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(16);
            }
            if (prefixMatcher == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(17);
            }
            PhpCompletionUtil.LimitedProcessor<PhpClass> processor2 = new PhpCompletionUtil.LimitedProcessor<PhpClass>(predicate, adder);
            if (context.isInInstanceof() || context.isInExtends()) {
                boolean result = !PhpCompletionUtil.addClassEntries(phpIndex, PhpCompletionUtil.PhpClassKind.CLASS, prefixMatcher, processor2);
                return result || !PhpCompletionUtil.addClassEntries(phpIndex, PhpCompletionUtil.PhpClassKind.INTERFACE, prefixMatcher, processor2);
            }
            if (context.isInImplements()) {
                return !PhpCompletionUtil.addClassEntries(phpIndex, PhpCompletionUtil.PhpClassKind.INTERFACE, prefixMatcher, processor2) || !PhpCompletionUtil.addClassEntries(phpIndex, PhpCompletionUtil.PhpClassKind.CLASS, prefixMatcher, processor2);
            }
            if (context.isInNew() || context.isInAttribute()) {
                return !PhpCompletionUtil.addClasses(phpIndex, prefixMatcher, predicate, adder);
            }
            if (context.isInClassUse()) {
                return !PhpCompletionUtil.addTraits(phpIndex, prefixMatcher, predicate, adder);
            }
            return PhpClassRefCompletionProvider.addAllClasses(prefixMatcher, phpIndex, processor2);
        }

        private static boolean addAllClasses(@NotNull PrefixMatcher prefixMatcher, PhpIndex phpIndex, PhpCompletionUtil.LimitedProcessor<PhpClass> processor2) {
            if (prefixMatcher == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(18);
            }
            boolean result = !PhpCompletionUtil.addClassEntries(phpIndex, PhpCompletionUtil.PhpClassKind.CLASS, prefixMatcher, processor2);
            result = result || !PhpCompletionUtil.addClassEntries(phpIndex, PhpCompletionUtil.PhpClassKind.INTERFACE, prefixMatcher, processor2);
            return result || !PhpCompletionUtil.addClassEntries(phpIndex, PhpCompletionUtil.PhpClassKind.TRAIT, prefixMatcher, processor2);
        }

        private static boolean filterByNamespace(PhpClass element, boolean restrict, PsiElement position, CompletionParameters parameters, boolean nsp) {
            if (restrict) {
                PsiElement prev = position instanceof PhpDocRef ? parameters.getPosition().getOriginalElement().getPrevSibling() : null;
                String namespaceName = nsp ? PhpCompletionContributor.getNamespace(prev, position) : null;
                return PhpCompletionUtil.hasNamespace(namespaceName, false, element);
            }
            return true;
        }

        private static boolean shouldAddElement(@NotNull PsiElement position, @NotNull ClassUsageContext context, @Nullable PhpClass aClass) {
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(19);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(20);
            }
            if (aClass == null) {
                return false;
            }
            PhpClass current = PhpPsiUtil.getParentOfClass(position, PhpClass.class);
            if (context.isInAttribute()) {
                List<PhpAttribute> rootAttributes = PhpClassCantBeUsedAsAttributeInspection.rootAttributes(aClass).collect(Collectors.toList());
                if (rootAttributes.isEmpty()) {
                    return false;
                }
                PhpAttributesList attributeList = PhpPsiUtil.getParentOfClass(position, PhpAttributesList.class);
                return attributeList == null || PhpInapplicableAttributeTargetDeclarationInspection.getInapplicableDeclarationName(attributeList.getParent(), rootAttributes) == null;
            }
            if (context.isInInstanceof()) {
                return PhpCompletionContributor.shouldAddClass(aClass, context, current) || PhpClassRefCompletionProvider.shouldAddInterface(aClass, context, position) || PhpCompletionContributor.shouldAddEnum(aClass, context);
            }
            if (context.isInExtends()) {
                if (current != null && current.isInterface()) {
                    return PhpClassRefCompletionProvider.shouldAddInterface(aClass, context, position) || PhpCompletionContributor.shouldAddClass(aClass, context, current);
                }
                return !aClass.isFinal() && (PhpCompletionContributor.shouldAddClass(aClass, context, current) || PhpClassRefCompletionProvider.shouldAddInterface(aClass, context, position));
            }
            if (context.isInImplements()) {
                return PhpClassRefCompletionProvider.shouldAddInterface(aClass, context, position) || PhpCompletionContributor.shouldAddClass(aClass, context, current);
            }
            if (context.isInNew()) {
                Method constructor = aClass.getConstructor();
                return (constructor == null || PhpAnnotatorVisitor.constructorAccessibleInContext(constructor, current)) && PhpCompletionContributor.shouldAddClass(aClass, context, current);
            }
            if (context.isInClassUse()) {
                return aClass.isTrait();
            }
            return PhpCompletionContributor.shouldAddClass(aClass, context, current) || PhpClassRefCompletionProvider.shouldAddInterface(aClass, context, position) || PhpCompletionContributor.shouldAddEnum(aClass, context) || !context.isInTypeDeclaration() && aClass.isTrait();
        }

        @NotNull
        private static PhpLookupElement createLookupElement(@NotNull ClassUsageContext context, @NotNull PhpUse use) {
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(21);
            }
            if (use == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(22);
            }
            PhpLookupElement lookupElement = new PhpLookupElement((PhpNamedElement)use);
            lookupElement.handler = PhpUseImpl.resolvesToClass(use) ? PhpVariantsUtil.getInsertHandlerForClassContext(context) : PhpNamespaceInsertHandler.getInstance();
            PhpLookupElement phpLookupElement = lookupElement;
            if (phpLookupElement == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(23);
            }
            return phpLookupElement;
        }

        @Nullable
        private static PhpClass getClass(@Nullable PhpUse phpUse) {
            if (phpUse != null) {
                PhpReference reference = phpUse.getTargetReference();
                return reference != null ? (PhpClass)reference.resolveGlobal(false).stream().filter(PhpClass.class::isInstance).findAny().orElse(null) : null;
            }
            return null;
        }

        private static boolean shouldAddInterface(@NotNull PhpClass anInterface, @NotNull ClassUsageContext context, @NotNull PsiElement position) {
            PhpClass extendingInterface;
            PhpClass aClass;
            if (anInterface == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(24);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(25);
            }
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(26);
            }
            if (!anInterface.isInterface()) {
                return false;
            }
            if (context.isInImplements() ? PhpClassRefCompletionProvider.containsReferenceToInterface((aClass = (PhpClass)position.getParent().getParent()).getImplementsList().getReferenceElements(), anInterface) : context.isInExtends() && (PhpLangUtil.equalsClassNames((extendingInterface = (PhpClass)position.getParent().getParent()).getFQN(), anInterface.getFQN()) || PhpClassRefCompletionProvider.containsReferenceToInterface(extendingInterface.getExtendsList().getReferenceElements(), anInterface))) {
                return false;
            }
            return PhpClassRefCompletionProvider.isNotIterable(anInterface) || !context.isInExtends() && !context.isStatic() && !context.isInImplements() && !(position.getParent() instanceof PhpUse);
        }

        private static boolean containsReferenceToInterface(@NotNull Collection<ClassReference> classReferences, @NotNull PhpClass anInterface) {
            if (classReferences == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(27);
            }
            if (anInterface == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(28);
            }
            String interfaceFQN = anInterface.getFQN();
            return ContainerUtil.exists(classReferences, classReference -> PhpLangUtil.equalsClassNames(classReference.getFQN(), interfaceFQN));
        }

        private static void addLookupElement(@NotNull PhpClass aClass, @NotNull ClassUsageContext context, @NotNull PsiElement position, @NotNull CompletionResultSetWrapper result) {
            PhpLookupElement lookupElement;
            if (aClass == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(29);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(30);
            }
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(31);
            }
            if (result == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(32);
            }
            if ((lookupElement = PhpVariantsUtil.getLookupItemForClass(aClass, context)) == null) {
                return;
            }
            if (!PhpClassRefCompletionProvider.canBeReferencedAsSuperClass(aClass, position)) {
                lookupElement.setNotApplicable();
            }
            result.addElement(lookupElement);
        }

        private static boolean canBeReferencedAsSuperClass(@NotNull PhpClass aClass, @NotNull PsiElement position) {
            PsiElement classDeclaration;
            PsiElement parent;
            if (aClass == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(33);
            }
            if (position == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(34);
            }
            if ((parent = position.getParent()) instanceof ImplementsList) {
                return aClass.isInterface();
            }
            if (parent instanceof ExtendsList && (classDeclaration = parent.getParent()) instanceof PhpClass) {
                return ((PhpClass)classDeclaration).isInterface() == aClass.isInterface();
            }
            return true;
        }

        private static boolean isNotIterable(@NotNull PhpClass anInterface) {
            if (anInterface == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(35);
            }
            return !PhpLangUtil.equalsClassNames(anInterface.getFQN(), "\\iterable");
        }

        private static LookupElement getBindingKeyword(@NotNull String keyword, @NotNull ClassUsageContext context, @NotNull Project project, @Nullable @NlsSafe String fqn) {
            if (keyword == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(36);
            }
            if (context == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(37);
            }
            if (project == null) {
                PhpClassRefCompletionProvider.$$$reportNull$$$0(38);
            }
            PhpType type = new PhpType().add(fqn);
            PhpReferenceInsertHandler handler = context.isInNew() ? PhpClassConstructorInsertHandler.getInstance() : PhpClassStaticInsertHandler.getInstance();
            PhpLookupElement element = PhpLookupElement.createKeywordLookupElement(keyword, PhpClassIndex.KEY, PhpIcons.STATIC_CLASS, type, project, handler);
            element.bold = true;
            return element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 23 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: 
                case 7: 
                case 9: 
                case 13: 
                case 19: 
                case 26: 
                case 31: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traitUseRule";
                    break;
                }
                case 3: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processingContext";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappedResult";
                    break;
                }
                case 8: 
                case 11: 
                case 14: 
                case 16: 
                case 20: 
                case 21: 
                case 25: 
                case 30: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixMatcher";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "use";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpClassRefCompletionProvider";
                    break;
                }
                case 24: 
                case 28: 
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anInterface";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classReferences";
                    break;
                }
                case 29: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyword";
                    break;
                }
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpClassRefCompletionProvider";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addTraitUseRuleTraits";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addUsedClassesAndNamespaces";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addClassesContextAware";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "addClassElements";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "addVariants";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "addAllClasses";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldAddElement";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupElement";
                    break;
                }
                case 23: {
                    break;
                }
                case 24: 
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldAddInterface";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "containsReferenceToInterface";
                    break;
                }
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "addLookupElement";
                    break;
                }
                case 33: 
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeReferencedAsSuperClass";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "isNotIterable";
                    break;
                }
                case 36: 
                case 37: 
                case 38: {
                    objectArray = objectArray;
                    objectArray[2] = "getBindingKeyword";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 23 -> new IllegalStateException(string);
            };
        }
    }

    private static class CollectFilteredUniquesProcessor
    extends CommonProcessors.CollectUniquesProcessor<String> {
        @NotNull
        private final PrefixMatcher myPrefixMatcher;

        CollectFilteredUniquesProcessor(@NotNull PrefixMatcher prefixMatcher) {
            if (prefixMatcher == null) {
                CollectFilteredUniquesProcessor.$$$reportNull$$$0(0);
            }
            this.myPrefixMatcher = prefixMatcher;
        }

        public boolean process(String s) {
            if (this.myPrefixMatcher.prefixMatches(s)) {
                return super.process((Object)s);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixMatcher", "com/jetbrains/php/completion/PhpCompletionContributor$CollectFilteredUniquesProcessor", "<init>"));
        }
    }

    private static final class PhpRadialSiblingIterator
    implements Iterator<PsiElement> {
        private PsiElement left;
        private PsiElement right;
        private boolean isLeftNext;

        private PhpRadialSiblingIterator(@NotNull PsiElement parent) {
            if (parent == null) {
                PhpRadialSiblingIterator.$$$reportNull$$$0(0);
            }
            this.left = parent.getPrevSibling();
            this.right = parent;
        }

        @Override
        public boolean hasNext() {
            return this.left != null || this.right != null;
        }

        @Override
        public PsiElement next() {
            if (this.left != null && (this.isLeftNext || this.right == null)) {
                this.isLeftNext = false;
                PsiElement element = this.left;
                this.left = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(this.left, true);
                return element;
            }
            if (this.right != null) {
                this.isLeftNext = true;
                PsiElement element = this.right;
                this.right = PhpPsiUtil.getNextSiblingIgnoreWhitespace(this.right, true);
                return element;
            }
            throw new IllegalStateException("hasNext() has not been called");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/php/completion/PhpCompletionContributor$PhpRadialSiblingIterator", "<init>"));
        }
    }

    private static final class PhpParameterFromTagLookupElement
    extends LookupElement {
        private final String myTypeHint;
        private final String myName;

        private PhpParameterFromTagLookupElement(PhpDocParamTag tag, Function function) {
            Project project = tag.getProject();
            this.myTypeHint = PhpAddMethodDeclarationQuickFix.createTypeHint(PhpLanguageLevel.current((Project)project), tag.getGlobalType(), (PsiElement)function, false, false);
            this.myName = tag.getVarName();
        }

        public void handleInsert(@NotNull InsertionContext context) {
            PsiElement classReference;
            if (context == null) {
                PhpParameterFromTagLookupElement.$$$reportNull$$$0(0);
            }
            super.handleInsert(context);
            PsiElement at = context.getFile().findElementAt(context.getEditor().getCaretModel().getOffset() - 1);
            Parameter parameter = PhpPsiUtil.getParentOfClass(at, false, Parameter.class);
            if (parameter == null) {
                return;
            }
            PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PsiTreeUtil.getChildOfType((PsiElement)parameter, PhpTypeDeclaration.class);
            PsiElement psiElement = classReference = typeDeclaration != null ? (PsiElement)ContainerUtil.getFirstItem((Collection)typeDeclaration.getClassReferences()) : null;
            if (classReference == null) {
                Parameter parameterWithTypeHint = PhpPsiElementFactory.createComplexParameter(context.getProject(), this.myTypeHint + " " + parameter.getText());
                parameter.replace((PsiElement)parameterWithTypeHint);
            }
        }

        @NotNull
        public String getLookupString() {
            String string = "$" + this.myName;
            if (string == null) {
                PhpParameterFromTagLookupElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void renderElement(@NotNull LookupElementPresentation presentation) {
            if (presentation == null) {
                PhpParameterFromTagLookupElement.$$$reportNull$$$0(2);
            }
            super.renderElement(presentation);
            if (StringUtil.isNotEmpty((String)this.myTypeHint)) {
                presentation.setTypeText(this.myTypeHint);
            }
            presentation.setIcon(PhpIcons.PARAMETER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpParameterFromTagLookupElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpParameterFromTagLookupElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "renderElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpExpressionGlobalCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final PhpExpressionGlobalCompletionProvider INSTANCE = new PhpExpressionGlobalCompletionProvider();

        private PhpExpressionGlobalCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            String fqn;
            if (parameters == null) {
                PhpExpressionGlobalCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpExpressionGlobalCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpExpressionGlobalCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            PsiElement parent = position.getParent();
            PsiElement grandParent = parent.getParent();
            boolean nsp = false;
            PsiElement prev = position.getPrevSibling();
            if (!(!PhpCompletionContributor.isNamespace(prev) || (fqn = PhpCompletionContributor.getNamespace(prev, parent)) != null && PhpLangUtil.isFqn(fqn) && PhpLangUtil.isGlobalNamespaceFQN(fqn))) {
                nsp = true;
            }
            if (!(nsp || PhpCompletionContributor.isList(position) || PhpCompletionContributor.isForeachKeyOrValue(position) || PhpCompletionContributor.isIssetOrUnset(position) || PhpCompletionContributor.isClosureUse(position) || PhpCompletionContributor.isGlobal(position) || !(position instanceof LeafPsiElement) || parent instanceof Variable || parent instanceof ClassReference || parent instanceof MemberReference || parent instanceof PhpCallableMethod || parent instanceof FunctionReference || parent instanceof PhpGoto || position instanceof PsiCommentImpl || PhpPsiUtil.getParentOfClass(position, PhpDocComment.class) != null)) {
                CompletionResultSetWrapper wrappedResult = PhpCompletionSorting.wrapResult(parameters, context, result);
                if (parameters.getInvocationCount() > 0 || !wrappedResult.getPrefixMatcher().getPrefix().isEmpty()) {
                    boolean isUse = grandParent instanceof PhpUse;
                    if (!isUse || PhpUseImpl.isOfConst((PhpUse)grandParent)) {
                        PhpCompletionContributor.addConstantVariants(position.getProject(), PhpCompletionContributor.getNamespaceNameForGroupUse(position), wrappedResult, parameters, isUse);
                    }
                    PhpCompletionContributor.addFunctionVariants(position.getProject(), grandParent, PhpCompletionContributor.getNamespaceNameForGroupUse(position), wrappedResult, parameters, isUse);
                    Collection<PhpUse> uses = PhpCompletionContributor.getUses(position);
                    for (PhpUse use : uses) {
                        PhpLookupElement element;
                        if (PhpUseImpl.isOfConst(use)) {
                            element = new PhpLookupElement((PhpNamedElement)use);
                            element.handler = PhpReferenceInsertHandler.getInstance();
                            wrappedResult.addElement(element);
                            continue;
                        }
                        if (!PhpUseImpl.isOfFunction(use) || PhpCompletionContributor.isDefaultValue(grandParent)) continue;
                        element = new PhpLookupElement((PhpNamedElement)use);
                        element.handler = PhpFunctionInsertHandler.getInstance();
                        wrappedResult.addElement(element);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpCompletionContributor$PhpExpressionGlobalCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

