/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.function.PhpPreviousFunctionDfaAnalyzerProcessor;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class PhpArrayIndexCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final PhpType ARRAY_OBJECT = new PhpType().add("\\ArrayObject");

    PhpArrayIndexCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        StringLiteralExpression literal;
        PsiElement position;
        if (parameters == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((position = parameters.getOriginalPosition()) == null) {
            position = parameters.getPosition().getOriginalElement();
        }
        if ((literal = PhpPsiUtil.getParentOfClass(position, true, StringLiteralExpression.class)) == null) {
            return;
        }
        ArrayAccessExpression array = PhpPsiUtil.getParentOfClass(position, true, ArrayAccessExpression.class);
        if (array == null) {
            return;
        }
        Project project = array.getProject();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
        PhpPsiElement arrayValue = array.getValue();
        if (arrayValue instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)arrayValue).getName(), "GLOBALS")) {
            return;
        }
        PhpArrayIndexCompletionProvider.addArrayObjectFields(result, (PsiElement)arrayValue, phpIndex);
        if (!(arrayValue instanceof PhpReference)) {
            return;
        }
        PsiElement decl = ((PhpReference)arrayValue).resolve();
        if (decl != null) {
            PsiFile declFile;
            boolean singleQuote = literal.isSingleQuote();
            HashSet<PhpPsiElement> visited = new HashSet<PhpPsiElement>();
            PsiFile currentFile = position.getContainingFile();
            if (currentFile != null) {
                PhpArrayIndexCompletionProvider.searchAndProcessReferences(decl.getOriginalElement(), (SearchScope)new LocalSearchScope((PsiElement)currentFile), result, array, singleQuote, visited);
            }
            if ((declFile = decl.getContainingFile()) != null && declFile != currentFile) {
                PhpArrayIndexCompletionProvider.searchAndProcessReferences(decl.getOriginalElement(), (SearchScope)new LocalSearchScope((PsiElement)declFile), result, array, singleQuote, visited);
            }
            if (parameters.getInvocationCount() <= 1) {
                result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.global.variants", PhpCompletionContributor.getCompletionActionShortcut()));
            } else {
                PhpArrayIndexCompletionProvider.searchAndProcessReferences(decl.getOriginalElement(), (SearchScope)phpIndex.getSearchScope(), result, array, singleQuote, visited);
            }
            if (decl instanceof Field) {
                PsiElement aeValue = ((Field)decl).getDefaultValue();
                PhpArrayIndexCompletionProvider.addArrayHashVariants(result, aeValue, singleQuote);
            }
        }
    }

    private static void searchAndProcessReferences(@NotNull PsiElement element, @NotNull SearchScope scope, @NotNull CompletionResultSet result, @NotNull ArrayAccessExpression array, boolean singleQuote, @NotNull Set<PhpPsiElement> visited) {
        if (element == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(4);
        }
        if (result == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(5);
        }
        if (array == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(6);
        }
        if (visited == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(7);
        }
        ReferencesSearch.search((PsiElement)element, (SearchScope)scope, (boolean)true).findAll().stream().filter(PhpPsiElement.class::isInstance).map(PhpPsiElement.class::cast).filter(visited::add).forEach(reference -> {
            PsiElement parent = reference.getParent();
            if (parent != array && parent instanceof ArrayAccessExpression) {
                ArrayIndex index = ((ArrayAccessExpression)parent).getIndex();
                if (index != null && index.getValue() instanceof StringLiteralExpression) {
                    PhpArrayIndexCompletionProvider.addIndex(result, (StringLiteralExpression)index.getValue(), singleQuote);
                }
            } else if (parent instanceof AssignmentExpression) {
                PhpPsiElement aeValue = ((AssignmentExpression)parent).getValue();
                PhpArrayIndexCompletionProvider.addArrayHashVariants(result, (PsiElement)aeValue, singleQuote);
            } else if (parent instanceof ParameterList && parent.getParent() instanceof FunctionReference) {
                PhpArrayIndexCompletionProvider.addArrayKeyExistsVariants(result, (FunctionReference)parent.getParent(), (ParameterList)parent, singleQuote);
            }
        });
    }

    private static PsiElement addArrayObjectFields(CompletionResultSet result, PsiElement arrayValue, PhpIndex phpIndex) {
        Variable value;
        PhpType type;
        if (arrayValue instanceof Variable && ARRAY_OBJECT.isConvertibleFrom(type = (value = (Variable)arrayValue).getGlobalType(), phpIndex)) {
            for (String fqn : type.getTypes()) {
                Collection classes = phpIndex.getClassesByFQN(fqn);
                for (PhpClass it : classes) {
                    if (it == null) continue;
                    for (Field field : it.getOwnFields()) {
                        String name = field.getName();
                        result.addElement((LookupElement)LookupElementBuilder.create((String)name));
                    }
                }
            }
        }
        return arrayValue;
    }

    private static void addArrayHashVariants(CompletionResultSet result, PsiElement aeValue, boolean singleQuote) {
        for (ArrayHashElement element : PhpPreviousFunctionDfaAnalyzerProcessor.unwrapMergedArrays(aeValue, true)) {
            PhpPsiElement key = element.getKey();
            if (!(key instanceof StringLiteralExpression)) continue;
            PhpArrayIndexCompletionProvider.addIndex(result, (StringLiteralExpression)key, singleQuote);
        }
    }

    private static void addArrayKeyExistsVariants(@NotNull CompletionResultSet result, @NotNull FunctionReference functionReference, @NotNull ParameterList parameterList, boolean singleQuote) {
        PsiElement[] parameters;
        String functionName;
        if (result == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(8);
        }
        if (functionReference == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(9);
        }
        if (parameterList == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(10);
        }
        if (PhpLangUtil.equalsFunctionNames(functionName = functionReference.getName(), "array_key_exists") && (parameters = parameterList.getParameters()).length == 2 && parameters[0] instanceof StringLiteralExpression) {
            PhpArrayIndexCompletionProvider.addIndex(result, (StringLiteralExpression)parameters[0], singleQuote);
        }
    }

    private static void addIndex(@NotNull CompletionResultSet result, @NotNull StringLiteralExpression key, boolean singleQuote) {
        String index;
        if (result == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(11);
        }
        if (key == null) {
            PhpArrayIndexCompletionProvider.$$$reportNull$$$0(12);
        }
        if (StringUtil.isNotEmpty((String)(index = key.getContents()))) {
            boolean keySingleQuote = key.isSingleQuote();
            if (keySingleQuote != singleQuote) {
                if (!PhpStringUtil.isUnescapableText(index, keySingleQuote)) {
                    return;
                }
                index = PhpStringUtil.unescapeText(index, keySingleQuote);
                index = PhpStringUtil.escapeText(index, singleQuote);
            }
            result.addElement((LookupElement)LookupElementBuilder.create((String)index));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/PhpArrayIndexCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "searchAndProcessReferences";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addArrayKeyExistsVariants";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

