/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow.instructions.impl;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionWithInversedEx;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpLinearInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConditionInstructionImpl
extends PhpLinearInstructionImpl
implements PhpConditionInstruction,
PhpInstructionWithInversedEx {
    private final boolean myResult;
    private PhpInstructionWithInversedEx myInverseInstruction;
    private PsiElement myShortCircuitRightOperand;

    public PhpConditionInstructionImpl(@Nullable PsiElement condition, boolean result) {
        super(condition);
        this.myResult = result;
    }

    @Nullable
    public PsiElement getCondition() {
        return this.myAnchor;
    }

    public boolean getResult() {
        return this.myResult;
    }

    @Override
    public boolean process(@NotNull PhpInstructionProcessor processor2) {
        if (processor2 == null) {
            PhpConditionInstructionImpl.$$$reportNull$$$0(0);
        }
        return processor2.processConditionInstruction((PhpConditionInstruction)this);
    }

    @Override
    @Nullable
    public PsiElement getAnchor() {
        return this.getCondition();
    }

    @Override
    public String toString() {
        return this.baseToString() + " CONDITION (" + this.myResult + ", " + this.getConditionPresentation() + ")";
    }

    protected String baseToString() {
        return super.toString();
    }

    @NotNull
    protected String getConditionPresentation() {
        return this.myAnchor != null ? this.myAnchor.getText() : "null";
    }

    @Override
    public void setInverseInstruction(PhpInstructionWithInversedEx instruction) {
        this.myInverseInstruction = instruction;
    }

    @Override
    public PhpInstructionWithInversedEx getInverseInstruction() {
        return this.myInverseInstruction;
    }

    public void setShortCircuitRightOperand(PsiElement shortCircuitRightOperand) {
        this.myShortCircuitRightOperand = shortCircuitRightOperand;
    }

    public PsiElement getShortCircuitRightOperand() {
        return this.myShortCircuitRightOperand;
    }

    private static boolean effectivelyTrue(PsiElement condition) {
        return PhpLangUtil.isTrue(condition) || PhpPsiUtil.isOfType(condition, PhpElementTypes.NUMBER) && PhpPsiUtil.getLiteralText(condition).equals("1");
    }

    @Override
    public boolean isUnreachable() {
        PsiElement condition = this.getCondition();
        return this.getResult() && PhpLangUtil.isFalse(condition) || !this.getResult() && PhpConditionInstructionImpl.effectivelyTrue(condition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/php/codeInsight/controlFlow/instructions/impl/PhpConditionInstructionImpl", "process"));
    }
}

