/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.PhpUnusedAliasInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import com.jetbrains.php.tools.quality.QualityToolExternalFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpImportOptimizer
implements ImportOptimizer {
    public boolean supports(@NotNull PsiFile file) {
        if (file == null) {
            PhpImportOptimizer.$$$reportNull$$$0(0);
        }
        return file instanceof PhpFile;
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file) {
        if (file == null) {
            PhpImportOptimizer.$$$reportNull$$$0(1);
        }
        PhpFile phpFile = (PhpFile)file;
        SmartList toInsert = new SmartList();
        SmartList toDelete = new SmartList();
        int unused = 0;
        unused += PhpImportOptimizer.processImports((PhpPsiElement)phpFile, (List<Pair<PhpUseList, List<PhpUseList>>>)toInsert, (List<PhpUseList>)toDelete);
        for (PhpNamespace namespace : PhpCodeInsightUtil.collectNamespaces((PsiFile)phpFile)) {
            unused += PhpImportOptimizer.processImports((PhpPsiElement)namespace, (List<Pair<PhpUseList, List<PhpUseList>>>)toInsert, (List<PhpUseList>)toDelete);
        }
        final int removed = unused;
        return new ImportOptimizer.CollectingInfoRunnable(){
            final /* synthetic */ List val$toDelete;
            final /* synthetic */ PsiFile val$file;
            final /* synthetic */ PhpFile val$phpFile;
            final /* synthetic */ List val$toInsert;
            {
                this.val$toDelete = list;
                this.val$file = psiFile;
                this.val$phpFile = phpFile;
                this.val$toInsert = list2;
            }

            @NotNull
            public String getUserNotificationInfo() {
                if (removed > 0) {
                    String string = PhpBundle.message("hint.text.use.statement.choice.s.removed", removed, removed > 1 ? 0 : 1);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = PhpBundle.message("hint.text.use.statements.checked.nothing.was.removed", this.val$toDelete.size());
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void run() {
                if (QualityToolExternalFormatter.isEnabled(this.val$file.getProject())) {
                    return;
                }
                PhpImportOptimizer.commitDocument((PsiFile)this.val$phpFile);
                for (Pair pair : this.val$toInsert) {
                    PsiElement anchor = (PsiElement)pair.getFirst();
                    PsiElement parent = anchor.getParent();
                    if (parent == null || !parent.isValid()) continue;
                    for (PhpUseList element : (List)pair.getSecond()) {
                        parent.addBefore((PsiElement)element, anchor);
                    }
                }
                for (PhpUseList useList : this.val$toDelete) {
                    useList.delete();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/codeInsight/PhpImportOptimizer$1", "getUserNotificationInfo"));
            }
        };
    }

    private static void commitDocument(@NotNull PsiFile file) {
        PsiDocumentManager manager;
        Document document;
        if (file == null) {
            PhpImportOptimizer.$$$reportNull$$$0(2);
        }
        if ((document = (manager = PsiDocumentManager.getInstance((Project)file.getProject())).getDocument(file)) != null) {
            manager.commitDocument(document);
        }
    }

    private static int processImports(@NotNull PhpPsiElement scope, @NotNull List<Pair<PhpUseList, List<PhpUseList>>> toInsert, @NotNull List<PhpUseList> toDelete) {
        if (scope == null) {
            PhpImportOptimizer.$$$reportNull$$$0(3);
        }
        if (toInsert == null) {
            PhpImportOptimizer.$$$reportNull$$$0(4);
        }
        if (toDelete == null) {
            PhpImportOptimizer.$$$reportNull$$$0(5);
        }
        Project project = scope.getProject();
        List<PhpUseList> useLists = PhpCodeInsightUtil.collectImports(scope);
        if (useLists.isEmpty()) {
            return 0;
        }
        int unused = 0;
        ArrayList<PhpImport> imports = new ArrayList<PhpImport>();
        for (PhpUseList useList : useLists) {
            Object[] declarations = useList.getDeclarations();
            Set<PhpUse> unusedDeclarations = PhpUnusedAliasInspection.filterUnused((PsiElement)scope, Arrays.stream(declarations).toList());
            List usedDeclarations = ContainerUtil.filter((Object[])declarations, use -> !unusedDeclarations.contains(use) && !PhpCodeInsightUtil.isUnnecessary(use));
            unused += declarations.length - usedDeclarations.size();
            if (usedDeclarations.isEmpty()) continue;
            PhpNamespaceReference namespaceReference = useList.getNamespaceReference();
            if (namespaceReference != null) {
                PhpImportOptimizer.processGroupUseDeclarations(project, useList, usedDeclarations, namespaceReference, imports);
                continue;
            }
            PhpImportOptimizer.processUseDeclarations(project, useList, usedDeclarations, imports);
        }
        ContainerUtil.sort(imports, PhpImportOptimizer.getComparator(scope.getContainingFile()));
        toInsert.add((Pair<PhpUseList, List<PhpUseList>>)Pair.create((Object)useLists.get(0), (Object)ContainerUtil.map(imports, phpImport -> phpImport.useList)));
        toDelete.addAll(useLists);
        return unused;
    }

    private static int getGroupUseElementLength(@NotNull PhpGroupUseElement i) {
        Object[] declarations;
        if (i == null) {
            PhpImportOptimizer.$$$reportNull$$$0(6);
        }
        int length = i.name.length();
        length += i.alias != null ? i.alias.length() + 3 : 0;
        length += i.keyword != null ? i.keyword.length() + 1 : 0;
        if (i instanceof PhpImport && (declarations = ((PhpImport)i).useList.getDeclarations()).length > 1) {
            length += StringUtil.join((Collection)ContainerUtil.map((Object[])declarations, PhpUseImpl::getReferenceText), (String)" ,").length() + 2;
        }
        return length;
    }

    private static void processGroupUseDeclarations(@NotNull Project project, @NotNull PhpUseList useList, @NotNull List<PhpUse> usedDeclarations, @NotNull PhpNamespaceReference namespaceReference, @NotNull List<PhpImport> imports) {
        if (project == null) {
            PhpImportOptimizer.$$$reportNull$$$0(7);
        }
        if (useList == null) {
            PhpImportOptimizer.$$$reportNull$$$0(8);
        }
        if (usedDeclarations == null) {
            PhpImportOptimizer.$$$reportNull$$$0(9);
        }
        if (namespaceReference == null) {
            PhpImportOptimizer.$$$reportNull$$$0(10);
        }
        if (imports == null) {
            PhpImportOptimizer.$$$reportNull$$$0(11);
        }
        String useListKeyword = PhpGroupUseElement.getKeyword(null, useList);
        String fqn = PhpLangUtil.toFQN(namespaceReference.getFullName());
        ArrayList<PhpGroupUseElement> uses = new ArrayList<PhpGroupUseElement>();
        for (PhpUse declaration : usedDeclarations) {
            String name = PhpUseImpl.getReferenceText(declaration);
            String alias = declaration.getAliasName();
            String useKeyword = PhpGroupUseElement.getKeyword(declaration, null);
            uses.add(new PhpGroupUseElement(useKeyword, name, alias));
        }
        if (!uses.isEmpty()) {
            ContainerUtil.sort(uses, PhpImportOptimizer.getComparator(useList.getContainingFile()));
            boolean trailingComma = PhpUseListImpl.getTrailingComma(useList) != null;
            PhpUseList newGroupUse = PhpPsiElementFactory.createGroupUseStatement(project, useListKeyword, fqn, uses, trailingComma);
            imports.add(new PhpImport(useListKeyword, fqn, null, newGroupUse));
        }
    }

    private static void processUseDeclarations(@NotNull Project project, @NotNull PhpUseList useList, @NotNull List<PhpUse> usedDeclarations, @NotNull List<PhpImport> imports) {
        if (project == null) {
            PhpImportOptimizer.$$$reportNull$$$0(12);
        }
        if (useList == null) {
            PhpImportOptimizer.$$$reportNull$$$0(13);
        }
        if (usedDeclarations == null) {
            PhpImportOptimizer.$$$reportNull$$$0(14);
        }
        if (imports == null) {
            PhpImportOptimizer.$$$reportNull$$$0(15);
        }
        for (PhpUse use : usedDeclarations) {
            String keyword = PhpGroupUseElement.getKeyword(use, useList);
            String fqn = use.getFQN();
            String alias = use.getAliasName();
            PhpUseList newUseList = PhpPsiElementFactory.createUseStatementWithKeyword(project, keyword, fqn, alias);
            imports.add(new PhpImport(keyword, fqn, alias, newUseList));
        }
    }

    @NotNull
    public static Comparator<PhpGroupUseElement> getComparator(@NotNull PsiFile file) {
        PhpCodeStyleSettings.ImportSorting sorting;
        if (file == null) {
            PhpImportOptimizer.$$$reportNull$$$0(16);
        }
        PhpGroupUseComparator phpGroupUseComparator = (sorting = ((PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class)).IMPORT_SORTING) == PhpCodeStyleSettings.ImportSorting.DONT_SORT ? PhpGroupUseComparator.dontSortComparator : (sorting == PhpCodeStyleSettings.ImportSorting.BY_LENGTH ? PhpGroupUseComparator.byLengthComparator : PhpGroupUseComparator.alphabeticComparator);
        if (phpGroupUseComparator == null) {
            PhpImportOptimizer.$$$reportNull$$$0(17);
        }
        return phpGroupUseComparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDelete";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useList";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedDeclarations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceReference";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/PhpImportOptimizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/PhpImportOptimizer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGroupUseElementLength";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processGroupUseDeclarations";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processUseDeclarations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getComparator";
                break;
            }
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17 -> new IllegalStateException(string);
        };
    }

    private static final class PhpImport
    extends PhpGroupUseElement {
        @NotNull
        private final PhpUseList useList;

        private PhpImport(@NotNull String keyword, @NotNull String name, @Nullable String alias, @NotNull PhpUseList useList) {
            if (keyword == null) {
                PhpImport.$$$reportNull$$$0(0);
            }
            if (name == null) {
                PhpImport.$$$reportNull$$$0(1);
            }
            if (useList == null) {
                PhpImport.$$$reportNull$$$0(2);
            }
            super(keyword, name, alias);
            this.useList = useList;
        }

        @Override
        public String toString() {
            return "PhpImport{useList=" + String.valueOf(this.useList) + "} " + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "keyword";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "useList";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/codeInsight/PhpImportOptimizer$PhpImport";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PhpGroupUseComparator
    implements Comparator<PhpGroupUseElement> {
        private final PhpCodeStyleSettings.ImportSorting mySorting;
        private static final PhpGroupUseComparator byLengthComparator = new PhpGroupUseComparator(PhpCodeStyleSettings.ImportSorting.BY_LENGTH);
        private static final PhpGroupUseComparator alphabeticComparator = new PhpGroupUseComparator(PhpCodeStyleSettings.ImportSorting.ALPHABETIC);
        private static final PhpGroupUseComparator dontSortComparator = new PhpGroupUseComparator(PhpCodeStyleSettings.ImportSorting.DONT_SORT);

        private PhpGroupUseComparator(PhpCodeStyleSettings.ImportSorting sorting) {
            this.mySorting = sorting;
        }

        @Override
        public int compare(PhpGroupUseElement phpImport1, PhpGroupUseElement phpImport2) {
            if (this.mySorting == PhpCodeStyleSettings.ImportSorting.DONT_SORT) {
                return 0;
            }
            if (!StringUtil.equalsIgnoreCase((CharSequence)phpImport1.keyword, (CharSequence)phpImport2.keyword)) {
                if (StringUtil.isEmpty((String)phpImport1.keyword)) {
                    return -1;
                }
                if (StringUtil.isEmpty((String)phpImport2.keyword)) {
                    return 1;
                }
                return phpImport2.keyword.length() - phpImport1.keyword.length();
            }
            if (this.mySorting == PhpCodeStyleSettings.ImportSorting.BY_LENGTH) {
                return PhpImportOptimizer.getGroupUseElementLength(phpImport1) - PhpImportOptimizer.getGroupUseElementLength(phpImport2);
            }
            int compare = PhpLangUtil.compareFQN(PhpLangUtil.toFQN(phpImport1.name), PhpLangUtil.toFQN(phpImport2.name));
            if (compare != 0) {
                return compare;
            }
            return StringUtil.compare((String)phpImport1.alias, (String)phpImport2.alias, (boolean)true);
        }
    }
}

