/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.copyPaste;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.intentions.PhpReplaceQuotesIntention;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReplaceUnnecessaryDoubleQuotesPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (!PhpSmartKeysConfiguration.getInstance().isReplaceUnnecessaryDoubleQuotes()) {
            String string = text;
            if (string == null) {
                PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (file instanceof PhpFile) {
            SelectionModel selectionModel = editor.getSelectionModel();
            int caretOffset = selectionModel.hasSelection() ? selectionModel.getSelectionStart() : editor.getCaretModel().getOffset();
            PsiElement element = file.findElementAt(caretOffset);
            if (PhpPsiUtil.getParentOfClass(element, StringLiteralExpression.class) != null) {
                String string = text;
                if (string == null) {
                    PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(1);
                }
                return string;
            }
            PhpFile tempFile = PhpPsiElementFactory.createFirstFromText(project, PhpFile.class, text);
            if (tempFile == null) {
                String string = text;
                if (string == null) {
                    PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(2);
                }
                return string;
            }
            Document document = FileDocumentManager.getInstance().getDocument(tempFile.getViewProvider().getVirtualFile());
            if (document == null) {
                String string = text;
                if (string == null) {
                    PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(3);
                }
                return string;
            }
            ArrayList strings = new ArrayList(PsiTreeUtil.findChildrenOfType((PsiElement)tempFile, StringLiteralExpression.class));
            for (StringLiteralExpression string : strings) {
                if (string.isSingleQuote() || PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.areDoubleQuotesNecessary(string) || !PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.isWrappedWithDoubleQuotes(string) || PhpPsiUtil.getParentOfClass((PsiElement)string, PhpDocComment.class) != null || PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.tryReplace(document, string)) continue;
                String string2 = text;
                if (string2 == null) {
                    PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(4);
                }
                return string2;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            String string = document.getText().substring(6);
            if (string == null) {
                PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean tryReplace(Document document, StringLiteralExpression string) {
        String stringWithReplacedQuotes = PhpReplaceQuotesIntention.createTextWithChangedQuotes(string);
        TextRange range = string.getTextRange();
        if (stringWithReplacedQuotes.length() != string.getTextLength()) {
            return false;
        }
        try {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)stringWithReplacedQuotes);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean areDoubleQuotesNecessary(@NotNull StringLiteralExpression expression) {
        if (expression == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(7);
        }
        return PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.isInterpolatedString(expression) || PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.hasSingleQuotes(expression) || PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.hasEscapeSequences(expression);
    }

    public static boolean isInterpolatedString(@NotNull StringLiteralExpression value) {
        if (value == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(8);
        }
        return PhpPsiUtil.getChildByCondition((PsiElement)value, (Condition<? super PsiElement>)Variable.INSTANCEOF) != null;
    }

    private static boolean hasEscapeSequences(@NotNull StringLiteralExpression expression) {
        if (expression == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(9);
        }
        String unescapedText = PhpStringUtil.unescapeText(expression.getText(), false);
        return !expression.getText().equals(unescapedText);
    }

    private static boolean hasSingleQuotes(@NotNull StringLiteralExpression expression) {
        if (expression == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(10);
        }
        return expression.textContains('\'');
    }

    private static boolean isWrappedWithDoubleQuotes(@NotNull StringLiteralExpression expression) {
        if (expression == null) {
            PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.$$$reportNull$$$0(11);
        }
        return expression.getText().length() > 1 && expression.getText().charAt(0) == '\"' && expression.getText().charAt(expression.getTextLength() - 1) == '\"';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/copyPaste/PhpReplaceUnnecessaryDoubleQuotesPasteProcessor";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/copyPaste/PhpReplaceUnnecessaryDoubleQuotesPasteProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areDoubleQuotesNecessary";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInterpolatedString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasEscapeSequences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasSingleQuotes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isWrappedWithDoubleQuotes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

