/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.DynamicBundle;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.PhpNewBaseAction;
import com.jetbrains.php.actions.statistics.PhpNewClassUsageLogger;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.templates.PhpCreateFileFromTemplateDataProvider;
import com.jetbrains.php.templates.PhpFileTemplateUtil;
import com.jetbrains.php.templates.PhpTemplatesSettings;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class PhpNewFileDialog
extends DialogWrapper
implements PhpCreateFileFromTemplateDataProvider {
    private static final int INIT_FILE_NAME_LENGTH = 30;
    private JPanel myMainPanel;
    protected JComboBox myExtensionComboBox;
    private JLabel myExtensionUpDownHint;
    private EditorTextField myFileNameField;
    @NotNull
    private final Project myProject;
    @NotNull
    protected final PsiDirectory myDirectory;

    public PhpNewFileDialog(@NotNull Project project, @NotNull PsiDirectory directory) {
        if (project == null) {
            PhpNewFileDialog.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            PhpNewFileDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.myDirectory = directory;
        this.$$$setupUI$$$();
        Object[] registeredExtensions = PhpFileTemplateUtil.getRegisteredPhpFileExtensions();
        this.myExtensionComboBox.setModel(new DefaultComboBoxModel<String>(registeredExtensions));
        int indexOfLast = ArrayUtil.indexOf((Object[])registeredExtensions, (Object)PhpTemplatesSettings.getInstance((Project)project).NEW_PHP_FILE_LAST_EXTENSION);
        if (indexOfLast > -1) {
            this.myExtensionComboBox.setSelectedIndex(indexOfLast);
        } else {
            this.myExtensionComboBox.setSelectedIndex(0);
        }
        this.myExtensionUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.myExtensionUpDownHint.setToolTipText(PhpBundle.message("actions.new.php.base.arrows.extension.tooltip", new Object[0]));
        this.init();
    }

    protected void init() {
        this.setTitle(PhpBundle.message("actions.new.php.file.dialog.title", new Object[0]));
        ComboboxSpeedSearch search = new ComboboxSpeedSearch(this.myExtensionComboBox, null){

            protected String getElementText(Object element) {
                return (String)element;
            }
        };
        search.setupListeners();
        KeyboardShortcut up = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null);
        KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null);
        AnAction extensionArrow = PhpNewFileDialog.getCbArrowAction(this.myExtensionComboBox);
        extensionArrow.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), (JComponent)this.myFileNameField);
        super.init();
    }

    @NotNull
    public static AnAction getCbArrowAction(final JComboBox extensionComboBox) {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e.getInputEvent() instanceof KeyEvent) {
                    int code = ((KeyEvent)e.getInputEvent()).getKeyCode();
                    int delta = code == 40 ? 1 : (code == 38 ? -1 : 0);
                    int size = extensionComboBox.getModel().getSize();
                    int next = extensionComboBox.getSelectedIndex() + delta;
                    if (next < 0 || next >= size) {
                        if (!UISettings.getInstance().getCycleScrolling()) {
                            return;
                        }
                        next = (next + size) % size;
                    }
                    extensionComboBox.setSelectedIndex(next);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/actions/PhpNewFileDialog$2", "actionPerformed"));
            }
        };
    }

    protected String getDimensionServiceKey() {
        return "NewPhpFileDialog";
    }

    protected ValidationInfo doValidate() {
        String errorMessage = PhpNewBaseAction.isValidFilePath(this.getFilePath(), this.myDirectory);
        if (errorMessage != null) {
            return new ValidationInfo(errorMessage, (JComponent)this.myFileNameField);
        }
        return null;
    }

    protected void doOKAction() {
        String extension;
        PhpTemplatesSettings.getInstance((Project)this.myProject).NEW_PHP_FILE_LAST_EXTENSION = extension = this.getExtension();
        super.doOKAction();
        PhpNewClassUsageLogger.logNewFile(this.myProject, extension);
    }

    protected JComponent createCenterPanel() {
        Font font = this.myFileNameField.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.myFileNameField.getFontMetrics(font);
            int width = fontMetrics.charWidth('a') * 30;
            this.myFileNameField.setPreferredWidth(width);
        }
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFileNameField;
    }

    @Override
    @NotNull
    public String getFilePath() {
        String filename;
        String extension;
        String chosenExtension = this.getExtension();
        if (chosenExtension.equals(extension = PhpNameUtil.getExtension(filename = this.getFileName()))) {
            String string = filename;
            if (string == null) {
                PhpNewFileDialog.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = PhpNameUtil.getFullFileName(filename, chosenExtension);
        if (string == null) {
            PhpNewFileDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiDirectory getBaseDirectory() {
        PsiDirectory psiDirectory = this.myDirectory;
        if (psiDirectory == null) {
            PhpNewFileDialog.$$$reportNull$$$0(4);
        }
        return psiDirectory;
    }

    @Override
    @NotNull
    public String getTemplateName() {
        return "PHP File";
    }

    @Override
    @NotNull
    public Properties getProperties(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpNewFileDialog.$$$reportNull$$$0(5);
        }
        Properties properties = FileTemplateManager.getInstance((Project)this.myProject).getDefaultProperties();
        if (properties == null) {
            PhpNewFileDialog.$$$reportNull$$$0(6);
        }
        return properties;
    }

    @NotNull
    private String getFileName() {
        String string = this.myFileNameField.getText().trim();
        if (string == null) {
            PhpNewFileDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String getExtension() {
        String string = (String)this.myExtensionComboBox.getSelectedItem();
        if (string == null) {
            PhpNewFileDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EditorTextField editorTextField;
        JLabel jLabel;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewFileDialog.class).getString("actions.new.php.base.dialog.label.file.name"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExtensionComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewFileDialog.class).getString("actions.new.php.base.dialog.label.extension"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExtensionUpDownHint = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileNameField = editorTextField = new EditorTextField();
        jPanel.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/PhpNewFileDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/PhpNewFileDialog";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

