/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.DynamicBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TreeChooser;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.actions.PhpBaseNewClassDialog;
import com.jetbrains.php.actions.PhpNewClassDataProvider;
import com.jetbrains.php.actions.PhpNewFileDialog;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.actions.statistics.PhpNewClassUsageLogger;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurableForm;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.roots.ui.PhpNamespaceComboBox;
import com.jetbrains.php.roots.ui.PhpPsrDirectoryComboBox;
import com.jetbrains.php.templates.PhpFileTemplateUtil;
import com.jetbrains.php.templates.PhpTemplatesSettings;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNewClassDialog
extends PhpBaseNewClassDialog
implements PhpNewClassDataProvider {
    private static final String LAST_SELECTED_CUSTOM_TEMPLATE_NAME_PROPERTY = PhpNewClassDialog.class.getName() + ".lastSelectedCustomTemplate";
    private JPanel myMainPanel;
    public EditorTextField myNameTextField;
    public PhpNamespaceComboBox myNamespaceCombobox;
    public EditorTextField myFileNameTextField;
    public JComboBox<Object> myTemplateComboBox;
    protected JComboBox<String> myExtensionComboBox;
    private JLabel myTemplateUpDownHint;
    private JLabel myExtensionUpDownHint;
    private JBLabel myNamespaceCompletionHintLabel;
    protected PhpPsrDirectoryComboBox myDirectoryCombobox;
    private JBLabel myEditDirectoryHintLabel;
    private JBCheckBox myUseTemplateNextTimeCheckBox;
    private EditorTextField mySuperFqnTextField;
    private JBLabel mySuperFqnCompletionHintLabel;
    private JPanel myInterfaceFqnsToImplementPanel;
    private final TableView<Ref<String>> myInterfaceFqnsToImplementTable;
    public boolean myTemplateTypeChangedUnderFocus;
    public boolean myExtensionTypeChangedUnderFocus;
    public boolean mySuperFqnTextChangedUnderFocus;
    public boolean myInterfaceFqnsToImplementTableChangedUnderFocus;
    private Properties myCustomProperties;

    public PhpNewClassDialog(@NotNull Project project, @Nullable PsiDirectory directory) {
        if (project == null) {
            PhpNewClassDialog.$$$reportNull$$$0(0);
        }
        super(project, directory);
        this.$$$setupUI$$$();
        this.myInterfaceFqnsToImplementTable = new TableView();
        this.myCustomProperties = new Properties();
        this.init(this.myMainPanel, this.myNameTextField, this.myNamespaceCombobox, this.myNamespaceCompletionHintLabel, this.myFileNameTextField, this.myDirectoryCombobox, this.myEditDirectoryHintLabel);
        this.init();
    }

    @Override
    public String getClassName() {
        return this.myNameTextField.getText();
    }

    @Override
    public String getNamespaceName() {
        return this.getNamespace();
    }

    @Override
    @Nullable
    public String getSuperFqn() {
        if (!PhpNewClassDialog.canOverrideSuperClass(this.getSelectedClassCreationType())) {
            return null;
        }
        String superFqn = this.mySuperFqnTextField.getText();
        return StringUtil.isNotEmpty((String)superFqn) ? PhpLangUtil.toFQN(superFqn) : null;
    }

    public static boolean canOverrideSuperClass(@NotNull ClassCreationType classCreationType) {
        if (classCreationType == null) {
            PhpNewClassDialog.$$$reportNull$$$0(1);
        }
        return ClassCreationType.CLASS.equals((Object)classCreationType);
    }

    @Override
    @NotNull
    public Collection<String> getInterfaceFqnsToImplement() {
        Collection<String> collection = PhpNewClassDialog.canImplementInterface(this.getSelectedClassCreationType()) ? PhpNewClassDialog.getOrderedClassFqns(this.myInterfaceFqnsToImplementTable) : Collections.emptyList();
        if (collection == null) {
            PhpNewClassDialog.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getOrderedClassFqns(@NotNull TableView<Ref<String>> table) {
        if (table == null) {
            PhpNewClassDialog.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.map((Collection)table.getListTableModel().getItems(), Ref::get);
        if (list == null) {
            PhpNewClassDialog.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static boolean canImplementInterface(@NotNull ClassCreationType classCreationType) {
        if (classCreationType == null) {
            PhpNewClassDialog.$$$reportNull$$$0(5);
        }
        return ClassCreationType.CLASS.equals((Object)classCreationType) || ClassCreationType.INTERFACE.equals((Object)classCreationType) || ClassCreationType.ENUM.equals((Object)classCreationType);
    }

    protected void init() {
        this.setTitle(PhpBundle.message("actions.new.php.class.dialog.title", new Object[0]));
        Object[] registeredExtensions = PhpFileTemplateUtil.getRegisteredPhpFileExtensions();
        this.myExtensionComboBox.setModel(new DefaultComboBoxModel<String>(registeredExtensions));
        int indexOfLast = ArrayUtil.indexOf((Object[])registeredExtensions, (Object)PhpTemplatesSettings.getInstance((Project)this.getProject()).NEW_PHP_CLASS_LAST_EXTENSION);
        if (indexOfLast > -1) {
            this.myExtensionComboBox.setSelectedIndex(indexOfLast);
        } else {
            this.myExtensionComboBox.setSelectedIndex(0);
        }
        this.myTemplateUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.myTemplateUpDownHint.setToolTipText(PhpBundle.message("actions.new.php.base.arrows.template.tooltip", new Object[0]));
        this.myExtensionUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.myExtensionUpDownHint.setToolTipText(PhpBundle.message("actions.new.php.base.arrows.extension.tooltip", new Object[0]));
        this.myTemplateComboBox.setRenderer((ListCellRenderer<Object>)new SimpleListCellRenderer<Object>(){
            private final Component mySeparator = new TitledSeparator();

            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return value instanceof ClassCreationType ? super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus) : this.mySeparator;
            }

            public void customize(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setText(((ClassCreationType)((Object)value)).getName());
                this.setIcon(((ClassCreationType)((Object)value)).getIcon());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/php/actions/PhpNewClassDialog$1", "customize"));
            }
        });
        ComboboxSpeedSearch search = new ComboboxSpeedSearch(this.myTemplateComboBox, null){

            protected String getElementText(Object element) {
                return ((ClassCreationType)((Object)element)).getName();
            }
        };
        search.setupListeners();
        KeyboardShortcut up = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null);
        KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null);
        AnAction templateArrow = PhpNewFileDialog.getCbArrowAction(this.myTemplateComboBox);
        templateArrow.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), (JComponent)this.myNameTextField);
        for (ClassCreationType it : ClassCreationType.BUNDLED) {
            if (StringUtil.equals((CharSequence)it.getTemplateName(), (CharSequence)"PHP Trait")) {
                if (!PhpLanguageFeature.TRAITS.isSupported(this.myProject)) continue;
                this.myTemplateComboBox.addItem((Object)it);
                continue;
            }
            if (StringUtil.equals((CharSequence)it.getTemplateName(), (CharSequence)"PHP Enum")) {
                if (!PhpLanguageFeature.ENUM_CLASSES.isSupported(this.myProject)) continue;
                this.myTemplateComboBox.addItem((Object)it);
                continue;
            }
            this.myTemplateComboBox.addItem((Object)it);
        }
        this.addCustomPhpTemplatesToCombo();
        this.myTemplateComboBox.addItemListener(e -> this.updateSuperClassesPanel());
        boolean defaultCustomTemplateExists = this.getDefaultCustomTemplateName() != null;
        this.myUseTemplateNextTimeCheckBox.setVisible(defaultCustomTemplateExists);
        this.myUseTemplateNextTimeCheckBox.setSelected(defaultCustomTemplateExists);
        AnAction extensionArrow = PhpNewFileDialog.getCbArrowAction(this.myExtensionComboBox);
        extensionArrow.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), (JComponent)this.myFileNameTextField);
        PhpCompletionUtil.installClassCompletion(this.mySuperFqnTextField, "", this.getDisposable(), (Condition<? super PhpClass>)((Condition)clazz -> !clazz.isFinal() && !PhpCompletionUtil.hasNamespace((PhpNamedElement)clazz, "\\___PHPSTORM_HELPERS")), new String[0]);
        this.mySuperFqnCompletionHintLabel.setText(PhpBundle.message("0.completion.shortcut", "class", PhpUiUtil.getShortcutTextByActionName("CodeCompletion")));
        ToolbarDecorator interfacesDecorator = PhpProjectConfigurableForm.initClassesTable(this.myProject, this.myInterfaceFqnsToImplementTable, (TreeChooser.Filter<? super PhpClass>)((TreeChooser.Filter)PhpClass::isInterface));
        interfacesDecorator.setAddActionName(PhpBundle.message("actions.new.php.class.dialog.label.superinterfaces.add.interface", new Object[0]));
        this.myInterfaceFqnsToImplementPanel.add((Component)interfacesDecorator.createPanel(), "Center");
        this.updateSuperClassesPanel();
        this.initChangeDetectors();
        super.init();
    }

    @Override
    protected void initChangeDetectors() {
        super.initChangeDetectors();
        this.myTemplateComboBox.addItemListener(e -> {
            if (!this.myTemplateComboBox.isFocusOwner()) {
                return;
            }
            this.myTemplateTypeChangedUnderFocus = true;
        });
        this.myExtensionComboBox.addItemListener(e -> {
            if (!this.myExtensionComboBox.isFocusOwner()) {
                return;
            }
            this.myExtensionTypeChangedUnderFocus = true;
        });
        this.mySuperFqnTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!PhpNewClassDialog.this.mySuperFqnTextField.isFocusOwner()) {
                    return;
                }
                PhpNewClassDialog.this.mySuperFqnTextChangedUnderFocus = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/actions/PhpNewClassDialog$3", "documentChanged"));
            }
        });
        this.myInterfaceFqnsToImplementTable.getListTableModel().addTableModelListener(e -> {
            this.myInterfaceFqnsToImplementTableChangedUnderFocus = true;
        });
        this.myNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                PhpNewClassDialog.this.addUpdateRequest(() -> {
                    PhpNewClassDialog.this.myFileNameTextField.setText(PhpNewClassDialog.this.getName());
                    if (PhpNewClassDialog.this.myTemplateComboBox.isEnabled()) {
                        if (PhpNewClassDialog.this.getName().endsWith("Interface")) {
                            PhpNewClassDialog.this.myTemplateComboBox.setSelectedItem((Object)ClassCreationType.INTERFACE);
                        } else if (PhpNewClassDialog.this.getName().endsWith("Class")) {
                            PhpNewClassDialog.this.myTemplateComboBox.setSelectedItem((Object)ClassCreationType.CLASS);
                        } else if (PhpNewClassDialog.this.getName().endsWith("Trait")) {
                            PhpNewClassDialog.this.myTemplateComboBox.setSelectedItem((Object)ClassCreationType.TRAIT);
                        } else if (PhpNewClassDialog.this.getName().endsWith("Enum")) {
                            PhpNewClassDialog.this.myTemplateComboBox.setSelectedItem((Object)ClassCreationType.ENUM);
                        }
                    }
                }, 10);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/actions/PhpNewClassDialog$4", "documentChanged"));
            }
        });
    }

    private void updateSuperClassesPanel() {
        if (!(this.myTemplateComboBox.getSelectedItem() instanceof ClassCreationType)) {
            return;
        }
        boolean canInheritSuperClasses = this.canInheritSuperClasses();
        ClassCreationType selectedClassCreationType = this.getSelectedClassCreationType();
        this.mySuperFqnTextField.setEnabled(canInheritSuperClasses && PhpNewClassDialog.canOverrideSuperClass(selectedClassCreationType));
        this.myInterfaceFqnsToImplementTable.setEnabled(canInheritSuperClasses && PhpNewClassDialog.canImplementInterface(selectedClassCreationType));
        this.updateInterfacesFqnsToImplementTableTitles();
    }

    private void updateInterfacesFqnsToImplementTableTitles() {
        String tableEmptyText = PhpNewClassDialog.canExtendInterface(this.getSelectedClassCreationType()) ? PhpBundle.message("actions.new.php.class.dialog.label.superinterfaces.to.extend.empty", new Object[0]) : PhpBundle.message("actions.new.php.class.dialog.label.superinterfaces.to.implement.empty", new Object[0]);
        this.myInterfaceFqnsToImplementTable.getEmptyText().setText(tableEmptyText);
    }

    private static boolean canExtendInterface(@NotNull ClassCreationType classCreationType) {
        if (classCreationType == null) {
            PhpNewClassDialog.$$$reportNull$$$0(6);
        }
        return ClassCreationType.INTERFACE.equals((Object)classCreationType);
    }

    private void addCustomPhpTemplatesToCombo() {
        List phpTemplates = ContainerUtil.filter((Object[])FileTemplateManager.getInstance((Project)this.myProject).getAllTemplates(), t -> StringUtil.equals((CharSequence)t.getExtension(), (CharSequence)"php"));
        if (phpTemplates.isEmpty()) {
            return;
        }
        this.myTemplateComboBox.addItem(new JSeparator(0));
        String defaultCustomTemplateName = this.getDefaultCustomTemplateName();
        for (FileTemplate template : phpTemplates) {
            ClassCreationType customTemplateItem = new ClassCreationType(template.getName(), PhpIcons.PHP_FILE, template.getName());
            this.myTemplateComboBox.addItem((Object)customTemplateItem);
            if (!StringUtil.equals((CharSequence)customTemplateItem.getTemplateName(), (CharSequence)defaultCustomTemplateName)) continue;
            this.myTemplateComboBox.setSelectedItem((Object)customTemplateItem);
        }
        this.myTemplateComboBox.addItemListener(new ItemListener(){
            private int myLastSelectedIndex;
            {
                this.myLastSelectedIndex = PhpNewClassDialog.this.myTemplateComboBox.getSelectedIndex();
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int selectedIndex = PhpNewClassDialog.this.myTemplateComboBox.getSelectedIndex();
                    if (!(PhpNewClassDialog.this.myTemplateComboBox.getSelectedItem() instanceof ClassCreationType)) {
                        int newIndex = this.myLastSelectedIndex < selectedIndex ? Math.min(selectedIndex + 1, PhpNewClassDialog.this.myTemplateComboBox.getItemCount() - 1) : Math.max(selectedIndex - 1, 0);
                        PhpNewClassDialog.this.myTemplateComboBox.setSelectedIndex(newIndex);
                    } else {
                        this.myLastSelectedIndex = selectedIndex;
                        PhpNewClassDialog.this.myUseTemplateNextTimeCheckBox.setVisible(!ClassCreationType.BUNDLED.contains((Object)PhpNewClassDialog.this.getSelectedClassCreationType()));
                    }
                }
            }
        });
    }

    @Override
    public boolean canInheritSuperClasses() {
        if (DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        ClassCreationType selectedClassCreationType = this.getSelectedClassCreationType();
        return PhpNewClassDialog.canOverrideSuperClass(selectedClassCreationType) || PhpNewClassDialog.canImplementInterface(selectedClassCreationType);
    }

    @Override
    public boolean shouldImplementAbstractMethods() {
        ClassCreationType selectedClassCreationType = this.getSelectedClassCreationType();
        return PhpNewClassDialog.canOverrideSuperClass(selectedClassCreationType) || ClassCreationType.ENUM.equals((Object)selectedClassCreationType);
    }

    @Nullable
    private String getDefaultCustomTemplateName() {
        return PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_SELECTED_CUSTOM_TEMPLATE_NAME_PROPERTY);
    }

    protected String getDimensionServiceKey() {
        return "NewPhpClassDialog";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doOKAction() {
        CreateFromTemplateDialog dialog = this.createFillCustomPropertiesDialog();
        if (UIUtil.findComponentOfType((JComponent)dialog.getContentPanel(), JTextField.class) != null) {
            if (!dialog.showAndGet()) return;
            this.myCustomProperties = dialog.getEnteredProperties();
        } else {
            dialog.close(1);
        }
        PhpTemplatesSettings.getInstance((Project)this.myProject).NEW_PHP_CLASS_LAST_EXTENSION = this.getExtension();
        this.saveDefaultLibraryName();
        super.doOKAction();
        PhpNewClassUsageLogger.logNewClass(this.myProject, this);
    }

    @Override
    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo validationInfo = super.doValidate();
        if (validationInfo != null || !this.canInheritSuperClasses()) {
            return validationInfo;
        }
        validationInfo = this.validateSuperFqn();
        return validationInfo == null ? this.validateInterfaceFqnsToImplement() : validationInfo;
    }

    @Nullable
    private ValidationInfo validateSuperFqn() {
        String superFqn = this.getSuperFqn();
        if (StringUtil.isEmpty((String)superFqn)) {
            return null;
        }
        ValidationInfo validationInfo = PhpNewClassDialog.validateClassFqn(this.myProject, superFqn, (JComponent)this.mySuperFqnTextField);
        if (validationInfo != null || PhpNewClassDialog.isOverridableClass(this.myProject, superFqn)) {
            return validationInfo;
        }
        return new ValidationInfo(PhpBundle.message("validation.class.cannot.be.overridden", PhpLangUtil.toPresentableFQN(superFqn)), (JComponent)this.mySuperFqnTextField);
    }

    @Nullable
    private ValidationInfo validateInterfaceFqnsToImplement() {
        for (String interfaceFqn : this.getInterfaceFqnsToImplement()) {
            ValidationInfo validationInfo = PhpNewClassDialog.validateClassFqn(this.myProject, interfaceFqn, this.myInterfaceFqnsToImplementPanel);
            if (validationInfo != null) {
                return validationInfo;
            }
            if (PhpNewClassDialog.isImplementableInterface(this.myProject, interfaceFqn)) continue;
            String errorMessage = PhpBundle.message("validation.interface.cannot.be.overridden", PhpLangUtil.toPresentableFQN(interfaceFqn));
            return new ValidationInfo(errorMessage, (JComponent)this.myInterfaceFqnsToImplementPanel);
        }
        return null;
    }

    @Nullable
    private static ValidationInfo validateClassFqn(@NotNull Project project, @NotNull String classFqn, @NotNull JComponent validationComponent) {
        if (project == null) {
            PhpNewClassDialog.$$$reportNull$$$0(7);
        }
        if (classFqn == null) {
            PhpNewClassDialog.$$$reportNull$$$0(8);
        }
        if (validationComponent == null) {
            PhpNewClassDialog.$$$reportNull$$$0(9);
        }
        String className = PhpLangUtil.toShortName(classFqn);
        String namespaceName = PhpLangUtil.toName(PhpLangUtil.getParentQualifiedName(classFqn));
        return PhpNewClassDialog.validateClass(project, className, namespaceName, validationComponent, validationComponent);
    }

    public static boolean isOverridableClass(@NotNull Project project, @Nullable String fqn) {
        if (project == null) {
            PhpNewClassDialog.$$$reportNull$$$0(10);
        }
        return ContainerUtil.exists((Iterable)PhpIndex.getInstance((Project)project).getClassesByFQN(fqn), (Condition)Conditions.not(PhpClass::isFinal));
    }

    public static boolean isImplementableInterface(@NotNull Project project, @Nullable String fqn) {
        if (project == null) {
            PhpNewClassDialog.$$$reportNull$$$0(11);
        }
        return !PhpIndex.getInstance((Project)project).getInterfacesByFQN(fqn).isEmpty();
    }

    private void saveDefaultLibraryName() {
        ClassCreationType selectedClassCreationType = this.getSelectedClassCreationType();
        String selectedCustomTemplateName = !ClassCreationType.BUNDLED.contains((Object)selectedClassCreationType) && this.myUseTemplateNextTimeCheckBox.isSelected() ? selectedClassCreationType.getTemplateName() : null;
        PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_SELECTED_CUSTOM_TEMPLATE_NAME_PROPERTY, selectedCustomTemplateName);
    }

    @NotNull
    private CreateFromTemplateDialog createFillCustomPropertiesDialog() {
        FileTemplate template = FileTemplateManager.getInstance((Project)this.myProject).getInternalTemplate(this.getTemplateName());
        AttributesDefaults defaults = new AttributesDefaults(this.getClassName()).withFixedName(true);
        return new CreateFromTemplateDialog(this.myProject, this.getBaseDirectory(), template, defaults, this.getIgnoredProperties()){

            protected void doOKAction() {
                this.close(0);
            }
        };
    }

    @NotNull
    private Properties getIgnoredProperties() {
        Properties properties = new Properties();
        properties.setProperty("NAME", this.getClassName());
        properties.setProperty("NAMESPACE", this.getNamespaceName());
        properties.setProperty("FILE_NAME", this.getFileName());
        properties.setProperty("CARET", "");
        properties.setProperty("BACKED_TYPE", "");
        PhpFileTemplateUtil.fillDefaultProperties(FileTemplateManager.getInstance((Project)this.myProject), properties, this.getBaseDirectory());
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpNewClassDialog.$$$reportNull$$$0(12);
        }
        return properties2;
    }

    @Override
    @NotNull
    public String getTemplateName() {
        String string = this.getSelectedClassCreationType().getTemplateName();
        if (string == null) {
            PhpNewClassDialog.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public ClassCreationType getSelectedClassCreationType() {
        ClassCreationType selectedItem = (ClassCreationType)((Object)this.myTemplateComboBox.getSelectedItem());
        assert (selectedItem != null);
        ClassCreationType classCreationType = selectedItem;
        if (classCreationType == null) {
            PhpNewClassDialog.$$$reportNull$$$0(14);
        }
        return classCreationType;
    }

    @Override
    @NotNull
    public String getExtension() {
        String string = (String)this.myExtensionComboBox.getSelectedItem();
        if (string == null) {
            PhpNewClassDialog.$$$reportNull$$$0(15);
        }
        return string;
    }

    public boolean hasCustomProperties() {
        return !this.myCustomProperties.isEmpty();
    }

    private void createUIComponents() {
        this.myNamespaceCombobox = new PhpNamespaceComboBox(this.getProject(), "", this.getDisposable());
        this.myDirectoryCombobox = new PhpPsrDirectoryComboBox(this.getProject(), PhpDirectoryByPsrProvider.getSourceRootProvide()){

            @Override
            protected void chooseFile(@NotNull VirtualFile file) {
                if (file == null) {
                    7.$$$reportNull$$$0(0);
                }
                super.chooseFile(file);
                PhpNewClassDialog.this.myDirectoryTextChangedUnderFocus = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/actions/PhpNewClassDialog$7", "chooseFile"));
            }
        };
        this.mySuperFqnTextField = new EditorTextField("", this.getProject(), (FileType)FileTypes.PLAIN_TEXT);
    }

    @Override
    public void setData(String className, ClassCreationType classType, String fileName, String namespaceName) {
        this.myNameTextField.setText(className);
        this.myFileNameTextField.setText(fileName);
        this.myNamespaceCombobox.getEditorTextField().setText(namespaceName);
        this.myTemplateComboBox.setSelectedItem((Object)classType);
        this.updateSuperClassesPanel();
    }

    public void setData(String className, ClassCreationType classType, String fileName, String namespaceName, String implementsFqn) {
        this.setData(className, classType, fileName, namespaceName);
        this.myInterfaceFqnsToImplementTable.getListTableModel().addRow((Object)Ref.create((Object)implementsFqn));
    }

    @Override
    @NotNull
    public Properties getProperties(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpNewClassDialog.$$$reportNull$$$0(16);
        }
        Properties properties = super.getProperties(directory);
        this.myCustomProperties.stringPropertyNames().forEach(name -> properties.setProperty((String)name, this.myCustomProperties.getProperty((String)name)));
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpNewClassDialog.$$$reportNull$$$0(17);
        }
        return properties2;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        EditorTextField editorTextField;
        EditorTextField editorTextField2;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("actions.new.php.class.dialog.border.title.class"), (int)0, (int)0, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myTemplateComboBox = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(6, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myExtensionComboBox = jComboBox2;
        jPanel3.add(jComboBox2, new GridConstraints(8, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("actions.new.php.class.dialog.label.class.name"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("actions.new.php.base.dialog.label.file.name"));
        jPanel3.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("actions.new.php.class.dialog.label.template"));
        jPanel3.add((Component)jLabel5, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("actions.new.php.base.dialog.label.extension"));
        jPanel3.add((Component)jLabel6, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplateUpDownHint = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExtensionUpDownHint = jLabel = new JLabel();
        jLabel.setText("");
        jPanel3.add((Component)jLabel, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameTextField = editorTextField2 = new EditorTextField();
        jPanel3.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("actions.new.php.class.dialog.label.namespace"));
        jPanel3.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PhpNamespaceComboBox phpNamespaceComboBox = this.myNamespaceCombobox;
        jPanel3.add((Component)((Object)phpNamespaceComboBox), new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myFileNameTextField = editorTextField = new EditorTextField();
        jPanel3.add((Component)editorTextField, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myNamespaceCompletionHintLabel = jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jPanel3.add((Component)jBLabel3, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("actions.new.php.class.dialog.label.directory"));
        jPanel3.add((Component)jBLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PhpPsrDirectoryComboBox phpPsrDirectoryComboBox = this.myDirectoryCombobox;
        jPanel3.add((Component)((Object)phpPsrDirectoryComboBox), new GridConstraints(4, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myEditDirectoryHintLabel = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jPanel3.add((Component)jBLabel2, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseTemplateNextTimeCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("checkbox.use.as.a.default.template"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("actions.new.php.class.dialog.label.superclasses.container"), (int)0, (int)0, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("actions.new.php.class.dialog.label.superclasses.super.fqn"));
        jPanel4.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(98, 16), null));
        EditorTextField editorTextField3 = this.mySuperFqnTextField;
        jPanel4.add((Component)editorTextField3, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.mySuperFqnCompletionHintLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewClassDialog.class).getString("actions.new.php.class.dialog.label.superinterfaces.to.implement"));
        jPanel4.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, new Dimension(98, 16), null));
        this.myInterfaceFqnsToImplementPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 1, 1, 1, 1, 1, 3, 3, null, new Dimension(-1, 80), null));
        jLabel5.setLabelFor(jComboBox);
        jLabel6.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 12, 13, 14, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classCreationType";
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/PhpNewClassDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validationComponent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/PhpNewClassDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceFqnsToImplement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedClassFqns";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredProperties";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedClassCreationType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canOverrideSuperClass";
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrderedClassFqns";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canImplementInterface";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canExtendInterface";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateClassFqn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOverridableClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isImplementableInterface";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 12, 13, 14, 15, 17 -> new IllegalStateException(string);
        };
    }
}

