/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.jetbrains.php.PhpCaches;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.classAlias.PhpClassAliasIndex;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpIteratedAccessTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpKeyTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpOptionalCompletionTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpOverriddenTraitMethodTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpReturnTypeContractTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider2;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider3;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnitMockBuilderProxyTP;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericConstructorTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsArrayAccessExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpTypeProviderEx;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpYieldGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.prophecy.ProphecyInheritanceMethodTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.prophecy.ProphecyProphesizeTypeProvider;
import com.jetbrains.php.lang.psi.stubs.PhpAvailableInLanguageLevelRangeElement;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCaseSensitiveConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInheritanceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpNamespaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpNamespaceInheritanceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPathInfo;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitUsageIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUnitCoversIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUseReferenceNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableNameIndex;
import com.jetbrains.php.mockery.PhpMockeryTypeInferenceUtil;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.util.PhpStringUtil;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIndexImpl
extends PhpIndex {
    private static final Logger LOG = Logger.getInstance(PhpIndexImpl.class);
    private final Project project;
    private static final int ABSOLUTE_TYPE_COMPLETION_COMPLEXITY_LIMIT = 100;
    private static final RecursionGuard<Object> RECURSION_GUARD = RecursionManager.createGuard((String)"php.index");
    public static final Map<String, String> ARRAY_VALUE_PROVIDERS = new HashMap<String, String>();
    public static final Map<String, String> ITERATOR_VALUE_PROVIDERS;
    public static final Map<String, String> ARRAY_KEY_PROVIDERS;

    PhpIndexImpl(Project project) {
        this.project = project;
    }

    public static int getMaxDepth() {
        return AdvancedSettings.getInt((String)"php.max.chain.resolve.depth");
    }

    @NotNull
    public <T extends PhpNamedElement> Collection<T> filterByNamespace(@NotNull Collection<T> elements, @Nullable String namespaceName) {
        if (elements == null) {
            PhpIndexImpl.$$$reportNull$$$0(0);
        }
        Collection<T> collection = this.filterByNamespace(elements, namespaceName, false);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public <T extends PhpNamedElement> Collection<T> filterByNamespace(@NotNull Collection<T> elements, @Nullable String namespaceName, boolean allowGlobal) {
        if (elements == null) {
            PhpIndexImpl.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty() || StringUtil.isEmpty((String)namespaceName)) {
            Collection<T> collection = elements;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(3);
            }
            return collection;
        }
        Collection collection = ((StreamEx)StreamEx.of(elements).filter(e -> PhpCompletionUtil.hasNamespace(namespaceName, allowGlobal, e))).toCollection(HashSet::new);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public PhpType completeType(@NotNull Project p, @NotNull PhpType type, @Nullable Set<String> visited, int currentRecursionDepth) {
        if (p == null) {
            PhpIndexImpl.$$$reportNull$$$0(5);
        }
        if (type == null) {
            PhpIndexImpl.$$$reportNull$$$0(6);
        }
        PhpType phpType = this.completeType(p, type, visited, currentRecursionDepth, null);
        if (phpType == null) {
            PhpIndexImpl.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    public PhpType completeType(@NotNull Project p, @NotNull PhpType type, @Nullable Set<String> visited) {
        if (p == null) {
            PhpIndexImpl.$$$reportNull$$$0(8);
        }
        if (type == null) {
            PhpIndexImpl.$$$reportNull$$$0(9);
        }
        return this.completeType(p, type, visited, 0);
    }

    @NotNull
    public PhpType completeType(@NotNull Project p, @NotNull PhpType type, @Nullable Set<String> visited, @Nullable java.util.function.Function<String, PhpType> incompleteTypeCustomProducer) {
        if (p == null) {
            PhpIndexImpl.$$$reportNull$$$0(10);
        }
        if (type == null) {
            PhpIndexImpl.$$$reportNull$$$0(11);
        }
        PhpType phpType = this.completeType(p, type, visited, 0, incompleteTypeCustomProducer);
        if (phpType == null) {
            PhpIndexImpl.$$$reportNull$$$0(12);
        }
        return phpType;
    }

    @ApiStatus.Internal
    @NotNull
    public PhpType completeType(@NotNull Project p, @NotNull PhpType type, @Nullable Set<String> visited, int depth, @Nullable @Nullable java.util.function.Function<@NotNull String, @Nullable PhpType> incompleteTypeCustomProducer) {
        if (p == null) {
            PhpIndexImpl.$$$reportNull$$$0(13);
        }
        if (type == null) {
            PhpIndexImpl.$$$reportNull$$$0(14);
        }
        int incompleteTypesCount = 0;
        boolean hasIncomplete = false;
        while (!type.isComplete()) {
            PhpType completeType = new PhpType();
            for (String typeName : type.getTypesWithParametrisedParts()) {
                ProgressIndicatorProvider.checkCanceled();
                String typeNameSaved = typeName;
                long t = System.currentTimeMillis();
                if (typeName.length() > 1 && typeName.charAt(0) == '#') {
                    if (visited == null) {
                        visited = new HashSet<String>();
                    }
                    if (visited.add(typeName)) {
                        if (!PhpIndexImpl.doAddCustomIncompleteType(incompleteTypeCustomProducer, completeType, typeName) && (typeName = this.doCompleteType(p, visited, depth + 1, completeType, typeName, typeNameSaved, incompleteTypeCustomProducer)) == null) {
                            continue;
                        }
                    } else {
                        ++incompleteTypesCount;
                        if (!PhpIndexImpl.incompleteSignatureCanBeOmitted(typeName) && !hasIncomplete) {
                            completeType.add("?");
                            hasIncomplete = true;
                        }
                    }
                } else {
                    completeType.add(typeName);
                }
                if ((t = System.currentTimeMillis() - t) > 500L) {
                    LOG.warn("Completing type '" + typeName + "' took " + t + "ms, visited:" + String.valueOf(ObjectUtils.notNull(visited, (Object)ContainerUtil.emptyList())));
                }
                if (completeType.size() + incompleteTypesCount <= PhpIndexImpl.getTypeCompletionComplexityLimit()) continue;
                break;
            }
            type = completeType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpIndexImpl.$$$reportNull$$$0(15);
        }
        return phpType;
    }

    @Nullable
    private String doCompleteType(@NotNull Project p, @NotNull Set<String> visited, int depth, PhpType completeType, String typeName, String typeNameSaved, @Nullable java.util.function.Function<@NotNull String, @Nullable PhpType> incompleteTypeCustomProducer) {
        if (p == null) {
            PhpIndexImpl.$$$reportNull$$$0(16);
        }
        if (visited == null) {
            PhpIndexImpl.$$$reportNull$$$0(17);
        }
        PhpType cacheInfo = PhpCaches.getInstance((Project)p).TYPE_COMPLETION_CACHE.get(typeName);
        if (incompleteTypeCustomProducer == null && cacheInfo != null && !cacheInfo.isEmpty()) {
            completeType.add(cacheInfo);
        } else {
            cacheInfo = new PhpType();
            Collection<PhpTypeProvider4> providers = this.getTypeProviders();
            boolean typeWasAdded = false;
            for (PhpTypeProvider4 provider : providers) {
                String finalTypeName;
                PhpType result;
                if (provider.getKey() != typeName.charAt(1) || ((result = (PhpType)RECURSION_GUARD.doPreventingRecursion((Object)typeName, true, () -> this.lambda$doCompleteType$1(depth, provider, finalTypeName = typeName))) == null || result.isEmpty()) && !provider.emptyResultIsComplete()) continue;
                completeType.add(result);
                if (incompleteTypeCustomProducer == null) {
                    cacheInfo.add(result);
                }
                if (provider.interceptsNativeSignature()) continue;
                if (ContainerUtil.exists(providers, e -> e.getKey() == finalTypeName.charAt(1) && e.interceptsNativeSignature()) && result != null && !result.isEmpty() && result.isAmbiguous()) {
                    typeWasAdded = true;
                    continue;
                }
                return null;
            }
            if (typeWasAdded) {
                return null;
            }
            int c0 = PhpType.getPluralDimension((String)typeName);
            typeName = PhpType.unpluralize((String)typeName, (int)c0);
            Collection targets = PhpIndexImpl.getInstance((Project)p).getBySignature(typeName, new HashSet<String>(visited), depth + 1);
            if (!targets.isEmpty()) {
                this.tryAddMockeryType(depth, completeType, typeName, incompleteTypeCustomProducer, cacheInfo, targets, new HashSet<String>(visited));
                boolean realDeclarationExists = ContainerUtil.exists((Iterable)targets, e -> !(e instanceof FakePsiElement));
                for (PhpNamedElement element : targets) {
                    PhpType outType = new PhpType();
                    PhpType elementType = element.getType();
                    for (String name : elementType.getTypesWithParametrisedParts()) {
                        if (PhpIndexImpl.doAddCustomIncompleteType(incompleteTypeCustomProducer, outType, name)) continue;
                        String superMemberPolymorphicType = PhpIndexImpl.findPolymorphicTypeInHierarchy(p, name, depth, new HashSet<String>());
                        if (superMemberPolymorphicType != null) {
                            outType.add(PhpIndexImpl.resolveNamePolymorphicAware(this.project, typeName, superMemberPolymorphicType));
                            continue;
                        }
                        outType.add(PhpIndexImpl.resolveNamePolymorphicAware(this.project, typeName, name));
                    }
                    outType = outType.pluralise(c0);
                    if (PhpTypeSignatureKey.FUNCTION.isSigned(typeName) || PhpTypeSignatureKey.METHOD.isSigned(typeName)) {
                        outType = PhpTypeAnalyserVisitor.replaceVoidWithNull(outType);
                    } else if (PhpTypeSignatureKey.FIELD.isSigned(typeName) && (!elementType.isEmpty() && PhpIndexImpl.isNonPrivateFieldWithTypeOnlyFromDefaultValue(element) || !realDeclarationExists && elementType.isEmpty())) {
                        outType = PhpType.or((PhpType)outType, (PhpType)PhpType.MIXED);
                    }
                    if (incompleteTypeCustomProducer == null) {
                        cacheInfo.add(outType);
                    }
                    completeType.add(outType);
                }
            } else if (!PhpIndexImpl.incompleteSignatureCanBeOmitted(typeName) && !completeType.hasUnknown()) {
                if (incompleteTypeCustomProducer == null) {
                    cacheInfo.add("?");
                }
                completeType.add("?");
            }
            PhpCaches.getInstance((Project)p).TYPE_COMPLETION_CACHE.put(typeNameSaved, cacheInfo);
        }
        return typeName;
    }

    @Nullable
    private PhpType completeType(int depth, PhpTypeProvider4 provider, String finalTypeName) {
        return provider instanceof PhpTypeProviderEx ? ((PhpTypeProviderEx)provider).complete(this.project, finalTypeName, depth) : provider.complete(finalTypeName, this.project);
    }

    private void tryAddMockeryType(int depth, PhpType completeType, String typeName, @Nullable java.util.function.Function<@NotNull String, @Nullable PhpType> incompleteTypeCustomProducer, PhpType cacheInfo, Collection<? extends PhpNamedElement> targets, Set<String> visited) {
        int dot = typeName.lastIndexOf(46);
        if (dot < 2) {
            return;
        }
        String classRef = typeName.substring(2, dot);
        PhpType res = new PhpType();
        if (ContainerUtil.exists(targets, e -> e instanceof Method && !PhpMockeryTypeInferenceUtil.isMockeryNamespace(e.getFQN())) && ContainerUtil.exists(this.getClasses(classRef, visited, depth + 1), c -> this.isMockeryExpectationInterface((PhpClass)c))) {
            res.add(PhpMockeryTypeInferenceUtil.MOCKERY_EXPECTATION_INTERFACE);
        }
        if (ContainerUtil.exists(targets, e -> this.isMockeryMethodWithType((PhpNamedElement)e, PhpMockeryTypeInferenceUtil.MOCKERY_EXPECTATION_INTERFACE))) {
            res.add(PhpMockeryTypeInferenceUtil.getMockedType(this.project, PhpType.from((String[])new String[]{classRef}), "\\Mockery\\ExpectationInterface"));
        }
        if (ContainerUtil.exists(targets, e -> this.isMockeryMethodWithType((PhpNamedElement)e, PhpMockeryTypeInferenceUtil.MOCKERY_MOCK))) {
            res.add(PhpMockeryTypeInferenceUtil.getMockedType(this.project, PhpType.from((String[])new String[]{classRef}), "\\Mockery\\MockInterface"));
        }
        if (!res.isEmpty()) {
            if (incompleteTypeCustomProducer == null) {
                cacheInfo.add(res);
            }
            completeType.add(res);
        }
    }

    private boolean isMockeryMethodWithType(PhpNamedElement e, PhpType type) {
        return e instanceof Method && PhpMockeryTypeInferenceUtil.isMockeryNamespace(e.getFQN()) && type.isConvertibleFromGlobal(this.project, e.getType());
    }

    private boolean isMockeryExpectationInterface(PhpClass c) {
        return PhpMockeryTypeInferenceUtil.isMockeryNamespace(c.getFQN()) && PhpMockeryTypeInferenceUtil.MOCKERY_EXPECTATION_INTERFACE.isConvertibleFromGlobal(this.project, PhpType.from((String[])new String[]{c.getFQN()}));
    }

    public static boolean isNonPrivateFieldWithTypeOnlyFromDefaultValue(PhpNamedElement field) {
        return field instanceof FieldImpl && !((FieldImpl)field).getModifier().isPrivate() && !((FieldImpl)field).getModifier().isStatic() && ((FieldImpl)field).hasDefaultValue() && PhpVariableInferredTypeAnalyzerProcessor.isDeclaredTypeEmpty((PhpTypedElement)field);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    private static String findPolymorphicTypeInHierarchy(@NotNull Project p, @NotNull String initialName, int depth, Set<String> visited) {
        String name;
        if (p == null) {
            PhpIndexImpl.$$$reportNull$$$0(18);
        }
        if (initialName == null) {
            PhpIndexImpl.$$$reportNull$$$0(19);
        }
        ArrayDeque<String> names = new ArrayDeque<String>();
        names.addFirst(initialName);
        while (!names.isEmpty() && visited.add(name = (String)names.poll())) {
            if (!PhpTypeSignatureKey.DOC_OF_SUPER_MEMBER.isSigned(name)) continue;
            for (PhpNamedElement superMember : PhpIndexImpl.getInstance((Project)p).getBySignature(PhpTypeSignatureKey.SUPER_MEMBER.sign((CharSequence)name.substring(2)), visited, depth + 1)) {
                @NlsSafe Set superMemberTypes = superMember.getType().getTypes();
                String polymorphicType = (String)ContainerUtil.find((Iterable)superMemberTypes, arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0));
                if (polymorphicType != null) {
                    return polymorphicType;
                }
                names.addAll(superMemberTypes);
            }
        }
        return null;
    }

    private Collection<PhpClass> getClasses(@NotNull String classRef, @Nullable Set<String> visited, int depth) {
        if (classRef == null) {
            PhpIndexImpl.$$$reportNull$$$0(20);
        }
        PhpType global = new PhpType().add(classRef);
        try {
            global = ((PhpIndexImpl)PhpIndexImpl.getInstance((Project)this.project)).completeType(this.project, global, visited, depth + 1, null);
        }
        catch (StackOverflowError e) {
            String message = "SOE in PhpType.global.getClasses @ " + String.valueOf(global);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
            return ContainerUtil.emptyList();
        }
        HashSet<PhpClass> classes = new HashSet<PhpClass>();
        for (String type : global.getTypesWithParametrisedParts()) {
            if (type.startsWith("\\class-string")) {
                for (String part : PhpType.getParametrizedParts((String)type)) {
                    classes.addAll(this.getAnyByFQN(part));
                }
                continue;
            }
            classes.addAll(this.getAnyByFQN(type));
        }
        return classes;
    }

    @Nullable
    public static String resolveSelfClassInTrait(Project project, String rawClassName, Collection<String> parametrisedParts, String rawTraitName) {
        String className = PhpTypeSignatureKey.CLASS.unsign(rawClassName);
        String traitName = PhpTypeSignatureKey.SELF_CLASS_IN_TRAIT.unsign(rawTraitName);
        Collection classes = PhpIndexImpl.getInstance((Project)project).getClassesByFQN(className);
        if (classes.isEmpty()) {
            return null;
        }
        Ref superClassWithTrait = new Ref();
        HashSet visited = new HashSet();
        for (PhpClass phpClass : classes) {
            PhpClassHierarchyUtils.processSupers((PhpClass)phpClass, (boolean)true, (boolean)true, superClass -> {
                if (PhpIndexImpl.isMyTrait(superClass, traitName, visited)) {
                    superClassWithTrait.set((Object)superClass.getFQN());
                    return false;
                }
                return true;
            });
            if (superClassWithTrait.isNull()) continue;
            String name = (String)superClassWithTrait.get();
            return PhpType.createParametrizedType((String)name, parametrisedParts);
        }
        return null;
    }

    private static boolean isMyTrait(@NotNull PhpClass me, @NotNull String traitName, @NotNull Collection<? super String> visited) {
        String[] myTraits;
        if (me == null) {
            PhpIndexImpl.$$$reportNull$$$0(21);
        }
        if (traitName == null) {
            PhpIndexImpl.$$$reportNull$$$0(22);
        }
        if (visited == null) {
            PhpIndexImpl.$$$reportNull$$$0(23);
        }
        if (!visited.add(me.getFQN())) {
            return false;
        }
        for (String candidateName : myTraits = me.getTraitNames()) {
            if (!visited.add(candidateName) || !candidateName.equals(traitName)) continue;
            return true;
        }
        for (String candidateName : myTraits) {
            Collection candidateTraits = PhpIndexImpl.getInstance((Project)me.getProject()).getTraitsByFQN(candidateName);
            for (PhpClass candidate : candidateTraits) {
                if (!PhpIndexImpl.isMyTrait(candidate, traitName, visited)) continue;
                return true;
            }
        }
        return false;
    }

    public static String resolveNamePolymorphicAware(Project project, String typeName, String name) {
        if (PhpTypeSignatureKey.POLYMORPHIC_CLASS.isSigned(name) || PhpTypeSignatureKey.SELF_CLASS_IN_TRAIT.isSigned(name)) {
            String selfClassName;
            int indexOfMemberSig;
            int c = PhpType.getPluralDimension((String)name);
            List parametrisedParts = PhpType.hasParameterizedPart((String)name) ? PhpType.getParametrizedParts((String)name) : ContainerUtil.emptyList();
            int index = typeName.lastIndexOf(46);
            int indexOfMethod = typeName.indexOf("#M");
            int indexOfProperty = typeName.indexOf("#P");
            int n = indexOfMethod < 0 ? indexOfProperty : (indexOfMemberSig = indexOfProperty < 0 ? indexOfMethod : Math.min(indexOfMethod, indexOfProperty));
            if (index < 0 || indexOfMemberSig < 0) {
                index = typeName.length();
            }
            String className = typeName.substring(Math.max(indexOfMemberSig, 0) + 2, index);
            if (PhpTypeSignatureKey.SELF_CLASS_IN_TRAIT.isSigned(name) && (selfClassName = PhpIndexImpl.resolveSelfClassInTrait(project, className, parametrisedParts, name)) != null) {
                return selfClassName;
            }
            return PhpType.pluralise((String)PhpType.createParametrizedType((String)className, (Collection)parametrisedParts), (int)c);
        }
        if (PhpType.hasParameterizedPart((String)name)) {
            List parametrizedParts = PhpType.getParametrizedParts((String)name);
            String type = PhpType.removeParametrisedType((String)name);
            List resolvedParts = ContainerUtil.map((Collection)parametrizedParts, p -> PhpIndexImpl.resolveNamePolymorphicAware(project, typeName, p));
            return PhpType.createParametrizedType((String)type, (Collection)resolvedParts);
        }
        return name;
    }

    @NotNull
    public Collection<PhpTypeProvider4> getTypeProviders() {
        String message = PhpIndexImpl.getDuplicatedProvidersErrorMessage(this.project);
        if (StringUtil.isNotEmpty((String)message)) {
            LOG.error(message);
        }
        List list = PhpTypeProvider4.EP_NAME.getExtensionList();
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private static String getDuplicatedProvidersErrorMessage(@NotNull Project project) {
        if (project == null) {
            PhpIndexImpl.$$$reportNull$$$0(25);
        }
        String string = (String)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> PhpIndexImpl.getDuplicatedProvidersErrorMessage());
        if (string == null) {
            PhpIndexImpl.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static CachedValueProvider.Result<String> getDuplicatedProvidersErrorMessage() {
        String r = ((StreamEx)StreamEx.of((Collection)PhpTypeProvider4.EP_NAME.getExtensionList()).filter(p -> !(p instanceof PhpGenericsExtendedTypeProvider))).groupingBy(f -> Character.valueOf(f.getKey())).values().stream().map(v -> Pair.create((Object)Character.valueOf(((PhpTypeProvider4)v.get(0)).getKey()), PhpIndexImpl.getUniqueClassNames(v))).filter(p -> ((Collection)p.second).size() > 1).map(p -> String.format("Duplicate type providers with key '%s': %s", p.first, StringUtil.join((Collection)((Collection)p.second), (String)","))).collect(Collectors.joining("\n"));
        return new CachedValueProvider.Result((Object)r, new Object[]{PhpTypeProvidersKeysModificationTracker.INSTANCE});
    }

    private static Collection<String> getUniqueClassNames(List<PhpTypeProvider4> typeProviders) {
        return typeProviders.stream().filter(t -> !(t instanceof PhpGenericsArrayAccessExtendedWithGenericTypeProvider)).filter(t -> !t.interceptsNativeSignature()).map(t -> t.getClass().getName()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Collection<PhpClass> getLibClassesCached(String fqn, Key<CachedValue<Collection<PhpClass>>> key) {
        return (Collection)CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this.getProject(), key, () -> CachedValueProvider.Result.create(this.getClassesByFQN(fqn), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}), false);
    }

    public Collection<PhpClass> getLibInterfacesCached(String fqn, Key<CachedValue<Collection<PhpClass>>> key) {
        return (Collection)CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this.getProject(), key, () -> CachedValueProvider.Result.create(this.getInterfacesByFQN(fqn), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}), false);
    }

    public static boolean incompleteSignatureCanBeOmitted(@NotNull String typeName) {
        if (typeName == null) {
            PhpIndexImpl.$$$reportNull$$$0(27);
        }
        return typeName.contains("#\u0401") || typeName.contains("#\u03c0") || typeName.contains("#a") || typeName.contains("#l") || typeName.contains("#" + PhpUnitMockBuilderProxyTP.BUILDER_TYPE_KEY.getKey()) || typeName.contains("#" + PhpGenericsExtendedTypeProvider.KEY.getKey()) || typeName.startsWith("#") && PhpOptionalCompletionTP.TYPE_KEY.is(typeName.charAt(1)) || typeName.startsWith("#") && PhpGenericConstructorTypeProvider.KEY.is(typeName.charAt(1)) || typeName.startsWith("#") && PhpGenericTypeProvider.KEY.is(typeName.charAt(1)) || typeName.startsWith("#") && ProphecyProphesizeTypeProvider.KEY.is(typeName.charAt(1)) || typeName.startsWith("#") && ProphecyInheritanceMethodTypeProvider.KEY.is(typeName.charAt(1)) || typeName.startsWith("#") && PhpYieldGenericTypeProvider.KEY.is(typeName.charAt(1)) || typeName.startsWith("#") && PhpReturnTypeContractTP.KEY.is(typeName.charAt(1)) || PhpKeyTypeProvider.isArrayKeySignature((String)typeName);
    }

    public Collection<PhpNamespace> getNamespacesByName(String name) {
        if (name == null || name.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.shouldUseSlowResolve()) {
            return ContainerUtil.emptyList();
        }
        return PhpIndexImpl.getElements(PhpNamespaceIndex.KEY, name, this.project, this.getSearchScope(), PhpNamespace.class);
    }

    private boolean shouldUseSlowResolve() {
        return DumbService.getInstance((Project)this.project).isAlternativeResolveEnabled();
    }

    @NotNull
    public Collection<String> getAllChildNamespacesFqns(@NotNull String parentNamespaceFqn) {
        if (parentNamespaceFqn == null) {
            PhpIndexImpl.$$$reportNull$$$0(28);
        }
        HashSet<String> result = new HashSet<String>();
        StubIndex.getInstance().processAllKeys(PhpNamespaceIndex.KEY, this.project, childFqn -> {
            if (childFqn.length() > parentNamespaceFqn.length() && childFqn.startsWith(parentNamespaceFqn)) {
                result.add((String)childFqn);
            }
            return true;
        });
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            PhpIndexImpl.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getAllConstantNames(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor processor2 = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpConstantNameIndex.KEY, (Processor)processor2, this.project);
        List<String> list = this.filterKeys(processor2.getResults(), PhpConstantNameIndex.KEY);
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    public Collection<String> getAllVariableNames(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor processor2 = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpVariableNameIndex.KEY, (Processor)processor2, this.project);
        List<String> list = this.filterKeys(processor2.getResults(), PhpVariableNameIndex.KEY);
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public Collection<String> getAllFunctionNames(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor processor2 = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpFunctionNameIndex.KEY, (Processor)processor2, this.project);
        List<String> list = this.filterKeys(processor2.getResults(), PhpFunctionNameIndex.KEY);
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public Collection<String> getAllClassNames(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor processor2 = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpClassNameIndex.KEY, (Processor)processor2, this.project);
        List<String> result = this.filterKeys(processor2.getResults(), PhpClassNameIndex.KEY);
        if (result.isEmpty()) {
            Collection<String> collection = this.getClassAliasesNames();
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(33);
            }
            return collection;
        }
        List list = ContainerUtil.concat(result, new ArrayList<String>(this.getClassAliasesNames()));
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    public Collection<String> getAllClassFqns(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor uniquesProcessor = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpClassFqnIndex.KEY, (Processor)uniquesProcessor, this.project);
        Collection collection = uniquesProcessor.getResults();
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(35);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getAllInterfacesFqns(@Nullable PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor uniquesProcessor = new CollectFilteredUniquesProcessor(prefixMatcher);
        FileBasedIndex.getInstance().processAllKeys(PhpInterfaceFqnIndex.KEY, (Processor)uniquesProcessor, this.project);
        Collection collection = uniquesProcessor.getResults();
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(36);
        }
        return collection;
    }

    public Collection<String> getAllTraitsFqns(PrefixMatcher prefixMatcher) {
        CollectFilteredUniquesProcessor uniquesProcessor = new CollectFilteredUniquesProcessor(prefixMatcher);
        StubIndex.getInstance().processAllKeys(PhpTraitFqnIndex.KEY, this.project, (Processor)uniquesProcessor);
        return uniquesProcessor.getResults();
    }

    @NotNull
    public Collection<String> getClassAliasesNames() {
        Collection collection = PhpClassAliasIndex.getInstance((Project)this.project).getClassNames();
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(37);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getInterfaceAliasesNames() {
        Collection collection = PhpClassAliasIndex.getInstance((Project)this.project).getInterfaceNames();
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(38);
        }
        return collection;
    }

    public Collection<String> getTraitsAliasesNames() {
        return PhpClassAliasIndex.getInstance((Project)this.project).getTraitNames();
    }

    @NotNull
    public Collection<String> getAllInterfaceNames() {
        HashSet<String> result = new HashSet<String>(StubIndex.getInstance().getAllKeys(PhpInterfaceIndex.KEY, this.project));
        result.addAll(PhpClassAliasIndex.getInstance((Project)this.project).getInterfaceNames());
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            PhpIndexImpl.$$$reportNull$$$0(39);
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getAllTraitNames() {
        HashSet<String> result = new HashSet<String>(StubIndex.getInstance().getAllKeys(PhpTraitIndex.KEY, this.project));
        result.addAll(PhpClassAliasIndex.getInstance((Project)this.project).getTraitNames());
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            PhpIndexImpl.$$$reportNull$$$0(40);
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getChildNamespacesByParentName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(41);
            }
            return set;
        }
        List values = FileBasedIndex.getInstance().getValues(PhpNamespaceInheritanceIndex.KEY, (Object)StringUtil.toLowerCase((String)name), this.getSearchScope());
        if (values.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(42);
            }
            return set;
        }
        if (values.size() == 1) {
            Collection collection = (Collection)values.get(0);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(43);
            }
            return collection;
        }
        HashSet<String> strings = new HashSet<String>();
        for (Set value : values) {
            strings.addAll(value);
        }
        HashSet<String> hashSet = strings;
        if (hashSet == null) {
            PhpIndexImpl.$$$reportNull$$$0(44);
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getTraitUsagesByFQN(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(45);
            }
            return set;
        }
        List values = FileBasedIndex.getInstance().getValues(PhpTraitUsageIndex.KEY, (Object)name, this.getSearchScope());
        if (values.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(46);
            }
            return set;
        }
        if (values.size() == 1) {
            Collection collection = (Collection)values.get(0);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(47);
            }
            return collection;
        }
        HashSet<String> strings = new HashSet<String>();
        for (Set value : values) {
            strings.addAll(value);
        }
        HashSet<String> hashSet = strings;
        if (hashSet == null) {
            PhpIndexImpl.$$$reportNull$$$0(48);
        }
        return hashSet;
    }

    @NotNull
    public Collection<PhpUse> getUseAliasesByReferenceName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            Set<PhpUse> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(49);
            }
            return set;
        }
        return PhpIndexImpl.getElements(PhpUseReferenceNameIndex.KEY, StringUtil.toLowerCase((String)name), this.project, this.getSearchScope(), PhpUse.class);
    }

    @NotNull
    public Collection<Constant> getConstantsByFQN(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            Set<Constant> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(50);
            }
            return set;
        }
        int i = name.lastIndexOf(92);
        Collection<Constant> elements = this.getConstantsByName(name.substring(i + 1));
        Collection<Constant> collection = elements = this.filterByNamespace(elements, i >= 0 ? name.substring(0, i + 1) : "\\");
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(51);
        }
        return collection;
    }

    @NotNull
    public Collection<Constant> getConstantsByName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            Set<Constant> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(52);
            }
            return set;
        }
        PhpCaches caches = PhpCaches.getInstance(this.project);
        Map cache = caches.caseSensitiveConstantsCache;
        Collection sensitive = PhpIndexImpl.getCached(name, cache, () -> StubIndex.getElements(PhpCaseSensitiveConstantIndex.KEY, (Object)name, (Project)this.project, (GlobalSearchScope)this.getSearchScope(), Constant.class));
        Collection insensitive = PhpIndexImpl.getCached(StringUtil.toLowerCase((String)name), caches.caseInsensitiveConstantsCache, () -> StubIndex.getElements(PhpConstantIndex.KEY, (Object)StringUtil.toLowerCase((String)name), (Project)this.project, (GlobalSearchScope)this.getSearchScope(), Constant.class));
        ArrayList<Constant> constants = new ArrayList<Constant>(sensitive);
        constants.addAll(insensitive);
        ArrayList<Constant> arrayList = constants;
        if (arrayList == null) {
            PhpIndexImpl.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    private static <T> Collection<T> getCached(String key, Map<String, Collection<T>> cache, Supplier<Collection<T>> supplier) {
        if (cache.containsKey(key)) {
            return cache.get(key);
        }
        Collection<T> result = supplier.get();
        if (result != null) {
            cache.put(key, result);
        }
        return result;
    }

    @NotNull
    public Collection<Variable> getVariablesByName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            Set<Variable> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(54);
            }
            return set;
        }
        Collection<Variable> collection = PhpIndexImpl.getCached(name, PhpCaches.getInstance((Project)this.project).globalVariablesCache, () -> PhpIndexImpl.getElements(PhpVariableIndex.KEY, name, this.project, this.getSearchScope(), Variable.class));
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(55);
        }
        return collection;
    }

    @NotNull
    public Collection<Function> getFunctionsByName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            Set<Function> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(56);
            }
            return set;
        }
        Collection<Function> collection = PhpIndexImpl.getCached(StringUtil.toLowerCase((String)name), PhpCaches.getInstance((Project)this.project).functionsCache, () -> PhpIndexImpl.getElements(PhpFunctionIndex.KEY, StringUtil.toLowerCase((String)name), this.project, this.getSearchScope(), Function.class));
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(57);
        }
        return collection;
    }

    @NotNull
    public Collection<Function> getFunctionsByFQN(@Nullable String name) {
        if ((name = PhpIndexImpl.sanitizeParameters(name)) == null || name.isEmpty()) {
            Set<Function> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(58);
            }
            return set;
        }
        int i = name.lastIndexOf(92);
        Collection<Function> elements = this.getFunctionsByName(name.substring(i + 1));
        Collection<Function> collection = elements = this.filterByNamespace(elements, i >= 0 ? name.substring(0, i + 1) : "\\");
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(59);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getInterfacesByName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            Set<PhpClass> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(60);
            }
            return set;
        }
        StubIndexKey<String, PhpClass> key = PhpInterfaceIndex.KEY;
        Collection<PhpClass> result = this.getByName(StringUtil.toLowerCase((String)name), PhpCaches.getInstance((Project)this.project).interfaceCache, key);
        Collection<PhpClass> collection = PhpIndexImpl.addAllWithUniqueFqn(result, this.getAliasesByName(name, key));
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(61);
        }
        return collection;
    }

    public Collection<PhpClass> getTraitsByName(String name) {
        if (name == null || name.isEmpty()) {
            return Collections.emptySet();
        }
        StubIndexKey<String, PhpClass> key = PhpTraitIndex.KEY;
        Collection<PhpClass> result = this.getByName(StringUtil.toLowerCase((String)name), PhpCaches.getInstance((Project)this.project).traitCache, key);
        return PhpIndexImpl.addAllWithUniqueFqn(result, this.getAliasesByName(name, key));
    }

    @NotNull
    public Collection<PhpClass> getClassesByName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            Set<PhpClass> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(62);
            }
            return set;
        }
        StubIndexKey<String, PhpClass> key = PhpClassIndex.KEY;
        Collection<PhpClass> result = this.getByName(StringUtil.toLowerCase((String)name), PhpCaches.getInstance((Project)this.project).classCache, key);
        Collection<PhpClass> collection = PhpIndexImpl.addAllWithUniqueFqn(result, this.getAliasesByName(name, key));
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(63);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getClassesByNameInScope(@Nullable String name, GlobalSearchScope scope) {
        if (name == null) {
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpIndexImpl.$$$reportNull$$$0(64);
            }
            return list;
        }
        return PhpIndexImpl.getElements(PhpClassIndex.KEY, StringUtil.toLowerCase((String)name), this.project, scope, PhpClass.class);
    }

    @NotNull
    private static <T extends PhpNamedElement> Collection<T> getElements(StubIndexKey<String, T> key, String name, Project project, GlobalSearchScope scope, Class<T> aClass) {
        Collection elements = StubIndex.getElements(key, (Object)name, (Project)project, (GlobalSearchScope)scope, aClass);
        if (Function.class.isAssignableFrom(aClass)) {
            List list = ContainerUtil.filter((Collection)elements, e -> !(e instanceof FunctionImpl) || PhpIndexImpl.suitsPhpStormStubsLanguageLevel(project, (FunctionImpl)e));
            if (list == null) {
                PhpIndexImpl.$$$reportNull$$$0(65);
            }
            return list;
        }
        Collection collection = elements;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(66);
        }
        return collection;
    }

    public static boolean suitsPhpStormStubsLanguageLevel(Project project, @NotNull PhpAvailableInLanguageLevelRangeElement element) {
        if (element == null) {
            PhpIndexImpl.$$$reportNull$$$0(67);
        }
        PhpLanguageLevel currentLevel = PhpLanguageLevel.current((Project)project);
        String from = element.getAvailableInLanguageLevelFrom();
        String to = element.getAvailableInLanguageLevelTo();
        PhpLanguageLevel fromLevel = from != null ? PhpLanguageLevel.parse((String)from) : null;
        PhpLanguageLevel toLevel = to != null ? PhpLanguageLevel.parse((String)to) : null;
        return !(fromLevel != null && !currentLevel.isAtLeast(fromLevel) || toLevel != null && !toLevel.isAtLeast(currentLevel));
    }

    @Nullable
    public PhpClass getClassByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        Collection<PhpClass> classes = this.getClassesByName(name);
        if (classes.size() == 1) {
            return classes.iterator().next();
        }
        classes = this.getInterfacesByName(name);
        if (classes.size() == 1) {
            return classes.iterator().next();
        }
        classes = this.getTraitsByName(name);
        if (classes.size() == 1) {
            return classes.iterator().next();
        }
        return null;
    }

    @NotNull
    public Collection<PhpClass> getDirectSubclasses(@Nullable String fqn) {
        if (fqn == null) {
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpIndexImpl.$$$reportNull$$$0(68);
            }
            return list;
        }
        Collection collection = PhpCaches.getInstance((Project)this.project).directSubclassesCache.computeIfAbsent(StringUtil.toLowerCase((String)PhpLangUtil.toFQN(fqn)), this::getDirectSubclassesInner);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(69);
        }
        return collection;
    }

    @NotNull
    private Collection<PhpClass> getDirectSubclassesInner(String fqn) {
        Collection<PhpClass> result = PhpIndexImpl.getElements(PhpInheritanceIndex.KEY, fqn, this.project, this.getSearchScope(), PhpClass.class);
        for (String aliasFqn : PhpClassAliasIndex.getInstance((Project)this.project).getAliasFqnsByClass(fqn)) {
            result.addAll(PhpIndexImpl.getElements(PhpInheritanceIndex.KEY, StringUtil.toLowerCase((String)aliasFqn), this.project, this.getSearchScope(), PhpClass.class));
        }
        Collection<PhpClass> collection = result;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(70);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getAllSubclasses(@Nullable String fqn) {
        String lowerCaseFQN = StringUtil.toLowerCase((String)fqn);
        Collection<PhpClass> result = PhpCaches.getInstance((Project)this.project).subclassCache.get(lowerCaseFQN);
        if (result != null) {
            Collection<PhpClass> collection = result;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(71);
            }
            return collection;
        }
        result = this.fillAllSubclasses(fqn, new LinkedHashSet<PhpClass>());
        PhpCaches.getInstance((Project)this.project).subclassCache.put(lowerCaseFQN, Collections.unmodifiableCollection(result));
        Collection<PhpClass> collection = result;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(72);
        }
        return collection;
    }

    private Collection<PhpClass> fillAllSubclasses(String fqn, @NotNull Collection<PhpClass> visited) {
        if (visited == null) {
            PhpIndexImpl.$$$reportNull$$$0(73);
        }
        for (PhpClass aDirect : this.getDirectSubclasses(fqn)) {
            if (!visited.add(aDirect)) continue;
            this.fillAllSubclasses(aDirect.getFQN(), visited);
        }
        return visited;
    }

    public GlobalSearchScope getSearchScope() {
        return GlobalSearchScope.allScope((Project)this.project);
    }

    @NotNull
    public Collection<? extends PhpNamedElement> getBySignature(@NotNull String s) {
        if (s == null) {
            PhpIndexImpl.$$$reportNull$$$0(74);
        }
        Collection<? extends PhpNamedElement> collection = this.getBySignature(s, null, 0);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(75);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> getBySignature(@NotNull String s, @Nullable Set<String> visited, int depth) {
        if (s == null) {
            PhpIndexImpl.$$$reportNull$$$0(76);
        }
        if (StringUtil.countChars((CharSequence)s, (char)'#') * 2 > PhpIndexImpl.getMaxDepth()) {
            LOG.trace("MAX_DEPTH(" + PhpIndexImpl.getMaxDepth() + ") has been exceeded for signature: <<<" + s + ">>>");
            Set set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(77);
            }
            return set;
        }
        Collection<? extends PhpNamedElement> result = PhpCaches.getInstance((Project)this.project).SIGNATURES_CACHE.get(s);
        if (result == null) {
            result = Collections.unmodifiableCollection(this.getBySignatureInternal(s, visited, depth));
            PhpCaches.getInstance((Project)this.project).SIGNATURES_CACHE.put(s, result);
        }
        Collection<? extends PhpNamedElement> collection = result;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(78);
        }
        return collection;
    }

    @NotNull
    protected Collection<? extends PhpNamedElement> getBySignatureInternal(@NotNull String s, @Nullable Set<String> visited, int depth) {
        Collection result;
        if (s == null) {
            PhpIndexImpl.$$$reportNull$$$0(79);
        }
        if (depth > PhpIndexImpl.getMaxDepth()) {
            LOG.warn("getBySignature recursion hit level " + PhpIndexImpl.getMaxDepth() + " @ <<<" + s + ">>>");
            Set set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(80);
            }
            return set;
        }
        if (visited == null) {
            visited = new HashSet<String>();
        }
        if (s.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(81);
            }
            return set;
        }
        if (s.length() < 2 || s.charAt(0) != '#') {
            LOG.warn("Invalid Signature '" + s + "'");
            Set set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(82);
            }
            return set;
        }
        String entityName = s.substring(2);
        char key = s.charAt(1);
        if (PhpTypeSignatureKey.CONSTANT.is(key)) {
            Collection<Constant> collection = this.getConstantsByFQN(entityName);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(83);
            }
            return collection;
        }
        if (PhpTypeSignatureKey.PARAMETER.is(key)) {
            String innerEntitySig = entityName.substring(0, entityName.length() > 2 ? entityName.length() - 2 : 0);
            Collection<? extends PhpNamedElement> elements = this.getBySignature(innerEntitySig, visited, depth + 1);
            ArrayList params = new ArrayList();
            for (PsiElement psiElement : elements) {
                if (psiElement instanceof Function) {
                    int n = entityName.charAt(entityName.length() - 1) - 48;
                    ContainerUtil.addIfNotNull(params, (Object)((Function)psiElement).getParameter(n));
                    continue;
                }
                LOG.warn("Function expected in " + s + ", got " + String.valueOf(psiElement));
            }
            ArrayList arrayList = params;
            if (arrayList == null) {
                PhpIndexImpl.$$$reportNull$$$0(84);
            }
            return arrayList;
        }
        if (PhpTypeSignatureKey.FUNCTION.is(key)) {
            Collection<Function> collection = this.getFunctionsByFQN(entityName);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(85);
            }
            return collection;
        }
        if (PhpIndexImpl.isClassSignature(key)) {
            Collection<PhpClass> classes = this.getAnyByFQN(entityName);
            if (PhpTypeSignatureKey.SELF_CLASS_IN_TRAIT.is(key)) {
                Collection collection = classes.stream().flatMap(c -> c.isTrait() ? StreamEx.of(PhpOverriddenTraitMethodTP.traitUsages(c)).append(c) : Stream.of(c)).collect(Collectors.toSet());
                if (collection == null) {
                    PhpIndexImpl.$$$reportNull$$$0(86);
                }
                return collection;
            }
            Collection<PhpClass> collection = classes;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(87);
            }
            return collection;
        }
        if (PhpTypeSignatureKey.PARENT.is(key)) {
            Collection<? extends PhpNamedElement> elementsBySignature = this.getBySignature(entityName, visited, depth + 1);
            String callSiteClassFqn = PhpIndexImpl.extractClassFqn(entityName);
            if (callSiteClassFqn == null) {
                List list = StreamEx.of(elementsBySignature).select(PhpClass.class).map(PhpClass::getSuperClass).nonNull().toList();
                if (list == null) {
                    PhpIndexImpl.$$$reportNull$$$0(88);
                }
                return list;
            }
            Collection collection = (Collection)StreamEx.of(elementsBySignature).select(PhpClassMember.class).flatMap(member -> PhpIndexImpl.findParentMembers(member, callSiteClassFqn).stream()).nonNull().collect(Collectors.toList());
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(89);
            }
            return collection;
        }
        if (PhpTypeSignatureKey.FIELD.is(key) || PhpTypeSignatureKey.METHOD.is(key) || PhpTypeSignatureKey.CLASS_CONSTANT.is(key)) {
            int dot = s.lastIndexOf(46);
            if (dot < 2) {
                PhpIndexImpl.reportInvalidMemberSignature(s);
                Set set = Collections.emptySet();
                if (set == null) {
                    PhpIndexImpl.$$$reportNull$$$0(90);
                }
                return set;
            }
            String classRef = s.substring(2, dot);
            String name = PhpIndexImpl.sanitizeParameters(s.substring(dot + 1));
            Collection<PhpClass> classes = this.getClasses(classRef, null, depth + 1);
            return PhpIndexImpl.getMembers(key, name, classes);
        }
        for (PhpTypeProvider4 provider : this.getTypeProviders()) {
            if (provider.getKey() != key || (result = provider.getBySignature(entityName, visited, depth + 1, this.project)) == null || result.isEmpty()) continue;
            Collection collection = result;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(91);
            }
            return collection;
        }
        for (PhpTypeProvider4 provider : PhpTypeProvider3.EP_NAME.getExtensionList()) {
            if (provider.getKey() != key || (result = provider.getBySignature(entityName, visited, depth + 1, this.project)) == null || result.isEmpty()) continue;
            Collection collection = result;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(92);
            }
            return collection;
        }
        for (PhpTypeProvider4 provider : PhpTypeProvider2.EP_NAME.getExtensionList()) {
            if (provider.getKey() != key || (result = provider.getBySignature(entityName, this.project)) == null || result.isEmpty()) continue;
            Collection collection = result;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(93);
            }
            return collection;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            PhpIndexImpl.$$$reportNull$$$0(94);
        }
        return set;
    }

    @NotNull
    public static Set<PhpNamedElement> getMembers(char key, String name, Collection<PhpClass> classes) {
        HashSet<PhpNamedElement> result = new HashSet<PhpNamedElement>();
        for (PhpClass phpClass : classes) {
            PhpClass onlyChild;
            Collection<? extends PhpNamedElement> members = PhpIndexImpl.getMembers(phpClass, name, key);
            result.addAll(members);
            if (!members.isEmpty() || !phpClass.isAbstract() || (onlyChild = PhpIndexImpl.getOnlyConcreteChild(phpClass, new HashSet<PhpClass>())) == null) continue;
            result.addAll(PhpIndexImpl.getMembers(onlyChild, name, key));
        }
        HashSet<PhpNamedElement> hashSet = result;
        if (hashSet == null) {
            PhpIndexImpl.$$$reportNull$$$0(95);
        }
        return hashSet;
    }

    public static void reportInvalidMemberSignature(@NotNull String s) {
        if (s == null) {
            PhpIndexImpl.$$$reportNull$$$0(96);
        }
        if (ApplicationManager.getApplication().isInternal() || ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn("Invalid Signature " + s);
        }
    }

    public static boolean isClassSignature(char key) {
        return PhpTypeSignatureKey.SELF_CLASS.is(key) || PhpTypeSignatureKey.CLASS.is(key) || PhpTypeSignatureKey.POLYMORPHIC_CLASS.is(key) || PhpTypeSignatureKey.SELF_CLASS_IN_TRAIT.is(key);
    }

    @Nullable
    private static PhpClass getOnlyConcreteChild(@Nullable PhpClass phpClass, Collection<PhpClass> visited) {
        if (phpClass == null || !visited.add(phpClass)) {
            return null;
        }
        PhpClass onlyChild = (PhpClass)ContainerUtil.getOnlyItem((Collection)PhpIndexImpl.getInstance((Project)phpClass.getProject()).getDirectSubclasses(phpClass.getFQN()));
        return onlyChild == null || onlyChild.isAbstract() || onlyChild.isInterface() ? PhpIndexImpl.getOnlyConcreteChild(onlyChild, visited) : onlyChild;
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> getMembers(@NotNull PhpClass phpClass, String name, char key) {
        if (phpClass == null) {
            PhpIndexImpl.$$$reportNull$$$0(97);
        }
        if (PhpTypeSignatureKey.FIELD.is(key)) {
            Collection<Field> member = PhpClassImpl.findFieldsByName(phpClass, name, false, null);
            if (!member.isEmpty()) {
                Collection<Field> collection = member;
                if (collection == null) {
                    PhpIndexImpl.$$$reportNull$$$0(98);
                }
                return collection;
            }
            Method m = phpClass.findMethodByName((CharSequence)"__get");
            Collection<Object> collection = m != null ? Collections.singleton(m) : ContainerUtil.emptyList();
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(99);
            }
            return collection;
        }
        if (PhpTypeSignatureKey.CLASS_CONSTANT.is(key)) {
            Set<PhpNamedElement> enumCases;
            if (phpClass.isEnum() && !(enumCases = PhpClassImpl.tryResolveEnumCases(phpClass, name)).isEmpty()) {
                Set<PhpNamedElement> set = enumCases;
                if (set == null) {
                    PhpIndexImpl.$$$reportNull$$$0(100);
                }
                return set;
            }
            Collection<Field> collection = PhpClassImpl.findFieldsByName(phpClass, name, true, null);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(101);
            }
            return collection;
        }
        if (PhpTypeSignatureKey.METHOD.is(key)) {
            Collection collection = phpClass.findMethodsByName((CharSequence)name);
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(102);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(103);
        }
        return list;
    }

    private static String extractClassFqn(String name) {
        int classSignature = name.indexOf("#C");
        int methodSeparatorIndex = name.lastIndexOf(46);
        return classSignature >= 0 && methodSeparatorIndex >= 0 ? name.substring(classSignature + 2, methodSeparatorIndex) : null;
    }

    private static Collection<PhpClassMember> findParentMembers(PhpClassMember member, @Nullable String callSiteClassFqn) {
        PhpClass containingClass = member.getContainingClass();
        if (containingClass != null && !PhpLangUtil.equalsClassNames(containingClass.getFQN(), callSiteClassFqn)) {
            return Collections.singleton(member);
        }
        HashSet<PhpClassMember> res = new HashSet<PhpClassMember>();
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)member, (classMember, subClass, baseClass) -> {
            res.add(classMember);
            return false;
        });
        return res;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> getTypeMethods(@NotNull String classSign, @Nullable Set<String> visited, Map<String, String> providers, int depth) {
        if (classSign == null) {
            PhpIndexImpl.$$$reportNull$$$0(104);
        }
        HashSet allSupers = new HashSet();
        for (PhpClass phpClass : this.getClasses(classSign, visited, depth + 1)) {
            PhpClassHierarchyUtils.processSupers((PhpClass)phpClass, (boolean)true, (boolean)true, aClass -> allSupers.add(StringUtil.toLowerCase((String)aClass.getFQN())));
            for (Map.Entry<String, String> arrayClass : providers.entrySet()) {
                String name;
                Collection<? extends PhpNamedElement> methods;
                if (!allSupers.contains(StringUtil.toLowerCase((String)arrayClass.getKey())) || (methods = this.getBySignature(name = arrayClass.getValue().replace("*", phpClass.getFQN()), visited, depth + 1)).isEmpty()) continue;
                Collection<? extends PhpNamedElement> collection = methods;
                if (collection == null) {
                    PhpIndexImpl.$$$reportNull$$$0(105);
                }
                return collection;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(106);
        }
        return list;
    }

    private static boolean doAddCustomIncompleteType(@Nullable java.util.function.Function<@NotNull String, @Nullable PhpType> incompleteTypeCustomProducer, PhpType completeType, String typeName) {
        PhpType customIncompleteType;
        if (incompleteTypeCustomProducer != null && (customIncompleteType = incompleteTypeCustomProducer.apply(typeName)) != null) {
            completeType.add(customIncompleteType);
            return true;
        }
        return false;
    }

    @NotNull
    private Collection<PhpClass> tryFindClassesInDumbMode(String fqn, StubIndexKey<String, PhpClass> key) {
        HashSet<PhpClass> result = new HashSet<PhpClass>();
        this.processPossibleFiles(fqn, (Processor<PhpFile>)((Processor)file -> PhpIndexImpl.addClassesFromFile(file, fqn, key, result)));
        HashSet<PhpClass> hashSet = result;
        if (hashSet == null) {
            PhpIndexImpl.$$$reportNull$$$0(107);
        }
        return hashSet;
    }

    private void processPossibleFiles(String fqn, Processor<PhpFile> processor2) {
        String possibleFileName = StringUtil.replace((String)PhpLangUtil.toPresentableFQN(fqn), (String)"\\", (String)File.separator) + ".php";
        PsiManager manager = PsiManager.getInstance((Project)this.project);
        for (VirtualFile root : ProjectRootManager.getInstance((Project)this.project).getContentSourceRoots()) {
            PsiFile psiFile;
            VirtualFile possibleClassFile = PhpIndexImpl.findFileWithName(possibleFileName, root);
            if (possibleClassFile == null || !((psiFile = manager.findFile(possibleClassFile)) instanceof PhpFile) || processor2.process((Object)((PhpFile)psiFile))) continue;
            return;
        }
        if (PhpLangUtil.isGlobalNamespaceFQN(PhpLangUtil.getParentNamespaceFQN(fqn))) {
            for (VirtualFile stubExtensionFile : this.getStubExtensionsFiles()) {
                PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(stubExtensionFile);
                if (!(psiFile instanceof PhpFile) || processor2.process((Object)((PhpFile)psiFile))) continue;
                return;
            }
        }
    }

    private Collection<VirtualFile> getStubExtensionsFiles() {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (VirtualFile root : PhpRuntimeLibraryRootsProvider.getLibraryRoots(this.project)) {
            VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, null, file -> {
                if (!file.isDirectory()) {
                    result.add(file);
                }
                return true;
            });
        }
        return result;
    }

    private static boolean addClassesFromFile(PhpFile file, String classFQN, StubIndexKey<String, PhpClass> classKey, Collection<PhpClass> result) {
        Collection<PhpClass> classes = PhpPsiUtil.findClasses(file, (Condition<? super PhpClass>)((Condition)c -> PhpLangUtil.equalsClassNames(classFQN, c.getFQN()) && PhpIndexImpl.isTypeMatchesKey(c, classKey)));
        result.addAll(classes);
        return true;
    }

    private static boolean isTypeMatchesKey(PhpClass aClass, StubIndexKey<String, PhpClass> key) {
        if (aClass.isInterface()) {
            return key == PhpInterfaceIndex.KEY;
        }
        if (aClass.isTrait()) {
            return key == PhpTraitIndex.KEY;
        }
        return key == PhpClassIndex.KEY;
    }

    private static VirtualFile findFileWithName(String fileName, VirtualFile root) {
        VirtualFile path = root.findFileByRelativePath(fileName);
        if (path != null) {
            return path;
        }
        int i = fileName.indexOf(File.separator);
        if (i < 0) {
            return null;
        }
        return PhpIndexImpl.findFileWithName(fileName.substring(i + 1), root);
    }

    private static String toFqn(String possibleFQN) {
        if (StringUtil.isEmpty((String)possibleFQN)) {
            return possibleFQN;
        }
        return PhpLangUtil.toFQN(possibleFQN);
    }

    @NotNull
    private Collection<PhpClass> getByFQN(String fqn, Map<String, Collection<PhpClass>> cache, StubIndexKey<String, PhpClass> key) {
        if (StringUtil.isEmpty((String)fqn) || PhpType.isNotExtendablePrimitiveType((String)fqn) || fqn.startsWith("#") || PhpType.isPluralType((String)fqn) || StringUtil.startsWithChar((CharSequence)fqn, (char)'?')) {
            Set<PhpClass> set = Collections.emptySet();
            if (set == null) {
                PhpIndexImpl.$$$reportNull$$$0(108);
            }
            return set;
        }
        if (this.shouldUseSlowResolve()) {
            return this.tryFindClassesInDumbMode(fqn, key);
        }
        Collection<Object> result = cache.get(fqn);
        if (result != null) {
            Collection<PhpClass> collection = result;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(109);
            }
            return collection;
        }
        String name = PhpLangUtil.toShortName(fqn);
        if (!name.isEmpty()) {
            result = this.getByName(StringUtil.toLowerCase((String)name), cache, key);
        }
        result = result != null && !result.isEmpty() ? this.filterByNamespace(result, PhpIndexImpl.getNamespace(fqn)) : Collections.emptySet();
        cache.put(fqn, result);
        Collection<PhpClass> collection = result;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(110);
        }
        return collection;
    }

    @NotNull
    public static String getNamespace(String fqn) {
        int i = fqn.lastIndexOf(92);
        return i >= 0 ? fqn.substring(0, i + 1) : "\\";
    }

    @NotNull
    private Collection<PhpClass> getByName(@NotNull String name, @NotNull Map<String, Collection<PhpClass>> cache, @NotNull StubIndexKey<String, PhpClass> key) {
        Collection<PhpClass> elements;
        if (name == null) {
            PhpIndexImpl.$$$reportNull$$$0(111);
        }
        if (cache == null) {
            PhpIndexImpl.$$$reportNull$$$0(112);
        }
        if (key == null) {
            PhpIndexImpl.$$$reportNull$$$0(113);
        }
        if ((elements = cache.get(name)) != null) {
            Collection<PhpClass> collection = elements;
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(114);
            }
            return collection;
        }
        elements = PhpIndexImpl.getElements(key, name, this.project, this.getSearchScope(), PhpClass.class);
        cache.put(name, elements);
        if (elements.isEmpty()) {
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpIndexImpl.$$$reportNull$$$0(115);
            }
            return list;
        }
        Collection<PhpClass> collection = elements;
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(116);
        }
        return collection;
    }

    private Collection<PhpClassAlias> getAliasesByName(@NotNull String name, @Nullable StubIndexKey<String, PhpClass> key) {
        if (name == null) {
            PhpIndexImpl.$$$reportNull$$$0(117);
        }
        if (DumbService.isDumb((Project)this.project)) {
            return ContainerUtil.emptyList();
        }
        if (key == PhpClassIndex.KEY) {
            return PhpClassAliasIndex.getInstance((Project)this.project).getClassesByName(name);
        }
        if (key == PhpInterfaceIndex.KEY) {
            return PhpClassAliasIndex.getInstance((Project)this.project).getInterfacesByName(name);
        }
        if (key == PhpTraitIndex.KEY) {
            return PhpClassAliasIndex.getInstance((Project)this.project).getTraitsByName(name);
        }
        if (key == null) {
            return PhpClassAliasIndex.getInstance((Project)this.project).getAllAliasesByName(name);
        }
        return ContainerUtil.emptyList();
    }

    private static Collection<PhpClass> addAllWithUniqueFqn(Collection<PhpClass> elements, Collection<PhpClassAlias> aliases) {
        if (!aliases.isEmpty()) {
            elements = new HashSet<PhpClass>(elements);
            Set fqns = CollectionFactory.createCaseInsensitiveStringSet((int)elements.size());
            for (PhpClass phpClass : elements) {
                fqns.add(phpClass.getFQN());
            }
            for (PhpClassAlias alias : aliases) {
                if (fqns.contains(alias.getFQN())) continue;
                elements.add((PhpClass)alias);
            }
        }
        return Collections.unmodifiableCollection(elements);
    }

    @NotNull
    public Collection<PhpClass> getClassesByFQN(String fqn) {
        StubIndexKey<String, PhpClass> key = PhpClassIndex.KEY;
        Collection<PhpClass> result = this.getClassesByFQNInternal(fqn, key);
        Collection<PhpClass> collection = this.addAliases(fqn, key, result);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(118);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getClassesByFQNInternal(String fqn, StubIndexKey<String, PhpClass> key) {
        if ((fqn = PhpIndexImpl.sanitizeParameters(fqn)) != null && fqn.contains("&")) {
            Collection collection = StringUtil.split((String)fqn, (String)"&").stream().flatMap(f -> this.getByFqnCacheAware((String)f, key).stream()).collect(Collectors.toSet());
            if (collection == null) {
                PhpIndexImpl.$$$reportNull$$$0(119);
            }
            return collection;
        }
        return this.getByFqnCacheAware(fqn, key);
    }

    @NotNull
    private Collection<PhpClass> getByFqnCacheAware(String fqn, StubIndexKey<String, PhpClass> key) {
        Map<String, Collection<PhpClass>> cache = this.getCache(key);
        return this.getByFQN(PhpIndexImpl.toFqn(fqn), cache, key);
    }

    private Map<String, Collection<PhpClass>> getCache(StubIndexKey<String, PhpClass> key) {
        if (key == PhpClassIndex.KEY) {
            return PhpCaches.getInstance((Project)this.project).classCache;
        }
        if (key == PhpInterfaceIndex.KEY) {
            return PhpCaches.getInstance((Project)this.project).interfaceCache;
        }
        if (key == PhpTraitIndex.KEY) {
            return PhpCaches.getInstance((Project)this.project).traitCache;
        }
        throw new IllegalArgumentException();
    }

    private Collection<PhpClass> addAliases(String fqn, @Nullable StubIndexKey<String, PhpClass> key, Collection<PhpClass> result) {
        if (StringUtil.isEmpty((String)fqn)) {
            return result;
        }
        String name = PhpLangUtil.toShortName(fqn);
        Collection<PhpClassAlias> aliases = this.filterByNamespace(this.getAliasesByName(name, key), PhpIndexImpl.getNamespace(fqn));
        return PhpIndexImpl.addAllWithUniqueFqn(result, aliases);
    }

    @NotNull
    public Collection<PhpClass> getInterfacesByFQN(String fqn) {
        StubIndexKey<String, PhpClass> key = PhpInterfaceIndex.KEY;
        Collection<PhpClass> result = this.getClassesByFQNInternal(fqn, key);
        Collection<PhpClass> collection = this.addAliases(fqn, key, result);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(120);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getTraitsByFQN(String fqn) {
        StubIndexKey<String, PhpClass> key = PhpTraitIndex.KEY;
        Collection<PhpClass> result = this.getClassesByFQNInternal(fqn, key);
        Collection<PhpClass> collection = this.addAliases(fqn, key, result);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(121);
        }
        return collection;
    }

    @NotNull
    public Collection<PhpClass> getAnyByFQN(String fqn) {
        if (!StringUtil.startsWithChar((CharSequence)fqn, (char)'\\')) {
            fqn = "\\" + (String)fqn;
        }
        Collection<PhpClass> classes = this.getClassesByFQNInternal((String)fqn, PhpClassIndex.KEY);
        Collection<PhpClass> interfaces = this.getClassesByFQNInternal((String)fqn, PhpInterfaceIndex.KEY);
        Collection<PhpClass> traits = this.getClassesByFQNInternal((String)fqn, PhpTraitIndex.KEY);
        SmartList result = new SmartList();
        result.addAll(classes);
        result.addAll(interfaces);
        result.addAll(traits);
        Collection<PhpClass> collection = this.addAliases((String)fqn, null, (Collection<PhpClass>)result);
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(122);
        }
        return collection;
    }

    @Contract(value="!null -> !null")
    @Nullable
    private static String sanitizeParameters(@Nullable String fqn) {
        return fqn != null && PhpType.hasParameterizedPart((String)fqn) ? PhpType.removeParametrisedType((String)fqn) : fqn;
    }

    @NotNull
    public Collection<PhpClass> getCoveringTestClasses(@NotNull Project project, @NotNull String targetClassFqn) {
        if (project == null) {
            PhpIndexImpl.$$$reportNull$$$0(123);
        }
        if (targetClassFqn == null) {
            PhpIndexImpl.$$$reportNull$$$0(124);
        }
        Collection collection = FileBasedIndex.getInstance().getValues(PhpUnitCoversIndex.KEY, (Object)PhpPathInfo.byClass(targetClassFqn), GlobalSearchScope.projectScope((Project)project)).stream().flatMap(Collection::stream).flatMap(s -> this.getClassesByFQN(s.getClassFQN()).stream()).filter(PhpUnitUtil::isTestClass).collect(Collectors.toList());
        if (collection == null) {
            PhpIndexImpl.$$$reportNull$$$0(125);
        }
        return collection;
    }

    @NotNull
    private List<Method> getTestMethods(@NotNull String classFqn, @NotNull String methodName) {
        if (classFqn == null) {
            PhpIndexImpl.$$$reportNull$$$0(126);
        }
        if (methodName == null) {
            PhpIndexImpl.$$$reportNull$$$0(127);
        }
        List list = ((StreamEx)StreamEx.of(this.getClassesByFQN(classFqn)).map(testClass -> testClass.findOwnMethodByName((CharSequence)methodName)).nonNull().filter(PhpUnitUtil::isTestMethod)).toList();
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(128);
        }
        return list;
    }

    @NotNull
    public Collection<Method> getCoveringTestMethods(@NotNull Project project, @NotNull Method method) {
        if (project == null) {
            PhpIndexImpl.$$$reportNull$$$0(129);
        }
        if (method == null) {
            PhpIndexImpl.$$$reportNull$$$0(130);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List list = StreamEx.of(PhpIndexImpl.getCoveringPaths(method)).flatMap(path -> ContainerUtil.flatten((Iterable)index.getValues(PhpUnitCoversIndex.KEY, path, scope)).stream()).toFlatList(path -> this.getTestMethods(path.getClassFQN(), path.getMethodName()));
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(131);
        }
        return list;
    }

    @NotNull
    public static List<PhpPathInfo> getCoveringPaths(@NotNull Method method) {
        PhpClass containingClass;
        if (method == null) {
            PhpIndexImpl.$$$reportNull$$$0(132);
        }
        if ((containingClass = method.getContainingClass()) == null) {
            List<PhpPathInfo> list = Collections.emptyList();
            if (list == null) {
                PhpIndexImpl.$$$reportNull$$$0(133);
            }
            return list;
        }
        String classFQN = containingClass.getFQN();
        String methodAccess = method.getAccess().toString();
        List<PhpPathInfo> result = Arrays.stream(PhpModifier.Access.values()).map(PhpModifier.Access::toString).filter(access -> !StringUtil.equals((CharSequence)methodAccess, (CharSequence)access)).map(access -> PhpPathInfo.byAccess(classFQN, access, true)).toList();
        List list = ContainerUtil.append(result, (Object[])new PhpPathInfo[]{PhpPathInfo.byMethod(classFQN, method.getName()), PhpPathInfo.byAccess(classFQN, methodAccess, false), PhpPathInfo.byClass(classFQN)});
        if (list == null) {
            PhpIndexImpl.$$$reportNull$$$0(134);
        }
        return list;
    }

    public Collection<PhpClass> getTraitUsages(PhpClass me) {
        return (Collection)CachedValuesManager.getCachedValue((PsiElement)me, () -> CachedValueProvider.Result.create(this.getTraitUsageInternal(me), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    private Collection<PhpClass> getTraitUsageInternal(PhpClass me) {
        ArrayList<PhpClass> usages = new ArrayList<PhpClass>();
        Collection<String> traitUsagesByName = this.getTraitUsagesByFQN(me.getFQN());
        for (String usage : traitUsagesByName) {
            usages.addAll(this.getClassesByFQN(usage));
            usages.addAll(this.getTraitsByFQN(usage));
        }
        ArrayList<PhpClass> arrayList = usages;
        if (arrayList == null) {
            PhpIndexImpl.$$$reportNull$$$0(135);
        }
        return arrayList;
    }

    public Collection<PhpClass> getNestedTraitUsages(PhpClass me, @Nullable Collection<String> _visited) {
        String fqn;
        SmartList result = new SmartList();
        Collection<String> visited = _visited != null ? _visited : PhpStringUtil.createCaseInsensitiveSet();
        if (!visited.add(fqn = me.getFQN())) {
            return result;
        }
        Collection<PhpClass> direct = this.getTraitUsages(me);
        for (PhpClass aDirect : direct) {
            result.add(aDirect);
            if (!aDirect.isTrait()) continue;
            Collection<PhpClass> usages = this.getNestedTraitUsages(aDirect, visited);
            result.addAll(usages);
        }
        PhpClassHierarchyUtils.processSupers((PhpClass)me, (boolean)false, (boolean)true, arg_0 -> PhpIndexImpl.lambda$getNestedTraitUsages$42(visited, me, (Collection)result, arg_0));
        return result;
    }

    public boolean processNestedTraitUsages(PhpClass me, @Nullable Collection<String> _visited, Processor<? super PhpClass> processor2) {
        String fqn;
        Collection<String> visited = _visited != null ? _visited : PhpStringUtil.createCaseInsensitiveSet();
        if (!visited.add(fqn = me.getFQN())) {
            return true;
        }
        Collection<PhpClass> direct = this.getTraitUsages(me);
        for (PhpClass aDirect : direct) {
            if (!processor2.process((Object)aDirect)) {
                return false;
            }
            if (!aDirect.isTrait() || this.processNestedTraitUsages(aDirect, visited, processor2)) continue;
            return false;
        }
        PhpClassHierarchyUtils.processSupers((PhpClass)me, (boolean)false, (boolean)true, aClass -> visited.add(me.getFQN()) && processor2.process((Object)me));
        return true;
    }

    private List<String> filterKeys(Collection<String> keys, ID id) {
        return ContainerUtil.filter(keys, key -> this.belongToProject(id, (String)key));
    }

    private boolean belongToProject(@NotNull ID id, @NotNull String key) {
        if (id == null) {
            PhpIndexImpl.$$$reportNull$$$0(136);
        }
        if (key == null) {
            PhpIndexImpl.$$$reportNull$$$0(137);
        }
        return !FileBasedIndex.getInstance().getContainingFiles(id, (Object)key, this.getSearchScope()).isEmpty();
    }

    public Project getProject() {
        return this.project;
    }

    private static int getTypeCompletionComplexityLimit() {
        return Math.min(100, AdvancedSettings.getInt((String)"php.type.completion.complexity.limit"));
    }

    private static /* synthetic */ boolean lambda$getNestedTraitUsages$42(Collection visited, PhpClass me, Collection result, PhpClass aClass) {
        if (visited.add(me.getFQN())) {
            result.add(me);
        }
        return true;
    }

    private /* synthetic */ PhpType lambda$doCompleteType$1(int depth, PhpTypeProvider4 provider, String finalTypeName) {
        return this.completeType(depth + 1, provider, finalTypeName);
    }

    static {
        ARRAY_VALUE_PROVIDERS.put("\\ArrayAccess", "#M#C*.offsetGet");
        ITERATOR_VALUE_PROVIDERS = new LinkedHashMap<String, String>();
        ITERATOR_VALUE_PROVIDERS.put("\\Iterator", "#M#C*.current");
        ITERATOR_VALUE_PROVIDERS.put("\\Traversable", "#M#C*.__iterator");
        ITERATOR_VALUE_PROVIDERS.put("\\IteratorAggregate", PhpIteratedAccessTP.TYPE_KEY.sign("#M#C*.getIterator"));
        ARRAY_KEY_PROVIDERS = new LinkedHashMap<String, String>();
        ARRAY_KEY_PROVIDERS.put("\\Iterator", "#M#C*.key");
        ARRAY_KEY_PROVIDERS.put("\\IteratorAggregate", "#Y#M#C*.getIterator");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 7, 12, 15, 24, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 68, 69, 70, 71, 72, 75, 77, 78, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 98, 99, 100, 101, 102, 103, 105, 106, 107, 108, 109, 110, 114, 115, 116, 118, 119, 120, 121, 122, 125, 128, 131, 133, 134, 135 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 134: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpIndexImpl";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: 
            case 23: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRef";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traitName";
                break;
            }
            case 25: 
            case 123: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNamespaceFqn";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 74: 
            case 76: 
            case 79: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSign";
                break;
            }
            case 111: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 113: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassFqn";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 130: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpIndexImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByNamespace";
                break;
            }
            case 7: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "completeType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeProviders";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicatedProvidersErrorMessage";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChildNamespacesFqns";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConstantNames";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVariableNames";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFunctionNames";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassNames";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassFqns";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInterfacesFqns";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAliasesNames";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceAliasesNames";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInterfaceNames";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTraitNames";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildNamespacesByParentName";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitUsagesByFQN";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseAliasesByReferenceName";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantsByFQN";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantsByName";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesByName";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionsByName";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionsByFQN";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfacesByName";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByNameInScope";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectSubclasses";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectSubclassesInner";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubclasses";
                break;
            }
            case 75: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getBySignature";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getBySignatureInternal";
                break;
            }
            case 95: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMethods";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "tryFindClassesInDumbMode";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "getByFQN";
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "getByName";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByFQN";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByFQNInternal";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfacesByFQN";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitsByFQN";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnyByFQN";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveringTestClasses";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethods";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveringTestMethods";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveringPaths";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitUsageInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterByNamespace";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 134: 
            case 135: {
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "completeType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doCompleteType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findPolymorphicTypeInHierarchy";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isMyTrait";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicatedProvidersErrorMessage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "incompleteSignatureCanBeOmitted";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAllChildNamespacesFqns";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "suitsPhpStormStubsLanguageLevel";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "fillAllSubclasses";
                break;
            }
            case 74: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getBySignature";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getBySignatureInternal";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "reportInvalidMemberSignature";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getMembers";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMethods";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getByName";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getAliasesByName";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getCoveringTestClasses";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethods";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getCoveringTestMethods";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getCoveringPaths";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "belongToProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 7, 12, 15, 24, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 68, 69, 70, 71, 72, 75, 77, 78, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 98, 99, 100, 101, 102, 103, 105, 106, 107, 108, 109, 110, 114, 115, 116, 118, 119, 120, 121, 122, 125, 128, 131, 133, 134, 135 -> new IllegalStateException(string);
        };
    }

    private static class PhpTypeProvidersKeysModificationTracker
    implements ModificationTracker {
        private static final PhpTypeProvidersKeysModificationTracker INSTANCE = new PhpTypeProvidersKeysModificationTracker();

        private PhpTypeProvidersKeysModificationTracker() {
        }

        public long getModificationCount() {
            return PhpTypeProvider4.EP_NAME.getExtensionList().size();
        }
    }

    public static class CollectFilteredUniquesProcessor
    extends CommonProcessors.CollectUniquesProcessor<String> {
        private final PrefixMatcher myPrefixMatcher;

        public CollectFilteredUniquesProcessor(PrefixMatcher prefixMatcher) {
            this.myPrefixMatcher = prefixMatcher;
        }

        public boolean process(String s) {
            if (this.myPrefixMatcher != null && !this.myPrefixMatcher.prefixMatches(s)) {
                return true;
            }
            return super.process((Object)s);
        }
    }
}

