/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.symfony.new.php.project.wizard;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.symfony.SymfonyBundle;
import com.intellij.symfony.SymfonyIcons;
import com.intellij.symfony.new.php.project.wizard.SymfonyGeneratorPeer;
import com.intellij.symfony.new.php.project.wizard.SymfonyProjectGeneratorCollectorKt;
import com.intellij.symfony.new.php.project.wizard.SymfonyProjectGeneratorSettings;
import com.intellij.symfony.new.php.project.wizard.SymfonyProjectType;
import com.jetbrains.php.composer.ComposerProjectGenerator;
import com.jetbrains.php.composer.ComposerProjectSettings;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.execution.executable.ExecutableComposerExecution;
import com.jetbrains.php.composer.execution.phar.PharComposerExecution;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/symfony/new/php/project/wizard/SymfonyProjectGenerator;", "Lcom/intellij/ide/util/projectWizard/WebProjectTemplate;", "Lcom/intellij/symfony/new/php/project/wizard/SymfonyProjectGeneratorSettings;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "getDescription", "", "getName", "getIcon", "Ljavax/swing/Icon;", "composerProjectGenerator", "Lcom/jetbrains/php/composer/ComposerProjectGenerator;", "generateProject", "", "project", "Lcom/intellij/openapi/project/Project;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "module", "Lcom/intellij/openapi/module/Module;", "createPeer", "Lcom/intellij/platform/ProjectGeneratorPeer;", "intellij.symfony"})
@SourceDebugExtension(value={"SMAP\nSymfonyProjectGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymfonyProjectGenerator.kt\ncom/intellij/symfony/new/php/project/wizard/SymfonyProjectGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public class SymfonyProjectGenerator
extends WebProjectTemplate<SymfonyProjectGeneratorSettings>
implements Disposable.Default {
    @NotNull
    private final ComposerProjectGenerator composerProjectGenerator = new ComposerProjectGenerator();

    @Nullable
    public String getDescription() {
        return SymfonyBundle.INSTANCE.message("generator.create.new.symfony.project", new Object[0]);
    }

    @NotNull
    public String getName() {
        return SymfonyBundle.INSTANCE.message("generator.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SymfonyIcons.SymfonyLogo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SymfonyLogo");
        return icon;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull SymfonyProjectGeneratorSettings settings, @NotNull Module module) {
        ComposerExecution composerExecution;
        boolean isDownload;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        boolean bl = isDownload = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)"composer") == null;
        if (isDownload) {
            List<PhpInterpreter> list = PhpInterpretersManagerImpl.getInstance(project).getInterpreters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getInterpreters(...)");
            PhpInterpreter phpInterpreter = (PhpInterpreter)CollectionsKt.firstOrNull(list);
            String interpreterId = phpInterpreter != null ? phpInterpreter.getId() : null;
            composerExecution = new PharComposerExecution(interpreterId, "", false);
        } else {
            composerExecution = new ExecutableComposerExecution("composer");
        }
        ExecutableComposerExecution composerExecutable = composerExecution;
        Object object = settings.getVersion().get();
        String it = (String)object;
        boolean bl2 = false;
        String version = (String)(!Intrinsics.areEqual((Object)it, (Object)"latest") ? object : null);
        String options = "--no-progress --no-interaction --ansi --remove-vcs";
        ComposerPackage composerPackage = new ComposerPackage(settings.getProjectType().get() != SymfonyProjectType.DEMO ? "symfony/skeleton" : "symfony/symfony-demo");
        String webPackage = settings.getProjectType().get() == SymfonyProjectType.WEB ? "webapp" : null;
        ComposerProjectSettings composerSettings = new ComposerProjectSettings(isDownload, composerPackage, version, options, composerExecutable, webPackage, (Boolean)settings.getCreateGit().get());
        SymfonyProjectGeneratorCollectorKt.logGeneratedEvent((SymfonyProjectType)((Object)settings.getProjectType().get()), (String)settings.getVersion().get(), (Boolean)settings.getCreateGit().get());
        this.composerProjectGenerator.generateProject(project, baseDir, composerSettings, module);
    }

    @NotNull
    public ProjectGeneratorPeer<SymfonyProjectGeneratorSettings> createPeer() {
        return (ProjectGeneratorPeer)new SymfonyGeneratorPeer();
    }
}

